/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.screen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_6382;
import net.minecraft.class_7923;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.client.screen.EntitySelectionScreen;
import ydmsama.hundred_years_war.main.network.packets.SpawnPointConfigPacket;
import ydmsama.hundred_years_war.main.spawn.SpawnPointBlockEntity;
import ydmsama.hundred_years_war.main.spawn.SpawnPointScreenHandler;

@Environment(value=EnvType.CLIENT)
public class SpawnPointScreen
extends class_465<SpawnPointScreenHandler> {
    private static final int SCROLLABLE_AREA_Y = 40;
    private static final int SCROLLABLE_AREA_HEIGHT = 200;
    private static final int CONTENT_WIDTH = 256;
    private int scrollOffset = 0;
    private int totalContentHeight = 0;
    private int maxScrollOffset = 0;
    private final Map<class_342, ConfigField> editBoxMap = new HashMap<class_342, ConfigField>();
    private final List<ScrollableWidget> scrollableWidgets = new ArrayList<ScrollableWidget>();
    private CheckBox infiniteCheckbox;
    private CheckBox showActivationCheckbox;
    private CheckBox pauseCheckbox;
    private CheckBox periodicResetCheckbox;
    private int lastCurrentInterval = -1;
    private int lastRemainingCount = -1;
    private int lastEntryCount = -1;
    private boolean lastHasSavedState = false;
    private boolean lastShowActivationRange = false;
    private boolean lastPaused = false;
    private boolean lastPeriodicReset = false;
    private boolean lastInfinite = false;
    private boolean draggingScrollbar = false;
    private int scrollbarDragOffset = 0;

    public SpawnPointScreen(SpawnPointScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.field_2792 = 256;
        this.field_2779 = 240;
    }

    public void method_37432() {
        super.method_37432();
        SpawnPointBlockEntity blockEntity = ((SpawnPointScreenHandler)this.field_2797).getBlockEntity();
        if (blockEntity == null) {
            return;
        }
        int currentInterval = blockEntity.getCurrentInterval();
        int remainingCount = blockEntity.getRemainingCount();
        boolean hasSavedState = blockEntity.getSavedState() != null;
        boolean showActivationRange = blockEntity.isShowActivationRange();
        boolean paused = blockEntity.isPaused();
        boolean periodicReset = blockEntity.isPeriodicResetEnabled();
        boolean infiniteSummon = blockEntity.isInfiniteSummon();
        if (currentInterval != this.lastCurrentInterval || remainingCount != this.lastRemainingCount || hasSavedState != this.lastHasSavedState || showActivationRange != this.lastShowActivationRange || paused != this.lastPaused || periodicReset != this.lastPeriodicReset || infiniteSummon != this.lastInfinite) {
            ConfigField field;
            class_342 editBox;
            this.lastCurrentInterval = currentInterval;
            this.lastRemainingCount = remainingCount;
            this.lastHasSavedState = hasSavedState;
            this.lastShowActivationRange = showActivationRange;
            this.lastPaused = paused;
            this.lastPeriodicReset = periodicReset;
            this.lastInfinite = infiniteSummon;
            HashMap<ConfigField, String> userEditedValues = new HashMap<ConfigField, String>();
            ConfigField focusedField = null;
            int cursorPosition = 0;
            for (Map.Entry<class_342, ConfigField> entry : this.editBoxMap.entrySet()) {
                editBox = entry.getKey();
                field = entry.getValue();
                if (!editBox.method_25370()) continue;
                focusedField = field;
                cursorPosition = editBox.method_1881();
                userEditedValues.put(field, editBox.method_1882());
            }
            this.setupElements();
            for (Map.Entry<class_342, ConfigField> entry : this.editBoxMap.entrySet()) {
                editBox = entry.getKey();
                field = entry.getValue();
                String savedValue = (String)userEditedValues.get(field);
                if (savedValue != null) {
                    editBox.method_1852(savedValue);
                }
                if (field == null || !field.equals(focusedField)) continue;
                this.method_25395((class_364)editBox);
                editBox.method_25365(true);
                editBox.method_1875(cursorPosition);
            }
        }
    }

    protected void method_25426() {
        super.method_25426();
        this.setupElements();
    }

    private void setupElements() {
        this.method_37067();
        this.editBoxMap.clear();
        this.scrollableWidgets.clear();
        this.infiniteCheckbox = null;
        this.showActivationCheckbox = null;
        this.pauseCheckbox = null;
        this.periodicResetCheckbox = null;
        this.draggingScrollbar = false;
        this.scrollbarDragOffset = 0;
        class_4185 doneButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), button -> this.method_25419()).method_46434(this.field_2776 + 256 - 8 - 55, this.field_2800 + 8, 55, 12).method_46431();
        this.method_37063((class_364)doneButton);
        this.buildScrollableContent();
    }

    private void buildScrollableContent() {
        SpawnPointBlockEntity blockEntity = ((SpawnPointScreenHandler)this.field_2797).getBlockEntity();
        if (blockEntity == null) {
            return;
        }
        int yPos = 3;
        boolean hasSavedState = blockEntity.getSavedState() != null;
        this.showActivationCheckbox = this.createCheckBox(8, yPos, 150, 10, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.spawn_point.show_activation_range"), blockEntity.isShowActivationRange(), this::onBooleanOptionChanged);
        this.scrollableWidgets.add(new ScrollableWidget((Object)this.showActivationCheckbox, yPos));
        this.pauseCheckbox = this.createCheckBox(8, yPos += 14, 150, 10, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.spawn_point.pause"), blockEntity.isPaused(), this::onBooleanOptionChanged);
        this.scrollableWidgets.add(new ScrollableWidget((Object)this.pauseCheckbox, yPos));
        this.periodicResetCheckbox = this.createCheckBox(8, yPos += 14, 150, 10, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.spawn_point.periodic_reset"), blockEntity.isPeriodicResetEnabled() && hasSavedState, this::onBooleanOptionChanged);
        this.periodicResetCheckbox.setEnabled(hasSavedState);
        if (!hasSavedState) {
            this.periodicResetCheckbox.setSelected(false);
        }
        this.scrollableWidgets.add(new ScrollableWidget((Object)this.periodicResetCheckbox, yPos));
        this.infiniteCheckbox = this.createCheckBox(8, yPos += 14, 120, 10, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.spawn_point.infinite"), blockEntity.isInfiniteSummon(), null);
        this.scrollableWidgets.add(new ScrollableWidget((Object)this.infiniteCheckbox, yPos));
        yPos += 14;
        yPos = this.addNumberField(yPos, "activation_distance", (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.spawn_point.activation_distance"), String.valueOf((int)blockEntity.getActivationDistance()), ConfigField.ACTIVATION_DISTANCE);
        yPos = this.addNumberField(yPos, "horizontal_range", (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.spawn_point.horizontal_range"), String.valueOf((int)blockEntity.getHorizontalRange()), ConfigField.HORIZONTAL_RANGE);
        yPos = this.addNumberField(yPos, "vertical_range", (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.spawn_point.vertical_range"), String.valueOf((int)blockEntity.getVerticalRange()), ConfigField.VERTICAL_RANGE);
        yPos = this.addNumberField(yPos, "per_spawn", (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.spawn_point.per_spawn"), String.valueOf(blockEntity.getPerSpawnCount()), ConfigField.PER_SPAWN);
        yPos = this.addNumberField(yPos, "remaining", (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.spawn_point.remaining"), String.valueOf(blockEntity.getRemainingCount()), ConfigField.REMAINING);
        yPos = this.addNumberField(yPos, "min_interval", (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.spawn_point.min_interval"), String.valueOf(blockEntity.getMinInterval()), ConfigField.MIN_INTERVAL);
        yPos = this.addNumberField(yPos, "max_interval", (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.spawn_point.max_interval"), String.valueOf(blockEntity.getMaxInterval()), ConfigField.MAX_INTERVAL);
        yPos = this.addNumberField(yPos, "max_active", (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.spawn_point.max_active"), String.valueOf(blockEntity.getMaxActiveEntities()), ConfigField.MAX_ACTIVE);
        yPos = this.addNumberField(yPos, "reset_interval", (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.spawn_point.reset_interval"), String.valueOf(blockEntity.getResetInterval()), ConfigField.RESET_INTERVAL);
        yPos += 4;
        yPos = this.addLabel(yPos, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.spawn_point.current_state_section"));
        yPos += 12;
        yPos = this.addNumberField(yPos, "current_summon_cooldown", (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.spawn_point.current_summon_cooldown"), String.valueOf(blockEntity.getCurrentInterval()), ConfigField.CURRENT_SUMMON_COOLDOWN);
        yPos = this.addNumberField(yPos, "current_reset_cooldown", (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.spawn_point.current_reset_cooldown"), String.valueOf(blockEntity.getCurrentResetCooldown()), ConfigField.CURRENT_RESET_COOLDOWN);
        yPos += 4;
        yPos = this.addLabel(yPos, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.spawn_point.status_section"));
        yPos += 12;
        int activeCount = blockEntity.getActiveEntityCount(blockEntity.method_10997());
        yPos = this.addReadOnlyField(yPos, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.spawn_point.active_entities"), String.valueOf(activeCount));
        yPos += 4;
        yPos = this.addLabel(yPos, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.spawn_point.spawn_entries"));
        yPos += 12;
        yPos = this.addLabel(yPos, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.spawn_point.entity_list_header"));
        yPos += 12;
        List<SpawnPointBlockEntity.SpawnEntry> entries = blockEntity.getSpawnEntries();
        int i = 0;
        while (i < entries.size()) {
            int index = i++;
            SpawnPointBlockEntity.SpawnEntry entry = entries.get(index);
            class_4185 entityButton = this.createButton(30, yPos, 90, 12, (class_2561)class_2561.method_43470((String)this.getEntityName(entry.entityId())), btn -> this.openEntityEditDialog(index, entry));
            this.scrollableWidgets.add(new ScrollableWidget(entityButton, yPos));
            class_342 weightInput = this.createEditBox(125, yPos, 26, String.valueOf(entry.weight()));
            this.editBoxMap.put(weightInput, new ConfigField("entry_weight_" + index, 100));
            this.scrollableWidgets.add(new ScrollableWidget(weightInput, yPos));
            class_342 levelInput = this.createEditBox(155, yPos, 26, String.valueOf(entry.level()));
            this.editBoxMap.put(levelInput, new ConfigField("entry_level_" + index, 101));
            this.scrollableWidgets.add(new ScrollableWidget(levelInput, yPos));
            class_342 equipmentInput = this.createEditBox(185, yPos, 26, String.valueOf(entry.equipmentLevel()));
            this.editBoxMap.put(equipmentInput, new ConfigField("entry_equipment_" + index, 102));
            this.scrollableWidgets.add(new ScrollableWidget(equipmentInput, yPos));
            class_4185 removeButton = this.createButton(215, yPos, 12, 12, (class_2561)class_2561.method_43470((String)"X"), btn -> this.removeEntry(index));
            this.scrollableWidgets.add(new ScrollableWidget(removeButton, yPos));
            yPos += 12;
        }
        class_4185 addEntityButton = this.createButton(30, yPos, 120, 12, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.spawn_point.add_entity"), btn -> this.openEntitySelectDialog());
        this.scrollableWidgets.add(new ScrollableWidget(addEntityButton, yPos));
        class_4185 saveButton = this.createButton(8, yPos += 14, 80, 12, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.spawn_point.save_state"), btn -> {
            this.sendAllConfigUpdates();
            ClientPacketHandler.sendSpawnPointConfigCommand(((SpawnPointScreenHandler)this.field_2797).getBlockPos(), SpawnPointConfigPacket.Mode.SAVE_DEFAULTS);
        });
        this.scrollableWidgets.add(new ScrollableWidget(saveButton, yPos));
        class_4185 loadButton = this.createButton(92, yPos, 80, 12, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.spawn_point.load_state"), btn -> {
            this.method_25395(null);
            ClientPacketHandler.sendSpawnPointConfigCommand(((SpawnPointScreenHandler)this.field_2797).getBlockPos(), SpawnPointConfigPacket.Mode.RESTORE_DEFAULTS);
        });
        loadButton.field_22763 = hasSavedState;
        this.scrollableWidgets.add(new ScrollableWidget(loadButton, yPos));
        if (hasSavedState) {
            this.scrollableWidgets.add(new ScrollableWidget(new LabelWidget(180, yPos, (class_2561)class_2561.method_43470((String)"\u2713").method_27694(style -> style.method_36139(65280))), yPos));
        }
        this.totalContentHeight = yPos += 12;
        this.maxScrollOffset = Math.max(0, this.totalContentHeight - 200);
        this.updateWidgetPositions();
    }

    private int addNumberField(int yPos, String key, class_2561 label, String value, ConfigField field) {
        this.scrollableWidgets.add(new ScrollableWidget(new LabelWidget(8, yPos, label), yPos));
        class_342 editBox = this.createEditBox(180, yPos, 50, value);
        this.editBoxMap.put(editBox, field);
        this.scrollableWidgets.add(new ScrollableWidget(editBox, yPos));
        return yPos + 12;
    }

    private int addLabel(int yPos, class_2561 text) {
        this.scrollableWidgets.add(new ScrollableWidget(new LabelWidget(8, yPos, text), yPos));
        return yPos;
    }

    private int addReadOnlyField(int yPos, class_2561 label, String value) {
        this.scrollableWidgets.add(new ScrollableWidget(new LabelWidget(8, yPos, label), yPos));
        this.scrollableWidgets.add(new ScrollableWidget(new LabelWidget(180, yPos, (class_2561)class_2561.method_43470((String)value)), yPos));
        return yPos + 12;
    }

    private class_342 createEditBox(int x, int y, int width, String value) {
        class_342 editBox = new class_342(this.field_22793, this.field_2776 + x, this.field_2800 + 40 + y - this.scrollOffset, width, 12, (class_2561)class_2561.method_43470((String)""));
        editBox.method_1880(10);
        editBox.method_1852(value);
        editBox.method_1890(text -> {
            if (text.isEmpty()) {
                return true;
            }
            try {
                Double.parseDouble(text);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
        return editBox;
    }

    private class_4185 createButton(int x, int y, int width, int height, class_2561 text, class_4185.class_4241 onPress) {
        return class_4185.method_46430((class_2561)text, (class_4185.class_4241)onPress).method_46434(this.field_2776 + x, this.field_2800 + 40 + y - this.scrollOffset, width, height).method_46431();
    }

    private CheckBox createCheckBox(int x, int y, int width, int height, class_2561 text, boolean defaultValue, Runnable onChange) {
        return new CheckBox(this.field_2776 + x, this.field_2800 + 40 + y - this.scrollOffset, width, height, text, defaultValue, onChange, this.field_22793);
    }

    private void updateWidgetPositions() {
        for (ScrollableWidget widget : this.scrollableWidgets) {
            int newY = this.field_2800 + 40 + widget.yPos - this.scrollOffset;
            Object object = widget.widget;
            if (object instanceof class_4185) {
                class_4185 button = (class_4185)object;
                button.method_46419(newY);
                continue;
            }
            object = widget.widget;
            if (object instanceof class_342) {
                class_342 editBox = (class_342)object;
                editBox.method_46419(newY);
                continue;
            }
            object = widget.widget;
            if (!(object instanceof CheckBox)) continue;
            CheckBox checkbox = (CheckBox)((Object)object);
            checkbox.method_48229(this.field_2776 + 8, newY);
        }
    }

    private void openEntitySelectDialog() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507((class_437)new EntitySelectionScreen(this, -1, null));
        }
    }

    private void openEntityEditDialog(int index, SpawnPointBlockEntity.SpawnEntry entry) {
        if (this.field_22787 != null) {
            this.field_22787.method_1507((class_437)new EntitySelectionScreen(this, index, entry));
        }
    }

    private void removeEntry(int index) {
        this.removeEntityEntry(index);
    }

    private String getEntityName(class_2960 entityId) {
        class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(entityId);
        if (entityType != null) {
            return entityType.method_5897().getString();
        }
        String path = entityId.method_12832();
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.method_25420(graphics);
        super.method_25394(graphics, mouseX, mouseY, delta);
        this.method_2380(graphics, mouseX, mouseY);
    }

    protected void method_2389(class_332 graphics, float delta, int mouseX, int mouseY) {
        graphics.method_25294(this.field_2776, this.field_2800, this.field_2776 + this.field_2792, this.field_2800 + this.field_2779, -3750202);
        graphics.method_25294(this.field_2776, this.field_2800, this.field_2776 + this.field_2792, this.field_2800 + 40, -2039584);
        graphics.method_25294(this.field_2776, this.field_2800 + 40, this.field_2776 + this.field_2792 - 12, this.field_2800 + 40 + 200, -986896);
        graphics.method_44379(this.field_2776, this.field_2800 + 40, this.field_2776 + this.field_2792 - 12, this.field_2800 + 40 + 200);
        for (ScrollableWidget widget : this.scrollableWidgets) {
            int widgetY = this.field_2800 + 40 + widget.yPos - this.scrollOffset;
            if (widgetY + 20 < this.field_2800 + 40 || widgetY > this.field_2800 + 40 + 200) continue;
            Object object = widget.widget;
            if (object instanceof class_4185) {
                class_4185 button = (class_4185)object;
                button.method_25394(graphics, mouseX, mouseY, delta);
                continue;
            }
            object = widget.widget;
            if (object instanceof class_342) {
                class_342 editBox = (class_342)object;
                editBox.method_25394(graphics, mouseX, mouseY, delta);
                continue;
            }
            object = widget.widget;
            if (object instanceof CheckBox) {
                CheckBox checkbox = (CheckBox)((Object)object);
                checkbox.method_25394(graphics, mouseX, mouseY, delta);
                continue;
            }
            object = widget.widget;
            if (!(object instanceof LabelWidget)) continue;
            LabelWidget label = (LabelWidget)object;
            graphics.method_51439(this.field_22793, label.text, this.field_2776 + label.x, widgetY, 0x404040, false);
        }
        graphics.method_44380();
        if (this.maxScrollOffset > 0) {
            int scrollbarX = this.field_2776 + this.field_2792 - 10;
            int scrollbarY = this.field_2800 + 40;
            int scrollbarHeight = 200;
            graphics.method_25294(scrollbarX, scrollbarY, scrollbarX + 8, scrollbarY + scrollbarHeight, -7631989);
            int thumbHeight = Math.max(20, 40000 / this.totalContentHeight);
            int thumbY = scrollbarY + (int)((float)this.scrollOffset / (float)this.maxScrollOffset * (float)(scrollbarHeight - thumbHeight));
            graphics.method_25294(scrollbarX + 1, thumbY, scrollbarX + 7, thumbY + thumbHeight, -4144960);
        }
    }

    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
        graphics.method_51439(this.field_22793, this.field_22785, 8, 8, 0x404040, false);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (this.isMouseOverScrollableArea(mouseX, mouseY)) {
            int scrollAmount = (int)(delta * 10.0);
            this.scrollOffset = Math.max(0, Math.min(this.maxScrollOffset, this.scrollOffset - scrollAmount));
            this.updateWidgetPositions();
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.isMouseOverScrollableArea(mouseX, mouseY)) {
            return super.method_25402(mouseX, mouseY, button);
        }
        if (this.maxScrollOffset > 0) {
            int scrollbarX = this.getScrollbarX();
            int scrollbarY = this.getScrollbarY();
            int scrollbarWidth = 8;
            int scrollbarHeight = 200;
            if (mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + scrollbarWidth) && mouseY >= (double)scrollbarY && mouseY <= (double)(scrollbarY + scrollbarHeight)) {
                int thumbHeight = this.computeThumbHeight();
                int thumbY = this.computeThumbY(thumbHeight);
                if (mouseY >= (double)thumbY && mouseY <= (double)(thumbY + thumbHeight)) {
                    this.draggingScrollbar = true;
                    this.scrollbarDragOffset = (int)(mouseY - (double)thumbY);
                } else {
                    double targetThumbTop = Math.max((double)scrollbarY, Math.min((double)(scrollbarY + scrollbarHeight - thumbHeight), mouseY - (double)thumbHeight / 2.0));
                    this.applyThumbPosition(targetThumbTop, thumbHeight);
                    this.draggingScrollbar = true;
                    this.scrollbarDragOffset = thumbHeight / 2;
                }
                this.updateWidgetPositions();
                return true;
            }
        }
        for (ScrollableWidget widget : this.scrollableWidgets) {
            CheckBox checkbox;
            Object object = widget.widget;
            if (object instanceof class_4185) {
                class_4185 btn = (class_4185)object;
                if (!btn.method_25405(mouseX, mouseY)) continue;
                btn.method_25402(mouseX, mouseY, button);
                return true;
            }
            object = widget.widget;
            if (object instanceof class_342) {
                class_342 editBox = (class_342)object;
                if (!editBox.method_25405(mouseX, mouseY)) continue;
                editBox.method_25402(mouseX, mouseY, button);
                this.method_25395((class_364)editBox);
                return true;
            }
            object = widget.widget;
            if (!(object instanceof CheckBox) || !(checkbox = (CheckBox)((Object)object)).method_25405(mouseX, mouseY)) continue;
            checkbox.method_25402(mouseX, mouseY, button);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.draggingScrollbar && button == 0 && this.maxScrollOffset > 0) {
            int thumbHeight = this.computeThumbHeight();
            int scrollbarY = this.getScrollbarY();
            int scrollbarHeight = 200;
            double targetThumbTop = Math.max((double)scrollbarY, Math.min((double)(scrollbarY + scrollbarHeight - thumbHeight), mouseY - (double)this.scrollbarDragOffset));
            this.applyThumbPosition(targetThumbTop, thumbHeight);
            this.updateWidgetPositions();
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 && this.draggingScrollbar) {
            this.draggingScrollbar = false;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        class_342 editBox;
        class_364 class_3642 = this.method_25399();
        if (class_3642 instanceof class_342 && (editBox = (class_342)class_3642).method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char codePoint, int modifiers) {
        class_342 editBox;
        class_364 class_3642 = this.method_25399();
        if (class_3642 instanceof class_342 && (editBox = (class_342)class_3642).method_25400(codePoint, modifiers)) {
            return true;
        }
        return super.method_25400(codePoint, modifiers);
    }

    private boolean isMouseOverScrollableArea(double mouseX, double mouseY) {
        return mouseX >= (double)this.field_2776 && mouseX < (double)(this.field_2776 + this.field_2792) && mouseY >= (double)(this.field_2800 + 40) && mouseY < (double)(this.field_2800 + 40 + 200);
    }

    private int getScrollbarX() {
        return this.field_2776 + this.field_2792 - 10;
    }

    private int getScrollbarY() {
        return this.field_2800 + 40;
    }

    private int computeThumbHeight() {
        if (this.totalContentHeight <= 0) {
            return 20;
        }
        return Math.max(20, 40000 / this.totalContentHeight);
    }

    private int computeThumbY(int thumbHeight) {
        if (this.maxScrollOffset <= 0) {
            return this.getScrollbarY();
        }
        int track = 200 - thumbHeight;
        if (track <= 0) {
            return this.getScrollbarY();
        }
        return this.getScrollbarY() + (int)((float)this.scrollOffset / (float)this.maxScrollOffset * (float)track);
    }

    private void applyThumbPosition(double thumbTop, int thumbHeight) {
        int scrollbarY = this.getScrollbarY();
        int track = 200 - thumbHeight;
        if (track <= 0) {
            this.scrollOffset = 0;
            return;
        }
        double relative = (thumbTop - (double)scrollbarY) / (double)track;
        relative = Math.max(0.0, Math.min(1.0, relative));
        this.scrollOffset = Math.max(0, Math.min(this.maxScrollOffset, (int)Math.round(relative * (double)this.maxScrollOffset)));
    }

    public void method_25432() {
        super.method_25432();
        this.sendAllConfigUpdates();
    }

    private void onBooleanOptionChanged() {
        SpawnPointBlockEntity blockEntity = ((SpawnPointScreenHandler)this.field_2797).getBlockEntity();
        if (blockEntity == null) {
            return;
        }
        ArrayList<SpawnPointConfigPacket.SpawnEntryData> entryDataList = new ArrayList<SpawnPointConfigPacket.SpawnEntryData>();
        for (SpawnPointBlockEntity.SpawnEntry entry : blockEntity.getSpawnEntries()) {
            entryDataList.add(new SpawnPointConfigPacket.SpawnEntryData(entry.entityId(), entry.weight(), entry.level(), entry.equipmentLevel()));
        }
        boolean infiniteValue = this.infiniteCheckbox != null && this.infiniteCheckbox.selected();
        boolean showActivationValue = this.showActivationCheckbox != null && this.showActivationCheckbox.selected();
        boolean pausedValue = this.pauseCheckbox != null && this.pauseCheckbox.selected();
        boolean periodicResetValue = this.periodicResetCheckbox != null && this.periodicResetCheckbox.method_37303() && this.periodicResetCheckbox.selected();
        SpawnPointConfigPacket.ConfigData configData = new SpawnPointConfigPacket.ConfigData(blockEntity.getActivationDistance(), blockEntity.getHorizontalRange(), blockEntity.getVerticalRange(), blockEntity.getPerSpawnCount(), blockEntity.getRemainingCount(), blockEntity.getMinInterval(), blockEntity.getMaxInterval(), blockEntity.getCurrentInterval(), blockEntity.getMaxActiveEntities(), infiniteValue, showActivationValue, pausedValue, periodicResetValue, blockEntity.getResetInterval(), blockEntity.getCurrentResetCooldown(), entryDataList);
        ClientPacketHandler.sendSpawnPointConfig(((SpawnPointScreenHandler)this.field_2797).getBlockPos(), configData);
    }

    private void sendAllConfigUpdates() {
        SpawnPointBlockEntity blockEntity = ((SpawnPointScreenHandler)this.field_2797).getBlockEntity();
        if (blockEntity == null) {
            return;
        }
        double activationDistance = this.getDoubleValue(ConfigField.ACTIVATION_DISTANCE, blockEntity.getActivationDistance());
        double horizontalRange = this.getDoubleValue(ConfigField.HORIZONTAL_RANGE, blockEntity.getHorizontalRange());
        double verticalRange = this.getDoubleValue(ConfigField.VERTICAL_RANGE, blockEntity.getVerticalRange());
        int perSpawn = this.getIntValue(ConfigField.PER_SPAWN, blockEntity.getPerSpawnCount());
        int remaining = this.getIntValue(ConfigField.REMAINING, blockEntity.getRemainingCount());
        int minInterval = this.getIntValue(ConfigField.MIN_INTERVAL, blockEntity.getMinInterval());
        int maxInterval = this.getIntValue(ConfigField.MAX_INTERVAL, blockEntity.getMaxInterval());
        int currentInterval = this.getIntValue(ConfigField.CURRENT_SUMMON_COOLDOWN, this.getIntValue(ConfigField.CURRENT_INTERVAL, blockEntity.getCurrentInterval()));
        int maxActive = this.getIntValue(ConfigField.MAX_ACTIVE, blockEntity.getMaxActiveEntities());
        long resetInterval = this.getLongValue(ConfigField.RESET_INTERVAL, blockEntity.getResetInterval());
        long currentResetCooldown = this.getLongValue(ConfigField.CURRENT_RESET_COOLDOWN, blockEntity.getCurrentResetCooldown());
        ArrayList<SpawnPointBlockEntity.SpawnEntry> entries = new ArrayList<SpawnPointBlockEntity.SpawnEntry>();
        for (int i = 0; i < blockEntity.getSpawnEntries().size(); ++i) {
            SpawnPointBlockEntity.SpawnEntry originalEntry = blockEntity.getSpawnEntries().get(i);
            int weight = this.getIntValue(new ConfigField("entry_weight_" + i, 100), originalEntry.weight());
            int level = this.getIntValue(new ConfigField("entry_level_" + i, 101), originalEntry.level());
            int equipmentLevel = this.getIntValue(new ConfigField("entry_equipment_" + i, 102), originalEntry.equipmentLevel());
            entries.add(new SpawnPointBlockEntity.SpawnEntry(originalEntry.entityId(), weight, level, equipmentLevel));
        }
        ArrayList<SpawnPointConfigPacket.SpawnEntryData> entryDataList = new ArrayList<SpawnPointConfigPacket.SpawnEntryData>();
        for (SpawnPointBlockEntity.SpawnEntry entry : entries) {
            entryDataList.add(new SpawnPointConfigPacket.SpawnEntryData(entry.entityId(), entry.weight(), entry.level(), entry.equipmentLevel()));
        }
        boolean infiniteValue = this.infiniteCheckbox != null && this.infiniteCheckbox.selected();
        boolean showActivationValue = this.showActivationCheckbox != null && this.showActivationCheckbox.selected();
        boolean pausedValue = this.pauseCheckbox != null && this.pauseCheckbox.selected();
        boolean periodicResetValue = this.periodicResetCheckbox != null && this.periodicResetCheckbox.method_37303() && this.periodicResetCheckbox.selected();
        SpawnPointConfigPacket.ConfigData configData = new SpawnPointConfigPacket.ConfigData(activationDistance, horizontalRange, verticalRange, perSpawn, remaining, minInterval, maxInterval, currentInterval, maxActive, infiniteValue, showActivationValue, pausedValue, periodicResetValue, resetInterval, currentResetCooldown, entryDataList);
        ClientPacketHandler.sendSpawnPointConfig(((SpawnPointScreenHandler)this.field_2797).getBlockPos(), configData);
    }

    private void sendConfigUpdate(List<SpawnPointBlockEntity.SpawnEntry> entries) {
        SpawnPointBlockEntity blockEntity = ((SpawnPointScreenHandler)this.field_2797).getBlockEntity();
        if (blockEntity == null) {
            return;
        }
        ArrayList<SpawnPointConfigPacket.SpawnEntryData> entryDataList = new ArrayList<SpawnPointConfigPacket.SpawnEntryData>();
        for (SpawnPointBlockEntity.SpawnEntry entry : entries) {
            entryDataList.add(new SpawnPointConfigPacket.SpawnEntryData(entry.entityId(), entry.weight(), entry.level(), entry.equipmentLevel()));
        }
        boolean infiniteValue = this.infiniteCheckbox != null ? this.infiniteCheckbox.selected() : blockEntity.isInfiniteSummon();
        boolean showActivationValue = this.showActivationCheckbox != null ? this.showActivationCheckbox.selected() : blockEntity.isShowActivationRange();
        boolean pausedValue = this.pauseCheckbox != null ? this.pauseCheckbox.selected() : blockEntity.isPaused();
        boolean periodicResetValue = this.periodicResetCheckbox != null && this.periodicResetCheckbox.method_37303() ? this.periodicResetCheckbox.selected() : blockEntity.isPeriodicResetEnabled();
        SpawnPointConfigPacket.ConfigData configData = new SpawnPointConfigPacket.ConfigData(blockEntity.getActivationDistance(), blockEntity.getHorizontalRange(), blockEntity.getVerticalRange(), blockEntity.getPerSpawnCount(), blockEntity.getRemainingCount(), blockEntity.getMinInterval(), blockEntity.getMaxInterval(), blockEntity.getCurrentInterval(), blockEntity.getMaxActiveEntities(), infiniteValue, showActivationValue, pausedValue, periodicResetValue, blockEntity.getResetInterval(), blockEntity.getCurrentResetCooldown(), entryDataList);
        ClientPacketHandler.sendSpawnPointConfig(((SpawnPointScreenHandler)this.field_2797).getBlockPos(), configData);
    }

    public void updateEntityEntry(int index, class_2960 entityId) {
        SpawnPointBlockEntity blockEntity = ((SpawnPointScreenHandler)this.field_2797).getBlockEntity();
        if (blockEntity == null) {
            return;
        }
        ArrayList<SpawnPointBlockEntity.SpawnEntry> entries = new ArrayList<SpawnPointBlockEntity.SpawnEntry>(blockEntity.getSpawnEntries());
        if (index < 0) {
            entries.add(new SpawnPointBlockEntity.SpawnEntry(entityId, 1, 1, 1));
        } else if (index < entries.size()) {
            SpawnPointBlockEntity.SpawnEntry existing = (SpawnPointBlockEntity.SpawnEntry)entries.get(index);
            entries.set(index, new SpawnPointBlockEntity.SpawnEntry(entityId, existing.weight(), existing.level(), existing.equipmentLevel()));
        }
        blockEntity.setSpawnEntries(entries);
        this.sendConfigUpdate(entries);
        this.lastEntryCount = entries.size();
        this.setupElements();
    }

    public void removeEntityEntry(int index) {
        SpawnPointBlockEntity blockEntity = ((SpawnPointScreenHandler)this.field_2797).getBlockEntity();
        if (blockEntity == null) {
            return;
        }
        ArrayList<SpawnPointBlockEntity.SpawnEntry> entries = new ArrayList<SpawnPointBlockEntity.SpawnEntry>(blockEntity.getSpawnEntries());
        if (index >= 0 && index < entries.size()) {
            SpawnPointBlockEntity.SpawnEntry removed = (SpawnPointBlockEntity.SpawnEntry)entries.remove(index);
            blockEntity.setSpawnEntries(entries);
            this.sendConfigUpdate(entries);
            this.lastEntryCount = entries.size();
            this.setupElements();
        }
    }

    private double getDoubleValue(ConfigField field, double defaultValue) {
        for (Map.Entry<class_342, ConfigField> entry : this.editBoxMap.entrySet()) {
            if (!entry.getValue().equals(field)) continue;
            String value = entry.getKey().method_1882();
            if (value == null || value.trim().isEmpty()) {
                return defaultValue;
            }
            try {
                double parsed = Double.parseDouble(value);
                return parsed;
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private int getIntValue(ConfigField field, int defaultValue) {
        return (int)this.getDoubleValue(field, defaultValue);
    }

    private long getLongValue(ConfigField field, long defaultValue) {
        return (long)this.getDoubleValue(field, defaultValue);
    }

    @Environment(value=EnvType.CLIENT)
    private static class ConfigField {
        static final ConfigField ACTIVATION_DISTANCE = new ConfigField("activation_distance", 0);
        static final ConfigField HORIZONTAL_RANGE = new ConfigField("horizontal_range", 1);
        static final ConfigField VERTICAL_RANGE = new ConfigField("vertical_range", 2);
        static final ConfigField PER_SPAWN = new ConfigField("per_spawn", 3);
        static final ConfigField REMAINING = new ConfigField("remaining", 4);
        static final ConfigField MIN_INTERVAL = new ConfigField("min_interval", 5);
        static final ConfigField MAX_INTERVAL = new ConfigField("max_interval", 6);
        static final ConfigField MAX_ACTIVE = new ConfigField("max_active", 7);
        static final ConfigField RESET_INTERVAL = new ConfigField("reset_interval", 8);
        static final ConfigField CURRENT_INTERVAL = new ConfigField("current_interval", 9);
        static final ConfigField CURRENT_SUMMON_COOLDOWN = new ConfigField("current_summon_cooldown", 10);
        static final ConfigField CURRENT_RESET_COOLDOWN = new ConfigField("current_reset_cooldown", 11);
        static final int ENTRY_WEIGHT = 100;
        static final int ENTRY_LEVEL = 101;
        static final int ENTRY_EQUIPMENT_LEVEL = 102;
        final String key;
        final int type;

        ConfigField(String key, int type) {
            this.key = key;
            this.type = type;
        }

        ConfigField(String key, ConfigField template) {
            this.key = key;
            this.type = template.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConfigField)) {
                return false;
            }
            ConfigField field = (ConfigField)o;
            return this.type == field.type && this.key.equals(field.key);
        }

        public int hashCode() {
            return 31 * this.key.hashCode() + this.type;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class CheckBox
    extends class_339 {
        private boolean checked;
        private final Runnable onChange;
        private final class_327 fontRenderer;

        public CheckBox(int x, int y, int width, int height, class_2561 message, boolean defaultValue, Runnable onChange, class_327 font) {
            super(x, y, width, height, message);
            this.checked = defaultValue;
            this.onChange = onChange;
            this.fontRenderer = font;
        }

        protected void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
            int boxSize = 10;
            int outerColor = this.method_37303() ? -1 : -5197648;
            int innerColor = this.method_37303() ? -16777216 : -10855846;
            graphics.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + boxSize, this.method_46427() + boxSize, outerColor);
            graphics.method_25294(this.method_46426() + 1, this.method_46427() + 1, this.method_46426() + boxSize - 1, this.method_46427() + boxSize - 1, innerColor);
            if (this.checked) {
                int checkColor = this.method_37303() ? 65280 : 39168;
                graphics.method_51433(this.fontRenderer, "\u2713", this.method_46426() + 2, this.method_46427() + 1, checkColor, false);
            }
            int labelColor = this.method_37303() ? 0x404040 : 0x707070;
            graphics.method_51439(this.fontRenderer, this.method_25369(), this.method_46426() + boxSize + 5, this.method_46427() + 1, labelColor, false);
        }

        public void method_25348(double mouseX, double mouseY) {
            if (!this.method_37303()) {
                return;
            }
            boolean bl = this.checked = !this.checked;
            if (this.onChange != null) {
                this.onChange.run();
            }
        }

        public boolean selected() {
            return this.checked;
        }

        public void setSelected(boolean selected) {
            this.checked = selected;
        }

        public void setEnabled(boolean enabled) {
            this.field_22763 = enabled;
        }

        public void method_48229(int x, int y) {
            this.method_46421(x);
            this.method_46419(y);
        }

        protected void method_47399(class_6382 output) {
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class ScrollableWidget {
        final Object widget;
        final int yPos;

        ScrollableWidget(Object widget, int yPos) {
            this.widget = widget;
            this.yPos = yPos;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private record LabelWidget(int x, int yPos, class_2561 text) {
    }
}

