/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main;

import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import org.slf4j.Logger;
import ydmsama.hundred_years_war.main.blocks.ModBlocks;
import ydmsama.hundred_years_war.main.commands.Commands;
import ydmsama.hundred_years_war.main.config.ServerModConfig;
import ydmsama.hundred_years_war.main.events.BuildingSyncEventHandler;
import ydmsama.hundred_years_war.main.handler.ModTickHandler;
import ydmsama.hundred_years_war.main.handler.WorldTickHandler;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.RelationSyncPacket;
import ydmsama.hundred_years_war.main.recruitment.PlayerRecruitmentData;
import ydmsama.hundred_years_war.main.recruitment.RecruitmentConfigManager;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywEntityRegistry;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;
import ydmsama.hundred_years_war.main.registry.LootTableModifiers;
import ydmsama.hundred_years_war.main.selection.SelectionSystem;
import ydmsama.hundred_years_war.main.supply.SupplyManager;
import ydmsama.hundred_years_war.main.template.TemplateManager;
import ydmsama.hundred_years_war.main.utils.CreativeModeSettings;
import ydmsama.hundred_years_war.main.utils.ExpBlacklistManager;
import ydmsama.hundred_years_war.main.utils.FirstJoinHandler;
import ydmsama.hundred_years_war.main.utils.FreecamStateManager;
import ydmsama.hundred_years_war.main.utils.HywLogger;
import ydmsama.hundred_years_war.main.utils.PlayerSettingsManager;
import ydmsama.hundred_years_war.main.utils.PuppetStateHandler;
import ydmsama.hundred_years_war.main.utils.RelationSystem;
import ydmsama.hundred_years_war.main.utils.ServerManager;
import ydmsama.hundred_years_war.main.utils.TargetListManager;
import ydmsama.hundred_years_war.main.utils.TeamRelationData;

public class HundredYearsWar
implements ModInitializer {
    private static final Logger LOGGER = HywLogger.LOGGER;

    public void onInitialize() {
        ServerModConfig.load();
        File configDir = new File("config/hundredyearswar");
        if (!configDir.exists()) {
            configDir.mkdirs();
            LOGGER.info("Created config/hundredyearswar directory");
        }
        LOGGER.info("Loading BaseCombatEntity target list...");
        TargetListManager.loadTargetList();
        LOGGER.info("Finished loading BaseCombatEntity target list");
        LOGGER.info("Loading target blacklist...");
        TargetListManager.loadTargetBlacklist();
        LOGGER.info("Finished loading target blacklist");
        LOGGER.info("Loading experience blacklist...");
        ExpBlacklistManager.loadExpBlacklist();
        LOGGER.info("Finished loading experience blacklist");
        HywItemRegistry.initialize();
        HywAttributes.initialize();
        ModBlocks.initialize();
        this.registerCommands();
        this.setupServerLifecycleEvents();
        this.initializeOtherSystems();
        WorldTickHandler.register();
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                FirstJoinHandler.handlePlayerFirstJoin(player);
                UUID playerUUID = player.method_5667();
                String playerName = player.method_5477().getString();
                RelationSystem.addPlayerAndEnsureRelations(playerUUID, playerName);
                SupplyManager.registerSupplySource(playerUUID, SupplyManager.SupplySourceType.PLAYER, 1000.0);
                RelationSyncPacket.sendToClient(player);
                ServerPacketHandler.sendCreativeSettingsSync(player);
                PlayerSettingsManager.PlayerSettings settings = PlayerSettingsManager.getSettings(player);
                PlayerRecruitmentData.setPlayerSelection((class_1657)player, settings.copyRecruitmentSelection());
                ServerPacketHandler.sendPlayerSettingsSync(player, settings);
                for (UUID teamUUID : RelationSystem.getAllTeams().keySet()) {
                    TeamRelationData team = RelationSystem.getTeamRelationData(teamUUID);
                    if (team == null || !"Player's Elite Squad".equals(team.getTeamName())) continue;
                    boolean hasOwner = false;
                    for (Map.Entry<UUID, TeamRelationData.MemberType> entry : team.getAllMembers().entrySet()) {
                        if (entry.getValue() != TeamRelationData.MemberType.OWNER) continue;
                        hasOwner = true;
                        break;
                    }
                    if (hasOwner) break;
                    team.addMember(playerUUID, TeamRelationData.MemberType.OWNER);
                    LOGGER.info("Player {} has been set as the owner of team Player's Elite Squad", (Object)playerName);
                    break;
                }
            }
        });
        BuildingSyncEventHandler.init();
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            class_3222 player = handler.method_32311();
            UUID playerUUID = player.method_5667();
            FreecamStateManager.removePlayerState(playerUUID);
            PuppetStateHandler.clearPlayerState(playerUUID);
            CreativeModeSettings.remove((class_1657)player);
            PlayerRecruitmentData.clearPlayerData(playerUUID);
        });
        LootTableModifiers.init();
        ServerManager.init();
    }

    private void registerCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, environment, registrationEnvironment) -> Commands.registerCommands((CommandDispatcher<class_2168>)dispatcher));
    }

    private void setupServerLifecycleEvents() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            Path worldPath = server.method_27050(class_5218.field_24188);
            FirstJoinHandler.loadFirstJoinData(worldPath);
            Path relationSavePath = worldPath.resolve("relations.dat");
            RelationSystem.loadRelations(relationSavePath);
            RecruitmentConfigManager.loadAllConfigs();
            TemplateManager.getInstance().initialize(server);
            Path supplyPath = worldPath.resolve("supply.dat");
            SupplyManager.loadData(supplyPath);
            Path playerSettingsPath = worldPath.resolve("player_settings.json");
            PlayerSettingsManager.load(playerSettingsPath);
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            Path worldPath = server.method_27050(class_5218.field_24188);
            FirstJoinHandler.saveFirstJoinData(worldPath);
            Path relationSavePath = worldPath.resolve("relations.dat");
            try {
                RelationSystem.saveRelations(relationSavePath);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Path supplyPath = worldPath.resolve("supply.dat");
            try {
                SupplyManager.saveData(supplyPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            PlayerSettingsManager.save();
            FreecamStateManager.clearAllStates();
            PuppetStateHandler.clearAllTemporaryStates();
        });
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            Path squadsPath = server.method_27050(class_5218.field_24188).resolve("squads.dat");
            try {
                SelectionSystem.loadSquads(squadsPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Path puppetStatesPath = server.method_27050(class_5218.field_24188).resolve("puppet_states.dat");
            try {
                PuppetStateHandler.loadPersistentStates(puppetStatesPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            Path squadsPath = server.method_27050(class_5218.field_24188).resolve("squads.dat");
            try {
                SelectionSystem.saveSquads(squadsPath);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Path puppetStatesPath = server.method_27050(class_5218.field_24188).resolve("puppet_states.dat");
            try {
                PuppetStateHandler.savePersistentStates(puppetStatesPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private void initializeOtherSystems() {
        HywEntityRegistry.registerEntities();
        ServerPacketHandler.registerReceivers();
        ModTickHandler.registerTickHandler();
    }
}

