/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.blocks.warehouse;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import org.jetbrains.annotations.Nullable;
import ydmsama.hundred_years_war.main.blocks.ModBlockEntities;
import ydmsama.hundred_years_war.main.blocks.warehouse.WarehouseControlBlock;
import ydmsama.hundred_years_war.main.blocks.warehouse.WarehouseControlScreenHandler;
import ydmsama.hundred_years_war.main.blocks.warehouse.WarehouseStorageBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.BoundedWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.warehouse.WarehouseItemData;

public class WarehouseControlBlockEntity
extends BoundedWorkstationBlockEntity
implements class_3908 {
    private final Set<class_2338> storagePositions = new HashSet<class_2338>();
    private final Map<class_1799, Integer> itemMap = new LinkedHashMap<class_1799, Integer>();
    private final List<Map.Entry<class_1799, Integer>> sortedItems = new ArrayList<Map.Entry<class_1799, Integer>>();
    private int totalCapacity = 0;
    private int usedCapacity = 0;
    private final Set<WarehouseControlScreenHandler> viewers = new HashSet<WarehouseControlScreenHandler>();
    private SortType sortType = SortType.NAME;
    private boolean sortAscending = true;

    public WarehouseControlBlockEntity(class_2338 pos, class_2680 blockState) {
        super(ModBlockEntities.WAREHOUSE_CONTROL, pos, blockState);
        this.workRangeLeft = 3;
        this.workRangeRight = 3;
        this.workRangeUp = 3;
        this.workRangeDown = 3;
        this.showRange = true;
    }

    @Override
    public int getMaxRangeLeft() {
        return 10;
    }

    @Override
    public int getMaxRangeRight() {
        return 10;
    }

    @Override
    public int getMaxRangeUp() {
        return 10;
    }

    @Override
    public int getMaxRangeDown() {
        return 10;
    }

    @Override
    protected boolean shouldLoadWorkRange() {
        return true;
    }

    @Override
    public class_2350 getFacing() {
        class_2680 state = this.method_11010();
        if (state.method_28498((class_2769)WarehouseControlBlock.FACING)) {
            return (class_2350)state.method_11654((class_2769)WarehouseControlBlock.FACING);
        }
        return class_2350.field_11043;
    }

    @Override
    public void triggerWork() {
        if (!this.field_11863.field_9236) {
            this.scanStorageBlocks();
            this.updateItemMap();
        }
    }

    public void tick() {
        if (this.field_11863 != null && !this.field_11863.field_9236 && this.field_11863.method_8510() % 20L == 0L) {
            this.scanAndUpdate();
        }
    }

    public void syncAllDataToClient(class_3222 player) {
        this.scanAndUpdate();
        this.syncToClient(player);
    }

    public void addViewer(WarehouseControlScreenHandler viewer) {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.viewers.add(viewer);
            viewer.markForUpdate();
        }
    }

    public void removeViewer(WarehouseControlScreenHandler viewer) {
        this.viewers.remove((Object)viewer);
    }

    public void updateViewers() {
        for (WarehouseControlScreenHandler viewer : this.viewers) {
            viewer.markForUpdate();
        }
    }

    public void scanAndUpdate() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.scanStorageBlocks();
            this.updateItemMap();
        }
    }

    private void scanStorageBlocks() {
        HashSet newStoragePositions = new HashSet();
        class_238 workArea = this.getWorkArea();
        if (workArea != null) {
            class_2338.method_20437((class_2338)class_2338.method_49637((double)workArea.field_1323, (double)workArea.field_1322, (double)workArea.field_1321), (class_2338)class_2338.method_49637((double)(workArea.field_1320 - 1.0), (double)(workArea.field_1325 - 1.0), (double)(workArea.field_1324 - 1.0))).forEach(pos -> {
                class_2586 blockEntity = this.field_11863.method_8321(pos);
                if (blockEntity instanceof WarehouseStorageBlockEntity) {
                    newStoragePositions.add(pos.method_10062());
                }
            });
        }
        if (!newStoragePositions.equals(this.storagePositions)) {
            this.storagePositions.clear();
            this.storagePositions.addAll(newStoragePositions);
            this.method_5431();
        }
    }

    private void updateItemMap() {
        LinkedHashMap<class_1799, Integer> newItemMap = new LinkedHashMap<class_1799, Integer>();
        int newTotalCapacity = 0;
        int newUsedCapacity = 0;
        for (class_2338 pos : this.storagePositions) {
            class_2586 blockEntity = this.field_11863.method_8321(pos);
            if (!(blockEntity instanceof WarehouseStorageBlockEntity)) continue;
            WarehouseStorageBlockEntity storage = (WarehouseStorageBlockEntity)blockEntity;
            newTotalCapacity += storage.method_5439();
            for (int i = 0; i < storage.method_5439(); ++i) {
                class_1799 stack = storage.method_5438(i);
                if (stack.method_7960()) continue;
                ++newUsedCapacity;
                boolean found = false;
                for (Map.Entry entry : newItemMap.entrySet()) {
                    if (!class_1799.method_31577((class_1799)((class_1799)entry.getKey()), (class_1799)stack)) continue;
                    entry.setValue((Integer)entry.getValue() + stack.method_7947());
                    found = true;
                    break;
                }
                if (found) continue;
                class_1799 keyStack = stack.method_7972();
                keyStack.method_7939(1);
                newItemMap.put(keyStack, stack.method_7947());
            }
        }
        if (!newItemMap.equals(this.itemMap) || newTotalCapacity != this.totalCapacity || newUsedCapacity != this.usedCapacity) {
            this.itemMap.clear();
            this.itemMap.putAll(newItemMap);
            this.totalCapacity = newTotalCapacity;
            this.usedCapacity = newUsedCapacity;
            this.updateSortedItems();
            this.updateViewers();
            this.syncToClients();
            this.method_5431();
        }
    }

    private void updateSortedItems() {
        this.sortedItems.clear();
        ArrayList<Map.Entry<class_1799, Integer>> entries = new ArrayList<Map.Entry<class_1799, Integer>>(this.itemMap.entrySet());
        entries.sort((a, b) -> {
            int result = 0;
            switch (this.sortType) {
                case NAME: {
                    result = ((class_1799)a.getKey()).method_7964().getString().compareTo(((class_1799)b.getKey()).method_7964().getString());
                    break;
                }
                case QUANTITY: {
                    result = Integer.compare((Integer)a.getValue(), (Integer)b.getValue());
                    break;
                }
                case ID: {
                    result = ((class_1799)a.getKey()).method_7909().toString().compareTo(((class_1799)b.getKey()).method_7909().toString());
                }
            }
            return this.sortAscending ? result : -result;
        });
        this.sortedItems.addAll(entries);
    }

    public class_1799 tryAddItem(class_1799 stack) {
        if (stack.method_7960() || this.field_11863.field_9236) {
            return stack;
        }
        class_1799 remaining = stack.method_7972();
        for (class_2338 pos : this.storagePositions) {
            if (remaining.method_7960()) break;
            class_2586 blockEntity = this.field_11863.method_8321(pos);
            if (!(blockEntity instanceof WarehouseStorageBlockEntity)) continue;
            WarehouseStorageBlockEntity storage = (WarehouseStorageBlockEntity)blockEntity;
            remaining = storage.tryAddItem(remaining);
        }
        this.updateItemMap();
        return remaining;
    }

    public class_1799 tryExtractItem(class_1799 requestStack) {
        if (requestStack.method_7960() || this.field_11863.field_9236) {
            return class_1799.field_8037;
        }
        int remainingCount = requestStack.method_7947();
        class_1799 result = requestStack.method_7972();
        result.method_7939(0);
        for (class_2338 pos : this.storagePositions) {
            if (remainingCount <= 0) break;
            class_2586 blockEntity = this.field_11863.method_8321(pos);
            if (!(blockEntity instanceof WarehouseStorageBlockEntity)) continue;
            WarehouseStorageBlockEntity storage = (WarehouseStorageBlockEntity)blockEntity;
            int extracted = storage.extractItem(requestStack, remainingCount);
            result.method_7933(extracted);
            remainingCount -= extracted;
        }
        this.updateItemMap();
        return result;
    }

    public int getItemCount(class_1799 stack) {
        for (Map.Entry<class_1799, Integer> entry : this.itemMap.entrySet()) {
            if (!class_1799.method_31577((class_1799)entry.getKey(), (class_1799)stack)) continue;
            return entry.getValue();
        }
        return 0;
    }

    public List<class_1799> getAvailableItemTypes() {
        ArrayList<class_1799> types = new ArrayList<class_1799>();
        for (Map.Entry<class_1799, Integer> entry : this.itemMap.entrySet()) {
            if (entry.getValue() <= 0) continue;
            types.add(entry.getKey().method_7972());
        }
        return types;
    }

    private void syncToClients() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            List players = this.field_11863.method_18456();
            for (class_1657 player : players) {
                if (!(player instanceof class_3222)) continue;
                class_3222 serverPlayer = (class_3222)player;
                if (!(player.method_5649((double)this.method_11016().method_10263(), (double)this.method_11016().method_10264(), (double)this.method_11016().method_10260()) < 4096.0)) continue;
                this.syncToClient(serverPlayer);
            }
        }
    }

    public void syncToClient(class_3222 player) {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            ArrayList<WarehouseItemData> itemDataList = new ArrayList<WarehouseItemData>();
            for (Map.Entry<class_1799, Integer> entry : this.sortedItems) {
                itemDataList.add(new WarehouseItemData(entry.getKey(), entry.getValue()));
            }
            ServerPacketHandler.sendWarehouseDataSync(player, this.method_11016(), itemDataList, this.totalCapacity, this.usedCapacity, this.sortType.name(), this.sortAscending);
        }
    }

    @Override
    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        class_2499 storageList = new class_2499();
        for (class_2338 pos : this.storagePositions) {
            class_2487 posTag = new class_2487();
            posTag.method_10569("x", pos.method_10263());
            posTag.method_10569("y", pos.method_10264());
            posTag.method_10569("z", pos.method_10260());
            storageList.add((Object)posTag);
        }
        tag.method_10566("StoragePositions", (class_2520)storageList);
        tag.method_10582("SortType", this.sortType.name());
        tag.method_10556("SortAscending", this.sortAscending);
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.storagePositions.clear();
        class_2499 storageList = tag.method_10554("StoragePositions", 10);
        for (int i = 0; i < storageList.size(); ++i) {
            class_2487 posTag = storageList.method_10602(i);
            this.storagePositions.add(new class_2338(posTag.method_10550("x"), posTag.method_10550("y"), posTag.method_10550("z")));
        }
        if (tag.method_10545("SortType")) {
            try {
                this.sortType = SortType.valueOf(tag.method_10558("SortType"));
            }
            catch (IllegalArgumentException e) {
                this.sortType = SortType.NAME;
            }
        }
        this.sortAscending = tag.method_10577("SortAscending");
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.hundred_years_war.warehouse_control");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new WarehouseControlScreenHandler(syncId, playerInventory, this);
    }

    public List<class_1799> getSortedItems() {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        for (Map.Entry<class_1799, Integer> entry : this.sortedItems) {
            class_1799 display = entry.getKey().method_7972();
            display.method_7939(Math.min(entry.getValue(), 127));
            items.add(display);
        }
        return items;
    }

    public int getTotalCapacity() {
        return this.totalCapacity;
    }

    public int getUsedCapacity() {
        return this.usedCapacity;
    }

    public SortType getSortType() {
        return this.sortType;
    }

    public void setSortType(SortType sortType) {
        this.sortType = sortType;
        this.updateSortedItems();
        this.syncToClients();
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }

    public void setSortAscending(boolean ascending) {
        this.sortAscending = ascending;
        this.updateSortedItems();
        this.syncToClients();
    }

    public int getStorageBlockCount() {
        return this.storagePositions.size();
    }

    public boolean stillValid(class_1657 player) {
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public static enum SortType {
        NAME,
        QUANTITY,
        ID;


        public SortType next() {
            SortType[] values = SortType.values();
            return values[(this.ordinal() + 1) % values.length];
        }
    }
}

