/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.blocks.workstation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2302;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2350;
import net.minecraft.class_2356;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2488;
import net.minecraft.class_2526;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ydmsama.hundred_years_war.main.blocks.ModBlockEntities;
import ydmsama.hundred_years_war.main.blocks.workstation.FarmingWorkstation;
import ydmsama.hundred_years_war.main.blocks.workstation.FarmingWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.InventoryBoundedWorkstationBlockEntity;

public class FarmingWorkstationBlockEntity
extends InventoryBoundedWorkstationBlockEntity {
    private static final int WORK_INTERVAL = 40;
    public static final int MAX_RANGE_LEFT = 8;
    public static final int MAX_RANGE_RIGHT = 8;
    public static final int MAX_RANGE_UP = 16;
    public static final int MAX_RANGE_DOWN = 0;
    private int workTimer = 0;
    private boolean selected = false;
    private final Random random = new Random();
    private int nextWorkInterval = 40;
    private WorkPhase currentPhase = WorkPhase.SCANNING;
    private final Set<class_2338> farmlandPositions = new HashSet<class_2338>();
    private final Set<class_2338> plantPositions = new HashSet<class_2338>();
    private final Set<class_2338> harvestPositions = new HashSet<class_2338>();
    private final Queue<class_2338> workQueue = new LinkedList<class_2338>();

    public FarmingWorkstationBlockEntity(class_2338 pos, class_2680 blockState) {
        super(ModBlockEntities.FARMING_WORKSTATION, pos, blockState);
        this.workRangeLeft = 3;
        this.workRangeRight = 3;
        this.workRangeUp = 3;
        this.workRangeDown = 0;
        this.setShowRange(true);
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, FarmingWorkstationBlockEntity blockEntity) {
        if (level != null && !level.field_9236) {
            blockEntity.serverTick();
        }
    }

    private void serverTick() {
        if (!this.activated) {
            return;
        }
        --this.workTimer;
        if (this.workTimer <= 0) {
            this.workTimer = this.nextWorkInterval;
            this.nextWorkInterval = 40 + this.random.nextInt(10) - 5;
            this.performFarmingWork();
        }
    }

    @Override
    public void triggerWork() {
        this.collectDroppedItems();
        this.performFarmingWork();
    }

    private void performFarmingWork() {
        switch (this.currentPhase) {
            case SCANNING: {
                this.scanFarmArea();
                break;
            }
            case TILLING: {
                this.performTilling();
                break;
            }
            case PLANTING: {
                this.performPlanting();
                break;
            }
            case HARVESTING: {
                this.performHarvesting();
                break;
            }
            case BONE_MEALING: {
                this.performBoneMealing();
            }
        }
    }

    private void scanFarmArea() {
        this.farmlandPositions.clear();
        this.plantPositions.clear();
        this.harvestPositions.clear();
        this.workQueue.clear();
        class_238 workArea = this.getWorkArea();
        int minX = (int)Math.floor(workArea.field_1323);
        int maxX = (int)Math.floor(workArea.field_1320 - 0.01);
        int minY = (int)Math.floor(workArea.field_1322);
        int maxY = (int)Math.floor(workArea.field_1325 - 0.01);
        int minZ = (int)Math.floor(workArea.field_1321);
        int maxZ = (int)Math.floor(workArea.field_1324 - 0.01);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    class_2302 cropBlock;
                    class_2338 pos = new class_2338(x, y, z);
                    class_2680 state = this.field_11863.method_8320(pos);
                    class_2248 block = state.method_26204();
                    class_2338 belowPos = pos.method_10074();
                    class_2680 belowState = this.field_11863.method_8320(belowPos);
                    if (this.canTill(belowState) && (state.method_26215() || this.isObstacle(state))) {
                        this.farmlandPositions.add(belowPos);
                    }
                    if (this.field_11863.method_8320(belowPos).method_26204() instanceof class_2344 && state.method_26215() && this.hasSeedsInInventory()) {
                        this.plantPositions.add(pos);
                    }
                    if (!(block instanceof class_2302) || !(cropBlock = (class_2302)block).method_9825(state)) continue;
                    this.harvestPositions.add(pos);
                }
            }
        }
        if (!this.farmlandPositions.isEmpty()) {
            this.workQueue.addAll(this.farmlandPositions);
            this.currentPhase = WorkPhase.TILLING;
        } else if (!this.plantPositions.isEmpty()) {
            this.workQueue.addAll(this.plantPositions);
            this.currentPhase = WorkPhase.PLANTING;
        } else if (!this.harvestPositions.isEmpty()) {
            this.workQueue.addAll(this.harvestPositions);
            this.currentPhase = WorkPhase.HARVESTING;
        } else {
            this.currentPhase = this.hasBoneMeal() ? WorkPhase.BONE_MEALING : WorkPhase.SCANNING;
        }
    }

    private void performTilling() {
        if (this.workQueue.isEmpty()) {
            this.currentPhase = WorkPhase.SCANNING;
            return;
        }
        class_2338 tillPos = this.workQueue.poll();
        if (this.canTill(this.field_11863.method_8320(tillPos))) {
            class_2338 abovePos = tillPos.method_10084();
            this.clearObstaclesAt(abovePos);
            this.field_11863.method_8652(tillPos, class_2246.field_10362.method_9564(), 3);
            this.field_11863.method_8396(null, tillPos, class_3417.field_14846, class_3419.field_15245, 1.0f, 1.0f);
        }
        if (this.workQueue.isEmpty()) {
            this.currentPhase = WorkPhase.SCANNING;
        }
    }

    private boolean isObstacle(class_2680 state) {
        if (state.method_26215()) {
            return false;
        }
        class_2248 block = state.method_26204();
        return state.method_45474() || block instanceof class_2488 || block instanceof class_2261 || block instanceof class_2526 || block instanceof class_2320 || block instanceof class_2356;
    }

    private void clearObstaclesAt(class_2338 pos) {
        class_2680 state = this.field_11863.method_8320(pos);
        if (this.isObstacle(state)) {
            this.field_11863.method_8652(pos, class_2246.field_10124.method_9564(), 3);
        }
    }

    private void performPlanting() {
        class_2680 cropState;
        if (this.workQueue.isEmpty()) {
            this.currentPhase = WorkPhase.SCANNING;
            return;
        }
        class_2338 plantPos = this.workQueue.poll();
        class_1799 seedStack = this.findSeedsInInventory();
        if (!seedStack.method_7960() && this.field_11863.method_8320(plantPos).method_26215() && (cropState = this.getCropStateFromSeed(seedStack.method_7909())) != null) {
            this.field_11863.method_8652(plantPos, cropState, 3);
            seedStack.method_7934(1);
            this.field_11863.method_8396(null, plantPos, class_3417.field_17611, class_3419.field_15245, 1.0f, 1.0f);
        }
        if (this.workQueue.isEmpty()) {
            this.currentPhase = WorkPhase.SCANNING;
        }
    }

    private void performHarvesting() {
        class_2302 cropBlock;
        if (this.workQueue.isEmpty()) {
            this.currentPhase = WorkPhase.SCANNING;
            return;
        }
        class_2338 harvestPos = this.workQueue.poll();
        class_2680 cropState = this.field_11863.method_8320(harvestPos);
        class_2248 class_22482 = cropState.method_26204();
        if (class_22482 instanceof class_2302 && (cropBlock = (class_2302)class_22482).method_9825(cropState)) {
            List drops = class_2248.method_9562((class_2680)cropState, (class_3218)((class_3218)this.field_11863), (class_2338)harvestPos, null);
            boolean canStore = true;
            ArrayList<class_1799> remainingItems = new ArrayList<class_1799>();
            for (class_1799 drop : drops) {
                class_1799 remaining = this.insertItem(drop.method_7972());
                if (remaining.method_7960()) continue;
                remainingItems.add(remaining);
                canStore = false;
            }
            if (canStore || remainingItems.size() < drops.size()) {
                this.field_11863.method_8652(harvestPos, cropBlock.method_9828(0), 3);
                this.field_11863.method_8396(null, harvestPos, class_3417.field_17610, class_3419.field_15245, 1.0f, 1.0f);
                this.spawnHarvestParticles(harvestPos, cropState);
                for (class_1799 remaining : remainingItems) {
                    class_2248.method_9577((class_1937)this.field_11863, (class_2338)harvestPos, (class_1799)remaining);
                }
            }
        }
        if (this.workQueue.isEmpty()) {
            this.currentPhase = WorkPhase.SCANNING;
        }
    }

    private boolean canTill(class_2680 state) {
        class_2248 block = state.method_26204();
        return block == class_2246.field_10566 || block == class_2246.field_10219 || block == class_2246.field_10253;
    }

    private boolean hasSeedsInInventory() {
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            class_1799 stack = this.inventory.method_5438(i);
            if (!this.isSeed(stack.method_7909())) continue;
            return true;
        }
        return false;
    }

    private class_1799 findSeedsInInventory() {
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            class_1799 stack = this.inventory.method_5438(i);
            if (!this.isSeed(stack.method_7909()) || stack.method_7960()) continue;
            return stack;
        }
        return class_1799.field_8037;
    }

    private boolean isSeed(class_1792 item) {
        if (item instanceof class_1747) {
            class_1747 blockItem = (class_1747)item;
            class_2248 block = blockItem.method_7711();
            return block instanceof class_2302;
        }
        return false;
    }

    private class_2680 getCropStateFromSeed(class_1792 seed) {
        class_1747 blockItem;
        class_2248 block;
        if (seed instanceof class_1747 && (block = (blockItem = (class_1747)seed).method_7711()) instanceof class_2302) {
            return block.method_9564();
        }
        return null;
    }

    private class_1799 insertItem(class_1799 stack) {
        for (int i = 0; i < this.inventory.method_5439() && !(stack = this.inventory.method_5491(stack)).method_7960(); ++i) {
        }
        return stack;
    }

    private boolean hasBoneMeal() {
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            class_1799 stack = this.inventory.method_5438(i);
            if (stack.method_7909() != class_1802.field_8324) continue;
            return true;
        }
        return false;
    }

    private void performBoneMealing() {
        if (!this.hasBoneMeal()) {
            this.currentPhase = WorkPhase.SCANNING;
            return;
        }
        class_238 workArea = this.getWorkArea();
        int minX = (int)Math.floor(workArea.field_1323);
        int maxX = (int)Math.floor(workArea.field_1320 - 0.01);
        int minY = (int)Math.floor(workArea.field_1322);
        int maxY = (int)Math.floor(workArea.field_1325 - 0.01);
        int minZ = (int)Math.floor(workArea.field_1321);
        int maxZ = (int)Math.floor(workArea.field_1324 - 0.01);
        ArrayList<class_2338> cropPositions = new ArrayList<class_2338>();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    class_2302 cropBlock;
                    class_2338 pos = new class_2338(x, y, z);
                    class_2680 cropState2 = this.field_11863.method_8320(pos);
                    class_2248 class_22482 = cropState2.method_26204();
                    if (!(class_22482 instanceof class_2302) || (cropBlock = (class_2302)class_22482).method_9825(cropState2)) continue;
                    cropPositions.add(pos);
                }
            }
        }
        if (cropPositions.isEmpty()) {
            this.currentPhase = WorkPhase.SCANNING;
            return;
        }
        Collections.shuffle(cropPositions, this.random);
        for (class_2338 pos : cropPositions) {
            class_2302 cropBlock;
            class_2680 cropState = this.field_11863.method_8320(pos);
            class_2248 cropState2 = cropState.method_26204();
            if (!(cropState2 instanceof class_2302) || (cropBlock = (class_2302)cropState2).method_9825(cropState)) continue;
            for (int i = 0; i < this.inventory.method_5439(); ++i) {
                class_5819 randomSource;
                class_1799 stack = this.inventory.method_5438(i);
                if (stack.method_7909() != class_1802.field_8324 || !cropBlock.method_9650(this.field_11863, randomSource = this.field_11863.method_8409(), pos, cropState)) continue;
                cropBlock.method_9652((class_3218)this.field_11863, randomSource, pos, cropState);
                ((class_3218)this.field_11863).method_14199((class_2394)class_2398.field_11211, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 10, 0.5, 0.5, 0.5, 0.1);
                stack.method_7934(1);
                if (stack.method_7960()) {
                    this.method_5447(i, class_1799.field_8037);
                }
                this.method_5431();
                this.currentPhase = WorkPhase.SCANNING;
                return;
            }
        }
        this.currentPhase = WorkPhase.SCANNING;
    }

    private void spawnHarvestParticles(class_2338 pos, class_2680 cropState) {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            double x = (double)pos.method_10263() + 0.5;
            double y = (double)pos.method_10264() + 0.5;
            double z = (double)pos.method_10260() + 0.5;
            class_2388 particleOption = new class_2388(class_2398.field_11217, cropState);
            for (int i = 0; i < 10; ++i) {
                double offsetX = this.random.nextGaussian() * 0.3;
                double offsetY = this.random.nextDouble() * 0.3;
                double offsetZ = this.random.nextGaussian() * 0.3;
                serverLevel.method_14199((class_2394)particleOption, x + offsetX, y + offsetY, z + offsetZ, 1, 0.0, 0.1, 0.0, 0.1);
            }
        }
    }

    @Override
    public void setWorkRangeLeft(int range) {
        super.setWorkRangeLeft(range);
        this.clearWorkCache();
    }

    @Override
    public void setWorkRangeRight(int range) {
        super.setWorkRangeRight(range);
        this.clearWorkCache();
    }

    @Override
    public void setWorkRangeUp(int range) {
        super.setWorkRangeUp(range);
        this.clearWorkCache();
    }

    @Override
    public void setWorkRangeDown(int range) {
        super.setWorkRangeDown(range);
        this.clearWorkCache();
    }

    private void clearWorkCache() {
        this.farmlandPositions.clear();
        this.plantPositions.clear();
        this.harvestPositions.clear();
        this.workQueue.clear();
        this.currentPhase = WorkPhase.SCANNING;
    }

    @Override
    @Nullable
    public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
        return new FarmingWorkstationScreenHandler(containerId, playerInventory, this);
    }

    @Override
    public class_2561 getDisplayName() {
        return class_2561.method_43471((String)"hundred_years_war.farming_workstation");
    }

    @Override
    public class_2350 getFacing() {
        class_2680 state = this.method_11010();
        if (state.method_28498((class_2769)FarmingWorkstation.FACING)) {
            return (class_2350)state.method_11654((class_2769)FarmingWorkstation.FACING);
        }
        return class_2350.field_11043;
    }

    @Override
    protected void method_11007(@NotNull class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("currentPhase", this.currentPhase.ordinal());
        tag.method_10569("workTimer", this.workTimer);
        tag.method_10569("nextWorkInterval", this.nextWorkInterval);
    }

    @Override
    public void method_11014(@NotNull class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10545("currentPhase")) {
            this.currentPhase = WorkPhase.values()[tag.method_10550("currentPhase")];
        }
        this.workTimer = tag.method_10550("workTimer");
        this.nextWorkInterval = tag.method_10550("nextWorkInterval");
        if (this.nextWorkInterval <= 0) {
            this.nextWorkInterval = 40;
        }
    }

    @Override
    public int getMaxRangeLeft() {
        return 8;
    }

    @Override
    public int getMaxRangeRight() {
        return 8;
    }

    @Override
    public int getMaxRangeUp() {
        return 16;
    }

    @Override
    public int getMaxRangeDown() {
        return 0;
    }

    private static enum WorkPhase {
        SCANNING,
        TILLING,
        PLANTING,
        HARVESTING,
        BONE_MEALING;

    }
}

