/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.blocks.workstation;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1299;
import net.minecraft.class_1536;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;
import ydmsama.hundred_years_war.main.blocks.ModBlockEntities;
import ydmsama.hundred_years_war.main.blocks.workstation.FishingWorkstation;
import ydmsama.hundred_years_war.main.blocks.workstation.FishingWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.InventoryBoundedWorkstationBlockEntity;

public class FishingWorkstationBlockEntity
extends InventoryBoundedWorkstationBlockEntity {
    private static final int WORK_INTERVAL = 60;
    private static final int FISHING_BASE_CHANCE = 30;
    public static final int MAX_RANGE_LEFT = 8;
    public static final int MAX_RANGE_RIGHT = 8;
    public static final int MAX_RANGE_UP = 16;
    public static final int MAX_RANGE_DOWN = 16;
    public static final int MIN_RANGE_DOWN = -16;
    private final Set<class_2338> waterPositions = new HashSet<class_2338>();
    private int workTimer = 0;
    private final Random random = new Random();

    public FishingWorkstationBlockEntity(class_2338 pos, class_2680 blockState) {
        super(ModBlockEntities.FISHING_WORKSTATION_BLOCK_ENTITY, pos, blockState);
        this.workRangeLeft = 3;
        this.workRangeRight = 3;
        this.workRangeUp = 16;
        this.workRangeDown = -3;
        this.showRange = true;
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, FishingWorkstationBlockEntity blockEntity) {
        if (level != null && !level.field_9236) {
            blockEntity.serverTick();
        }
    }

    private void serverTick() {
        if (!this.activated) {
            return;
        }
        --this.workTimer;
        if (this.workTimer <= 0) {
            this.workTimer = 60 + this.random.nextInt(40) - 20;
            if (this.waterPositions.isEmpty()) {
                this.scanForWaterSources();
            }
            if (!this.waterPositions.isEmpty()) {
                this.performFishing();
            }
        }
    }

    @Override
    public void triggerWork() {
        this.collectDroppedItems();
        if (this.waterPositions.isEmpty()) {
            this.scanForWaterSources();
        }
        if (!this.waterPositions.isEmpty()) {
            this.performFishing();
        }
    }

    private void scanForWaterSources() {
        this.waterPositions.clear();
        class_238 workArea = this.getWorkArea();
        int minX = (int)Math.floor(workArea.field_1323);
        int maxX = (int)Math.floor(workArea.field_1320 - 0.01);
        int minY = (int)Math.floor(workArea.field_1322);
        int maxY = (int)Math.floor(workArea.field_1325 - 0.01);
        int minZ = (int)Math.floor(workArea.field_1321);
        int maxZ = (int)Math.floor(workArea.field_1324 - 0.01);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2338 checkPos = new class_2338(x, y, z);
                    if (!this.isWaterSource(checkPos)) continue;
                    this.waterPositions.add(checkPos);
                }
            }
        }
    }

    private boolean performFishing() {
        if (this.waterPositions.isEmpty()) {
            return false;
        }
        if (this.random.nextInt(100) >= 30) {
            return false;
        }
        ArrayList<class_2338> waterList = new ArrayList<class_2338>(this.waterPositions);
        class_2338 fishingPos = (class_2338)waterList.get(this.random.nextInt(waterList.size()));
        class_1799 fishingResult = this.getFishingLoot(fishingPos);
        if (!fishingResult.method_7960()) {
            class_1799 remaining = this.insertItem(fishingResult.method_7972());
            if (remaining.method_7960()) {
                this.field_11863.method_8396(null, fishingPos, class_3417.field_15093, class_3419.field_15245, 1.0f, 1.0f);
                this.spawnFishingParticles(fishingPos);
                return true;
            }
            class_2248.method_9577((class_1937)this.field_11863, (class_2338)fishingPos, (class_1799)remaining);
            this.field_11863.method_8396(null, fishingPos, class_3417.field_15093, class_3419.field_15245, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    private boolean isWaterSource(class_2338 pos) {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return false;
        }
        class_2680 state = this.field_11863.method_8320(pos);
        class_3610 fluidState = state.method_26227();
        if (!fluidState.method_15767(class_3486.field_15517) || !fluidState.method_15771()) {
            return false;
        }
        class_2680 above = this.field_11863.method_8320(pos.method_10084());
        boolean hasOpenTop = above.method_26215() || above.method_27852(class_2246.field_10588);
        return hasOpenTop;
    }

    private class_1799 getFishingLoot(class_2338 fishingPos) {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return class_1799.field_8037;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        final boolean openWater = this.isOpenWaterFishingSpot(fishingPos);
        class_1536 fishingHook = new class_1536(class_1299.field_6103, (class_1937)serverLevel){

            public boolean method_26088() {
                return openWater;
            }
        };
        fishingHook.method_33574(class_243.method_24953((class_2382)fishingPos));
        class_52 lootTable = serverLevel.method_8503().method_3857().getLootTable(class_39.field_353);
        class_8567 lootParams = new class_8567.class_8568(serverLevel).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)fishingPos)).method_51874(class_181.field_1229, (Object)new class_1799((class_1935)class_1802.field_8378)).method_51877(class_181.field_1226, (Object)fishingHook).method_51871(0.0f).method_51875(class_173.field_1176);
        ObjectArrayList drops = lootTable.method_51878(lootParams);
        if (drops.isEmpty()) {
            return class_1799.field_8037;
        }
        return (class_1799)drops.get(serverLevel.field_9229.method_43048(drops.size()));
    }

    private boolean isOpenWaterFishingSpot(class_2338 blockPos) {
        if (this.field_11863 == null) {
            return false;
        }
        OpenWaterType openWaterType = OpenWaterType.INVALID;
        for (int i = -1; i <= 2; ++i) {
            OpenWaterType layerType = this.getOpenWaterTypeForArea(blockPos.method_10069(-2, i, -2), blockPos.method_10069(2, i, 2));
            switch (layerType) {
                case INVALID: {
                    return false;
                }
                case ABOVE_WATER: {
                    if (openWaterType != OpenWaterType.INVALID) break;
                    return false;
                }
                case INSIDE_WATER: {
                    if (openWaterType != OpenWaterType.ABOVE_WATER) break;
                    return false;
                }
            }
            openWaterType = layerType;
        }
        return true;
    }

    private OpenWaterType getOpenWaterTypeForArea(class_2338 min, class_2338 max) {
        return class_2338.method_20437((class_2338)min, (class_2338)max).map(this::getOpenWaterTypeForBlock).reduce((a, b) -> a == b ? a : OpenWaterType.INVALID).orElse(OpenWaterType.INVALID);
    }

    private OpenWaterType getOpenWaterTypeForBlock(class_2338 pos) {
        class_2680 state = this.field_11863.method_8320(pos);
        if (state.method_26215() || state.method_27852(class_2246.field_10588)) {
            return OpenWaterType.ABOVE_WATER;
        }
        class_3610 fluidState = state.method_26227();
        if (fluidState.method_15767(class_3486.field_15517) && fluidState.method_15771() && state.method_26220((class_1922)this.field_11863, pos).method_1110()) {
            return OpenWaterType.INSIDE_WATER;
        }
        return OpenWaterType.INVALID;
    }

    private class_1799 insertItem(class_1799 stack) {
        for (int i = 0; i < this.inventory.method_5439() && !(stack = this.inventory.method_5491(stack)).method_7960(); ++i) {
        }
        return stack;
    }

    private void spawnFishingParticles(class_2338 pos) {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        class_3218 serverLevel = (class_3218)this.field_11863;
        class_5819 random = serverLevel.method_8409();
        double centerX = (double)pos.method_10263() + 0.5;
        double centerY = (double)pos.method_10264() + 1.0;
        double centerZ = (double)pos.method_10260() + 0.5;
        for (int i = 0; i < 6; ++i) {
            double offsetX = (random.method_43058() - 0.5) * 0.6;
            double offsetZ = (random.method_43058() - 0.5) * 0.6;
            double velX = (random.method_43058() - 0.5) * 0.1;
            double velY = random.method_43058() * 0.1;
            double velZ = (random.method_43058() - 0.5) * 0.1;
            serverLevel.method_14199((class_2394)class_2398.field_11202, centerX + offsetX, centerY, centerZ + offsetZ, 1, velX, velY, velZ, 0.1);
        }
    }

    @Override
    public int getMaxRangeLeft() {
        return 8;
    }

    @Override
    public int getMaxRangeRight() {
        return 8;
    }

    @Override
    public int getMaxRangeUp() {
        return 16;
    }

    @Override
    public int getMaxRangeDown() {
        return 16;
    }

    @Override
    public void setWorkRangeLeft(int range) {
        super.setWorkRangeLeft(range);
        this.clearWorkCache();
    }

    @Override
    public void setWorkRangeRight(int range) {
        super.setWorkRangeRight(range);
        this.clearWorkCache();
    }

    @Override
    public void setWorkRangeUp(int range) {
        super.setWorkRangeUp(range);
        this.clearWorkCache();
    }

    @Override
    public void setWorkRangeDown(int range) {
        this.workRangeDown = Math.max(-16, Math.min(range, this.getMaxRangeDown()));
        this.updateWorkCenter();
        this.method_5431();
        this.syncToClient();
        this.updateRangeChunkLoading();
        this.clearWorkCache();
    }

    private void clearWorkCache() {
        this.waterPositions.clear();
    }

    @Override
    @Nullable
    public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
        return new FishingWorkstationScreenHandler(containerId, playerInventory, this);
    }

    @Override
    public class_2561 getDisplayName() {
        return class_2561.method_43471((String)"hundred_years_war.fishing_workstation");
    }

    @Override
    public class_2350 getFacing() {
        class_2680 state = this.method_11010();
        if (state.method_28498((class_2769)FishingWorkstation.FACING)) {
            return (class_2350)state.method_11654((class_2769)FishingWorkstation.FACING);
        }
        return class_2350.field_11043;
    }

    private static enum OpenWaterType {
        ABOVE_WATER,
        INSIDE_WATER,
        INVALID;

    }
}

