/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.chunk;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ydmsama.hundred_years_war.main.chunk.HywChunkManager;

public class ChunkLoadTestManager
extends class_18 {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChunkLoadTestManager.class);
    private static final String DATA_NAME = "hundred_years_war_chunk_load_test";
    public static final boolean ENABLE_CONSOLE_OUTPUT = true;
    private static volatile boolean testEnabled = false;
    private static final int MIN_DISTANCE_FROM_PLAYER = 5000;
    private static final int MAX_DISTANCE_FROM_PLAYER = 10000;
    private static final int MAX_NEW_DISCOVERIES_PER_TICK = 1;
    private static final int MAX_ACTIVE_LOADS = 1;
    private static final int PRELOAD_BATCH_SIZE = 10;
    private static final int PRELOAD_BATCH_COOLDOWN_TICKS = 40;
    private static final int GRID_SIZE = 512;
    private static final boolean RELEASE_AFTER_GENERATION = true;
    private final Long2ObjectOpenHashMap<ChunkLoadRecord> records = new Long2ObjectOpenHashMap();
    private final LongSet knownGrids = new LongOpenHashSet();
    private transient class_3218 cachedLevel;
    private transient HywChunkManager chunkManager;
    private transient boolean runtimeInitialised;
    private transient Random random;
    private final List<BatchEntry> activeBatch = new ArrayList<BatchEntry>();
    private boolean batchIssued = false;
    private long nextBatchAllowedTick = 0L;
    private long lastTickGameTime = -1L;

    public ChunkLoadTestManager() {
    }

    public ChunkLoadTestManager(class_2487 tag) {
        long[] known;
        class_2499 list = tag.method_10554("records", 10);
        for (int i = 0; i < list.size(); ++i) {
            ChunkLoadRecord record = new ChunkLoadRecord(list.method_10602(i));
            this.records.put(record.gridKey, (Object)record);
            this.knownGrids.add(record.gridKey);
        }
        for (long key : known = tag.method_10565("knownGrids")) {
            this.knownGrids.add(key);
        }
        this.lastTickGameTime = tag.method_10537("lastTick");
    }

    public class_2487 method_75(class_2487 tag) {
        class_2499 list = new class_2499();
        for (ChunkLoadRecord record : this.records.values()) {
            list.add((Object)record.save());
        }
        tag.method_10566("records", (class_2520)list);
        long[] known = this.knownGrids.toLongArray();
        tag.method_10564("knownGrids", known);
        tag.method_10544("lastTick", this.lastTickGameTime);
        return tag;
    }

    public static ChunkLoadTestManager get(class_3218 level) {
        class_26 storage = level.method_17983();
        return (ChunkLoadTestManager)storage.method_17924(ChunkLoadTestManager::new, ChunkLoadTestManager::new, DATA_NAME);
    }

    public static boolean isTestEnabled() {
        return testEnabled;
    }

    public static void setTestEnabled(boolean enabled) {
        testEnabled = enabled;
        LOGGER.info("[ChunkLoadTest] \u6d4b\u8bd5\u6a21\u5f0f {}", (Object)(enabled ? "\u542f\u7528" : "\u7981\u7528"));
    }

    public void tick(class_3218 level) {
        if (!testEnabled) {
            return;
        }
        this.initialiseRuntime(level);
        long gameTime = level.method_8510();
        if (gameTime == this.lastTickGameTime) {
            return;
        }
        this.lastTickGameTime = gameTime;
        List players = level.method_18456();
        this.discoverRandomChunks(level, players);
        this.prepareLoadingCandidates(level, players, gameTime);
        this.processLoadingBatches(level, players, gameTime);
        this.monitorActiveLoads(level);
    }

    private void initialiseRuntime(class_3218 level) {
        if (this.runtimeInitialised && this.cachedLevel == level) {
            return;
        }
        this.cachedLevel = level;
        this.chunkManager = HywChunkManager.get(level);
        this.random = new Random(level.method_8412());
        this.runtimeInitialised = true;
        this.activeBatch.clear();
        this.batchIssued = false;
        this.nextBatchAllowedTick = level.method_8510();
    }

    private boolean hasUnfinishedLoads() {
        for (ChunkLoadRecord record : this.records.values()) {
            if (record.state.isTerminal()) continue;
            return true;
        }
        return false;
    }

    private void discoverRandomChunks(class_3218 level, List<class_3222> players) {
        if (this.hasUnfinishedLoads()) {
            return;
        }
        int discoveredThisTick = 0;
        int maxAttempts = 100;
        for (class_3222 player : players) {
            if (discoveredThisTick >= 1) {
                return;
            }
            class_2338 playerPos = player.method_24515();
            for (int attempt = 0; attempt < maxAttempts; ++attempt) {
                int gridZ;
                int offsetZ;
                double angle = this.random.nextDouble() * Math.PI * 2.0;
                int distanceRange = 5000;
                int distance = 5000 + this.random.nextInt(distanceRange);
                int offsetX = (int)(Math.cos(angle) * (double)distance);
                class_2338 targetPos = playerPos.method_10069(offsetX, 0, offsetZ = (int)(Math.sin(angle) * (double)distance));
                int gridX = Math.floorDiv(targetPos.method_10263(), 512) * 512;
                class_2338 alignedPos = new class_2338(gridX, 64, gridZ = Math.floorDiv(targetPos.method_10260(), 512) * 512);
                long key = ChunkLoadTestManager.gridKey(alignedPos);
                if (this.knownGrids.contains(key) || this.records.containsKey(key)) continue;
                ChunkLoadRecord record = new ChunkLoadRecord(key, alignedPos, level.method_8510());
                this.records.put(key, (Object)record);
                this.knownGrids.add(key);
                ++discoveredThisTick;
                this.method_80();
                double actualDistance = Math.sqrt(alignedPos.method_10262((class_2382)playerPos));
                ChunkLoadTestManager.logInfo("\u53d1\u73b0\u6d4b\u8bd5\u4f4d\u7f6e @ ({}, {}) | \u8ddd\u73a9\u5bb6 {:.0f} \u65b9\u5757 (\u76ee\u6807\uff1a\u6d4b\u8bd5\u65b0\u533a\u5757\u751f\u6210)", alignedPos.method_10263(), alignedPos.method_10260(), actualDistance);
                break;
            }
            if (discoveredThisTick < true) continue;
            return;
        }
    }

    private void prepareLoadingCandidates(class_3218 level, List<class_3222> players, long gameTime) {
        ChunkLoadRecord candidate;
        if (players.isEmpty()) {
            return;
        }
        int activeLoaders = this.countLoadingRecords();
        while (activeLoaders < 1 && (candidate = this.findBestCandidate(players, LoadState.DISCOVERED)) != null) {
            class_1923 centerChunk = new class_1923(candidate.position);
            ArrayList<class_1923> requiredChunks = new ArrayList<class_1923>();
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    requiredChunks.add(new class_1923(centerChunk.field_9181 + dx, centerChunk.field_9180 + dz));
                }
            }
            candidate.requiredChunks = requiredChunks;
            if (requiredChunks.isEmpty()) {
                candidate.state = LoadState.COMPLETED;
                candidate.completedTick = gameTime;
                this.method_80();
                continue;
            }
            candidate.state = LoadState.LOADING;
            candidate.lastStateTick = gameTime;
            ChunkLoadTestManager.logInfo("\u6d4b\u8bd5\u4f4d\u7f6e ({}, {}) \u5f00\u59cb\u52a0\u8f7d | {} \u4e2a\u533a\u5757", candidate.position.method_10263(), candidate.position.method_10260(), requiredChunks.size());
            this.method_80();
            ++activeLoaders;
        }
    }

    private void processLoadingBatches(class_3218 level, List<class_3222> players, long gameTime) {
        if (this.batchIssued) {
            if (this.isCurrentBatchLoaded(level)) {
                this.finalizeBatch(level, gameTime);
            }
            return;
        }
        if (players.isEmpty()) {
            return;
        }
        if (gameTime < this.nextBatchAllowedTick) {
            return;
        }
        List<ChunkLoadRecord> candidates = this.getLoadingRecords(players);
        if (candidates.isEmpty()) {
            return;
        }
        this.activeBatch.clear();
        for (ChunkLoadRecord record : candidates) {
            while (this.activeBatch.size() < 10 && record.requestedCount < record.requiredChunks.size()) {
                int chunkIndex = record.requestedCount;
                class_1923 chunkPos = record.requiredChunks.get(chunkIndex);
                long chunkKey = chunkPos.method_8324();
                if (record.requestedChunks.add(chunkKey)) {
                    this.chunkManager.requestChunk(chunkPos.field_9181, chunkPos.field_9180);
                }
                this.activeBatch.add(new BatchEntry(record, chunkIndex, chunkPos));
                ++record.requestedCount;
            }
            if (this.activeBatch.size() < 10) continue;
            break;
        }
        if (!this.activeBatch.isEmpty()) {
            this.batchIssued = true;
        }
    }

    private boolean isCurrentBatchLoaded(class_3218 level) {
        for (BatchEntry entry : this.activeBatch) {
            if (level.method_8393(entry.chunkPos.field_9181, entry.chunkPos.field_9180)) continue;
            return false;
        }
        return true;
    }

    private void finalizeBatch(class_3218 level, long gameTime) {
        for (BatchEntry entry : this.activeBatch) {
            if (entry.record.loadedCount < entry.chunkIndex + 1) {
                entry.record.loadedCount = entry.chunkIndex + 1;
            }
            if (entry.record.requestedCount >= entry.record.loadedCount) continue;
            entry.record.requestedCount = entry.record.loadedCount;
        }
        this.activeBatch.clear();
        this.batchIssued = false;
        this.nextBatchAllowedTick = gameTime + 40L;
        for (ChunkLoadRecord record : this.records.values()) {
            if (record.state != LoadState.LOADING || record.loadedCount < record.requiredChunks.size()) continue;
            record.state = LoadState.COMPLETED;
            record.completedTick = gameTime;
            long duration = gameTime - record.addedTick;
            ChunkLoadTestManager.logInfo("\u6d4b\u8bd5\u4f4d\u7f6e ({}, {}) \u751f\u6210\u5b8c\u6210 | \u8017\u65f6: {} ticks ({:.2f}\u79d2)", record.position.method_10263(), record.position.method_10260(), duration, (double)duration / 20.0);
            record.lastStateTick = gameTime;
            this.releaseRecordChunks(record);
            ChunkLoadTestManager.logInfo("\u6d4b\u8bd5\u4f4d\u7f6e ({}, {}) \u7684\u533a\u5757\u5df2\u91ca\u653e\uff0c\u7b49\u5f85\u5378\u8f7d", record.position.method_10263(), record.position.method_10260());
            this.method_80();
        }
    }

    private void releaseRecordChunks(ChunkLoadRecord record) {
    }

    private void monitorActiveLoads(class_3218 level) {
    }

    private List<ChunkLoadRecord> getLoadingRecords(List<class_3222> players) {
        ArrayList<ChunkLoadRecord> list = new ArrayList<ChunkLoadRecord>();
        for (ChunkLoadRecord record2 : this.records.values()) {
            if (record2.state != LoadState.LOADING || record2.loadedCount >= record2.requiredChunks.size()) continue;
            list.add(record2);
        }
        list.sort(Comparator.comparingDouble(record -> this.recordDistanceSquared((ChunkLoadRecord)record, players)));
        return list;
    }

    private int countLoadingRecords() {
        int count = 0;
        for (ChunkLoadRecord record : this.records.values()) {
            if (record.state != LoadState.LOADING || record.loadedCount >= record.requiredChunks.size()) continue;
            ++count;
        }
        return count;
    }

    private ChunkLoadRecord findBestCandidate(List<class_3222> players, LoadState state) {
        if (this.records.isEmpty()) {
            return null;
        }
        if (players.isEmpty()) {
            for (ChunkLoadRecord record : this.records.values()) {
                if (record.state != state) continue;
                return record;
            }
            return null;
        }
        double bestDistance = Double.POSITIVE_INFINITY;
        ChunkLoadRecord bestRecord = null;
        for (ChunkLoadRecord record : this.records.values()) {
            double distance;
            if (record.state != state || !Double.isFinite(distance = this.recordDistanceSquared(record, players)) || !(distance < bestDistance)) continue;
            bestRecord = record;
            bestDistance = distance;
        }
        return bestRecord;
    }

    private double recordDistanceSquared(ChunkLoadRecord record, List<class_3222> players) {
        if (players.isEmpty()) {
            return Double.POSITIVE_INFINITY;
        }
        double best = Double.POSITIVE_INFINITY;
        for (class_3222 player : players) {
            double dist = player.method_24515().method_10262((class_2382)record.position);
            if (!(dist < best)) continue;
            best = dist;
        }
        return best;
    }

    public String getStats() {
        long total = this.records.size();
        long completed = this.records.values().stream().filter(r -> r.state == LoadState.COMPLETED).count();
        long loading = this.records.values().stream().filter(r -> r.state == LoadState.LOADING).count();
        long discovered = this.records.values().stream().filter(r -> r.state == LoadState.DISCOVERED).count();
        double avgTime = 0.0;
        int completedCount = 0;
        for (ChunkLoadRecord record : this.records.values()) {
            if (record.state != LoadState.COMPLETED || record.completedTick <= record.addedTick) continue;
            avgTime += (double)(record.completedTick - record.addedTick);
            ++completedCount;
        }
        if (completedCount > 0) {
            avgTime /= (double)completedCount;
        }
        return String.format(Locale.ROOT, "\u6d4b\u8bd5\u603b\u6570:%d | \u5b8c\u6210:%d | \u52a0\u8f7d\u4e2d:%d | \u7b49\u5f85:%d | \u5e73\u5747\u751f\u6210\u65f6\u95f4:%.1f ticks (%.2f\u79d2) | \u8ddd\u79bb:%d-%d\u65b9\u5757 | \u6d4b\u8bd5\u72b6\u6001:%s", total, completed, loading, discovered, avgTime, avgTime / 20.0, 5000, 10000, testEnabled ? "\u542f\u7528" : "\u7981\u7528");
    }

    public void clearRecords() {
        this.records.clear();
        this.knownGrids.clear();
        this.activeBatch.clear();
        this.batchIssued = false;
        this.method_80();
        ChunkLoadTestManager.logInfo("\u5df2\u6e05\u9664\u6240\u6709\u6d4b\u8bd5\u8bb0\u5f55", new Object[0]);
    }

    public void releaseAllChunks() {
        if (this.chunkManager == null || this.cachedLevel == null) {
            ChunkLoadTestManager.logWarn("\u65e0\u6cd5\u91ca\u653e\u533a\u5757\uff1a\u7ba1\u7406\u5668\u672a\u521d\u59cb\u5316", new Object[0]);
            return;
        }
        int releasedCount = 0;
        for (ChunkLoadRecord record : this.records.values()) {
            if (record.requiredChunks == null) continue;
            for (class_1923 chunkPos : record.requiredChunks) {
                if (!record.requestedChunks.contains(chunkPos.method_8324())) continue;
                ++releasedCount;
            }
        }
        ChunkLoadTestManager.logInfo("\u5df2\u6807\u8bb0\u91ca\u653e {} \u4e2a\u6d4b\u8bd5\u533a\u5757\u7684\u7968\u636e", releasedCount);
        ChunkLoadTestManager.logInfo("\u6ce8\u610f\uff1a\u533a\u5757\u53ef\u80fd\u56e0\u4e3a\u73a9\u5bb6\u6216\u5176\u4ed6\u7cfb\u7edf\u800c\u4fdd\u6301\u52a0\u8f7d\u72b6\u6001", new Object[0]);
    }

    public void reset() {
        this.releaseAllChunks();
        this.clearRecords();
        ChunkLoadTestManager.logInfo("\u6d4b\u8bd5\u7cfb\u7edf\u5df2\u5b8c\u5168\u91cd\u7f6e", new Object[0]);
    }

    private static long gridKey(class_2338 pos) {
        int gridX = Math.floorDiv(pos.method_10263(), 512);
        int gridZ = Math.floorDiv(pos.method_10260(), 512);
        return class_1923.method_8331((int)gridX, (int)gridZ);
    }

    private static void logInfo(String message, Object ... args) {
        LOGGER.info(message, args);
    }

    private static void logWarn(String message, Object ... args) {
        LOGGER.warn(message, args);
    }

    private static final class ChunkLoadRecord {
        final long gridKey;
        final class_2338 position;
        LoadState state = LoadState.DISCOVERED;
        long addedTick;
        long completedTick;
        long lastStateTick;
        List<class_1923> requiredChunks = Collections.emptyList();
        final LongSet requestedChunks = new LongOpenHashSet();
        int requestedCount = 0;
        int loadedCount = 0;

        ChunkLoadRecord(long gridKey, class_2338 position, long addedTick) {
            this.gridKey = gridKey;
            this.position = position;
            this.addedTick = addedTick;
        }

        ChunkLoadRecord(class_2487 tag) {
            long[] requested;
            class_2499 list;
            this.gridKey = tag.method_10537("gridKey");
            long posLong = tag.method_10537("position");
            this.position = class_2338.method_10092((long)posLong);
            this.state = LoadState.valueOf(tag.method_10558("state"));
            this.addedTick = tag.method_10537("addedTick");
            this.completedTick = tag.method_10537("completedTick");
            this.lastStateTick = tag.method_10537("lastStateTick");
            if (tag.method_10545("requestedCount")) {
                this.requestedCount = tag.method_10550("requestedCount");
            }
            if (tag.method_10545("loadedCount")) {
                this.loadedCount = tag.method_10550("loadedCount");
            }
            if (!(list = tag.method_10554("requiredChunks", 4)).isEmpty()) {
                this.requiredChunks = new ArrayList<class_1923>(list.size());
                for (class_2520 element : list) {
                    long chunkLong = ((class_2503)element).method_10699();
                    this.requiredChunks.add(new class_1923(chunkLong));
                }
            } else {
                this.requiredChunks = new ArrayList<class_1923>();
            }
            for (long value : requested = tag.method_10565("requestedChunks")) {
                this.requestedChunks.add(value);
            }
        }

        class_2487 save() {
            class_2487 tag = new class_2487();
            tag.method_10544("gridKey", this.gridKey);
            tag.method_10544("position", this.position.method_10063());
            tag.method_10582("state", this.state.name());
            tag.method_10544("addedTick", this.addedTick);
            tag.method_10544("completedTick", this.completedTick);
            tag.method_10544("lastStateTick", this.lastStateTick);
            tag.method_10569("requestedCount", this.requestedCount);
            tag.method_10569("loadedCount", this.loadedCount);
            if (!this.requiredChunks.isEmpty()) {
                class_2499 list = new class_2499();
                for (class_1923 chunk : this.requiredChunks) {
                    list.add((Object)class_2503.method_23251((long)chunk.method_8324()));
                }
                tag.method_10566("requiredChunks", (class_2520)list);
            }
            long[] requested = this.requestedChunks.toLongArray();
            tag.method_10564("requestedChunks", requested);
            return tag;
        }
    }

    private static enum LoadState {
        DISCOVERED,
        LOADING,
        COMPLETED,
        FAILED;


        boolean isTerminal() {
            return this == COMPLETED || this == FAILED;
        }
    }

    private static final class BatchEntry {
        final ChunkLoadRecord record;
        final int chunkIndex;
        final class_1923 chunkPos;

        BatchEntry(ChunkLoadRecord record, int chunkIndex, class_1923 chunkPos) {
            this.record = record;
            this.chunkIndex = chunkIndex;
            this.chunkPos = chunkPos;
        }
    }
}

