/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_7923;
import ydmsama.hundred_years_war.main.commands.ChunkLoadTestCommands;
import ydmsama.hundred_years_war.main.commands.ChunkPreheatCommands;
import ydmsama.hundred_years_war.main.commands.InstGenCommands;
import ydmsama.hundred_years_war.main.commands.PlayerRelationCommands;
import ydmsama.hundred_years_war.main.commands.PregenCommands;
import ydmsama.hundred_years_war.main.commands.StructureCommands;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.goals.TargetAttackGoal;
import ydmsama.hundred_years_war.main.entity.utils.FormationManager;
import ydmsama.hundred_years_war.main.mixins.EntityAccessor;
import ydmsama.hundred_years_war.main.selection.SelectionSystem;
import ydmsama.hundred_years_war.main.utils.ServerRelationHelper;

public class Commands {
    private static final SuggestionProvider<class_2168> SUGGEST_HYW_ENTITIES = (context, builder) -> class_2172.method_9265((Iterable)StreamSupport.stream(class_7923.field_41177.spliterator(), false).filter(entityType -> {
        class_2960 registryName = class_7923.field_41177.method_10221(entityType);
        return registryName != null && registryName.method_12836().equals("hundred_years_war") && entityType.method_5883((class_1937)((class_2168)context.getSource()).method_9225()) instanceof BaseCombatEntity;
    }).map(entityType -> class_7923.field_41177.method_10221(entityType).method_12832()).collect(Collectors.toList()), (SuggestionsBuilder)builder);

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        PlayerRelationCommands.register(dispatcher);
        ChunkLoadTestCommands.register(dispatcher);
        ChunkPreheatCommands.register(dispatcher);
        InstGenCommands.register(dispatcher);
        PregenCommands.register(dispatcher);
        StructureCommands.register(dispatcher);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"hundred_years_war").then(class_2170.method_9247((String)"summon").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"entity", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_HYW_ENTITIES).requires(source -> source.method_9259(2))).executes(context -> {
            String entityName = StringArgumentType.getString((CommandContext)context, (String)"entity");
            class_2168 source = (class_2168)context.getSource();
            Commands.summonEntity(source, entityName, 1, 1, null);
            return 1;
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"entity_level", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            String entityName = StringArgumentType.getString((CommandContext)context, (String)"entity");
            int entityLevel = IntegerArgumentType.getInteger((CommandContext)context, (String)"entity_level");
            class_2168 source = (class_2168)context.getSource();
            Commands.summonEntity(source, entityName, entityLevel, entityLevel, null);
            return 1;
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"equipment_level", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            String entityName = StringArgumentType.getString((CommandContext)context, (String)"entity");
            int entityLevel = IntegerArgumentType.getInteger((CommandContext)context, (String)"entity_level");
            int equipmentLevel = IntegerArgumentType.getInteger((CommandContext)context, (String)"equipment_level");
            class_2168 source = (class_2168)context.getSource();
            Commands.summonEntity(source, entityName, entityLevel, equipmentLevel, null);
            return 1;
        })).then(class_2170.method_9244((String)"owner", (ArgumentType)class_2186.method_9305()).executes(context -> {
            String entityName = StringArgumentType.getString((CommandContext)context, (String)"entity");
            int entityLevel = IntegerArgumentType.getInteger((CommandContext)context, (String)"entity_level");
            int equipmentLevel = IntegerArgumentType.getInteger((CommandContext)context, (String)"equipment_level");
            class_2168 source = (class_2168)context.getSource();
            Commands.summonEntity(source, entityName, entityLevel, equipmentLevel, (class_1297)class_2186.method_9315((CommandContext)context, (String)"owner"));
            return 1;
        }))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"follow").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"soldier", (ArgumentType)class_2186.method_9306()).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            class_3222 player = null;
            try {
                player = source.method_9207();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            int successCount = 0;
            for (class_1297 soldier : class_2186.method_9317((CommandContext)context, (String)"soldier")) {
                if (!(soldier instanceof BaseCombatEntity)) {
                    source.method_9213((class_2561)class_2561.method_43470((String)("Entity " + soldier.method_5477().getString() + " is not a controllable combat unit")));
                    continue;
                }
                BaseCombatEntity combatEntity = (BaseCombatEntity)soldier;
                if (player != null && !ServerRelationHelper.hasControlOver((class_1657)player, (class_1297)combatEntity)) {
                    source.method_9213((class_2561)class_2561.method_43470((String)("You don't have permission to control " + soldier.method_5477().getString())));
                    continue;
                }
                class_1297 targetEntity = class_2186.method_9313((CommandContext)context, (String)"target");
                if (!(targetEntity instanceof class_1309)) {
                    source.method_9213((class_2561)class_2561.method_43470((String)("Target " + targetEntity.method_5477().getString() + " is not a valid follow target")));
                    continue;
                }
                class_1309 livingTarget = (class_1309)targetEntity;
                combatEntity.clearCommandedGoals();
                combatEntity.setFollowTarget(livingTarget);
                ++successCount;
            }
            if (successCount > 0) {
                int finalSuccessCount = successCount;
                source.method_9226(() -> class_2561.method_43470((String)("Successfully commanded " + finalSuccessCount + " units to follow target")), true);
            } else {
                source.method_9213((class_2561)class_2561.method_43470((String)"No units were successfully set to follow"));
            }
            return successCount;
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"stop_follow").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"soldier", (ArgumentType)class_2186.method_9306()).executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            class_3222 player = null;
            try {
                player = source.method_9207();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            int successCount = 0;
            for (class_1297 soldier : class_2186.method_9317((CommandContext)context, (String)"soldier")) {
                if (!(soldier instanceof BaseCombatEntity)) {
                    source.method_9213((class_2561)class_2561.method_43470((String)("Entity " + soldier.method_5477().getString() + " is not a controllable combat unit")));
                    continue;
                }
                BaseCombatEntity combatEntity = (BaseCombatEntity)soldier;
                if (player != null && !ServerRelationHelper.hasControlOver((class_1657)player, (class_1297)combatEntity)) {
                    source.method_9213((class_2561)class_2561.method_43470((String)("You don't have permission to control " + soldier.method_5477().getString())));
                    continue;
                }
                if (combatEntity.getFollowTarget() == null) continue;
                combatEntity.setFollowTarget(null);
                combatEntity.setHomePosition(combatEntity.method_24515());
                ++successCount;
            }
            if (successCount > 0) {
                int finalSuccessCount = successCount;
                source.method_9226(() -> class_2561.method_43470((String)("Successfully commanded " + finalSuccessCount + " units to stop following")), true);
            } else {
                source.method_9213((class_2561)class_2561.method_43470((String)"No units were following a target"));
            }
            return successCount;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"squad_follow").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"squad_number", (ArgumentType)IntegerArgumentType.integer((int)0)).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            class_3222 player = null;
            try {
                player = source.method_9207();
            }
            catch (CommandSyntaxException e) {
                source.method_9213((class_2561)class_2561.method_43470((String)"This command must be executed by a player"));
                return 0;
            }
            int squadNumber = IntegerArgumentType.getInteger((CommandContext)context, (String)"squad_number");
            class_1297 targetEntity = class_2186.method_9313((CommandContext)context, (String)"target");
            if (!(targetEntity instanceof class_1309)) {
                source.method_9213((class_2561)class_2561.method_43470((String)("Target " + targetEntity.method_5477().getString() + " is not a valid follow target")));
                return 0;
            }
            class_1309 livingTarget = (class_1309)targetEntity;
            List<SelectionSystem.Squad> playerSquads = SelectionSystem.getSquads().get(player.method_5667());
            if (playerSquads == null || squadNumber >= playerSquads.size() || playerSquads.get(squadNumber) == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)("Squad #" + squadNumber + " does not exist")));
                return 0;
            }
            SelectionSystem.Squad squad = playerSquads.get(squadNumber);
            class_3218 world = (class_3218)((EntityAccessor)player).getLevel();
            int successCount = 0;
            for (UUID entityUUID : squad.getEntityUUIDs()) {
                class_1297 entity = world.method_14190(entityUUID);
                if (!(entity instanceof BaseCombatEntity)) continue;
                BaseCombatEntity combatEntity = (BaseCombatEntity)entity;
                if (!ServerRelationHelper.hasControlOver((class_1657)player, (class_1297)combatEntity)) {
                    source.method_9213((class_2561)class_2561.method_43470((String)"You don't have permission to control some units in this squad"));
                    continue;
                }
                combatEntity.clearCommandedGoals();
                combatEntity.setFollowTarget(livingTarget);
                ++successCount;
            }
            if (successCount > 0) {
                int finalSuccessCount = successCount;
                source.method_9226(() -> class_2561.method_43470((String)("Successfully commanded " + finalSuccessCount + " units in squad #" + squadNumber + " to follow target")), true);
            } else {
                source.method_9213((class_2561)class_2561.method_43470((String)("No units in squad #" + squadNumber + " could be set to follow")));
            }
            return successCount;
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"squad_stop_follow").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"squad_number", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            class_3222 player = null;
            try {
                player = source.method_9207();
            }
            catch (CommandSyntaxException e) {
                source.method_9213((class_2561)class_2561.method_43470((String)"This command must be executed by a player"));
                return 0;
            }
            int squadNumber = IntegerArgumentType.getInteger((CommandContext)context, (String)"squad_number");
            List<SelectionSystem.Squad> playerSquads = SelectionSystem.getSquads().get(player.method_5667());
            if (playerSquads == null || squadNumber >= playerSquads.size() || playerSquads.get(squadNumber) == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)("Squad #" + squadNumber + " does not exist")));
                return 0;
            }
            SelectionSystem.Squad squad = playerSquads.get(squadNumber);
            class_3218 world = (class_3218)((EntityAccessor)player).getLevel();
            int successCount = 0;
            for (UUID entityUUID : squad.getEntityUUIDs()) {
                class_1297 entity = world.method_14190(entityUUID);
                if (!(entity instanceof BaseCombatEntity)) continue;
                BaseCombatEntity combatEntity = (BaseCombatEntity)entity;
                if (!ServerRelationHelper.hasControlOver((class_1657)player, (class_1297)combatEntity)) {
                    source.method_9213((class_2561)class_2561.method_43470((String)"You don't have permission to control some units in this squad"));
                    continue;
                }
                if (combatEntity.getFollowTarget() == null) continue;
                combatEntity.setFollowTarget(null);
                combatEntity.setHomePosition(combatEntity.method_24515());
                ++successCount;
            }
            if (successCount > 0) {
                int finalSuccessCount = successCount;
                source.method_9226(() -> class_2561.method_43470((String)("Successfully commanded " + finalSuccessCount + " units in squad #" + squadNumber + " to stop following")), true);
            } else {
                source.method_9213((class_2561)class_2561.method_43470((String)("No units in squad #" + squadNumber + " were following a target")));
            }
            return successCount;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"squad_move").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"squad_number", (ArgumentType)IntegerArgumentType.integer((int)0)).then(class_2170.method_9244((String)"attack_move", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            class_3222 player = null;
            try {
                player = source.method_9207();
            }
            catch (CommandSyntaxException e) {
                source.method_9213((class_2561)class_2561.method_43470((String)"This command must be executed by a player"));
                return 0;
            }
            int squadNumber = IntegerArgumentType.getInteger((CommandContext)context, (String)"squad_number");
            boolean attackMove = BoolArgumentType.getBool((CommandContext)context, (String)"attack_move");
            List<SelectionSystem.Squad> playerSquads = SelectionSystem.getSquads().get(player.method_5667());
            if (playerSquads == null || squadNumber >= playerSquads.size() || playerSquads.get(squadNumber) == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)("Squad #" + squadNumber + " does not exist")));
                return 0;
            }
            class_2338 targetPos = Commands.getPlayerLookTargetPos((class_1657)player, 200);
            if (targetPos == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)"Failed to get target position"));
                return 0;
            }
            SelectionSystem.Squad squad = playerSquads.get(squadNumber);
            class_3218 world = (class_3218)((EntityAccessor)player).getLevel();
            ArrayList<BaseCombatEntity> entities = new ArrayList<BaseCombatEntity>();
            for (UUID entityUUID : squad.getEntityUUIDs()) {
                class_1297 entity = world.method_14190(entityUUID);
                if (!(entity instanceof BaseCombatEntity)) continue;
                BaseCombatEntity combatEntity = (BaseCombatEntity)entity;
                if (!ServerRelationHelper.hasControlOver((class_1657)player, (class_1297)combatEntity)) {
                    source.method_9213((class_2561)class_2561.method_43470((String)"You don't have permission to control some units in this squad"));
                    continue;
                }
                entities.add(combatEntity);
            }
            if (entities.isEmpty()) {
                source.method_9213((class_2561)class_2561.method_43470((String)("No units in squad #" + squadNumber + " could be commanded")));
                return 0;
            }
            int priority = attackMove ? 3 : 1;
            FormationManager.move(entities, targetPos, priority, false);
            int finalEntityCount = entities.size();
            if (attackMove) {
                source.method_9226(() -> class_2561.method_43470((String)("Successfully commanded " + finalEntityCount + " units in squad #" + squadNumber + " to attack-move to position (" + targetPos.method_10263() + ", " + targetPos.method_10264() + ", " + targetPos.method_10260() + ")")), true);
            } else {
                source.method_9226(() -> class_2561.method_43470((String)("Successfully commanded " + finalEntityCount + " units in squad #" + squadNumber + " to move to position (" + targetPos.method_10263() + ", " + targetPos.method_10264() + ", " + targetPos.method_10260() + ")")), true);
            }
            return entities.size();
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"squad_form_move").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"squad_number", (ArgumentType)IntegerArgumentType.integer((int)0)).then(class_2170.method_9244((String)"attack_move", (ArgumentType)BoolArgumentType.bool()).then(class_2170.method_9244((String)"formation_type", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9253((String[])new String[]{"loose", "tight", "line", "circle", "wedge"}, (SuggestionsBuilder)builder)).executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            class_3222 player = null;
            try {
                player = source.method_9207();
            }
            catch (CommandSyntaxException e) {
                source.method_9213((class_2561)class_2561.method_43470((String)"This command must be executed by a player"));
                return 0;
            }
            int squadNumber = IntegerArgumentType.getInteger((CommandContext)context, (String)"squad_number");
            boolean attackMove = BoolArgumentType.getBool((CommandContext)context, (String)"attack_move");
            String formationType = StringArgumentType.getString((CommandContext)context, (String)"formation_type");
            List<SelectionSystem.Squad> playerSquads = SelectionSystem.getSquads().get(player.method_5667());
            if (playerSquads == null || squadNumber >= playerSquads.size() || playerSquads.get(squadNumber) == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)("Squad #" + squadNumber + " does not exist")));
                return 0;
            }
            class_2338 targetPos = Commands.getPlayerLookTargetPos((class_1657)player, 200);
            if (targetPos == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)"Failed to get target position"));
                return 0;
            }
            SelectionSystem.Squad squad = playerSquads.get(squadNumber);
            class_3218 world = (class_3218)((EntityAccessor)player).getLevel();
            ArrayList<BaseCombatEntity> entities = new ArrayList<BaseCombatEntity>();
            for (UUID entityUUID : squad.getEntityUUIDs()) {
                class_1297 entity = world.method_14190(entityUUID);
                if (!(entity instanceof BaseCombatEntity)) continue;
                BaseCombatEntity combatEntity = (BaseCombatEntity)entity;
                if (!ServerRelationHelper.hasControlOver((class_1657)player, (class_1297)combatEntity)) {
                    source.method_9213((class_2561)class_2561.method_43470((String)"You don't have permission to control some units in this squad"));
                    continue;
                }
                entities.add(combatEntity);
            }
            if (entities.isEmpty()) {
                source.method_9213((class_2561)class_2561.method_43470((String)("No units in squad #" + squadNumber + " could be commanded")));
                return 0;
            }
            int priority = attackMove ? 3 : 1;
            FormationManager.formMove(entities, targetPos, priority, false, formationType);
            int finalEntityCount = entities.size();
            if (attackMove) {
                source.method_9226(() -> class_2561.method_43470((String)("Successfully commanded " + finalEntityCount + " units in squad #" + squadNumber + " to formation attack-move (" + formationType + ") to position (" + targetPos.method_10263() + ", " + targetPos.method_10264() + ", " + targetPos.method_10260() + ")")), true);
            } else {
                source.method_9226(() -> class_2561.method_43470((String)("Successfully commanded " + finalEntityCount + " units in squad #" + squadNumber + " to formation move (" + formationType + ") to position (" + targetPos.method_10263() + ", " + targetPos.method_10264() + ", " + targetPos.method_10260() + ")")), true);
            }
            return entities.size();
        })))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"move").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).then(class_2170.method_9244((String)"attack_move", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            class_3222 player = null;
            try {
                player = source.method_9207();
            }
            catch (CommandSyntaxException e) {
                source.method_9213((class_2561)class_2561.method_43470((String)"This command must be executed by a player"));
                return 0;
            }
            boolean attackMove = BoolArgumentType.getBool((CommandContext)context, (String)"attack_move");
            class_2338 targetPos = Commands.getPlayerLookTargetPos((class_1657)player, 200);
            if (targetPos == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)"Failed to get target position"));
                return 0;
            }
            ArrayList<BaseCombatEntity> entities = new ArrayList<BaseCombatEntity>();
            for (class_1297 entity : class_2186.method_9317((CommandContext)context, (String)"entities")) {
                if (!(entity instanceof BaseCombatEntity)) continue;
                BaseCombatEntity combatEntity = (BaseCombatEntity)entity;
                if (!ServerRelationHelper.hasControlOver((class_1657)player, (class_1297)combatEntity)) {
                    source.method_9213((class_2561)class_2561.method_43470((String)("You don't have permission to control " + entity.method_5477().getString())));
                    continue;
                }
                entities.add(combatEntity);
            }
            if (entities.isEmpty()) {
                source.method_9213((class_2561)class_2561.method_43470((String)"No valid units could be commanded"));
                return 0;
            }
            int priority = attackMove ? 3 : 1;
            FormationManager.move(entities, targetPos, priority, false);
            int finalEntityCount = entities.size();
            if (attackMove) {
                source.method_9226(() -> class_2561.method_43470((String)("Successfully commanded " + finalEntityCount + " units to attack-move to position (" + targetPos.method_10263() + ", " + targetPos.method_10264() + ", " + targetPos.method_10260() + ")")), true);
            } else {
                source.method_9226(() -> class_2561.method_43470((String)("Successfully commanded " + finalEntityCount + " units to move to position (" + targetPos.method_10263() + ", " + targetPos.method_10264() + ", " + targetPos.method_10260() + ")")), true);
            }
            return entities.size();
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"form_move").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).then(class_2170.method_9244((String)"attack_move", (ArgumentType)BoolArgumentType.bool()).then(class_2170.method_9244((String)"formation_type", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9253((String[])new String[]{"loose", "tight", "line", "circle", "wedge"}, (SuggestionsBuilder)builder)).executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            class_3222 player = null;
            try {
                player = source.method_9207();
            }
            catch (CommandSyntaxException e) {
                source.method_9213((class_2561)class_2561.method_43470((String)"This command must be executed by a player"));
                return 0;
            }
            boolean attackMove = BoolArgumentType.getBool((CommandContext)context, (String)"attack_move");
            String formationType = StringArgumentType.getString((CommandContext)context, (String)"formation_type");
            class_2338 targetPos = Commands.getPlayerLookTargetPos((class_1657)player, 200);
            if (targetPos == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)"Failed to get target position"));
                return 0;
            }
            ArrayList<BaseCombatEntity> entities = new ArrayList<BaseCombatEntity>();
            for (class_1297 entity : class_2186.method_9317((CommandContext)context, (String)"entities")) {
                if (!(entity instanceof BaseCombatEntity)) continue;
                BaseCombatEntity combatEntity = (BaseCombatEntity)entity;
                if (!ServerRelationHelper.hasControlOver((class_1657)player, (class_1297)combatEntity)) {
                    source.method_9213((class_2561)class_2561.method_43470((String)("You don't have permission to control " + entity.method_5477().getString())));
                    continue;
                }
                entities.add(combatEntity);
            }
            if (entities.isEmpty()) {
                source.method_9213((class_2561)class_2561.method_43470((String)"No valid units could be commanded"));
                return 0;
            }
            int priority = attackMove ? 3 : 1;
            FormationManager.formMove(entities, targetPos, priority, false, formationType);
            int finalEntityCount = entities.size();
            if (attackMove) {
                source.method_9226(() -> class_2561.method_43470((String)("Successfully commanded " + finalEntityCount + " units to formation attack-move (" + formationType + ") to position (" + targetPos.method_10263() + ", " + targetPos.method_10264() + ", " + targetPos.method_10260() + ")")), true);
            } else {
                source.method_9226(() -> class_2561.method_43470((String)("Successfully commanded " + finalEntityCount + " units to formation move (" + formationType + ") to position (" + targetPos.method_10263() + ", " + targetPos.method_10264() + ", " + targetPos.method_10260() + ")")), true);
            }
            return entities.size();
        })))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"attack_target").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            class_3222 player = null;
            try {
                player = source.method_9207();
            }
            catch (CommandSyntaxException e) {
                source.method_9213((class_2561)class_2561.method_43470((String)"This command must be executed by a player"));
                return 0;
            }
            class_1309 targetEntity = Commands.getPlayerLookTargetEntity((class_1657)player, 200);
            if (targetEntity == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)"No target entity found in your line of sight"));
                return 0;
            }
            ArrayList<BaseCombatEntity> entities = new ArrayList<BaseCombatEntity>();
            for (Object entity : class_2186.method_9317((CommandContext)context, (String)"entities")) {
                if (!(entity instanceof BaseCombatEntity)) continue;
                BaseCombatEntity combatEntity = (BaseCombatEntity)entity;
                if (!ServerRelationHelper.hasControlOver((class_1657)player, (class_1297)combatEntity)) {
                    source.method_9213((class_2561)class_2561.method_43470((String)("You don't have permission to control " + entity.method_5477().getString())));
                    continue;
                }
                entities.add(combatEntity);
            }
            if (entities.isEmpty()) {
                source.method_9213((class_2561)class_2561.method_43470((String)"No valid units could be commanded"));
                return 0;
            }
            int successCount = 0;
            for (BaseCombatEntity combatEntity : entities) {
                TargetAttackGoal targetAttackGoal = new TargetAttackGoal(combatEntity, 1.0, combatEntity.getAttackReach(), targetEntity);
                combatEntity.clearCommandedGoals();
                combatEntity.addCustomGoal(1, targetAttackGoal);
                ++successCount;
            }
            int finalSuccessCount = successCount;
            String targetName = targetEntity.method_5477().getString();
            source.method_9226(() -> class_2561.method_43470((String)("Successfully commanded " + finalSuccessCount + " units to attack target: " + targetName)), true);
            return successCount;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"squad_attack_target").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"squad_number", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            class_3222 player = null;
            try {
                player = source.method_9207();
            }
            catch (CommandSyntaxException e) {
                source.method_9213((class_2561)class_2561.method_43470((String)"This command must be executed by a player"));
                return 0;
            }
            int squadNumber = IntegerArgumentType.getInteger((CommandContext)context, (String)"squad_number");
            class_1309 targetEntity = Commands.getPlayerLookTargetEntity((class_1657)player, 200);
            if (targetEntity == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)"No target entity found in your line of sight"));
                return 0;
            }
            List<SelectionSystem.Squad> playerSquads = SelectionSystem.getSquads().get(player.method_5667());
            if (playerSquads == null || squadNumber >= playerSquads.size() || playerSquads.get(squadNumber) == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)("Squad #" + squadNumber + " does not exist")));
                return 0;
            }
            SelectionSystem.Squad squad = playerSquads.get(squadNumber);
            class_3218 world = (class_3218)((EntityAccessor)player).getLevel();
            int successCount = 0;
            for (UUID entityUUID : squad.getEntityUUIDs()) {
                class_1297 entity = world.method_14190(entityUUID);
                if (!(entity instanceof BaseCombatEntity)) continue;
                BaseCombatEntity combatEntity = (BaseCombatEntity)entity;
                if (!ServerRelationHelper.hasControlOver((class_1657)player, (class_1297)combatEntity)) {
                    source.method_9213((class_2561)class_2561.method_43470((String)"You don't have permission to control some units in this squad"));
                    continue;
                }
                TargetAttackGoal targetAttackGoal = new TargetAttackGoal(combatEntity, 1.0, combatEntity.getAttackReach(), targetEntity);
                combatEntity.clearCommandedGoals();
                combatEntity.addCustomGoal(1, targetAttackGoal);
                ++successCount;
            }
            int finalSuccessCount = successCount;
            String targetName = targetEntity.method_5477().getString();
            source.method_9226(() -> class_2561.method_43470((String)("Successfully commanded " + finalSuccessCount + " units in squad #" + squadNumber + " to attack target: " + targetName)), true);
            return successCount;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add_to_squad").requires(source -> source.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"squad_number", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            class_3222 player = null;
            try {
                player = source.method_9207();
            }
            catch (CommandSyntaxException e) {
                source.method_9213((class_2561)class_2561.method_43470((String)"This command must be executed by a player"));
                return 0;
            }
            int squadNumber = IntegerArgumentType.getInteger((CommandContext)context, (String)"squad_number");
            class_1309 targetEntity = Commands.getPlayerLookTargetEntity((class_1657)player, 200);
            if (targetEntity == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)"No target entity found in your line of sight"));
                return 0;
            }
            if (!(targetEntity instanceof BaseCombatEntity)) {
                source.method_9213((class_2561)class_2561.method_43470((String)"Target entity is not a valid combat unit"));
                return 0;
            }
            if (!ServerRelationHelper.hasControlOver((class_1657)player, (class_1297)targetEntity)) {
                source.method_9213((class_2561)class_2561.method_43470((String)("You don't have permission to control " + targetEntity.method_5477().getString())));
                return 0;
            }
            List playerSquads = SelectionSystem.getSquads().computeIfAbsent(player.method_5667(), k -> new ArrayList());
            while (playerSquads.size() <= squadNumber) {
                playerSquads.add(new SelectionSystem.Squad(new ArrayList<UUID>()));
            }
            SelectionSystem.Squad squad = (SelectionSystem.Squad)playerSquads.get(squadNumber);
            List<UUID> squadEntityUUIDs = squad.getEntityUUIDs();
            if (squadEntityUUIDs.contains(targetEntity.method_5667())) {
                source.method_9213((class_2561)class_2561.method_43470((String)("Target entity is already in squad #" + squadNumber)));
                return 0;
            }
            squadEntityUUIDs.add(targetEntity.method_5667());
            squad.setEntityUUIDs(squadEntityUUIDs);
            playerSquads.set(squadNumber, squad);
            SelectionSystem.getSquads().put(player.method_5667(), playerSquads);
            String targetName = targetEntity.method_5477().getString();
            source.method_9226(() -> class_2561.method_43470((String)("Successfully added " + targetName + " to squad #" + squadNumber)), true);
            return 1;
        })).then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            class_3222 player = null;
            try {
                player = source.method_9207();
            }
            catch (CommandSyntaxException e) {
                source.method_9213((class_2561)class_2561.method_43470((String)"This command must be executed by a player"));
                return 0;
            }
            int squadNumber = IntegerArgumentType.getInteger((CommandContext)context, (String)"squad_number");
            ArrayList<BaseCombatEntity> entitiesToAdd = new ArrayList<BaseCombatEntity>();
            for (class_1297 entity : class_2186.method_9317((CommandContext)context, (String)"entities")) {
                if (!(entity instanceof BaseCombatEntity)) continue;
                BaseCombatEntity combatEntity = (BaseCombatEntity)entity;
                if (!ServerRelationHelper.hasControlOver((class_1657)player, (class_1297)combatEntity)) {
                    source.method_9213((class_2561)class_2561.method_43470((String)("You don't have permission to control " + entity.method_5477().getString())));
                    continue;
                }
                entitiesToAdd.add(combatEntity);
            }
            if (entitiesToAdd.isEmpty()) {
                source.method_9213((class_2561)class_2561.method_43470((String)"No valid units could be added to squad"));
                return 0;
            }
            List playerSquads = SelectionSystem.getSquads().computeIfAbsent(player.method_5667(), k -> new ArrayList());
            while (playerSquads.size() <= squadNumber) {
                playerSquads.add(new SelectionSystem.Squad(new ArrayList<UUID>()));
            }
            SelectionSystem.Squad squad = (SelectionSystem.Squad)playerSquads.get(squadNumber);
            List<UUID> squadEntityUUIDs = squad.getEntityUUIDs();
            int successCount = 0;
            for (BaseCombatEntity entity : entitiesToAdd) {
                if (squadEntityUUIDs.contains(entity.method_5667())) continue;
                squadEntityUUIDs.add(entity.method_5667());
                ++successCount;
            }
            if (successCount > 0) {
                squad.setEntityUUIDs(squadEntityUUIDs);
                playerSquads.set(squadNumber, squad);
                SelectionSystem.getSquads().put(player.method_5667(), playerSquads);
                int finalSuccessCount = successCount;
                source.method_9226(() -> class_2561.method_43470((String)("Successfully added " + finalSuccessCount + " units to squad #" + squadNumber)), true);
            } else {
                source.method_9213((class_2561)class_2561.method_43470((String)("No new units were added to squad #" + squadNumber)));
            }
            return successCount;
        }))))).then(class_2170.method_9247((String)"owner").executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            class_3222 player = null;
            try {
                player = source.method_9207();
            }
            catch (CommandSyntaxException e) {
                source.method_9213((class_2561)class_2561.method_43470((String)"This command must be executed by a player"));
                return 0;
            }
            class_1309 targetEntity = Commands.getPlayerLookTargetEntity((class_1657)player, 200);
            if (targetEntity == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)"No entity found in your line of sight"));
                return 0;
            }
            if (!(targetEntity instanceof BaseCombatEntity)) {
                source.method_9213((class_2561)class_2561.method_43470((String)"Target entity is not a combat unit"));
                return 0;
            }
            BaseCombatEntity combatEntity = (BaseCombatEntity)targetEntity;
            UUID ownerUUID = combatEntity.method_6139();
            if (ownerUUID == null) {
                source.method_9226(() -> Commands.lambda$registerCommands$51((class_1297)targetEntity), false);
                return 1;
            }
            class_3218 serverLevel = source.method_9225();
            class_3222 ownerPlayer = serverLevel.method_8503().method_3760().method_14602(ownerUUID);
            if (ownerPlayer != null) {
                String entityName = targetEntity.method_5477().getString();
                String ownerName = ownerPlayer.method_5477().getString();
                source.method_9226(() -> class_2561.method_43470((String)("Entity: " + entityName + "\nOwner: " + ownerName + "\nUUID: " + ownerUUID)), false);
            } else {
                String entityName = targetEntity.method_5477().getString();
                source.method_9226(() -> class_2561.method_43470((String)("Entity: " + entityName + "\nOwner UUID: " + ownerUUID + "\n(Owner is offline)")), false);
            }
            return 1;
        })));
    }

    private static class_2338 getPlayerLookTargetPos(class_1657 player, int maxDistance) {
        class_243 startPos = player.method_33571();
        class_243 lookVec = player.method_5828(1.0f);
        class_243 endPos = startPos.method_1031(lookVec.field_1352 * (double)maxDistance, lookVec.field_1351 * (double)maxDistance, lookVec.field_1350 * (double)maxDistance);
        class_3965 blockResult = player.method_37908().method_17742(new class_3959(startPos, endPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
        if (blockResult.method_17783() != class_239.class_240.field_1333) {
            return blockResult.method_17777();
        }
        return new class_2338((int)endPos.field_1352, (int)endPos.field_1351, (int)endPos.field_1350);
    }

    private static class_1309 getPlayerLookTargetEntity(class_1657 player, int maxDistance) {
        class_243 startPos = player.method_33571();
        class_243 lookVec = player.method_5828(1.0f);
        class_243 endPos = startPos.method_1031(lookVec.field_1352 * (double)maxDistance, lookVec.field_1351 * (double)maxDistance, lookVec.field_1350 * (double)maxDistance);
        class_3965 blockResult = player.method_37908().method_17742(new class_3959(startPos, endPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
        double blockDistance = Double.MAX_VALUE;
        if (blockResult.method_17783() != class_239.class_240.field_1333) {
            blockDistance = startPos.method_1025(blockResult.method_17784());
        }
        class_1309 closestEntity = null;
        double closestDistance = Double.MAX_VALUE;
        class_238 searchBox = new class_238(startPos.field_1352 - (double)maxDistance, startPos.field_1351 - (double)maxDistance, startPos.field_1350 - (double)maxDistance, startPos.field_1352 + (double)maxDistance, startPos.field_1351 + (double)maxDistance, startPos.field_1350 + (double)maxDistance);
        List entities = player.method_37908().method_8335((class_1297)player, searchBox);
        for (class_1297 entity : entities) {
            double distance;
            class_243 rayEndPos;
            class_238 entityBox;
            Optional hitPos;
            if (entity == player || !entity.method_5805() || !(entity instanceof class_1309) || !(hitPos = (entityBox = entity.method_5829().method_1014(0.3)).method_992(startPos, rayEndPos = startPos.method_1019(lookVec.method_1021((double)maxDistance)))).isPresent() || !((distance = startPos.method_1025((class_243)hitPos.get())) < closestDistance) || !(distance < blockDistance)) continue;
            closestEntity = (class_1309)entity;
            closestDistance = distance;
        }
        return closestEntity;
    }

    public static void summonEntity(class_2168 source, String entityName, int entityLevel, int equipmentLevel, class_1297 owner) throws CommandSyntaxException {
        class_3218 world = source.method_9225();
        String fullEntityName = "hundred_years_war:" + entityName;
        class_1299 entityType = class_1299.method_5898((String)fullEntityName).orElse(null);
        if (entityType != null && entityType.method_5883((class_1937)world) instanceof BaseCombatEntity) {
            BaseCombatEntity entity = (BaseCombatEntity)entityType.method_5883((class_1937)world);
            assert (entity != null);
            if (owner instanceof class_1657) {
                class_1657 player = (class_1657)owner;
                entity.method_6732(player.method_5667());
            }
            entity.method_5808(source.method_9222().field_1352, source.method_9222().field_1351, source.method_9222().field_1350, 0.0f, 0.0f);
            if (entityLevel > 0) {
                entity.setLevel(1);
                entity.setExperiencePoints(0);
                for (int i = 1; i < entityLevel; ++i) {
                    entity.levelUp();
                }
                entity.setExperiencePoints(0);
            }
            entity.setEquipment(equipmentLevel);
            world.method_8649((class_1297)entity);
            entity.setHomePosition(entity.method_24515());
            source.method_9226(() -> class_2561.method_43470((String)("Successfully summoned " + entityName + (String)(entityLevel > 0 ? " (Entity Level: " + entityLevel + ")" : "") + (String)(equipmentLevel > 0 ? " (Equipment Level: " + equipmentLevel + ")" : ""))), true);
        } else {
            source.method_9213((class_2561)class_2561.method_43470((String)"Failed to summon entity"));
        }
    }

    private static /* synthetic */ class_2561 lambda$registerCommands$51(class_1297 targetEntity) {
        return class_2561.method_43470((String)("Entity: " + targetEntity.method_5477().getString() + "\nOwner: No owner (\u91ce\u751f\u5355\u4f4d)"));
    }
}

