/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3312;
import ydmsama.hundred_years_war.main.utils.RelationSystem;

public class PlayerRelationCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"hundred_years_war").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"relation").then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).then(class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            for (RelationSystem.RelationType type : RelationSystem.RelationType.values()) {
                builder.suggest(type.name().toLowerCase());
            }
            return builder.buildFuture();
        }).executes(context -> PlayerRelationCommands.setRelation((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"type"))))))).then(class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).executes(PlayerRelationCommands::getRelation)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(PlayerRelationCommands::listAllRelations)).then(class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            for (RelationSystem.RelationType type : RelationSystem.RelationType.values()) {
                builder.suggest(type.name().toLowerCase());
            }
            return builder.buildFuture();
        }).executes(context -> PlayerRelationCommands.listRelationsByType((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"type")))))));
    }

    private static int setRelation(CommandContext<class_2168> context, String relationTypeStr) {
        try {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            Collection targets = class_2191.method_9330(context, (String)"player");
            RelationSystem.RelationType relationType = RelationSystem.RelationType.valueOf(relationTypeStr.toUpperCase());
            for (GameProfile target : targets) {
                UUID targetUUID = target.getId();
                if (player.method_5667().equals(targetUUID)) {
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"relation.error.self"));
                    continue;
                }
                RelationSystem.setRelation(player.method_5667(), targetUUID, relationType);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"relation.set.success", (Object[])new Object[]{target.getName(), class_2561.method_43471((String)("relation.type." + relationType.name().toLowerCase()))}), false);
            }
            return 1;
        }
        catch (IllegalArgumentException e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"relation.error.invalid_type"));
            return 0;
        }
        catch (Exception e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"relation.error.generic", (Object[])new Object[]{e.getMessage()}));
            return 0;
        }
    }

    private static int getRelation(CommandContext<class_2168> context) {
        try {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            Collection targets = class_2191.method_9330(context, (String)"player");
            for (GameProfile target : targets) {
                UUID targetUUID = target.getId();
                RelationSystem.RelationType myRelation = RelationSystem.getRelation(player.method_5667(), targetUUID);
                RelationSystem.RelationType theirRelation = RelationSystem.getRelation(targetUUID, player.method_5667());
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"relation.get.result.my", (Object[])new Object[]{target.getName(), class_2561.method_43471((String)("relation.type." + myRelation.name().toLowerCase()))}), false);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"relation.get.result.their", (Object[])new Object[]{target.getName(), class_2561.method_43471((String)("relation.type." + theirRelation.name().toLowerCase()))}), false);
                if (!RelationSystem.hasMutualRelation(player.method_5667(), targetUUID)) continue;
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"relation.get.result.mutual", (Object[])new Object[]{class_2561.method_43471((String)("relation.type." + myRelation.name().toLowerCase()))}), false);
            }
            return 1;
        }
        catch (Exception e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"relation.error.get", (Object[])new Object[]{e.getMessage()}));
            return 0;
        }
    }

    private static int listAllRelations(CommandContext<class_2168> context) {
        try {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            Map<UUID, RelationSystem.RelationType> relations = RelationSystem.getAllRelations(player.method_5667());
            if (relations.isEmpty()) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"relation.list.empty"), false);
                return 1;
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"relation.list.header"), false);
            class_3312 profileCache = ((class_2168)context.getSource()).method_9211().method_3793();
            for (Map.Entry<UUID, RelationSystem.RelationType> entry : relations.entrySet()) {
                UUID targetUUID = entry.getKey();
                RelationSystem.RelationType relation = entry.getValue();
                Optional<String> nameOpt = profileCache.method_14512(targetUUID).map(profile -> profile.getName());
                String name = nameOpt.orElse(targetUUID.toString());
                boolean isMutual = RelationSystem.hasMutualRelation(player.method_5667(), targetUUID, relation);
                if (isMutual) {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"relation.list.entry.mutual", (Object[])new Object[]{name, class_2561.method_43471((String)("relation.type." + relation.name().toLowerCase()))}), false);
                    continue;
                }
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"relation.list.entry", (Object[])new Object[]{name, class_2561.method_43471((String)("relation.type." + relation.name().toLowerCase()))}), false);
            }
            return 1;
        }
        catch (Exception e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"relation.error.list", (Object[])new Object[]{e.getMessage()}));
            return 0;
        }
    }

    private static int listRelationsByType(CommandContext<class_2168> context, String relationTypeStr) {
        try {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            RelationSystem.RelationType relationType = RelationSystem.RelationType.valueOf(relationTypeStr.toUpperCase());
            Map<UUID, RelationSystem.RelationType> relations = RelationSystem.getRelationsByType(player.method_5667(), relationType);
            if (relations.isEmpty()) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"relation.list.type.empty", (Object[])new Object[]{class_2561.method_43471((String)("relation.type." + relationType.name().toLowerCase()))}), false);
                return 1;
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"relation.list.type.header", (Object[])new Object[]{class_2561.method_43471((String)("relation.type." + relationType.name().toLowerCase()))}), false);
            class_3312 profileCache = ((class_2168)context.getSource()).method_9211().method_3793();
            for (UUID targetUUID : relations.keySet()) {
                Optional<String> nameOpt = profileCache.method_14512(targetUUID).map(profile -> profile.getName());
                String name = nameOpt.orElse(targetUUID.toString());
                boolean isMutual = RelationSystem.hasMutualRelation(player.method_5667(), targetUUID, relationType);
                if (isMutual) {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"relation.list.type.entry.mutual", (Object[])new Object[]{name}), false);
                    continue;
                }
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"relation.list.type.entry", (Object[])new Object[]{name}), false);
            }
            return 1;
        }
        catch (IllegalArgumentException e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"relation.error.invalid_type"));
            return 0;
        }
        catch (Exception e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"relation.error.list_type", (Object[])new Object[]{e.getMessage()}));
            return 0;
        }
    }
}

