/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;
import ydmsama.hundred_years_war.main.config.RecruitBalanceConfig;

public class ServerModConfig {
    public static final ServerModConfig INSTANCE = new ServerModConfig();
    private static final int CONFIG_VERSION = 1;
    private int configVersion = 1;
    public boolean enableRecruitBalance = true;
    public boolean enableFirstJoinManual = true;
    public boolean enableScrollLootGeneration = true;
    public boolean enableScrollMobDrops = true;
    public boolean allowSoldierRecall = true;
    public boolean allowEquipmentChange = true;
    public boolean allowSiegeRecall = false;
    public boolean enablePlayerPuppets = true;
    public double followDistanceInner = 5.0;
    public double followDistanceOuter = 15.0;
    public float baseCombatEntityPathfindingRange = 35.0f;
    public int pathfindingTasksPerTick = 10;
    public int soldierLevelCap = 99999;
    public boolean allowLevel4ArmySummoning = false;
    public boolean allowNecromancySummoning = false;
    public boolean enableWorshipMechanism = true;
    public boolean enableSiegeTreeFelling = true;
    public double siegeTreeFellingExtraRange = 3.0;
    public int siegeTreeFellingInterval = 40;
    public double siegeTreeFellingMoveThreshold = 2.0;
    public int maxTreeLogCount = 100;
    public int minTreeLogCount = 1;
    public int maxTreeHeight = 30;
    public int minTreeHeight = 1;
    public int maxSiegeTreeBlocksPerAction = 50;
    public float siegeTreeParticleChance = 0.3f;
    public boolean allowMeleeAttackCreeper = false;
    public double playerFriendlyFireDamageMultiplier = 0.5;
    public boolean allowEquipmentDrop = false;
    public boolean shareExperienceWithPlayer = true;
    public boolean enableBetterMobCombat = true;
    public boolean enableEpicKnightsCompat = false;
    public boolean enableSupplySystem = true;
    private static final String CONFIG_FILE = "config/hundredyearswar/hyw_main.json5";

    public static void load() {
        try {
            ServerModConfig.ensureConfigDirectory();
            LoadResult result = ServerModConfig.readAndMergeConfig();
            ServerModConfig.copyFrom(result.config());
            ServerModConfig.syncRuntimeConfig();
            if (result.rewriteRequired()) {
                ServerModConfig.save();
            }
            System.out.println("Loaded main config");
        }
        catch (Exception e) {
            System.err.println("Error loading main config: " + e.getMessage());
            e.printStackTrace();
            ServerModConfig.copyFrom(new ServerModConfig());
            ServerModConfig.syncRuntimeConfig();
            ServerModConfig.save();
        }
    }

    public static void save() {
        try {
            ServerModConfig.ensureConfigDirectory();
            File configFile = new File(CONFIG_FILE);
            try (FileWriter writer = new FileWriter(configFile);){
                ServerModConfig.INSTANCE.configVersion = 1;
                writer.write("{\n");
                writer.write("  // Config file version\n");
                writer.write("  \"configVersion\": " + ServerModConfig.INSTANCE.configVersion + ",\n\n");
                writer.write("  // Enable recruitment balance feature (survival mode summoning gives units weakness and slowness effects)\n");
                writer.write("  \"enableRecruitBalance\": " + ServerModConfig.INSTANCE.enableRecruitBalance + ",\n\n");
                writer.write("  // Give manual to players on first join\n");
                writer.write("  \"enableFirstJoinManual\": " + ServerModConfig.INSTANCE.enableFirstJoinManual + ",\n\n");
                writer.write("  // Generate scrolls in treasure chests\n");
                writer.write("  \"enableScrollLootGeneration\": " + ServerModConfig.INSTANCE.enableScrollLootGeneration + ",\n\n");
                writer.write("  // Allow monsters to drop scrolls\n");
                writer.write("  \"enableScrollMobDrops\": " + ServerModConfig.INSTANCE.enableScrollMobDrops + ",\n\n");
                writer.write("  // Allow recalling soldiers to inventory (shift + right click)\n");
                writer.write("  \"allowSoldierRecall\": " + ServerModConfig.INSTANCE.allowSoldierRecall + ",\n\n");
                writer.write("  // Allow changing soldier equipment (shift + attack)\n");
                writer.write("  \"allowEquipmentChange\": " + ServerModConfig.INSTANCE.allowEquipmentChange + ",\n\n");
                writer.write("  // Allow recalling siege units to inventory in survival mode (shift + right click)\n");
                writer.write("  \"allowSiegeRecall\": " + ServerModConfig.INSTANCE.allowSiegeRecall + ",\n\n");
                writer.write("  // Allow melee attack creepers\n");
                writer.write("  \"allowMeleeAttackCreeper\": " + ServerModConfig.INSTANCE.allowMeleeAttackCreeper + ",\n\n");
                writer.write("  // Player friendly fire damage multiplier (damage dealt by players to their own soldiers)\n");
                writer.write("  \"playerFriendlyFireDamageMultiplier\": " + ServerModConfig.INSTANCE.playerFriendlyFireDamageMultiplier + ",\n\n");
                writer.write("  // Allow soldiers to drop equipment when killed\n");
                writer.write("  \"allowEquipmentDrop\": " + ServerModConfig.INSTANCE.allowEquipmentDrop + ",\n\n");
                writer.write("  // Whether soldiers share experience with the player upon killing mobs\n");
                writer.write("  \"shareExperienceWithPlayer\": " + ServerModConfig.INSTANCE.shareExperienceWithPlayer + ",\n\n");
                writer.write("  // Soldier follow distance configuration\n");
                writer.write("  // Follow distance (inner) - maximum follow distance when idle\n");
                writer.write("  \"followDistanceInner\": " + ServerModConfig.INSTANCE.followDistanceInner + ",\n");
                writer.write("  // Follow distance (outer) - maximum follow distance during combat\n");
                writer.write("  \"followDistanceOuter\": " + ServerModConfig.INSTANCE.followDistanceOuter + ",\n\n");
                writer.write("  // Base combat entity pathfinding range - higher values make entity pathfinding smarter but impact performance heavily\n");
                writer.write("  // (e.g., 20 supports 500 entities smoothly, 200 causes lag with just 50 entities)\n");
                writer.write("  \"baseCombatEntityPathfindingRange\": " + ServerModConfig.INSTANCE.baseCombatEntityPathfindingRange + ",\n\n");
                writer.write("  // Soldier level cap\n");
                writer.write("  \"soldierLevelCap\": " + ServerModConfig.INSTANCE.soldierLevelCap + ",\n\n");
                writer.write("  // Allow summoning tier 4 armies\n");
                writer.write("  \"allowLevel4ArmySummoning\": " + ServerModConfig.INSTANCE.allowLevel4ArmySummoning + ",\n\n");
                writer.write("  // Allow summoning undead armies\n");
                writer.write("  \"allowNecromancySummoning\": " + ServerModConfig.INSTANCE.allowNecromancySummoning + ",\n\n");
                writer.write("  // Enable worship mechanism (resistance boost and health regeneration based on nearby controlled entities)\n");
                writer.write("  \"enableWorshipMechanism\": " + ServerModConfig.INSTANCE.enableWorshipMechanism + ",\n\n");
                writer.write("  // Enable player puppets (whether to convert players into controllable units in RTS mode)\n");
                writer.write("  \"enablePlayerPuppets\": " + ServerModConfig.INSTANCE.enablePlayerPuppets + ",\n\n");
                writer.write("  // Enable Better Mob Combat integration (use Better Combat attack system for melee units)\n");
                writer.write("  \"enableBetterMobCombat\": " + ServerModConfig.INSTANCE.enableBetterMobCombat + ",\n\n");
                writer.write("  // Enable Epic Knights compatibility (use Epic Knights equipment by default)\n");
                writer.write("  \"enableEpicKnightsCompat\": " + ServerModConfig.INSTANCE.enableEpicKnightsCompat + ",\n\n");
                writer.write("  // Enable supply system (soldiers require supply and suffer penalties when not supplied)\n");
                writer.write("  \"enableSupplySystem\": " + ServerModConfig.INSTANCE.enableSupplySystem + "\n");
                writer.write("}\n");
                System.out.println("Saved main config");
            }
        }
        catch (IOException e) {
            System.err.println("Error saving main config: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void copyFrom(ServerModConfig other) {
        ServerModConfig.INSTANCE.configVersion = other.configVersion;
        ServerModConfig.INSTANCE.enableRecruitBalance = other.enableRecruitBalance;
        ServerModConfig.INSTANCE.enableFirstJoinManual = other.enableFirstJoinManual;
        ServerModConfig.INSTANCE.enableScrollLootGeneration = other.enableScrollLootGeneration;
        ServerModConfig.INSTANCE.enableScrollMobDrops = other.enableScrollMobDrops;
        ServerModConfig.INSTANCE.allowSoldierRecall = other.allowSoldierRecall;
        ServerModConfig.INSTANCE.allowEquipmentChange = other.allowEquipmentChange;
        ServerModConfig.INSTANCE.allowSiegeRecall = other.allowSiegeRecall;
        ServerModConfig.INSTANCE.followDistanceInner = other.followDistanceInner;
        ServerModConfig.INSTANCE.followDistanceOuter = other.followDistanceOuter;
        ServerModConfig.INSTANCE.baseCombatEntityPathfindingRange = other.baseCombatEntityPathfindingRange;
        ServerModConfig.INSTANCE.pathfindingTasksPerTick = other.pathfindingTasksPerTick;
        ServerModConfig.INSTANCE.soldierLevelCap = other.soldierLevelCap;
        ServerModConfig.INSTANCE.allowLevel4ArmySummoning = other.allowLevel4ArmySummoning;
        ServerModConfig.INSTANCE.allowNecromancySummoning = other.allowNecromancySummoning;
        ServerModConfig.INSTANCE.enableWorshipMechanism = other.enableWorshipMechanism;
        ServerModConfig.INSTANCE.allowMeleeAttackCreeper = other.allowMeleeAttackCreeper;
        ServerModConfig.INSTANCE.playerFriendlyFireDamageMultiplier = other.playerFriendlyFireDamageMultiplier;
        ServerModConfig.INSTANCE.allowEquipmentDrop = other.allowEquipmentDrop;
        ServerModConfig.INSTANCE.shareExperienceWithPlayer = other.shareExperienceWithPlayer;
        ServerModConfig.INSTANCE.enablePlayerPuppets = other.enablePlayerPuppets;
        ServerModConfig.INSTANCE.enableBetterMobCombat = other.enableBetterMobCombat;
        ServerModConfig.INSTANCE.enableEpicKnightsCompat = other.enableEpicKnightsCompat;
        ServerModConfig.INSTANCE.enableSupplySystem = other.enableSupplySystem;
    }

    public boolean isEnableRecruitBalance() {
        return this.enableRecruitBalance;
    }

    public boolean isEnableFirstJoinManual() {
        return this.enableFirstJoinManual;
    }

    public boolean isEnableScrollLootGeneration() {
        return this.enableScrollLootGeneration;
    }

    public boolean isEnableScrollMobDrops() {
        return this.enableScrollMobDrops;
    }

    public boolean isAllowSoldierRecall() {
        return this.allowSoldierRecall;
    }

    public boolean isAllowEquipmentChange() {
        return this.allowEquipmentChange;
    }

    public double getFollowDistanceInner() {
        return this.followDistanceInner;
    }

    public double getFollowDistanceOuter() {
        return this.followDistanceOuter;
    }

    public float getBaseCombatEntityPathfindingRange() {
        return this.baseCombatEntityPathfindingRange;
    }

    public int getPathfindingTasksPerTick() {
        return this.pathfindingTasksPerTick;
    }

    public int getSoldierLevelCap() {
        return this.soldierLevelCap;
    }

    public boolean isAllowLevel4ArmySummoning() {
        return this.allowLevel4ArmySummoning;
    }

    public boolean isAllowNecromancySummoning() {
        return this.allowNecromancySummoning;
    }

    public boolean isEnableWorshipMechanism() {
        return this.enableWorshipMechanism;
    }

    public boolean isAllowSiegeRecall() {
        return this.allowSiegeRecall;
    }

    public boolean isAllowMeleeAttackCreeper() {
        return this.allowMeleeAttackCreeper;
    }

    public boolean isEnablePlayerPuppets() {
        return this.enablePlayerPuppets;
    }

    public double getPlayerFriendlyFireDamageMultiplier() {
        return this.playerFriendlyFireDamageMultiplier;
    }

    public boolean isAllowEquipmentDrop() {
        return this.allowEquipmentDrop;
    }

    public boolean isShareExperienceWithPlayer() {
        return this.shareExperienceWithPlayer;
    }

    public boolean isEnableBetterMobCombat() {
        return this.enableBetterMobCombat;
    }

    public boolean isEnableEpicKnightsCompat() {
        return this.enableEpicKnightsCompat;
    }

    public boolean isEnableSupplySystem() {
        return this.enableSupplySystem;
    }

    private static void ensureConfigDirectory() {
        File configDir = new File("config/hundredyearswar");
        if (!configDir.exists() && configDir.mkdirs()) {
            System.out.println("Created config/hundredyearswar directory");
        }
    }

    private static LoadResult readAndMergeConfig() {
        File configFile = new File(CONFIG_FILE);
        if (!configFile.exists()) {
            System.out.println("hyw_main.json5 missing, writing defaults");
            return new LoadResult(new ServerModConfig(), true);
        }
        JsonObject json = ServerModConfig.parseJson(configFile);
        if (json == null) {
            System.err.println("Failed to parse config file, using defaults and rewriting file");
            return new LoadResult(new ServerModConfig(), true);
        }
        MergeResult mergeResult = ServerModConfig.mergeWithDefaults(json);
        boolean rewrite = mergeResult.requiresRewrite() || mergeResult.fileVersion() != 1;
        return new LoadResult(mergeResult.config(), rewrite);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JsonObject parseJson(File configFile) {
        try (FileReader reader = new FileReader(configFile);){
            JsonReader jsonReader = new JsonReader((Reader)reader);
            jsonReader.setLenient(true);
            JsonElement element = JsonParser.parseReader((JsonReader)jsonReader);
            if (element == null) return null;
            if (!element.isJsonObject()) return null;
            JsonObject jsonObject = element.getAsJsonObject();
            return jsonObject;
        }
        catch (Exception e) {
            System.err.println("Error reading config file: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    private static MergeResult mergeWithDefaults(JsonObject json) {
        ServerModConfig defaults = new ServerModConfig();
        ServerModConfig merged = new ServerModConfig();
        MergeState state = new MergeState();
        merged.configVersion = 1;
        int fileVersion = ServerModConfig.getAsInt(json, "configVersion", 0, state);
        merged.enableRecruitBalance = ServerModConfig.getAsBoolean(json, "enableRecruitBalance", defaults.enableRecruitBalance, state);
        merged.enableFirstJoinManual = ServerModConfig.getAsBoolean(json, "enableFirstJoinManual", defaults.enableFirstJoinManual, state);
        merged.enableScrollLootGeneration = ServerModConfig.getAsBoolean(json, "enableScrollLootGeneration", defaults.enableScrollLootGeneration, state);
        merged.enableScrollMobDrops = ServerModConfig.getAsBoolean(json, "enableScrollMobDrops", defaults.enableScrollMobDrops, state);
        merged.allowSoldierRecall = ServerModConfig.getAsBoolean(json, "allowSoldierRecall", defaults.allowSoldierRecall, state);
        merged.allowEquipmentChange = ServerModConfig.getAsBoolean(json, "allowEquipmentChange", defaults.allowEquipmentChange, state);
        merged.allowSiegeRecall = ServerModConfig.getAsBoolean(json, "allowSiegeRecall", defaults.allowSiegeRecall, state);
        merged.followDistanceInner = ServerModConfig.getAsDouble(json, "followDistanceInner", defaults.followDistanceInner, state);
        merged.followDistanceOuter = ServerModConfig.getAsDouble(json, "followDistanceOuter", defaults.followDistanceOuter, state);
        merged.pathfindingTasksPerTick = ServerModConfig.getAsInt(json, "pathfindingTasksPerTick", defaults.pathfindingTasksPerTick, state);
        merged.baseCombatEntityPathfindingRange = ServerModConfig.getAsFloat(json, "baseCombatEntityPathfindingRange", defaults.baseCombatEntityPathfindingRange, state);
        merged.soldierLevelCap = ServerModConfig.getAsInt(json, "soldierLevelCap", defaults.soldierLevelCap, state);
        merged.allowLevel4ArmySummoning = ServerModConfig.getAsBoolean(json, "allowLevel4ArmySummoning", defaults.allowLevel4ArmySummoning, state);
        merged.allowNecromancySummoning = ServerModConfig.getAsBoolean(json, "allowNecromancySummoning", defaults.allowNecromancySummoning, state);
        merged.enableWorshipMechanism = ServerModConfig.getAsBoolean(json, "enableWorshipMechanism", defaults.enableWorshipMechanism, state);
        merged.allowMeleeAttackCreeper = ServerModConfig.getAsBoolean(json, "allowMeleeAttackCreeper", defaults.allowMeleeAttackCreeper, state);
        merged.playerFriendlyFireDamageMultiplier = ServerModConfig.getAsDouble(json, "playerFriendlyFireDamageMultiplier", defaults.playerFriendlyFireDamageMultiplier, state);
        merged.allowEquipmentDrop = ServerModConfig.getAsBoolean(json, "allowEquipmentDrop", defaults.allowEquipmentDrop, state);
        merged.shareExperienceWithPlayer = ServerModConfig.getAsBoolean(json, "shareExperienceWithPlayer", defaults.shareExperienceWithPlayer, state);
        merged.enablePlayerPuppets = ServerModConfig.getAsBoolean(json, "enablePlayerPuppets", defaults.enablePlayerPuppets, state);
        merged.enableBetterMobCombat = ServerModConfig.getAsBoolean(json, "enableBetterMobCombat", defaults.enableBetterMobCombat, state);
        merged.enableEpicKnightsCompat = ServerModConfig.getAsBoolean(json, "enableEpicKnightsCompat", defaults.enableEpicKnightsCompat, state);
        merged.enableSupplySystem = ServerModConfig.getAsBoolean(json, "enableSupplySystem", defaults.enableSupplySystem, state);
        return new MergeResult(merged, state.usedDefault, fileVersion);
    }

    private static boolean getAsBoolean(JsonObject json, String key, boolean defaultValue, MergeState state) {
        Boolean value = ServerModConfig.tryGetBoolean(json, key);
        if (value != null) {
            return value;
        }
        state.usedDefault = true;
        return defaultValue;
    }

    private static Boolean tryGetBoolean(JsonObject json, String key) {
        String value;
        if (!json.has(key)) {
            return null;
        }
        JsonElement element = json.get(key);
        if (!element.isJsonPrimitive()) {
            return null;
        }
        JsonPrimitive primitive = element.getAsJsonPrimitive();
        if (primitive.isBoolean()) {
            return primitive.getAsBoolean();
        }
        if (primitive.isNumber()) {
            return primitive.getAsInt() != 0;
        }
        if (primitive.isString() && ("true".equals(value = primitive.getAsString().trim().toLowerCase()) || "false".equals(value))) {
            return Boolean.parseBoolean(value);
        }
        return null;
    }

    private static int getAsInt(JsonObject json, String key, int defaultValue, MergeState state) {
        Integer value = ServerModConfig.tryGetInt(json, key);
        if (value != null) {
            return value;
        }
        state.usedDefault = true;
        return defaultValue;
    }

    private static Integer tryGetInt(JsonObject json, String key) {
        if (!json.has(key)) {
            return null;
        }
        JsonElement element = json.get(key);
        if (!element.isJsonPrimitive()) {
            return null;
        }
        JsonPrimitive primitive = element.getAsJsonPrimitive();
        try {
            if (primitive.isNumber()) {
                return primitive.getAsNumber().intValue();
            }
            if (primitive.isString()) {
                return (int)Double.parseDouble(primitive.getAsString());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    private static double getAsDouble(JsonObject json, String key, double defaultValue, MergeState state) {
        Double value = ServerModConfig.tryGetDouble(json, key);
        if (value != null) {
            return value;
        }
        state.usedDefault = true;
        return defaultValue;
    }

    private static Double tryGetDouble(JsonObject json, String key) {
        if (!json.has(key)) {
            return null;
        }
        JsonElement element = json.get(key);
        if (!element.isJsonPrimitive()) {
            return null;
        }
        JsonPrimitive primitive = element.getAsJsonPrimitive();
        try {
            if (primitive.isNumber()) {
                return primitive.getAsNumber().doubleValue();
            }
            if (primitive.isString()) {
                return Double.parseDouble(primitive.getAsString());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    private static float getAsFloat(JsonObject json, String key, float defaultValue, MergeState state) {
        Double value = ServerModConfig.tryGetDouble(json, key);
        if (value != null) {
            return value.floatValue();
        }
        state.usedDefault = true;
        return defaultValue;
    }

    private static void syncRuntimeConfig() {
        RecruitBalanceConfig.ENABLE_RECRUIT_BALANCE = ServerModConfig.INSTANCE.enableRecruitBalance;
    }

    public static String getCurrentEquipmentFileName() {
        boolean useEpicKnights = INSTANCE.isEnableEpicKnightsCompat() && FabricLoader.getInstance().isModLoaded("magistuarmory");
        return useEpicKnights ? "equipment_epic_knights.json" : "equipment.json";
    }

    private record LoadResult(ServerModConfig config, boolean rewriteRequired) {
    }

    private record MergeResult(ServerModConfig config, boolean requiresRewrite, int fileVersion) {
    }

    private static class MergeState {
        private boolean usedDefault = false;

        private MergeState() {
        }
    }
}

