/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1324;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.siege.PositionAttackable;
import ydmsama.hundred_years_war.main.entity.entities.tags.HeavyUnit;
import ydmsama.hundred_years_war.main.entity.entities.tags.RotationLimited;
import ydmsama.hundred_years_war.main.entity.goals.HywWaterAvoidingRandomStrollGoal;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class HywGiantEntity
extends BaseCombatEntity
implements HeavyUnit,
PositionAttackable,
RotationLimited {
    private static final float ATTACK_REACH = 10.0f;
    private static final float MOVEMENT_SPEED = 0.23f;
    private static final double SLAM_RADIUS = 10.0;
    private static final double SLAM_HORIZONTAL_SPEED = 0.35;
    private static final double SLAM_VERTICAL_BOOST = 0.65;
    private static final int SLAM_COOLDOWN_TICKS = 120;
    private static final float MAX_DESTROYABLE_HARDNESS = 50.0f;
    private static final double DESTRUCTION_VALUE_PER_ATTACK = 30.0;
    private static final int MANDATORY_MARGIN = 1;
    private static final int INFLUENCE_MARGIN = 3;
    private static final int EXTRA_HEIGHT_TOP = 2;
    private static final class_2940<class_2338> TARGET_POS = class_2945.method_12791(HywGiantEntity.class, (class_2941)class_2943.field_13324);
    private static final class_2940<Boolean> HAS_POSITION_TARGET = class_2945.method_12791(HywGiantEntity.class, (class_2941)class_2943.field_13323);
    private boolean slamming = false;
    private boolean leftGround = false;
    private int slamCooldown = 0;
    private class_243 positionTarget;

    public HywGiantEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.method_49477(5.0f);
    }

    public static class_5132.class_5133 createHywGiantAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23717, 28.0).method_26868(class_5134.field_23719, (double)0.23f).method_26868(class_5134.field_23721, 50.0).method_26868(class_5134.field_23724, 8.0).method_26868(class_5134.field_23716, 500.0).method_26868(class_5134.field_23718, 0.9).method_26868(HywAttributes.ATTACK_REACH, 10.0);
    }

    @Override
    public float getRotationLimit() {
        return 5.0f;
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(TARGET_POS, (Object)class_2338.field_10980);
        this.field_6011.method_12784(HAS_POSITION_TARGET, (Object)false);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            if (this.hasPositionTarget() && this.positionTarget != null) {
                this.field_6011.method_12778(TARGET_POS, (Object)class_2338.method_49638((class_2374)this.positionTarget));
            } else {
                this.field_6011.method_12778(TARGET_POS, (Object)class_2338.field_10980);
            }
            if (this.slamCooldown > 0) {
                --this.slamCooldown;
            }
            if (this.slamming) {
                if (!this.method_24828()) {
                    this.leftGround = true;
                } else if (this.leftGround) {
                    this.performSlamImpact();
                    this.finishSlam();
                }
            } else if (this.canStartSlam()) {
                this.startSlam();
            }
        }
    }

    private boolean canStartSlam() {
        class_1309 target = this.getActiveTarget();
        if (this.slamCooldown > 0 || target == null || !target.method_5805() || !this.method_24828()) {
            return false;
        }
        double distance = this.method_5739((class_1297)target);
        return distance <= 10.0;
    }

    private void startSlam() {
        class_1309 target = this.getActiveTarget();
        if (target == null) {
            return;
        }
        class_243 direction = target.method_19538().method_1020(this.method_19538());
        class_243 horizontal = new class_243(direction.field_1352, 0.0, direction.field_1350);
        if (horizontal.method_1027() > 1.0E-4) {
            horizontal = horizontal.method_1029().method_1021(0.35);
        }
        this.method_18800(horizontal.field_1352, 0.65, horizontal.field_1350);
        this.field_6007 = true;
        this.slamming = true;
        this.leftGround = false;
    }

    private void finishSlam() {
        this.slamming = false;
        this.leftGround = false;
        this.slamCooldown = 120;
        this.method_38785();
    }

    private void performSlamImpact() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_14199((class_2394)class_2398.field_11204, this.method_23317(), this.method_23318(), this.method_23321(), 12, 1.0, 0.2, 1.0, 0.05);
        }
        this.method_5783(class_3417.field_15152, 0.7f, 0.9f + this.method_6051().method_43057() * 0.2f);
        class_238 area = this.method_5829().method_1009(10.0, 0.8, 10.0);
        for (class_1309 living : this.method_37908().method_8390(class_1309.class, area, target -> target != this && this.isValidTarget((class_1309)target))) {
            living.field_6008 = 0;
            living.method_5643(this.method_48923().method_48812((class_1309)this), (float)(this.method_26825(class_5134.field_23721) * (double)0.9f));
            double dx = living.method_23317() - this.method_23317();
            double dz = living.method_23321() - this.method_23321();
            living.method_6005(0.7, dx, dz);
        }
    }

    private void performBlockDestructionAttack(class_243 targetPosition) {
        if (this.method_37908().field_9236 || targetPosition == null) {
            return;
        }
        double centerX = targetPosition.field_1352;
        double centerZ = targetPosition.field_1350;
        double entityBottomY = this.method_5829().field_1322;
        double halfWidth = (double)this.method_17681() / 2.0 + 1.0;
        int minX = class_3532.method_15357((double)(centerX - halfWidth));
        int maxX = class_3532.method_15357((double)(centerX + halfWidth));
        int minZ = class_3532.method_15357((double)(centerZ - halfWidth));
        int maxZ = class_3532.method_15357((double)(centerZ + halfWidth));
        int minY = class_3532.method_15357((double)entityBottomY);
        int maxY = class_3532.method_15357((double)(entityBottomY + (double)this.method_17682() + 2.0));
        double influenceHalfWidth = halfWidth + 3.0;
        int influenceMinX = class_3532.method_15357((double)(centerX - influenceHalfWidth));
        int influenceMaxX = class_3532.method_15357((double)(centerX + influenceHalfWidth));
        int influenceMinZ = class_3532.method_15357((double)(centerZ - influenceHalfWidth));
        int influenceMaxZ = class_3532.method_15357((double)(centerZ + influenceHalfWidth));
        int influenceMaxY = maxY + 3;
        List<class_2338> mandatoryBlocks = this.collectDestructibleBlocks(minX, maxX, minY, maxY, minZ, maxZ);
        if (mandatoryBlocks.isEmpty()) {
            this.setPositionTarget(null);
            return;
        }
        HashSet<class_2338> mandatorySet = new HashSet<class_2338>(mandatoryBlocks);
        HashSet<class_2338> influenceBlocks = new HashSet<class_2338>(this.collectDestructibleBlocks(influenceMinX, influenceMaxX, minY, influenceMaxY, influenceMinZ, influenceMaxZ));
        influenceBlocks.removeIf(pos -> this.isWithinBounds((class_2338)pos, minX, maxX, minY, maxY, minZ, maxZ));
        Set<class_2338> connectedInfluence = this.getConnectedInfluenceBlocks(mandatorySet, influenceBlocks, influenceMinX, influenceMaxX, minY, influenceMaxY, influenceMinZ, influenceMaxZ);
        class_5819 random = this.method_6051();
        List<class_2338> toBreakMandatory = this.selectBlocksByBudget(mandatoryBlocks, 30.0, random);
        this.destroyBlocks(toBreakMandatory);
        if (!connectedInfluence.isEmpty()) {
            List<class_2338> toBreakInfluence = this.selectBlocksByBudget(new ArrayList<class_2338>(connectedInfluence), 15.0, random);
            this.destroyBlocks(toBreakInfluence);
        }
        if (!this.hasDestructibleInBounds(minX, maxX, minY, maxY, minZ, maxZ)) {
            this.setPositionTarget(null);
        }
    }

    private List<class_2338> collectDestructibleBlocks(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        ArrayList<class_2338> result = new ArrayList<class_2338>();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2338 pos = new class_2338(x, y, z);
                    if (!this.isDestructible(pos)) continue;
                    result.add(pos);
                }
            }
        }
        return result;
    }

    private boolean isDestructible(class_2338 pos) {
        class_2680 state = this.method_37908().method_8320(pos);
        if (state.method_26215()) {
            return false;
        }
        float hardness = state.method_26214((class_1922)this.method_37908(), pos);
        return hardness >= 0.0f && hardness <= 50.0f;
    }

    private boolean isWithinBounds(class_2338 pos, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        return pos.method_10263() >= minX && pos.method_10263() <= maxX && pos.method_10264() >= minY && pos.method_10264() <= maxY && pos.method_10260() >= minZ && pos.method_10260() <= maxZ;
    }

    private Set<class_2338> getConnectedInfluenceBlocks(Set<class_2338> mandatoryBlocks, Set<class_2338> influenceBlocks, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        HashSet<class_2338> connected = new HashSet<class_2338>(mandatoryBlocks);
        ArrayDeque<class_2338> queue = new ArrayDeque<class_2338>(mandatoryBlocks);
        while (!queue.isEmpty()) {
            class_2338 current = queue.poll();
            for (class_2350 direction : class_2350.values()) {
                class_2338 next = current.method_10093(direction);
                if (!this.isWithinBounds(next, minX, maxX, minY, maxY, minZ, maxZ) || !influenceBlocks.contains(next) || connected.contains(next)) continue;
                connected.add(next);
                queue.add(next);
            }
        }
        connected.removeAll(mandatoryBlocks);
        return connected;
    }

    private double getBlockDestructionCost(class_2338 pos) {
        class_2680 state = this.method_37908().method_8320(pos);
        float hardness = state.method_26214((class_1922)this.method_37908(), pos);
        if (hardness < 0.0f || hardness > 50.0f) {
            return Double.MAX_VALUE;
        }
        double coefficient = 1.0;
        if (state.method_26164(class_3481.field_33715)) {
            coefficient = 3.0;
        } else if (state.method_26164(class_3481.field_33716)) {
            coefficient = 0.5;
        } else if (state.method_26164(class_3481.field_33713)) {
            coefficient = 1.5;
        }
        return (double)hardness * coefficient;
    }

    private List<class_2338> selectBlocksByBudget(List<class_2338> candidates, double budget, class_5819 random) {
        class_2338 pos;
        double cost;
        ArrayList<class_2338> shuffled = new ArrayList<class_2338>(candidates);
        Collections.shuffle(shuffled, new Random(random.method_43055()));
        ArrayList<class_2338> selected = new ArrayList<class_2338>();
        double remaining = budget;
        Iterator iterator = shuffled.iterator();
        while (iterator.hasNext() && !((cost = this.getBlockDestructionCost(pos = (class_2338)iterator.next())) > remaining)) {
            selected.add(pos);
            if (!((remaining -= cost) <= 0.0)) continue;
            break;
        }
        return selected;
    }

    private void destroyBlocks(Collection<class_2338> positions) {
        for (class_2338 pos : positions) {
            this.method_37908().method_22352(pos, true);
        }
    }

    private boolean hasDestructibleInBounds(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!this.isDestructible(new class_2338(x, y, z))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void performPositionAttack(class_243 targetPosition, float pullProgress) {
        this.method_23667(class_1268.field_5808, true);
        this.performBlockDestructionAttack(targetPosition);
    }

    @Override
    public double getArrivalThreshold() {
        return 5.0;
    }

    @Override
    public boolean canFireAtPosition(class_243 targetPosition) {
        return targetPosition != null;
    }

    @Override
    public boolean hasPositionTarget() {
        return (Boolean)this.field_6011.method_12789(HAS_POSITION_TARGET);
    }

    @Override
    public class_243 getPositionTarget() {
        return this.positionTarget;
    }

    @Override
    public void setPositionTarget(class_243 targetPosition) {
        this.positionTarget = targetPosition;
        this.field_6011.method_12778(HAS_POSITION_TARGET, (Object)(targetPosition != null ? 1 : 0));
        this.field_6011.method_12778(TARGET_POS, (Object)(targetPosition != null ? class_2338.method_49638((class_2374)targetPosition) : class_2338.field_10980));
    }

    @Override
    public void PerformRangedAttackBoth(class_243 targetPosition, class_1309 target) {
        if (targetPosition == null && target != null) {
            targetPosition = target.method_19538();
        }
        this.performBlockDestructionAttack(targetPosition);
    }

    public boolean method_6121(class_1297 entity) {
        boolean success = super.method_6121(entity);
        if (success && entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            class_238 splashArea = living.method_5829().method_1014(1.8);
            for (class_1309 other : this.method_37908().method_8390(class_1309.class, splashArea, target -> target != this && target != living && this.isValidTarget((class_1309)target))) {
                other.field_6008 = 0;
                other.method_5643(this.method_48923().method_48812((class_1309)this), (float)(this.method_26825(class_5134.field_23721) * (double)0.65f));
            }
        }
        return success;
    }

    private class_1309 getActiveTarget() {
        class_1309 target = this.getHywTarget();
        if (target == null) {
            target = this.method_5968();
        }
        return target;
    }

    @Override
    protected void setDefaultEquipment() {
        this.method_5673(class_1304.field_6173, class_1799.field_8037);
        this.method_5673(class_1304.field_6171, class_1799.field_8037);
        this.method_5673(class_1304.field_6169, class_1799.field_8037);
        this.method_5673(class_1304.field_6174, class_1799.field_8037);
        this.method_5673(class_1304.field_6172, class_1799.field_8037);
        this.method_5673(class_1304.field_6166, class_1799.field_8037);
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("Slamming", this.slamming);
        compound.method_10556("LeftGround", this.leftGround);
        compound.method_10569("SlamCooldown", this.slamCooldown);
        compound.method_10556("HasPositionTarget", this.hasPositionTarget());
        if (this.hasPositionTarget() && this.positionTarget != null) {
            compound.method_10549("PositionTargetX", this.positionTarget.field_1352);
            compound.method_10549("PositionTargetY", this.positionTarget.field_1351);
            compound.method_10549("PositionTargetZ", this.positionTarget.field_1350);
        }
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.slamming = compound.method_10577("Slamming");
        this.leftGround = compound.method_10577("LeftGround");
        this.slamCooldown = compound.method_10550("SlamCooldown");
        if (compound.method_10577("HasPositionTarget")) {
            double x = compound.method_10574("PositionTargetX");
            double y = compound.method_10574("PositionTargetY");
            double z = compound.method_10574("PositionTargetZ");
            this.setPositionTarget(new class_243(x, y, z));
        } else {
            this.setPositionTarget(null);
        }
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 18;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 8;
    }

    @Override
    public int getAttackCoolDownDuration() {
        Random random = new Random();
        return 12 + random.nextInt(10);
    }

    @Override
    protected void increaseStatsOnLevelUp() {
        class_1324 attackDamage;
        class_1324 maxHealth = this.method_5996(class_5134.field_23716);
        if (maxHealth != null) {
            maxHealth.method_6192(maxHealth.method_6201() + 6.0);
            this.method_6025(6.0f);
        }
        if ((attackDamage = this.method_5996(class_5134.field_23721)) != null) {
            attackDamage.method_6192(attackDamage.method_6201() + 0.6);
        }
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(5, (class_1352)new HywWaterAvoidingRandomStrollGoal(this, 0.6));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        super.method_5959();
    }

    @Override
    public class_1792 getScrollType() {
        return HywItemRegistry.SCROLL_GIANT;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return class_3417.field_15088;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14930;
    }

    protected class_3414 method_5994() {
        return class_3417.field_15174;
    }

    public class_1310 method_6046() {
        return class_1310.field_6289;
    }
}

