/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.bandits;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1355;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4135;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.bandits.BanditWarHoundEntity;
import ydmsama.hundred_years_war.main.entity.entities.tags.LightUnit;
import ydmsama.hundred_years_war.main.entity.goals.BaseCombatEntityAttackGoal;
import ydmsama.hundred_years_war.main.entity.goals.HywWaterAvoidingRandomStrollGoal;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywEntityRegistry;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class BanditBeastmasterEntity
extends BaseCombatEntity
implements LightUnit {
    private static final int SUMMON_COOLDOWN_TICKS = 300;
    private static final int HOUND_LIFETIME_TICKS = 1200;
    private static final int PACK_SIZE = 8;
    private static final int SUMMON_INTERVAL_TICKS = 8;
    private static final double SUMMON_RADIUS = 2.5;
    private static final double MIN_OBSERVE_DISTANCE = 6.0;
    private static final double MAX_OBSERVE_DISTANCE = 10.0;
    private int summonCooldown = 0;
    private final Set<UUID> activeHounds = new HashSet<UUID>();
    private int pendingSummons = 0;
    private int summonInterval = 0;
    private static final class_2940<Boolean> SUMMONING = class_2945.method_12791(BanditBeastmasterEntity.class, (class_2941)class_2943.field_13323);

    public BanditBeastmasterEntity(class_1299<? extends class_1314> type, class_1937 level) {
        super(type, level);
        this.method_49477(1.0f);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SUMMONING, (Object)false);
    }

    public static class_5132.class_5133 createBanditBeastmasterAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23717, 26.0).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23721, 5.0).method_26868(class_5134.field_23724, 3.0).method_26868(class_5134.field_23716, 28.0).method_26868(class_5134.field_23718, 0.4).method_26868(HywAttributes.ATTACK_REACH, (double)2.2f);
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.removeAttackGoal();
        this.field_6201.method_6277(2, (class_1352)new ObserveTargetGoal(this, 1.0, 6.0, 10.0));
        this.field_6201.method_6277(5, (class_1352)new HywWaterAvoidingRandomStrollGoal(this, 0.8));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            if (this.summonCooldown > 0) {
                --this.summonCooldown;
            }
            this.cleanupSummons();
            this.handleSummonSequence();
        }
    }

    private void cleanupSummons() {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        Iterator<UUID> iterator = this.activeHounds.iterator();
        while (iterator.hasNext()) {
            BanditWarHoundEntity hound;
            UUID id = iterator.next();
            class_1297 entity = serverLevel.method_14190(id);
            if (entity instanceof BanditWarHoundEntity && (hound = (BanditWarHoundEntity)entity).method_5805()) continue;
            iterator.remove();
        }
    }

    private boolean shouldSummonPack() {
        return this.getValidSummonTarget() != null;
    }

    private void handleSummonSequence() {
        if (this.pendingSummons > 0) {
            if (this.summonInterval <= 0) {
                this.summonOne(this.pendingSummons - 1);
                --this.pendingSummons;
                this.summonInterval = 8;
                if (this.pendingSummons == 0) {
                    this.field_6011.method_12778(SUMMONING, (Object)false);
                }
            } else {
                --this.summonInterval;
            }
            return;
        }
        if (this.summonCooldown == 0 && this.shouldSummonPack()) {
            this.pendingSummons = 8;
            this.summonInterval = 0;
            this.summonCooldown = 300;
            this.field_6011.method_12778(SUMMONING, (Object)true);
        }
    }

    private void summonOne(int indexFromEnd) {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        class_1309 target = this.getHywTarget();
        class_2338 origin = this.method_24515();
        class_5819 random = this.method_6051();
        int sequenceIndex = 8 - indexFromEnd - 1;
        BanditWarHoundEntity hound = (BanditWarHoundEntity)HywEntityRegistry.BANDIT_WAR_HOUND.method_5883(this.method_37908());
        if (hound == null) {
            return;
        }
        double angle = 0.7853981633974483 * (double)sequenceIndex;
        double radius = class_3532.method_15366((class_5819)random, (double)1.5, (double)2.5);
        double offsetX = Math.cos(angle += class_3532.method_15366((class_5819)random, (double)-0.19634954084936207, (double)0.19634954084936207)) * radius;
        double offsetZ = Math.sin(angle) * radius;
        hound.method_5808((double)origin.method_10263() + 0.5 + offsetX, origin.method_10264(), (double)origin.method_10260() + 0.5 + offsetZ, this.method_36454(), 0.0f);
        hound.method_6732(this.method_6139());
        hound.setHomePosition(origin);
        hound.setRequiresSupply(false);
        hound.setEquipment(1);
        hound.setTemporaryLifetime(1200);
        if (target != null) {
            hound.setHywTarget(target);
        }
        serverLevel.method_8649((class_1297)hound);
        this.activeHounds.add(hound.method_5667());
        serverLevel.method_14199((class_2394)class_2398.field_11204, hound.method_23317(), hound.method_23318() + 0.2, hound.method_23321(), 8, 0.15, 0.0, 0.15, 0.01);
    }

    public boolean isSummoning() {
        return (Boolean)this.field_6011.method_12789(SUMMONING);
    }

    private void removeAttackGoal() {
        this.field_6201.method_35115().stream().filter(wrapped -> wrapped.method_19058() instanceof BaseCombatEntityAttackGoal).map(class_4135::method_19058).toList().forEach(arg_0 -> ((class_1355)this.field_6201).method_6280(arg_0));
    }

    private class_1309 getValidSummonTarget() {
        class_1309 target = this.getHywTarget();
        if (target == null || target.method_31481() || !target.method_5805()) {
            return null;
        }
        return this.isValidTarget(target) ? target : null;
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 12;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 6;
    }

    @Override
    public int getAttackCoolDownDuration() {
        return 18;
    }

    @Override
    public class_1792 getScrollType() {
        return HywItemRegistry.SCROLL_BANDIT_BEASTMASTER;
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("SummonCooldown", this.summonCooldown);
        compound.method_10569("ActiveHounds", this.activeHounds.size());
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.summonCooldown = compound.method_10550("SummonCooldown");
        this.activeHounds.clear();
    }

    @Override
    protected boolean allowEquipmentReplacement() {
        return false;
    }

    @Override
    public int getSkinCounts() {
        return 1;
    }

    private static class ObserveTargetGoal
    extends class_1352 {
        private final BanditBeastmasterEntity beastmaster;
        private final double speed;
        private final double minDistanceSq;
        private final double maxDistanceSq;

        private ObserveTargetGoal(BanditBeastmasterEntity beastmaster, double speed, double minDistance, double maxDistance) {
            this.beastmaster = beastmaster;
            this.speed = speed;
            this.minDistanceSq = minDistance * minDistance;
            this.maxDistanceSq = maxDistance * maxDistance;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            class_1309 target = this.beastmaster.getHywTarget();
            return target != null && target.method_5805();
        }

        public boolean method_6266() {
            class_1309 target = this.beastmaster.getHywTarget();
            return target != null && target.method_5805();
        }

        public void method_6270() {
            this.beastmaster.method_5942().method_6340();
        }

        public void method_6268() {
            class_1309 target = this.beastmaster.getHywTarget();
            if (target == null) {
                return;
            }
            this.beastmaster.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
            double distanceSq = this.beastmaster.method_5858((class_1297)target);
            if (distanceSq < this.minDistanceSq) {
                double dz;
                double dx = this.beastmaster.method_23317() - target.method_23317();
                double len = Math.sqrt(dx * dx + (dz = this.beastmaster.method_23321() - target.method_23321()) * dz);
                if (len > 1.0E-4) {
                    double destX = this.beastmaster.method_23317() + (dx /= len) * 2.0;
                    double destZ = this.beastmaster.method_23321() + (dz /= len) * 2.0;
                    this.beastmaster.method_5942().method_6337(destX, this.beastmaster.method_23318(), destZ, this.speed);
                }
            } else if (distanceSq > this.maxDistanceSq) {
                this.beastmaster.method_5942().method_6335((class_1297)target, this.speed);
            } else {
                this.beastmaster.method_5942().method_6340();
            }
        }
    }
}

