/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.bandits;

import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8111;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.siege.PositionAttackable;
import ydmsama.hundred_years_war.main.entity.entities.tags.LightUnit;
import ydmsama.hundred_years_war.main.entity.goals.HywWaterAvoidingRandomStrollGoal;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class BanditDemolitionistEntity
extends BaseCombatEntity
implements LightUnit,
PositionAttackable {
    private static final int DETONATION_DELAY = 120;
    private static final class_2940<Boolean> PRIMING = class_2945.method_12791(BanditDemolitionistEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> HAS_POSITION_TARGET = class_2945.method_12791(BanditDemolitionistEntity.class, (class_2941)class_2943.field_13323);
    private int detonationTimer = -1;
    private class_243 positionTarget;

    public BanditDemolitionistEntity(class_1299<? extends class_1314> type, class_1937 level) {
        super(type, level);
        this.method_49477(1.0f);
    }

    public static class_5132.class_5133 createBanditDemolitionistAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23717, 24.0).method_26868(class_5134.field_23719, 0.32).method_26868(class_5134.field_23721, 200.0).method_26868(class_5134.field_23724, 0.0).method_26868(class_5134.field_23716, 16.0).method_26868(class_5134.field_23718, 0.6).method_26868(HywAttributes.ATTACK_REACH, 2.0);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(PRIMING, (Object)false);
        this.field_6011.method_12784(HAS_POSITION_TARGET, (Object)false);
    }

    @Override
    protected void setDefaultEquipment() {
        this.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8528));
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(5, (class_1352)new HywWaterAvoidingRandomStrollGoal(this, 0.85));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 5.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        super.method_5959();
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            this.handleDetonation();
        } else if (this.isPriming()) {
            this.spawnSmoke();
        }
    }

    private void handleDetonation() {
        if (this.isPriming()) {
            if (this.detonationTimer > 0) {
                --this.detonationTimer;
            } else if (this.detonationTimer == 0) {
                this.explode();
            }
        } else if (this.shouldPrime()) {
            this.startPriming();
        }
    }

    private boolean shouldPrime() {
        boolean hasEntityTarget = this.getHywTarget() != null && this.method_5858((class_1297)this.getHywTarget()) < 20.25;
        boolean hasPositionTarget = this.hasPositionTarget() && this.positionTarget != null && this.method_19538().method_1025(this.positionTarget) < 20.25;
        return hasEntityTarget || hasPositionTarget;
    }

    private void startPriming() {
        this.detonationTimer = 120;
        this.setPriming(true);
        this.method_5942().method_6340();
    }

    private void spawnSmoke() {
        float bodyYaw = class_3532.method_17821((float)1.0f, (float)this.field_6220, (float)this.field_6283);
        double yawRad = Math.toRadians(bodyYaw);
        double forwardX = -Math.sin(yawRad);
        double forwardZ = Math.cos(yawRad);
        double offsetX = forwardX * 0.5;
        double offsetZ = forwardZ * 0.5;
        double y = this.method_23318() + 1.5;
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_14199((class_2394)class_2398.field_11251, this.method_23317() + offsetX, y, this.method_23321() + offsetZ, 2, 0.05, 0.0, 0.05, 0.01);
        } else {
            this.method_37908().method_8406((class_2394)class_2398.field_11251, this.method_23317() + offsetX, y, this.method_23321() + offsetZ, 0.0, 0.05, 0.0);
        }
    }

    private void explode() {
        if (!this.method_37908().field_9236) {
            this.applyAreaDamage();
        }
        this.method_37908().method_8437((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), 3.5f, class_1937.class_7867.field_40890);
        this.method_31472();
    }

    private void applyAreaDamage() {
        double damageRadius = 3.5;
        float damageAmount = (float)this.method_26825(class_5134.field_23721);
        class_238 damageArea = new class_238(this.method_23317() - damageRadius, this.method_23318() - damageRadius, this.method_23321() - damageRadius, this.method_23317() + damageRadius, this.method_23318() + damageRadius, this.method_23321() + damageRadius);
        class_6880.class_6883 explosionDamageType = this.method_37908().method_30349().method_30530(class_7924.field_42534).method_40290(class_8111.field_42331);
        class_1282 damageSource = new class_1282((class_6880)explosionDamageType, (class_1297)this);
        for (class_1297 entity : this.method_37908().method_8335((class_1297)this, damageArea)) {
            if (!(entity instanceof class_1309)) continue;
            class_1309 livingEntity = (class_1309)entity;
            if (entity == this || !this.isValidTarget(livingEntity)) continue;
            double distance = livingEntity.method_19538().method_1022(this.method_19538());
            float distanceFactor = Math.max(0.4f, 1.0f - (float)(distance / damageRadius));
            float finalDamage = damageAmount * distanceFactor;
            livingEntity.method_5643(damageSource, finalDamage);
        }
    }

    @Override
    public void performPositionAttack(class_243 targetPosition, float pullProgress) {
        if (targetPosition != null && !this.isPriming()) {
            this.startPriming();
        }
    }

    @Override
    public boolean canFireAtPosition(class_243 targetPosition) {
        return targetPosition != null;
    }

    @Override
    public boolean hasPositionTarget() {
        return (Boolean)this.field_6011.method_12789(HAS_POSITION_TARGET);
    }

    @Override
    public class_243 getPositionTarget() {
        return this.positionTarget;
    }

    @Override
    public void setPositionTarget(class_243 targetPosition) {
        this.positionTarget = targetPosition;
        this.field_6011.method_12778(HAS_POSITION_TARGET, (Object)(targetPosition != null ? 1 : 0));
    }

    @Override
    public void PerformRangedAttackBoth(class_243 targetPosition, class_1309 target) {
        if (targetPosition == null && target != null) {
            targetPosition = target.method_19538();
        }
        this.performPositionAttack(targetPosition, 1.0f);
    }

    private void setPriming(boolean priming) {
        this.field_6011.method_12778(PRIMING, (Object)priming);
    }

    public boolean isPriming() {
        return (Boolean)this.field_6011.method_12789(PRIMING);
    }

    @Override
    public class_1792 getScrollType() {
        return HywItemRegistry.SCROLL_BANDIT_DEMOLITIONIST;
    }

    @Override
    public boolean canFireAtTarget(class_1309 target) {
        return false;
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 10;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 5;
    }

    @Override
    public int getAttackCoolDownDuration() {
        return 14;
    }

    @Override
    protected boolean allowEquipmentReplacement() {
        return false;
    }

    @Override
    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10569("DetonationTimer", this.detonationTimer);
        compoundTag.method_10556("Priming", this.isPriming());
        compoundTag.method_10556("HasPositionTarget", this.hasPositionTarget());
        if (this.hasPositionTarget() && this.positionTarget != null) {
            compoundTag.method_10549("PositionTargetX", this.positionTarget.field_1352);
            compoundTag.method_10549("PositionTargetY", this.positionTarget.field_1351);
            compoundTag.method_10549("PositionTargetZ", this.positionTarget.field_1350);
        }
    }

    @Override
    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.detonationTimer = compoundTag.method_10550("DetonationTimer");
        this.setPriming(compoundTag.method_10577("Priming"));
        if (compoundTag.method_10577("HasPositionTarget")) {
            double x = compoundTag.method_10574("PositionTargetX");
            double y = compoundTag.method_10574("PositionTargetY");
            double z = compoundTag.method_10574("PositionTargetZ");
            this.setPositionTarget(new class_243(x, y, z));
        } else {
            this.setPositionTarget(null);
        }
    }

    @Override
    public int getSkinCounts() {
        return 1;
    }
}

