/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.bandits;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.tags.CounterHeavy;
import ydmsama.hundred_years_war.main.entity.entities.tags.LightUnit;
import ydmsama.hundred_years_war.main.entity.goals.HywWaterAvoidingRandomStrollGoal;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;
import ydmsama.hundred_years_war.main.utils.ServerRelationHelper;

public class BanditExecutionerEntity
extends BaseCombatEntity
implements LightUnit,
CounterHeavy {
    private static final int WHIRLWIND_DURATION = 80;
    private static final int WHIRLWIND_COOLDOWN = 200;
    private static final class_2940<Boolean> SPINNING = class_2945.method_12791(BanditExecutionerEntity.class, (class_2941)class_2943.field_13323);
    private int spinningTicks = 0;
    private int spinCooldown = 0;
    private int damageTicker = 0;
    private static final int DAMAGE_INTERVAL_TICKS = 12;
    private static final double SPIN_DAMAGE_RADIUS = 1.25;
    private float clientSpinYaw = 0.0f;

    public BanditExecutionerEntity(class_1299<? extends class_1314> type, class_1937 level) {
        super(type, level);
        this.method_49477(1.0f);
    }

    public static class_5132.class_5133 createBanditExecutionerAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23717, 24.0).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23721, 7.0).method_26868(class_5134.field_23724, 4.0).method_26868(class_5134.field_23716, 32.0).method_26868(class_5134.field_23718, 0.8).method_26868(HywAttributes.ATTACK_REACH, 2.5);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            this.handleSpinLogic();
        } else if (!this.isSpinning()) {
            this.clientSpinYaw = 0.0f;
        }
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SPINNING, (Object)false);
    }

    private void handleSpinLogic() {
        if (this.spinCooldown > 0) {
            --this.spinCooldown;
        }
        if (this.spinningTicks > 0) {
            class_1937 class_19372;
            --this.spinningTicks;
            ++this.damageTicker;
            this.applySpinRotation();
            if (this.damageTicker % 12 == 0) {
                this.applySpinDamage();
            }
            if ((class_19372 = this.method_37908()) instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                this.spawnSpinParticles(serverLevel);
            }
            if (this.spinningTicks == 0) {
                this.damageTicker = 0;
                this.setSpinning(false);
                this.clientSpinYaw = 0.0f;
            }
        } else if (this.spinCooldown == 0 && this.hasSpinOpportunity()) {
            this.startWhirlwind();
        }
    }

    private void applySpinRotation() {
        if (!this.method_37908().field_9236) {
            float yawAdd = 18.0f;
            this.method_36456(this.method_36454() + yawAdd);
            this.field_6283 = this.method_36454();
            this.field_6241 = this.method_36454();
            this.clientSpinYaw += yawAdd;
        }
    }

    @Override
    public boolean shouldSkipBaseRotation() {
        return this.isSpinning();
    }

    protected float method_6031(float bodyRot, float headRot) {
        if (this.isSpinning()) {
            float yaw;
            this.field_6241 = yaw = this.method_36454();
            this.field_6283 = yaw;
            return yaw;
        }
        return super.method_6031(bodyRot, headRot);
    }

    private boolean hasSpinOpportunity() {
        if (this.getHywTarget() == null) {
            return false;
        }
        class_238 area = this.method_5829().method_1014(3.0);
        long enemyCount = this.method_37908().method_8390(class_1309.class, area, target -> target != this && ServerRelationHelper.isEnemyRelation((class_1297)this, (class_1297)target)).size();
        return enemyCount >= 1L;
    }

    private void startWhirlwind() {
        this.spinningTicks = 80;
        this.spinCooldown = 200;
        this.setSpinning(true);
    }

    private void applySpinDamage() {
        class_238 area = this.method_5829().method_1014(1.25);
        for (class_1309 living : this.method_37908().method_8390(class_1309.class, area, target -> target != this && ServerRelationHelper.isEnemyRelation((class_1297)this, (class_1297)target))) {
            living.field_6008 = 0;
            living.method_5643(this.method_48923().method_48812((class_1309)this), (float)(this.method_26825(class_5134.field_23721) * (double)0.6f));
        }
    }

    private void spawnSpinParticles(class_3218 serverLevel) {
        class_5819 random = serverLevel.field_9229;
        for (int i = 0; i < 1; ++i) {
            double angle = random.method_43058() * Math.PI * 2.0;
            double radius = random.method_43058() * 1.25;
            double offsetX = Math.cos(angle) * radius;
            double offsetZ = Math.sin(angle) * radius;
            serverLevel.method_14199((class_2394)class_2398.field_11227, this.method_23317() + offsetX, this.method_23318() + 1.0, this.method_23321() + offsetZ, 1, 0.05, 0.02, 0.05, 0.0);
        }
    }

    public float getClientSpinYaw() {
        return this.clientSpinYaw;
    }

    public boolean isSpinning() {
        return (Boolean)this.field_6011.method_12789(SPINNING);
    }

    private void setSpinning(boolean spinning) {
        this.field_6011.method_12778(SPINNING, (Object)spinning);
    }

    @Override
    protected void setDefaultEquipment() {
        this.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8475));
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(5, (class_1352)new HywWaterAvoidingRandomStrollGoal(this, 0.75));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 5.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        super.method_5959();
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 12;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 6;
    }

    @Override
    public int getAttackCoolDownDuration() {
        return 20;
    }

    @Override
    protected boolean allowBetterCombatAttack() {
        return false;
    }

    @Override
    protected boolean allowEquipmentReplacement() {
        return false;
    }

    @Override
    public class_1792 getScrollType() {
        return HywItemRegistry.SCROLL_BANDIT_EXECUTIONER;
    }

    @Override
    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10569("SpinCooldown", this.spinCooldown);
        compoundTag.method_10569("SpinTicks", this.spinningTicks);
        compoundTag.method_10556("Spinning", this.isSpinning());
    }

    @Override
    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.spinCooldown = compoundTag.method_10550("SpinCooldown");
        this.spinningTicks = compoundTag.method_10550("SpinTicks");
        this.setSpinning(compoundTag.method_10577("Spinning") && this.spinningTicks > 0);
    }

    @Override
    public double getLightDamageModifier() {
        return 1.5;
    }

    @Override
    public double getHeavyDamageModifier() {
        return 0.8;
    }

    @Override
    public int getSkinCounts() {
        return 3;
    }
}

