/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.bandits;

import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.projectile.ThrowingKnifeEntity;
import ydmsama.hundred_years_war.main.entity.entities.tags.CounterLight;
import ydmsama.hundred_years_war.main.entity.entities.tags.LightUnit;
import ydmsama.hundred_years_war.main.entity.entities.tags.RangedUnit;
import ydmsama.hundred_years_war.main.entity.goals.HywWaterAvoidingRandomStrollGoal;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class BanditKnifeThrowerEntity
extends BaseCombatEntity
implements class_1603,
LightUnit,
RangedUnit,
CounterLight {
    private static final float ATTACK_REACH = 32.0f;
    private static final float MOVEMENT_SPEED = 0.32f;
    private static final float BASE_RANGED_DAMAGE = 5.0f;
    private static final int OFFHAND_THROW_DELAY = 12;
    private int offhandThrowTicker = -1;
    private class_1309 queuedOffhandTarget = null;

    public BanditKnifeThrowerEntity(class_1299<? extends class_1314> type, class_1937 level) {
        super(type, level);
        this.method_49477(1.0f);
    }

    public static class_5132.class_5133 createKnifeThrowerAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23717, 32.0).method_26868(class_5134.field_23719, (double)0.32f).method_26868(class_5134.field_23721, 4.0).method_26868(class_5134.field_23724, 2.0).method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23718, 0.3).method_26868(HywAttributes.ATTACK_REACH, 32.0).method_26868(HywAttributes.RANGED_ATTACK_DAMAGE, 5.0);
    }

    @Override
    protected void setDefaultEquipment() {
        this.method_5673(class_1304.field_6173, new class_1799((class_1935)HywItemRegistry.THROWING_KNIFE));
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(5, (class_1352)new HywWaterAvoidingRandomStrollGoal(this, 0.8));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        super.method_5959();
    }

    public void method_7105(class_1309 target, float pullProgress) {
        this.throwFan(class_1268.field_5808, target);
        this.queuedOffhandTarget = target;
        this.offhandThrowTicker = 12;
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 16;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 10;
    }

    @Override
    public int getAttackCoolDownDuration() {
        return 20 + this.method_6051().method_43048(10);
    }

    @Override
    protected boolean allowEquipmentReplacement() {
        return false;
    }

    @Override
    public class_1792 getScrollType() {
        return HywItemRegistry.SCROLL_BANDIT_KNIFE_THROWER;
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            this.handleQueuedOffhandThrow();
        }
    }

    private void handleQueuedOffhandThrow() {
        if (this.offhandThrowTicker >= 0) {
            --this.offhandThrowTicker;
            if (this.offhandThrowTicker == 0 && this.queuedOffhandTarget != null && this.queuedOffhandTarget.method_5805()) {
                this.throwFan(class_1268.field_5810, this.queuedOffhandTarget);
            }
            if (this.offhandThrowTicker == 0 || this.queuedOffhandTarget == null || this.queuedOffhandTarget != null && !this.queuedOffhandTarget.method_5805()) {
                this.offhandThrowTicker = -1;
                this.queuedOffhandTarget = null;
            }
        }
    }

    private void throwFan(class_1268 hand, class_1309 target) {
        this.method_23667(hand, true);
        for (int i = 0; i < 4; ++i) {
            ThrowingKnifeEntity knife = new ThrowingKnifeEntity(this.method_37908(), (class_1309)this);
            knife.method_7438((float)this.method_26825(HywAttributes.RANGED_ATTACK_DAMAGE));
            this.shootFlatPredicted(target, knife);
        }
        this.method_5783(class_3417.field_15001, 1.0f, 1.0f + (this.method_6051().method_43057() - 0.5f) * 0.2f);
    }

    private void shootFlatPredicted(class_1309 target, ThrowingKnifeEntity knife) {
        double predicteddz;
        double dy;
        double dz;
        double dx = target.method_23317() - this.method_23317();
        double distance = Math.sqrt(dx * dx + (dz = target.method_23321() - this.method_23321()) * dz + (dy = target.method_23323(0.5) - knife.method_23318()) * dy);
        if (distance == 0.0) {
            return;
        }
        float speed = 1.4f;
        double gravity = 0.05;
        float miss = 18.0f;
        double[] angles = this.calculateLaunchAngles(speed, gravity, distance, dy);
        double angle = angles[1];
        if (Double.isNaN(angle)) {
            return;
        }
        class_243 targetVel = target.method_18798();
        double timeToTarget = distance / ((double)speed * Math.cos(angle));
        double predictedX = target.method_23317() + targetVel.field_1352 * timeToTarget;
        double predictedZ = target.method_23321() + targetVel.field_1350 * timeToTarget;
        double predicteddx = predictedX - this.method_23317();
        double horizontalDistance = Math.sqrt(predicteddx * predicteddx + (predicteddz = predictedZ - this.method_23321()) * predicteddz);
        if (horizontalDistance == 0.0) {
            return;
        }
        double horizontalSpeed = (double)speed * Math.cos(angle);
        double verticalSpeed = (double)speed * Math.sin(angle);
        float velocityX = (float)(predicteddx / horizontalDistance * horizontalSpeed);
        float velocityY = (float)verticalSpeed;
        float velocityZ = (float)(predicteddz / horizontalDistance * horizontalSpeed);
        float horizontalMiss = miss;
        float verticalMiss = miss * 0.5f;
        this.shootWithAnisotropicInaccuracy(knife, velocityX, velocityY, velocityZ, speed, horizontalMiss, verticalMiss);
        knife.method_7439(false);
        this.method_37908().method_8649((class_1297)knife);
    }

    private double[] calculateLaunchAngles(double speed, double gravity, double distance, double heightDifference) {
        double discriminant = speed * speed * speed * speed - gravity * (gravity * distance * distance + 2.0 * heightDifference * speed * speed);
        if (discriminant < 0.0) {
            return new double[]{Double.NaN, Double.NaN};
        }
        double angle1 = Math.atan2(speed * speed + Math.sqrt(discriminant), gravity * distance);
        double angle2 = Math.atan2(speed * speed - Math.sqrt(discriminant), gravity * distance);
        return new double[]{angle1, angle2};
    }

    private void shootWithAnisotropicInaccuracy(ThrowingKnifeEntity knife, float velocityX, float velocityY, float velocityZ, float speed, float horizontalMiss, float verticalMiss) {
        class_243 direction = new class_243((double)velocityX, (double)velocityY, (double)velocityZ).method_1029().method_1031(this.method_6051().method_43385(0.0, 0.0172275 * (double)horizontalMiss), this.method_6051().method_43385(0.0, 0.0172275 * (double)verticalMiss), this.method_6051().method_43385(0.0, 0.0172275 * (double)horizontalMiss)).method_1029().method_1021((double)speed);
        knife.method_18799(direction);
        double horizontalLength = direction.method_37267();
        knife.method_36456((float)(class_3532.method_15349((double)direction.field_1352, (double)direction.field_1350) * 57.29577951308232));
        knife.method_36457((float)(class_3532.method_15349((double)direction.field_1351, (double)horizontalLength) * 57.29577951308232));
        knife.field_5982 = knife.method_36454();
        knife.field_6004 = knife.method_36455();
    }

    @Override
    public int getSkinCounts() {
        return 1;
    }

    @Override
    public double getLightDamageModifier() {
        return 1.5;
    }

    @Override
    public double getHeavyDamageModifier() {
        return 0.5;
    }
}

