/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.bandits;

import java.util.List;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1292;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.tags.CounterRanged;
import ydmsama.hundred_years_war.main.entity.entities.tags.LightUnit;
import ydmsama.hundred_years_war.main.entity.goals.HywWaterAvoidingRandomStrollGoal;
import ydmsama.hundred_years_war.main.entity.utils.json.EquipmentLevelData;
import ydmsama.hundred_years_war.main.entity.utils.json.EquipmentOption;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;
import ydmsama.hundred_years_war.main.utils.ServerRelationHelper;

public class BanditRaiderEntity
extends BaseCombatEntity
implements LightUnit,
CounterRanged {
    private static final float ATTACK_REACH = 2.5f;
    private static final float MOVEMENT_SPEED = 0.34f;
    private static final UUID DAMAGE_SCALE_MODIFIER = UUID.fromString("f9f2c1c7-1027-49ba-87a5-06bb3d92a3fd");
    private int offhandAttackDelay = -1;
    private class_1309 offhandAttackTarget;
    private int chargeCooldown = 0;
    private int chargeTicks = 0;
    private boolean performingCharge = false;

    public BanditRaiderEntity(class_1299<? extends class_1314> type, class_1937 level) {
        super(type, level);
        this.method_49477(1.0f);
    }

    public static class_5132.class_5133 createBanditRaiderAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23717, 24.0).method_26868(class_5134.field_23719, (double)0.34f).method_26868(class_5134.field_23721, 6.0).method_26868(class_5134.field_23724, 4.0).method_26868(class_5134.field_23716, 32.0).method_26868(class_5134.field_23718, 0.4).method_26868(HywAttributes.ATTACK_REACH, 2.5);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            this.tickOffhandStrike();
            this.tickCharge();
        }
    }

    @Override
    protected void setDefaultEquipment() {
        this.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8371));
        this.method_5673(class_1304.field_6171, new class_1799((class_1935)class_1802.field_8371));
    }

    @Override
    protected void setEquipmentFromLevelData(EquipmentLevelData levelData) {
        EquipmentOption option;
        class_1799 stack;
        super.setEquipmentFromLevelData(levelData);
        List<EquipmentOption> options = levelData.getOffHandWeapon();
        if (options != null && !options.isEmpty() && !(stack = this.createItemStack(option = this.selectRandomItem(options))).method_7960()) {
            this.method_5673(class_1304.field_6171, stack);
        }
    }

    private void tickOffhandStrike() {
        if (this.offhandAttackDelay > 0) {
            --this.offhandAttackDelay;
            if (this.offhandAttackDelay == 0 && this.offhandAttackTarget != null && this.offhandAttackTarget.method_5805()) {
                this.method_23667(class_1268.field_5810, true);
                this.clearImmunity(this.offhandAttackTarget);
                this.performScaledAttack(this.offhandAttackTarget, 0.8f);
            }
            if (this.offhandAttackDelay == 0) {
                this.offhandAttackDelay = -1;
                this.offhandAttackTarget = null;
            }
        } else if (this.offhandAttackTarget != null && !this.offhandAttackTarget.method_5805()) {
            this.offhandAttackTarget = null;
            this.offhandAttackDelay = -1;
        }
    }

    private void tickCharge() {
        if (this.chargeCooldown > 0) {
            --this.chargeCooldown;
        }
        if (this.performingCharge) {
            if (this.chargeTicks > 0) {
                --this.chargeTicks;
                if (this.chargeTicks % 3 == 0) {
                    this.dealChargeDamage();
                }
                if (this.method_24828() && this.chargeTicks < 5) {
                    this.performingCharge = false;
                }
            } else {
                this.performingCharge = false;
            }
        } else if (this.chargeCooldown <= 0) {
            this.tryStartCharge();
        }
    }

    private void tryStartCharge() {
        class_1309 target = this.getHywTarget();
        if (target == null || !target.method_5805() || this.method_5765()) {
            return;
        }
        double distanceSq = this.method_5858((class_1297)target);
        if (distanceSq < 9.0 || distanceSq > 144.0) {
            return;
        }
        if (!this.method_24828()) {
            return;
        }
        class_243 dir = new class_243(target.method_23317() - this.method_23317(), 0.0, target.method_23321() - this.method_23321());
        if (dir.method_1027() < 1.0E-4) {
            return;
        }
        class_243 motion = dir.method_1029().method_1021(1.35);
        this.method_18800(motion.field_1352, 0.35, motion.field_1350);
        this.field_6007 = true;
        this.chargeTicks = 15;
        this.performingCharge = true;
        this.chargeCooldown = 80;
        this.method_5942().method_6340();
        this.spawnChargeParticles();
    }

    private void spawnChargeParticles() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_14199((class_2394)class_2398.field_11204, this.method_23317(), this.method_23318() + 0.2, this.method_23321(), 8, 0.2, 0.0, 0.2, 0.0);
        }
    }

    private void dealChargeDamage() {
        class_238 box = this.method_5829().method_1014(1.5);
        List targets = this.method_37908().method_8390(class_1309.class, box, this::isEnemyTarget);
        for (class_1309 living : targets) {
            this.clearImmunity(living);
            living.method_5643(this.method_48923().method_48812((class_1309)this), (float)(this.method_26825(class_5134.field_23721) * (double)0.9f));
            living.method_6005((double)0.4f, this.method_23317() - living.method_23317(), this.method_23321() - living.method_23321());
        }
    }

    private boolean isEnemyTarget(class_1309 living) {
        if (living == this) {
            return false;
        }
        return ServerRelationHelper.isEnemyRelation((class_1297)this, (class_1297)living);
    }

    private void scheduleOffhandStrike(class_1309 target) {
        this.offhandAttackTarget = target;
        this.offhandAttackDelay = Math.max(1, this.getSwingDurationTicks() + 1);
    }

    private void clearImmunity(class_1309 target) {
        target.field_6008 = 0;
        target.field_6235 = 0;
    }

    private boolean performScaledAttack(class_1309 target, float multiplier) {
        class_1324 attributeInstance = this.method_5996(class_5134.field_23721);
        class_1322 modifier = null;
        if (attributeInstance != null) {
            modifier = new class_1322(DAMAGE_SCALE_MODIFIER, "BanditRaiderScale", (double)multiplier - 1.0, class_1322.class_1323.field_6331);
            attributeInstance.method_26835(modifier);
        }
        boolean success = super.method_6121((class_1297)target);
        if (attributeInstance != null && modifier != null) {
            attributeInstance.method_6202(modifier);
        }
        return success;
    }

    public boolean method_6121(class_1297 entity) {
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            this.clearImmunity(living);
            boolean success = this.performScaledAttack(living, 0.8f);
            this.clearImmunity(living);
            if (living.method_5805()) {
                this.scheduleOffhandStrike(living);
            }
            return success;
        }
        return super.method_6121(entity);
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 8;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 4;
    }

    @Override
    public int getAttackCoolDownDuration() {
        return 6;
    }

    @Override
    protected boolean allowBetterCombatAttack() {
        return false;
    }

    @Override
    protected boolean allowEquipmentReplacement() {
        return false;
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(5, (class_1352)new HywWaterAvoidingRandomStrollGoal(this, 0.85));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        super.method_5959();
    }

    @Override
    public class_1792 getScrollType() {
        return HywItemRegistry.SCROLL_BANDIT_RAIDER;
    }

    @Override
    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("ChargeCooldown", this.chargeCooldown);
        tag.method_10556("PerformingCharge", this.performingCharge);
        tag.method_10569("ChargeTicks", this.chargeTicks);
    }

    @Override
    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.chargeCooldown = tag.method_10550("ChargeCooldown");
        this.performingCharge = tag.method_10577("PerformingCharge");
        this.chargeTicks = tag.method_10550("ChargeTicks");
    }

    public boolean isCharging() {
        return this.performingCharge;
    }

    @Override
    public double getRangedDamageModifier() {
        return 1.3;
    }

    @Override
    public int getSkinCounts() {
        return 3;
    }

    private int getSwingDurationTicks() {
        if (class_1292.method_5576((class_1309)this)) {
            return 6 - (1 + class_1292.method_5575((class_1309)this));
        }
        if (this.method_6059(class_1294.field_5901)) {
            return 6 + (1 + this.method_6112(class_1294.field_5901).method_5578()) * 2;
        }
        return 6;
    }
}

