/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.mounted;

import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1324;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1829;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.main.config.ServerModConfig;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.HywHorseEntity;
import ydmsama.hundred_years_war.main.entity.entities.UseShield;
import ydmsama.hundred_years_war.main.entity.entities.tags.CavalryUnit;
import ydmsama.hundred_years_war.main.entity.entities.tags.CounterHeavy;
import ydmsama.hundred_years_war.main.entity.entities.tags.CounterSiege;
import ydmsama.hundred_years_war.main.entity.entities.tags.HeavyUnit;
import ydmsama.hundred_years_war.main.entity.utils.BaseCombatSupport;
import ydmsama.hundred_years_war.main.entity.utils.Chargeable;
import ydmsama.hundred_years_war.main.entity.utils.HorseRider;
import ydmsama.hundred_years_war.main.entity.utils.json.EquipmentLevelData;
import ydmsama.hundred_years_war.main.entity.utils.json.EquipmentOption;
import ydmsama.hundred_years_war.main.item.BaseScrollItem;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywEntityRegistry;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;
import ydmsama.hundred_years_war.main.utils.CreativeModeSettings;
import ydmsama.hundred_years_war.main.utils.ServerRelationHelper;
import ydmsama.hundred_years_war.main.utils.WeaponTypeHelper;

public class MountedLancerRiderEntity
extends BaseCombatEntity
implements HorseRider,
UseShield,
CavalryUnit,
HeavyUnit,
CounterHeavy,
CounterSiege,
Chargeable {
    private static final float ATTACK_REACH = 3.0f;
    private static final float MOVEMENT_SPEED = 0.33f;
    protected static float BASE_CHARGE_SPEED_MULTIPLIER = 0.25f;
    protected static float BASE_CHARGE_DAMAGE_MULTIPLIER = 3.0f;
    protected static float BASE_CHARGE_KNOCKBACK_STRENGTH = 1.5f;
    protected static float MIN_CHARGE_DISTANCE_SQUARED = 25.0f;
    protected static float MAX_CHARGE_DISTANCE_SQUARED = 900.0f;
    protected static int BASE_CHARGE_COOLDOWN_TICKS = 240;
    protected static int BASE_MAX_CHARGE_DURATION_TICKS = 160;
    protected static int BASE_READY_STANCE_DELAY = 40;
    protected int chargeCooldownCounter = 0;
    protected int chargeDurationCounter = 0;
    protected int readyStanceCounter = 0;
    private boolean horseSpawned = false;
    protected class_1496 mountedHorse;
    private UUID horseUUID;
    private class_2487 savedHorseData;
    private boolean needsHorseSpawn = false;
    private static final class_2940<Boolean> IS_CHARGING = class_2945.method_12791(MountedLancerRiderEntity.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<class_1799> DATA_CHARGE_WEAPON = class_2945.method_12791(MountedLancerRiderEntity.class, (class_2941)class_2943.field_13322);
    protected static final class_2940<class_1799> DATA_MAIN_WEAPON = class_2945.method_12791(MountedLancerRiderEntity.class, (class_2941)class_2943.field_13322);
    protected static final class_2940<Boolean> DATA_IS_USING_CHARGE_WEAPON = class_2945.method_12791(MountedLancerRiderEntity.class, (class_2941)class_2943.field_13323);

    public MountedLancerRiderEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.method_49477(1.0f);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_CHARGE_WEAPON, (Object)this.getDefaultChargeWeapon());
        this.field_6011.method_12784(DATA_MAIN_WEAPON, (Object)this.getDefaultMainWeapon());
        this.field_6011.method_12784(DATA_IS_USING_CHARGE_WEAPON, (Object)false);
        this.field_6011.method_12784(IS_CHARGING, (Object)false);
    }

    protected class_1799 getDefaultChargeWeapon() {
        return new class_1799((class_1935)HywItemRegistry.WOODEN_LANCE);
    }

    protected class_1799 getDefaultMainWeapon() {
        return new class_1799((class_1935)class_1802.field_8371);
    }

    public class_1799 getChargeWeapon() {
        return (class_1799)this.field_6011.method_12789(DATA_CHARGE_WEAPON);
    }

    public void setChargeWeapon(class_1799 stack) {
        this.field_6011.method_12778(DATA_CHARGE_WEAPON, (Object)stack);
    }

    public class_1799 getMainWeapon() {
        return (class_1799)this.field_6011.method_12789(DATA_MAIN_WEAPON);
    }

    public void setMainWeapon(class_1799 stack) {
        this.field_6011.method_12778(DATA_MAIN_WEAPON, (Object)stack);
    }

    public boolean isUsingChargeWeapon() {
        return (Boolean)this.field_6011.method_12789(DATA_IS_USING_CHARGE_WEAPON);
    }

    public void setUsingChargeWeapon(boolean usingChargeWeapon) {
        this.field_6011.method_12778(DATA_IS_USING_CHARGE_WEAPON, (Object)usingChargeWeapon);
        this.method_5673(class_1304.field_6173, usingChargeWeapon ? this.getChargeWeapon() : this.getMainWeapon());
    }

    @Override
    public boolean isCharging() {
        return (Boolean)this.field_6011.method_12789(IS_CHARGING);
    }

    public void setCharging(boolean charging) {
        this.field_6011.method_12778(IS_CHARGING, (Object)charging);
    }

    @Override
    protected void setDefaultEquipment() {
        this.setMainWeapon(this.getDefaultMainWeapon());
        this.setChargeWeapon(this.getDefaultChargeWeapon());
        this.setUsingChargeWeapon(false);
        this.method_5673(class_1304.field_6171, new class_1799((class_1935)class_1802.field_8255));
        this.method_5673(class_1304.field_6169, new class_1799((class_1935)class_1802.field_8743));
        this.method_5673(class_1304.field_6174, new class_1799((class_1935)class_1802.field_8523));
        this.method_5673(class_1304.field_6172, new class_1799((class_1935)class_1802.field_8396));
        this.method_5673(class_1304.field_6166, new class_1799((class_1935)class_1802.field_8660));
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        class_2487 chargeWeaponTag = new class_2487();
        this.getChargeWeapon().method_7953(chargeWeaponTag);
        compound.method_10566("ChargeWeapon", (class_2520)chargeWeaponTag);
        class_2487 mainWeaponTag = new class_2487();
        this.getMainWeapon().method_7953(mainWeaponTag);
        compound.method_10566("MainWeapon", (class_2520)mainWeaponTag);
        compound.method_10556("HorseSpawned", this.horseSpawned);
        if (this.horseUUID != null) {
            compound.method_25927("HorseUUID", this.horseUUID);
        }
        if (this.savedHorseData != null) {
            compound.method_10566("SavedHorseData", (class_2520)this.savedHorseData);
        }
        compound.method_10556("IsCharging", this.isCharging());
        compound.method_10569("ChargeCooldown", this.chargeCooldownCounter);
        compound.method_10569("ChargeDuration", this.chargeDurationCounter);
        compound.method_10569("ReadyStance", this.readyStanceCounter);
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10545("ChargeWeapon")) {
            class_2487 chargeWeaponTag = compound.method_10562("ChargeWeapon");
            class_1799 chargeWeaponStack = class_1799.method_7915((class_2487)chargeWeaponTag);
            this.setChargeWeapon(chargeWeaponStack);
        }
        if (compound.method_10545("MainWeapon")) {
            class_2487 mainWeaponTag = compound.method_10562("MainWeapon");
            class_1799 mainWeaponStack = class_1799.method_7915((class_2487)mainWeaponTag);
            this.setMainWeapon(mainWeaponStack);
        }
        this.horseSpawned = compound.method_10577("HorseSpawned");
        if (compound.method_25928("HorseUUID")) {
            this.horseUUID = compound.method_25926("HorseUUID");
        }
        if (compound.method_10545("SavedHorseData")) {
            this.savedHorseData = compound.method_10562("SavedHorseData");
            this.needsHorseSpawn = true;
            this.horseSpawned = false;
        }
        this.setCharging(compound.method_10577("IsCharging"));
        this.chargeCooldownCounter = compound.method_10550("ChargeCooldown");
        this.chargeDurationCounter = compound.method_10550("ChargeDuration");
        this.readyStanceCounter = compound.method_10550("ReadyStance");
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236 && this.needsHorseSpawn && this.method_5805()) {
            this.spawnHorse();
            this.needsHorseSpawn = false;
        } else if (!this.method_37908().field_9236 && !this.horseSpawned && this.method_5805() && !this.method_5765()) {
            this.spawnHorse();
        }
        if (!this.method_37908().field_9236 && this.horseSpawned && this.mountedHorse == null && this.horseUUID != null) {
            for (class_1297 entity : this.method_37908().method_18467(class_1496.class, this.method_5829().method_1014(10.0))) {
                if (!entity.method_5667().equals(this.horseUUID)) continue;
                this.mountedHorse = (class_1496)entity;
                if (this.method_5765()) break;
                this.method_5873((class_1297)this.mountedHorse, true);
                break;
            }
        }
        if (!this.method_37908().field_9236) {
            this.handleChargeLogic();
            this.manageHorseChargeSpeed();
        }
    }

    private void spawnHorse() {
        this.mountedHorse = this.createHorseEntity();
        if (this.mountedHorse != null) {
            BaseCombatSupport support;
            this.mountedHorse.method_5814(this.method_23317(), this.method_23318(), this.method_23321());
            class_1496 class_14962 = this.mountedHorse;
            if (class_14962 instanceof BaseCombatSupport) {
                support = (BaseCombatSupport)class_14962;
                support.method_6732(this.method_6139());
            }
            if ((class_14962 = this.mountedHorse) instanceof HywHorseEntity) {
                HywHorseEntity hywHorse = (HywHorseEntity)class_14962;
                hywHorse.setRiderEntity(this);
                hywHorse.setNpcHorse(true);
            }
            if (this.savedHorseData != null) {
                try {
                    this.mountedHorse.method_5749(this.savedHorseData);
                    this.savedHorseData = null;
                }
                catch (Exception e) {
                    System.err.println("Failed to restore horse data: " + e.getMessage());
                }
            } else {
                class_14962 = this.mountedHorse;
                if (class_14962 instanceof BaseCombatSupport) {
                    support = (BaseCombatSupport)class_14962;
                    support.setEquipment(this.getEquipmentLevel());
                }
            }
            this.method_37908().method_8649((class_1297)this.mountedHorse);
            this.method_5873((class_1297)this.mountedHorse, true);
            this.horseSpawned = true;
            this.horseUUID = this.mountedHorse.method_5667();
        }
    }

    protected class_1496 createHorseEntity() {
        return (class_1496)HywEntityRegistry.HORSE.method_5883(this.method_37908());
    }

    private void handleChargeLogic() {
        if (this.chargeCooldownCounter > 0) {
            --this.chargeCooldownCounter;
        } else if (this.getHywTarget() == null) {
            ++this.readyStanceCounter;
            if (this.readyStanceCounter > this.getReadyStanceDelay() && !this.isUsingChargeWeapon() && this.getHywTarget() == null) {
                this.setUsingChargeWeapon(true);
            }
        } else {
            this.readyStanceCounter = 0;
        }
        if (this.getHywTarget() != null) {
            double distanceToTarget = this.method_5858((class_1297)this.getHywTarget());
            if (!this.isCharging() && distanceToTarget < (double)this.getMinChargeDistanceSquared()) {
                this.setUsingChargeWeapon(false);
            }
            if (this.canCharge() && !this.isCharging() && this.isFacingTarget(this.getHywTarget(), 10.0f)) {
                this.startCharge();
            }
        }
        if (this.isCharging()) {
            ++this.chargeDurationCounter;
            this.applyChargeImpulse();
            if (this.chargeDurationCounter >= this.getMaxChargeDurationTicks()) {
                this.endCharge(false);
            } else if (this.getHywTarget() != null && this.method_5858((class_1297)this.getHywTarget()) <= (double)(this.getChargeAttackReach() * this.getChargeAttackReach())) {
                this.performChargeAttack();
                this.endCharge(true);
            }
        }
    }

    protected float getMinChargeDistanceSquared() {
        return MIN_CHARGE_DISTANCE_SQUARED;
    }

    protected float getMaxChargeDistanceSquared() {
        return MAX_CHARGE_DISTANCE_SQUARED;
    }

    protected int getChargeCooldownTicks() {
        return BASE_CHARGE_COOLDOWN_TICKS;
    }

    protected int getMaxChargeDurationTicks() {
        return BASE_MAX_CHARGE_DURATION_TICKS;
    }

    protected float getChargeSpeedMultiplier() {
        return BASE_CHARGE_SPEED_MULTIPLIER;
    }

    protected float getChargeDamageMultiplier() {
        return 6.0f;
    }

    protected float getChargeKnockbackStrength() {
        return BASE_CHARGE_KNOCKBACK_STRENGTH;
    }

    protected int getReadyStanceDelay() {
        return BASE_READY_STANCE_DELAY;
    }

    public float getChargeAttackReach() {
        class_1324 attackReachAttr = this.method_5996(HywAttributes.ATTACK_REACH);
        float baseReach = attackReachAttr != null ? (float)attackReachAttr.method_6194() : 3.0f;
        return baseReach + 0.5f;
    }

    protected boolean canCharge() {
        if (this.chargeCooldownCounter > 0 || this.getHywTarget() == null || !this.isUsingChargeWeapon() || this.shouldMoveOnly()) {
            return false;
        }
        if (this.method_5854() == null || !(this.method_5854() instanceof class_1496)) {
            return false;
        }
        if (this.isHolding()) {
            return false;
        }
        double distance = this.method_5858((class_1297)this.getHywTarget());
        return distance >= (double)this.getMinChargeDistanceSquared() && distance <= (double)this.getMaxChargeDistanceSquared();
    }

    protected boolean isFacingTarget(class_1309 target, float maxAngle) {
        float yaw = this.method_5854() != null ? this.method_5854().method_36454() : this.method_36454();
        class_243 forward = new class_243((double)(-class_3532.method_15374((float)(yaw * (float)Math.PI / 180.0f))), 0.0, (double)class_3532.method_15362((float)(yaw * (float)Math.PI / 180.0f))).method_1029();
        class_243 toTarget = new class_243(target.method_23317() - this.method_23317(), 0.0, target.method_23321() - this.method_23321()).method_1029();
        double dot = forward.method_1026(toTarget);
        double angle = Math.acos(dot) * 57.29577951308232;
        return angle <= (double)maxAngle;
    }

    protected void startCharge() {
        this.setCharging(true);
        this.chargeDurationCounter = 0;
    }

    protected void performChargeAttack() {
        class_1309 target = this.getHywTarget();
        if (target != null) {
            float weaponDamage = this.getMainHandWeaponDamage();
            float chargeDamage = weaponDamage * this.getChargeDamageMultiplier() + this.getChargeDamageBonus();
            target.method_5643(this.method_48923().method_48812((class_1309)this), chargeDamage);
            target.method_6005((double)this.getChargeKnockbackStrength(), this.method_23317() - target.method_23317(), this.method_23321() - target.method_23321());
        }
    }

    private float getMainHandWeaponDamage() {
        class_1799 mainHandItem = this.method_5998(class_1268.field_5808);
        class_1792 class_17922 = mainHandItem.method_7909();
        if (class_17922 instanceof class_1829) {
            class_1829 swordItem = (class_1829)class_17922;
            return swordItem.method_8020();
        }
        return (float)this.method_26825(class_5134.field_23721);
    }

    private float getChargeDamageBonus() {
        return (float)(this.getEquipmentLevel() - 1) * 0.5f;
    }

    protected void endCharge(boolean attacked) {
        this.setCharging(false);
        this.chargeCooldownCounter = this.getChargeCooldownTicks();
        this.chargeDurationCounter = 0;
        this.setUsingChargeWeapon(false);
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 12;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 5;
    }

    @Override
    public int getAttackCoolDownDuration() {
        Random random = new Random();
        return 3 + random.nextInt(8);
    }

    protected void method_6060(class_1309 livingEntity) {
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 4.0f));
        super.method_5959();
    }

    @Override
    protected void increaseStatsOnLevelUp() {
        class_1324 attackDamage;
        super.increaseStatsOnLevelUp();
        class_1324 maxHealth = this.method_5996(class_5134.field_23716);
        if (maxHealth != null) {
            maxHealth.method_6192(maxHealth.method_6201() + 2.0);
            this.method_6025(2.0f);
        }
        if ((attackDamage = this.method_5996(class_5134.field_23721)) != null) {
            attackDamage.method_6192(attackDamage.method_6201() + 0.2);
        }
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        class_1657 player;
        class_1297 class_12972;
        if (this.mountedHorse != null && this.mountedHorse.method_5805()) {
            this.mountedHorse.method_5643(source, 0.0f);
        }
        if ((class_12972 = source.method_5529()) instanceof class_1657 && (player = (class_1657)class_12972).method_5715() && (ServerRelationHelper.hasControlOver(player, (class_1297)this) || CreativeModeSettings.canControlAllUnits(player)) && ServerModConfig.INSTANCE.isAllowEquipmentChange()) {
            class_1799 playerItem = player.method_5998(class_1268.field_5808);
            if (WeaponTypeHelper.isLanceLikeWeapon(playerItem)) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.lastWeaponReplaceTime < 1000L) {
                    return false;
                }
                class_1799 entityItem = this.getChargeWeapon();
                this.setChargeWeapon(playerItem.method_7972());
                if (this.isUsingChargeWeapon()) {
                    this.method_5673(class_1304.field_6173, playerItem.method_7972());
                }
                player.method_6122(class_1268.field_5808, class_1799.field_8037);
                if (!entityItem.method_7960()) {
                    player.method_6122(class_1268.field_5808, entityItem);
                }
                this.lastWeaponReplaceTime = currentTime;
                return false;
            }
            if (WeaponTypeHelper.isSwordLikeWeapon(playerItem)) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.lastWeaponReplaceTime < 1000L) {
                    return false;
                }
                class_1799 entityItem = this.getMainWeapon();
                this.setMainWeapon(playerItem.method_7972());
                if (!this.isUsingChargeWeapon()) {
                    this.method_5673(class_1304.field_6173, playerItem.method_7972());
                }
                player.method_6122(class_1268.field_5808, class_1799.field_8037);
                if (!entityItem.method_7960()) {
                    player.method_6122(class_1268.field_5808, entityItem);
                }
                this.lastWeaponReplaceTime = currentTime;
                return false;
            }
        }
        return super.method_5643(source, amount);
    }

    protected boolean isChargeWeaponItem(class_1799 stack) {
        return WeaponTypeHelper.isLanceLikeWeapon(stack);
    }

    public static class_5132.class_5133 createMountedLancerRiderAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23717, 30.0).method_26868(class_5134.field_23719, (double)0.33f).method_26868(class_5134.field_23721, 6.0).method_26868(class_5134.field_23724, 6.0).method_26868(class_5134.field_23716, 34.0).method_26868(class_5134.field_23718, 0.5).method_26868(HywAttributes.ATTACK_REACH, 3.0);
    }

    @Override
    protected void setEquipmentFromLevelData(EquipmentLevelData levelData) {
        super.setEquipmentFromLevelData(levelData);
        this.loadWeaponsFromLevelData(levelData);
    }

    protected void loadWeaponsFromLevelData(EquipmentLevelData levelData) {
        EquipmentOption chargeWeaponOption = this.selectRandomItem(levelData.getLanceWeapon());
        class_1799 chargeWeaponStack = this.createItemStack(chargeWeaponOption);
        this.setChargeWeapon(chargeWeaponStack);
        EquipmentOption mainWeaponOption = this.selectRandomItem(levelData.getMainWeapon());
        class_1799 mainWeaponStack = this.createItemStack(mainWeaponOption);
        this.setMainWeapon(mainWeaponStack);
    }

    @Override
    @NotNull
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (player.method_5715() && hand == class_1268.field_5808) {
            if ((ServerModConfig.INSTANCE.isAllowSoldierRecall() || player.method_7337() && CreativeModeSettings.canControlAllUnits(player)) && this.getScrollType() != null) {
                return this.handleScrollConversion(player);
            }
            return class_1269.field_5811;
        }
        return super.method_5992(player, hand);
    }

    private class_1269 handleScrollConversion(class_1657 player) {
        class_1799 stack = new class_1799((class_1935)this.getScrollType());
        class_2487 entityData = new class_2487();
        if (this.mountedHorse != null && this.mountedHorse.method_5805()) {
            class_2487 horseData = new class_2487();
            this.method_5848();
            class_1496 class_14962 = this.mountedHorse;
            if (class_14962 instanceof HywHorseEntity) {
                HywHorseEntity hywHorse = (HywHorseEntity)class_14962;
                hywHorse.setRiderEntity(null);
            }
            this.mountedHorse.method_5647(horseData);
            entityData.method_10566("SavedHorseData", (class_2520)horseData);
            this.mountedHorse.method_31472();
            this.mountedHorse = null;
        }
        this.method_5647(entityData);
        ((BaseScrollItem)stack.method_7909()).saveEntityDataToItem(stack, entityData);
        if (!player.method_31548().method_7394(stack)) {
            player.method_7328(stack, false);
        }
        this.spawnDespawnParticles();
        this.method_31472();
        return class_1269.field_5812;
    }

    private void spawnDespawnParticles() {
        int particleCount = 40;
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            for (int i = 0; i < particleCount; ++i) {
                double offsetX = (this.method_37908().field_9229.method_43058() - 0.5) * 1.0;
                double offsetY = this.method_37908().field_9229.method_43058() * 0.5 + 0.5;
                double offsetZ = (this.method_37908().field_9229.method_43058() - 0.5) * 1.0;
                serverLevel.method_14199((class_2394)class_2398.field_11204, this.method_23317(), this.method_23318() + 0.5, this.method_23321(), 1, offsetX, offsetY, offsetZ, 0.0);
            }
        }
    }

    protected void applyChargeImpulse() {
        double deltaZ;
        double deltaX;
        double distance;
        class_1297 class_12972;
        if (this.method_5854() == null || !((class_12972 = this.method_5854()) instanceof class_1496)) {
            return;
        }
        class_1496 horse = (class_1496)class_12972;
        if (!horse.method_24828()) {
            return;
        }
        class_1309 target = this.getHywTarget();
        if (target != null && (distance = Math.sqrt((deltaX = target.method_23317() - horse.method_23317()) * deltaX + (deltaZ = target.method_23321() - horse.method_23321()) * deltaZ)) > 0.0) {
            deltaX = deltaX / distance * (double)this.getChargeSpeedMultiplier();
            deltaZ = deltaZ / distance * (double)this.getChargeSpeedMultiplier();
            horse.method_5762(deltaX, 0.0, deltaZ);
        }
    }

    @Override
    public double getLightDamageModifier() {
        return 1.0;
    }

    @Override
    public double getHeavyDamageModifier() {
        return 1.5;
    }

    @Override
    public double getSiegeDamageModifier() {
        return 1.2;
    }

    @Override
    public class_1309 asLivingEntity() {
        return this;
    }

    @Override
    public boolean hasValidTarget() {
        return this.getHywTarget() != null;
    }

    @Override
    public double getHorseSpeed() {
        return 0.38;
    }

    @Override
    public class_1792 getScrollType() {
        return switch (this.getEquipmentLevel()) {
            case 1 -> HywItemRegistry.SCROLL_MOUNTED_LANCER;
            case 2 -> HywItemRegistry.SCROLL_MOUNTED_LANCER_1;
            case 3 -> HywItemRegistry.SCROLL_MOUNTED_LANCER_2;
            case 4 -> HywItemRegistry.SCROLL_MOUNTED_LANCER_3;
            default -> null;
        };
    }

    @Override
    public void method_6078(class_1282 damageSource) {
        if (this.mountedHorse != null && this.mountedHorse.method_5805()) {
            this.mountedHorse.method_5768();
        }
        super.method_6078(damageSource);
    }

    @Override
    public float getRotationLimit() {
        return 30.0f;
    }

    @Override
    public double getArrivalThreshold() {
        return 2.0;
    }
}

