/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.siege;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1603;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2675;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import ydmsama.hundred_years_war.main.entity.action.Action;
import ydmsama.hundred_years_war.main.entity.action.PositionAttackAction;
import ydmsama.hundred_years_war.main.entity.action.SiegeModeAction;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.projectile.BlockBreakable;
import ydmsama.hundred_years_war.main.entity.entities.projectile.CannonballEntity;
import ydmsama.hundred_years_war.main.entity.entities.siege.PositionAttackable;
import ydmsama.hundred_years_war.main.entity.entities.siege.SiegeMode;
import ydmsama.hundred_years_war.main.entity.entities.tags.SiegeUnit;
import ydmsama.hundred_years_war.main.entity.goals.BaseCombatEntityAttackGoal;
import ydmsama.hundred_years_war.main.entity.goals.FollowEntityGoal;
import ydmsama.hundred_years_war.main.entity.goals.PatrolGoal;
import ydmsama.hundred_years_war.main.entity.goals.ReturnToHomeGoal;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywEntityRegistry;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class BombardEntity
extends BaseCombatEntity
implements class_1603,
SiegeUnit,
SiegeMode,
PositionAttackable {
    private static final float ATTACK_REACH = 100.0f;
    private static final float MOVEMENT_SPEED = 0.2f;
    private static final float BASE_RANGED_ATTACK_DAMAGE = 35.0f;
    private float leftWheelRotation;
    private float rightWheelRotation;
    private static final class_2940<class_2338> TARGET_POS = class_2945.method_12791(BombardEntity.class, (class_2941)class_2943.field_13324);
    private static final class_2940<Integer> STATE = class_2945.method_12791(BombardEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> SIEGE_MODE = class_2945.method_12791(BombardEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> HAS_POSITION_TARGET = class_2945.method_12791(BombardEntity.class, (class_2941)class_2943.field_13323);
    private class_243 positionTarget;
    private SiegeModeAction siegeModeAction;
    private PositionAttackAction positionAttackAction;
    private int packingProgress = 0;
    private int assemblingProgress = 0;
    private int assemblingWait = 10;

    public BombardEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.method_49477(1.0f);
        this.field_6011.method_12784(TARGET_POS, (Object)class_2338.field_10980);
        this.field_6011.method_12784(STATE, (Object)BombardState.PACKED.ordinal());
        this.field_6011.method_12784(SIEGE_MODE, (Object)false);
        this.field_6011.method_12784(HAS_POSITION_TARGET, (Object)false);
        this.siegeModeAction = new SiegeModeAction(false);
        this.positionAttackAction = new PositionAttackAction();
        this.positionTarget = null;
    }

    @Override
    public List<Action> getActions() {
        ArrayList<Action> actions = new ArrayList<Action>(super.getActions());
        this.siegeModeAction.setCurrentState(this.isSiegeModeEnabled());
        actions.add(this.siegeModeAction);
        actions.add(this.positionAttackAction);
        return actions;
    }

    @Override
    public boolean isSiegeModeEnabled() {
        return (Boolean)this.field_6011.method_12789(SIEGE_MODE);
    }

    @Override
    public void setSiegeModeEnabled(boolean enabled) {
        this.field_6011.method_12778(SIEGE_MODE, (Object)enabled);
        if (!this.method_37908().field_9236) {
            this.siegeModeAction.setCurrentState(enabled);
        }
    }

    public static class_5132.class_5133 createBombardAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23717, 100.0).method_26868(class_5134.field_23719, (double)0.2f).method_26868(class_5134.field_23721, 12.0).method_26868(class_5134.field_23724, 15.0).method_26868(class_5134.field_23716, 100.0).method_26868(class_5134.field_23718, 1.0).method_26868(HywAttributes.ATTACK_REACH, 100.0).method_26868(HywAttributes.RANGED_ATTACK_DAMAGE, 35.0);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            if (this.hasPositionTarget() && this.getPositionTarget() != null) {
                class_2338 targetBlockPos = new class_2338((int)this.getPositionTarget().field_1352, (int)this.getPositionTarget().field_1351, (int)this.getPositionTarget().field_1350);
                this.setTargetPosition(targetBlockPos);
            } else if (this.getHywTarget() != null) {
                this.setTargetPosition(this.getHywTarget().method_24515());
            } else {
                this.setTargetPosition(class_2338.field_10980);
            }
        }
        double velocityX = this.method_18798().field_1352;
        double velocityZ = this.method_18798().field_1350;
        double speedSq = velocityX * velocityX + velocityZ * velocityZ;
        double speedThreshold = 1.0E-4;
        if (!this.method_37908().field_9236) {
            this.manageState();
            if (speedSq < speedThreshold && this.getCurrentState() == BombardState.PACKED) {
                if (this.assemblingWait > 0) {
                    --this.assemblingWait;
                } else {
                    this.startAssembling();
                    this.assemblingWait = 10;
                }
            }
            if (speedSq > speedThreshold && this.getCurrentState() == BombardState.ASSEMBLING) {
                this.setCurrentState(BombardState.PACKED);
            }
            if (!this.method_5942().method_6357() && this.getCurrentState() == BombardState.ASSEMBLED) {
                this.startPacking();
            }
        }
    }

    private void manageState() {
        switch (this.getCurrentState()) {
            case PACKED: {
                this.setAttributeBaseValue(class_5134.field_23719, 0.2f);
                break;
            }
            case ASSEMBLED: {
                this.setAttributeBaseValue(class_5134.field_23719, 0.0);
                break;
            }
            case PACKING: {
                if (this.packingProgress > 0) {
                    --this.packingProgress;
                    break;
                }
                this.setCurrentState(BombardState.PACKED);
                this.setAttributeBaseValue(class_5134.field_23719, 0.2f);
                break;
            }
            case ASSEMBLING: {
                if (this.assemblingProgress > 0) {
                    --this.assemblingProgress;
                    break;
                }
                this.setCurrentState(BombardState.ASSEMBLED);
            }
        }
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 15;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 5;
    }

    @Override
    public int getAttackCoolDownDuration() {
        Random random = new Random();
        return 70 + random.nextInt(50);
    }

    @Override
    public float getRotationLimit() {
        return 0.5f;
    }

    @Override
    protected void increaseStatsOnLevelUp() {
    }

    @Override
    public double getDesiredDistance() {
        return 2.5;
    }

    public void method_7105(class_1309 target, float pullProgress) {
        this.PerformRangedAttackBoth(null, target);
    }

    @Override
    public void performPositionAttack(class_243 targetPosition, float pullProgress) {
        this.PerformRangedAttackBoth(targetPosition, null);
    }

    @Override
    public void PerformRangedAttackBoth(class_243 targetPosition, class_1309 target) {
        double horizontalDistance;
        if (targetPosition == null && target != null) {
            targetPosition = new class_243(target.method_23317(), target.method_23323(0.5), target.method_23321());
        }
        if (targetPosition == null) {
            return;
        }
        if (target != null && !this.canFireAtTarget(target) || target == null && !this.canFireAtPosition(targetPosition)) {
            return;
        }
        CannonballEntity cannonball = new CannonballEntity(HywEntityRegistry.CANNONBALL, (class_1309)this, this.method_37908());
        double baseDamage = this.method_26825(HywAttributes.RANGED_ATTACK_DAMAGE);
        cannonball.method_7438(baseDamage);
        if (cannonball instanceof BlockBreakable) {
            cannonball.setCanBreakBlocks(this.isSiegeModeEnabled());
        }
        float yBodyRot = this.getTrueYBodyRot() + 90.0f;
        double offsetX = Math.cos(Math.toRadians(yBodyRot)) * 2.5;
        double offsetZ = Math.sin(Math.toRadians(yBodyRot)) * 2.5;
        cannonball.method_5814(this.method_23317() + offsetX, this.method_23318(), this.method_23321() + offsetZ);
        cannonball.method_33574(cannonball.method_19538().method_1019(new class_243(0.0, 1.2, 0.0)));
        double dx = targetPosition.field_1352 - cannonball.method_23317();
        double dz = targetPosition.field_1350 - cannonball.method_23321();
        double dy = targetPosition.field_1351 - cannonball.method_23318();
        double distance = Math.sqrt(dx * dx + dz * dz + dy * dy);
        if (distance == 0.0) {
            return;
        }
        float speed = 4.0f;
        double gravity = 0.05;
        double angle = Double.NaN;
        float miss = 2.5f;
        double[] angles = this.calculateLaunchAngles(speed, gravity, distance, dy);
        angle = angles[1];
        if (Double.isNaN(angle)) {
            return;
        }
        double randomSpeedOffset = BombardEntity.getRandomInRange(-0.25, 0.75);
        if (target != null) {
            double timeToTarget = distance / (((double)speed - randomSpeedOffset) * Math.cos(angle));
            double targetVelocityX = target.method_18798().method_10216();
            double targetVelocityZ = target.method_18798().method_10215();
            double predictedX = target.method_23317() + targetVelocityX * timeToTarget;
            double predictedZ = target.method_23321() + targetVelocityZ * timeToTarget;
            double predictedDistance = Math.sqrt((predictedX - cannonball.method_23317()) * (predictedX - cannonball.method_23317()) + (predictedZ - cannonball.method_23321()) * (predictedZ - cannonball.method_23321()));
            angles = this.calculateLaunchAngles(speed, gravity, predictedDistance, dy);
            if (Double.isNaN(angles[0]) && Double.isNaN(angles[1])) {
                return;
            }
            angle = angles[1];
            dx = predictedX - this.method_23317();
            dz = predictedZ - this.method_23321();
        }
        if ((horizontalDistance = Math.sqrt(dx * dx + dz * dz)) == 0.0) {
            return;
        }
        double horizontalSpeed = (double)speed * Math.cos(angle);
        double verticalSpeed = (double)speed * Math.sin(angle);
        float velocityX = (float)(dx / horizontalDistance * horizontalSpeed);
        float velocityY = (float)verticalSpeed;
        float velocityZ = (float)(dz / horizontalDistance * horizontalSpeed);
        cannonball.method_7485(velocityX, velocityY, velocityZ, speed, miss);
        this.method_5783(class_3417.field_14803, 15.0f, 1.0f / (this.method_6051().method_43057() * 0.4f + 0.8f));
        this.method_37908().method_8649((class_1297)cannonball);
        this.spawnParticles(this.method_37908(), cannonball.method_23317(), cannonball.method_23318(), cannonball.method_23321());
        this.method_6021();
    }

    @Override
    public boolean canFireAtTarget(class_1309 target) {
        if (this.isObstructed(target)) {
            return false;
        }
        class_243 targetPosition = new class_243(target.method_23317(), target.method_23318(), target.method_23321());
        return this.canFireAtPosition(targetPosition);
    }

    @Override
    public boolean canFireAtPosition(class_243 targetPosition) {
        if (targetPosition == null || this.getCurrentState() != BombardState.ASSEMBLED) {
            return false;
        }
        float allowedRotationDifference = 15.0f;
        double dx = targetPosition.field_1352 - this.method_23317();
        double dz = targetPosition.field_1350 - this.method_23321();
        float actualTargetRot = (float)(class_3532.method_15349((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
        float actualRotDifference = class_3532.method_15393((float)(actualTargetRot - this.currentRot));
        float rotationDifference = class_3532.method_15393((float)(this.targetRot - this.currentRot));
        return Math.abs(rotationDifference) <= allowedRotationDifference && Math.abs(actualRotDifference) <= allowedRotationDifference;
    }

    private boolean isPathClear(class_1665 arrow, double angle, float speed, double dx, double dy, double dz, double distance, class_1309 target) {
        class_243 startPos = this.method_33571();
        class_243 direction = new class_243(dx / distance, Math.tan(angle), dz / distance).method_1029();
        class_243 endPos = startPos.method_1019(direction.method_1021(5.0));
        class_3965 hitResult = this.method_37908().method_17742(new class_3959(startPos, endPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)arrow));
        return hitResult.method_17783() == class_239.class_240.field_1333;
    }

    private double[] calculateLaunchAngles(double speed, double gravity, double distance, double heightDifference) {
        double discriminant = speed * speed * speed * speed - gravity * (gravity * distance * distance + 2.0 * heightDifference * speed * speed);
        if (discriminant < 0.0) {
            return new double[]{Double.NaN, Double.NaN};
        }
        double angle1 = Math.atan2(speed * speed + Math.sqrt(discriminant), gravity * distance);
        double angle2 = Math.atan2(speed * speed - Math.sqrt(discriminant), gravity * distance);
        return new double[]{angle1, angle2};
    }

    public static double getRandomInRange(double min, double max) {
        return min + Math.random() * (max - min);
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new FollowEntityGoal(this, 1.0, 5.0, 20.0, 25.0, 50.0));
        this.field_6201.method_6277(2, (class_1352)new BaseCombatEntityAttackGoal(this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new PatrolGoal(this, 1.0, 40));
        this.field_6201.method_6277(3, (class_1352)new FollowEntityGoal(this, 1.0, 5.0, 5.0, Double.MAX_VALUE, 0.0));
        this.field_6201.method_6277(4, (class_1352)new ReturnToHomeGoal(this, 1.0));
        super.addTargetSelector();
    }

    @Override
    public boolean isValidTarget(class_1309 potentialTarget) {
        if (this.isObstructed(potentialTarget)) {
            return false;
        }
        double minimumAttackDistance = 5.0;
        double allowedVerticalDistance = 30.0;
        double distanceToTarget = this.method_5649(potentialTarget.method_23317(), potentialTarget.method_23318(), potentialTarget.method_23321());
        if (distanceToTarget < minimumAttackDistance * minimumAttackDistance) {
            return false;
        }
        double verticalDistance = Math.abs(potentialTarget.method_23318() - this.method_23318());
        if (verticalDistance > allowedVerticalDistance) {
            return false;
        }
        return super.isValidTarget(potentialTarget);
    }

    public void setTargetPosition(class_2338 pos) {
        this.field_6011.method_12778(TARGET_POS, (Object)pos);
    }

    @Override
    public float getCurrentRot() {
        return this.currentRot;
    }

    @Override
    public float getTargetRot() {
        return this.targetRot;
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("BombardState", ((Integer)this.field_6011.method_12789(STATE)).intValue());
        compound.method_10569("AssemblingProgress", this.assemblingProgress);
        compound.method_10569("PackingProgress", this.packingProgress);
        compound.method_10569("AssemblingWait", this.assemblingWait);
        compound.method_10556("SiegeMode", this.isSiegeModeEnabled());
        compound.method_10556("HasPositionTarget", this.hasPositionTarget());
        if (this.hasPositionTarget() && this.positionTarget != null) {
            compound.method_10549("PositionTargetX", this.positionTarget.field_1352);
            compound.method_10549("PositionTargetY", this.positionTarget.field_1351);
            compound.method_10549("PositionTargetZ", this.positionTarget.field_1350);
        }
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.field_6011.method_12778(STATE, (Object)compound.method_10550("BombardState"));
        this.assemblingProgress = compound.method_10550("AssemblingProgress");
        this.packingProgress = compound.method_10550("PackingProgress");
        this.assemblingWait = compound.method_10550("AssemblingWait");
        if (compound.method_10545("SiegeMode")) {
            this.setSiegeModeEnabled(compound.method_10577("SiegeMode"));
        }
        if (compound.method_10545("HasPositionTarget") && compound.method_10577("HasPositionTarget")) {
            double x = compound.method_10574("PositionTargetX");
            double y = compound.method_10574("PositionTargetY");
            double z = compound.method_10574("PositionTargetZ");
            this.setPositionTarget(new class_243(x, y, z));
        } else {
            this.setPositionTarget(null);
        }
    }

    private void spawnParticles(class_1937 world, double x, double y, double z) {
        if (world instanceof class_3218) {
            class_3218 serverLevel = (class_3218)world;
            this.sendParticlesToAllNearby(serverLevel, class_2398.field_11236, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
            this.sendParticlesToAllNearby(serverLevel, class_2398.field_11251, x, y, z, 100, 0.0, 0.0, 0.0, 0.25);
            this.sendParticlesToAllNearby(serverLevel, class_2398.field_11240, x, y, z, 50, 0.0, 0.0, 0.0, 0.25);
            this.sendParticlesToAllNearby(serverLevel, class_2398.field_11237, x, y, z, 25, 0.0, 0.0, 0.0, 0.1);
        }
    }

    public <T extends class_2394> int sendParticlesToAllNearby(class_3218 serverLevel, T particleOptions, double x, double y, double z, int count, double xOffset, double yOffset, double zOffset, double speed) {
        class_2675 packet = new class_2675(particleOptions, true, x, y, z, (float)xOffset, (float)yOffset, (float)zOffset, (float)speed, count);
        int sentCount = 0;
        for (class_3222 serverPlayer : serverLevel.method_18456()) {
            if (!this.sendParticlesToPlayer(serverLevel, serverPlayer, x, y, z, (class_2596<?>)packet)) continue;
            ++sentCount;
        }
        return sentCount;
    }

    private boolean sendParticlesToPlayer(class_3218 serverLevel, class_3222 serverPlayer, double x, double y, double z, class_2596<?> packet) {
        if (serverPlayer.method_37908() != serverLevel) {
            return false;
        }
        double distanceSquared = serverPlayer.method_19538().method_1025(new class_243(x, y, z));
        if (distanceSquared < 262144.0) {
            serverPlayer.field_13987.method_14364(packet);
            return true;
        }
        return false;
    }

    public BombardState getCurrentState() {
        return BombardState.values()[(Integer)this.field_6011.method_12789(STATE)];
    }

    private void setCurrentState(BombardState state) {
        this.field_6011.method_12778(STATE, (Object)state.ordinal());
    }

    public void startPacking() {
        if (this.getCurrentState() == BombardState.ASSEMBLED) {
            this.setCurrentState(BombardState.PACKING);
            this.packingProgress = 10;
        }
    }

    public void startAssembling() {
        if (this.getCurrentState() == BombardState.PACKED) {
            this.setCurrentState(BombardState.ASSEMBLING);
            this.assemblingProgress = 100;
        }
    }

    public float getLeftWheelRotation() {
        return this.leftWheelRotation;
    }

    public void setLeftWheelRotation(float leftWheelRotation) {
        this.leftWheelRotation = leftWheelRotation;
    }

    public float getRightWheelRotation() {
        return this.rightWheelRotation;
    }

    public void setRightWheelRotation(float rightWheelRotation) {
        this.rightWheelRotation = rightWheelRotation;
    }

    public int getPackingProgress() {
        return this.packingProgress;
    }

    public int getAssemblingProgress() {
        return this.assemblingProgress;
    }

    public void setPackingProgress(int packingProgress) {
        this.packingProgress = packingProgress;
    }

    public void setAssemblingProgress(int assemblingProgress) {
        this.assemblingProgress = assemblingProgress;
    }

    @Override
    public double getArrivalThreshold() {
        return 2.0;
    }

    public void method_5784(class_1313 type, class_243 displacement) {
        if (this.getCurrentState() != BombardState.PACKED) {
            displacement = displacement.field_1351 > 0.0 ? displacement.method_1021(0.0) : new class_243(0.0, displacement.field_1351, 0.0);
        }
        super.method_5784(type, displacement);
    }

    @Override
    public class_1792 getScrollType() {
        return HywItemRegistry.BOMBARD;
    }

    @Override
    public boolean hasPositionTarget() {
        return (Boolean)this.field_6011.method_12789(HAS_POSITION_TARGET);
    }

    @Override
    public class_243 getPositionTarget() {
        return this.positionTarget;
    }

    @Override
    public void setPositionTarget(class_243 targetPosition) {
        this.positionTarget = targetPosition;
        this.field_6011.method_12778(HAS_POSITION_TARGET, (Object)(targetPosition != null ? 1 : 0));
        if (targetPosition != null) {
            this.setTargetPosition(class_2338.method_49638((class_2374)targetPosition));
        } else {
            this.setTargetPosition(class_2338.field_10980);
        }
    }

    public static enum BombardState {
        PACKED,
        ASSEMBLED,
        PACKING,
        ASSEMBLING;

    }
}

