/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.siege;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1603;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2675;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import ydmsama.hundred_years_war.main.entity.action.Action;
import ydmsama.hundred_years_war.main.entity.action.PositionAttackAction;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.projectile.RocketEntity;
import ydmsama.hundred_years_war.main.entity.entities.siege.PositionAttackable;
import ydmsama.hundred_years_war.main.entity.entities.tags.SiegeUnit;
import ydmsama.hundred_years_war.main.entity.goals.BaseCombatEntityAttackGoal;
import ydmsama.hundred_years_war.main.entity.goals.FollowEntityGoal;
import ydmsama.hundred_years_war.main.entity.goals.PatrolGoal;
import ydmsama.hundred_years_war.main.entity.goals.ReturnToHomeGoal;
import ydmsama.hundred_years_war.main.entity.goals.SkyExposedTargetGoal;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywEntityRegistry;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;
import ydmsama.hundred_years_war.main.utils.RocketTrajectoryCalculator;

public class NestOfBeesEntity
extends BaseCombatEntity
implements class_1603,
SiegeUnit,
PositionAttackable {
    private static final float ATTACK_REACH = 100.0f;
    private static final float MOVEMENT_SPEED = 0.15f;
    private static final float BASE_RANGED_ATTACK_DAMAGE = 25.0f;
    private static final class_2940<class_2338> TARGET_POS = class_2945.method_12791(NestOfBeesEntity.class, (class_2941)class_2943.field_13324);
    private static final class_2940<Boolean> HAS_POSITION_TARGET = class_2945.method_12791(NestOfBeesEntity.class, (class_2941)class_2943.field_13323);
    private static final int ROCKET_COUNT = 36;
    private static final int FIRE_DELAY_TICKS = 5;
    private static final float TUBE_LATERAL_SPACING = 0.18f;
    private static final float TUBE_VERTICAL_SPACING = -0.05f;
    private static final float TUBE_HEIGHT_SPACING = 0.15f;
    private static final float MATRIX_FORWARD_OFFSET = 1.2f;
    private static final float MATRIX_HEIGHT_OFFSET = 1.8f;
    private static final float PREDICTION_INTENSITY = 3.0f;
    private int currentRocketIndex = 0;
    private int fireDelay = 0;
    private boolean inFiringSequence = false;
    private class_1309 currentTarget = null;
    private class_243 lastTargetPos = null;
    private int attackCooldown = 0;
    private class_243 positionTarget;
    private PositionAttackAction positionAttackAction;
    private static final RocketTubePosition[] ROCKET_POSITIONS = NestOfBeesEntity.createRocketPositions();

    public NestOfBeesEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.method_49477(1.0f);
        this.field_6011.method_12784(TARGET_POS, (Object)class_2338.field_10980);
        this.field_6011.method_12784(HAS_POSITION_TARGET, (Object)false);
        this.positionAttackAction = new PositionAttackAction();
        this.positionTarget = null;
    }

    public static class_5132.class_5133 createNestOfBeesAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23717, 100.0).method_26868(class_5134.field_23719, (double)0.15f).method_26868(class_5134.field_23721, 8.0).method_26868(class_5134.field_23724, 20.0).method_26868(class_5134.field_23716, 80.0).method_26868(class_5134.field_23718, 1.0).method_26868(HywAttributes.ATTACK_REACH, 100.0).method_26868(HywAttributes.RANGED_ATTACK_DAMAGE, 25.0);
    }

    @Override
    public List<Action> getActions() {
        ArrayList<Action> actions = new ArrayList<Action>(super.getActions());
        actions.add(this.positionAttackAction);
        return actions;
    }

    private static RocketTubePosition[] createRocketPositions() {
        RocketTubePosition[] positions = new RocketTubePosition[36];
        int index = 0;
        for (int row = 0; row < 6; ++row) {
            for (int col = 0; col < 6; ++col) {
                float lateralOffset = row <= 3 ? ((float)col - 2.5f) * 0.18f * 1.8f : ((float)col - 2.5f) * 0.18f;
                float longitudinalOffset = ((float)row - 2.5f) * -0.05f;
                float verticalOffset = row <= 3 ? ((float)row - 2.5f) * 0.15f * 0.8f : ((float)row - 2.5f) * 0.15f * 1.5f;
                positions[index] = new RocketTubePosition(lateralOffset, longitudinalOffset, verticalOffset);
                ++index;
            }
        }
        return positions;
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            if (this.attackCooldown > 0) {
                --this.attackCooldown;
            }
            if (this.hasPositionTarget() && this.getPositionTarget() != null) {
                class_2338 targetBlockPos = new class_2338((int)this.getPositionTarget().field_1352, (int)this.getPositionTarget().field_1351, (int)this.getPositionTarget().field_1350);
                this.setTargetPosition(targetBlockPos);
            } else if (this.getHywTarget() != null) {
                this.setTargetPosition(this.getHywTarget().method_24515());
            } else {
                this.setTargetPosition(class_2338.field_10980);
            }
            if (this.inFiringSequence && this.fireDelay > 0) {
                --this.fireDelay;
                if (this.fireDelay == 0 && this.currentRocketIndex < 36) {
                    this.fireSingleRocket(this.currentRocketIndex);
                    ++this.currentRocketIndex;
                    if (this.currentRocketIndex < 36) {
                        this.fireDelay = 5;
                    } else {
                        this.finishFiringSequence();
                    }
                }
            }
        }
    }

    public void method_7105(class_1309 target, float pullProgress) {
        this.PerformRangedAttackBoth(null, target);
    }

    @Override
    public void performPositionAttack(class_243 targetPosition, float pullProgress) {
        this.PerformRangedAttackBoth(targetPosition, null);
    }

    @Override
    public void PerformRangedAttackBoth(class_243 targetPosition, class_1309 target) {
        if (this.attackCooldown > 0 || this.inFiringSequence) {
            return;
        }
        if (target != null && !this.canFireAtTarget(target)) {
            return;
        }
        if (targetPosition != null && !this.canFireAtPosition(targetPosition)) {
            return;
        }
        if (target != null) {
            this.startFiringSequence(target);
        } else if (targetPosition != null) {
            this.startFiringSequenceAtPosition(targetPosition);
        }
    }

    private void startFiringSequence(class_1309 target) {
        this.currentTarget = target;
        this.lastTargetPos = target.method_19538();
        this.currentRocketIndex = 0;
        this.inFiringSequence = true;
        this.fireSingleRocket(this.currentRocketIndex);
        ++this.currentRocketIndex;
        this.fireDelay = 5;
        this.method_5783(class_3417.field_14702, 3.5f, 0.8f);
    }

    private void startFiringSequenceAtPosition(class_243 targetPosition) {
        this.currentTarget = null;
        this.lastTargetPos = targetPosition;
        this.currentRocketIndex = 0;
        this.inFiringSequence = true;
        this.fireSingleRocket(this.currentRocketIndex);
        ++this.currentRocketIndex;
        this.fireDelay = 5;
        this.method_5783(class_3417.field_14702, 3.5f, 0.8f);
    }

    private void fireSingleRocket(int rocketIndex) {
        RocketTubePosition tubePos = ROCKET_POSITIONS[rocketIndex];
        class_243 launchPosition = this.calculateLaunchPosition(tubePos);
        RocketEntity rocket = new RocketEntity(HywEntityRegistry.ROCKET, (class_1309)this, this.method_37908());
        rocket.method_5814(launchPosition.field_1352, launchPosition.field_1351, launchPosition.field_1350);
        class_243 targetPosition = this.determineTargetPosition();
        RocketTrajectoryCalculator.TrajectoryResult trajectoryResult = RocketTrajectoryCalculator.calculateForRocketLauncher(launchPosition, targetPosition, true);
        if (trajectoryResult.success) {
            launchVector = trajectoryResult.launchVector;
            rocket.setRocketParamsFromCalculator((float)launchVector.field_1352, (float)launchVector.field_1351, (float)launchVector.field_1350, trajectoryResult.velocity);
        } else {
            launchVector = this.calculateFallbackLaunchVector(launchPosition, targetPosition);
            rocket.setRocketParams((float)launchVector.field_1352, (float)launchVector.field_1351, (float)launchVector.field_1350);
        }
        rocket.method_7438(this.method_26825(HywAttributes.RANGED_ATTACK_DAMAGE));
        this.method_37908().method_8649((class_1297)rocket);
        float randomPitch = 1.0f + (float)NestOfBeesEntity.getRandomInRange(-0.2, 0.2);
        this.method_5783(class_3417.field_14702, 2.5f, randomPitch);
    }

    private class_243 calculateLaunchPosition(RocketTubePosition tubePos) {
        float yBodyRot = this.getTrueYBodyRot() + 90.0f;
        float yBodyRotRad = (float)Math.toRadians(yBodyRot);
        double forwardX = Math.cos(yBodyRotRad);
        double forwardZ = Math.sin(yBodyRotRad);
        double rightX = Math.cos((double)yBodyRotRad + 1.5707963267948966);
        double rightZ = Math.sin((double)yBodyRotRad + 1.5707963267948966);
        double totalForwardOffset = 1.2f + tubePos.longitudinalOffset;
        double offsetX = forwardX * totalForwardOffset + rightX * (double)tubePos.lateralOffset;
        double offsetZ = forwardZ * totalForwardOffset + rightZ * (double)tubePos.lateralOffset;
        double offsetY = 1.8f + tubePos.verticalOffset;
        return new class_243(this.method_23317() + offsetX, this.method_23318() + offsetY, this.method_23321() + offsetZ);
    }

    private class_243 determineTargetPosition() {
        class_243 defaultPos;
        if (this.hasPositionTarget() && this.getPositionTarget() != null) {
            class_243 posTarget;
            this.lastTargetPos = posTarget = this.getPositionTarget();
            return posTarget;
        }
        class_1309 dynamicTarget = this.getHywTarget();
        if (dynamicTarget != null && dynamicTarget.method_5805()) {
            class_243 predictedPos;
            this.lastTargetPos = predictedPos = this.calculateTargetPrediction(dynamicTarget);
            return predictedPos;
        }
        if (this.lastTargetPos != null) {
            return this.lastTargetPos;
        }
        float yaw = this.getTrueYBodyRot() + 90.0f;
        float yawRad = (float)Math.toRadians(yaw);
        this.lastTargetPos = defaultPos = new class_243(this.method_23317() + Math.cos(yawRad) * 50.0, this.method_23318() + 2.0, this.method_23321() + Math.sin(yawRad) * 50.0);
        return defaultPos;
    }

    private class_243 calculateTargetPrediction(class_1309 target) {
        class_243 baseTargetPos = target.method_19538().method_1031(0.0, (double)target.method_17682() * 0.5, 0.0);
        class_243 sampleLaunchPos = this.calculateLaunchPosition(ROCKET_POSITIONS[0]);
        double dx = baseTargetPos.field_1352 - sampleLaunchPos.field_1352;
        double dy = baseTargetPos.field_1351 - sampleLaunchPos.field_1351;
        double dz = baseTargetPos.field_1350 - sampleLaunchPos.field_1350;
        double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
        if (horizontalDistance == 0.0) {
            return baseTargetPos;
        }
        double timeToTarget = this.calculateRocketFlightTime(sampleLaunchPos, baseTargetPos);
        double targetVelocityX = target.method_18798().method_10216();
        double targetVelocityZ = target.method_18798().method_10215();
        double targetSpeedPerSecond = Math.sqrt(targetVelocityX * targetVelocityX + targetVelocityZ * targetVelocityZ) * 20.0;
        double predictedX = target.method_23317() + targetVelocityX * 20.0 * timeToTarget * 3.0;
        double predictedZ = target.method_23321() + targetVelocityZ * 20.0 * timeToTarget * 3.0;
        double baseSpread = 2.0;
        double distanceSpread = horizontalDistance * 0.02;
        double speedSpread = targetSpeedPerSecond * 0.5;
        double totalSpread = baseSpread + distanceSpread + speedSpread;
        double randomTargetOffsetX = NestOfBeesEntity.getRandomInRange(-totalSpread, totalSpread);
        double randomTargetOffsetZ = NestOfBeesEntity.getRandomInRange(-totalSpread, totalSpread);
        double randomTargetOffsetY = NestOfBeesEntity.getRandomInRange(-1.0, 1.0);
        class_243 finalPredictedPos = new class_243(predictedX + randomTargetOffsetX, baseTargetPos.field_1351 + randomTargetOffsetY, predictedZ + randomTargetOffsetZ);
        return finalPredictedPos;
    }

    private double calculateRocketFlightTime(class_243 launchPos, class_243 targetPos) {
        RocketTrajectoryCalculator.TrajectoryResult result = RocketTrajectoryCalculator.calculateForRocketLauncher(launchPos, targetPos, false);
        if (!result.success) {
            double distance = launchPos.method_1022(targetPos);
            return Math.max(1.0, distance * 0.15);
        }
        class_243 launchVector = result.launchVector;
        float velocity = result.velocity;
        float motionX = (float)launchVector.field_1352 * 0.05f;
        float motionY = (float)launchVector.field_1351 * 0.05f;
        float motionZ = (float)launchVector.field_1350 * 0.05f;
        float motionMagnitude = class_3532.method_15355((float)(motionX * motionX + motionY * motionY + motionZ * motionZ));
        float BURN_TIME_FACTOR = 3.0f;
        int rocketBurnTime = (int)(motionMagnitude * 20.0f * 3.0f);
        double burnTimeSeconds = (double)rocketBurnTime / 20.0;
        double dx = targetPos.field_1352 - launchPos.field_1352;
        double dy = targetPos.field_1351 - launchPos.field_1351;
        double dz = targetPos.field_1350 - launchPos.field_1350;
        double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
        float ACCELERATION_FACTOR = 0.01f;
        double finalBurnVelocity = motionMagnitude + 0.01f * (float)rocketBurnTime;
        double burnPhaseDistance = (double)(motionMagnitude * (float)rocketBurnTime) + (double)0.005f * (double)rocketBurnTime * (double)rocketBurnTime;
        double remainingDistance = Math.max(0.0, horizontalDistance - burnPhaseDistance);
        double gravityPhaseTime = remainingDistance / Math.max(0.1, finalBurnVelocity * 20.0);
        double totalFlightTime = burnTimeSeconds + gravityPhaseTime;
        double randomVariation = NestOfBeesEntity.getRandomInRange(0.8, 1.2);
        return Math.max(0.5, totalFlightTime * randomVariation);
    }

    private class_243 calculateFallbackLaunchVector(class_243 launchPos, class_243 targetPos) {
        double dx = targetPos.field_1352 - launchPos.field_1352;
        double dy = targetPos.field_1351 - launchPos.field_1351;
        double dz = targetPos.field_1350 - launchPos.field_1350;
        float baseAngle = RocketTrajectoryCalculator.calculateOptimalLaunchAngle(launchPos, targetPos);
        float baseVelocity = 35.0f;
        float accuracy = 0.25f;
        float spreadFactor = (1.0f - accuracy) * 25.0f;
        float yawSpread = (float)NestOfBeesEntity.getRandomInRange(-spreadFactor, spreadFactor);
        float pitchSpread = (float)NestOfBeesEntity.getRandomInRange(-spreadFactor * 0.3f, spreadFactor * 0.3f);
        float velocitySpread = (float)NestOfBeesEntity.getRandomInRange(-3.0, 3.0);
        float adjustedAngle = Math.max(20.0f, Math.min(70.0f, baseAngle + pitchSpread));
        float adjustedVelocity = Math.max(5.0f, baseVelocity + velocitySpread);
        float yaw = (float)Math.toDegrees(Math.atan2(-dx, dz)) + yawSpread;
        double yawRad = Math.toRadians(yaw);
        double pitchRad = Math.toRadians(adjustedAngle);
        double horizontalComponent = (double)adjustedVelocity * Math.cos(pitchRad);
        double verticalComponent = (double)adjustedVelocity * Math.sin(pitchRad);
        return new class_243(horizontalComponent * Math.sin(yawRad), verticalComponent, horizontalComponent * Math.cos(yawRad));
    }

    private void finishFiringSequence() {
        this.inFiringSequence = false;
        this.currentRocketIndex = 0;
        this.fireDelay = 0;
        this.currentTarget = null;
        this.attackCooldown = this.getAttackCoolDownDuration();
        this.method_6021();
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 30;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 10;
    }

    @Override
    public int getAttackCoolDownDuration() {
        Random random = new Random();
        return 20 + random.nextInt(20);
    }

    @Override
    public float getRotationLimit() {
        return 2.0f;
    }

    @Override
    protected void increaseStatsOnLevelUp() {
    }

    public void debugShowAngleSelection(class_1309 target) {
        if (target != null && !this.method_37908().field_9236) {
            class_243 launchPos = this.calculateLaunchPosition(ROCKET_POSITIONS[0]);
            class_243 targetPos = target.method_19538().method_1031(0.0, (double)target.method_17682() * 0.5, 0.0);
            float optimalAngle = RocketTrajectoryCalculator.calculateOptimalLaunchAngle(launchPos, targetPos);
            double heightDiff = targetPos.field_1351 - launchPos.field_1351;
            double horizontalDistance = Math.sqrt(Math.pow(targetPos.field_1352 - launchPos.field_1352, 2.0) + Math.pow(targetPos.field_1350 - launchPos.field_1350, 2.0));
            float heightRatio = (float)(heightDiff / Math.max(horizontalDistance, 1.0));
            System.out.printf("=== \u667a\u80fd\u89d2\u5ea6\u9009\u62e9\u8c03\u8bd5\u4fe1\u606f ===%n", new Object[0]);
            System.out.printf("\u76ee\u6807: %s%n", target.method_5477().getString());
            System.out.printf("\u9ad8\u5ea6\u5dee: %.1f \u65b9\u5757%n", heightDiff);
            System.out.printf("\u6c34\u5e73\u8ddd\u79bb: %.1f \u65b9\u5757%n", horizontalDistance);
            System.out.printf("\u9ad8\u5ea6\u6bd4\u7387: %.3f%n", Float.valueOf(heightRatio));
            System.out.printf("\u9009\u62e9\u89d2\u5ea6: %.1f\u00b0%n", Float.valueOf(optimalAngle));
            String strategy = "";
            strategy = heightRatio > 0.5f ? "\u9ad8\u89d2\u5ea6\u5c04\u51fb\uff08\u653b\u51fb\u9ad8\u76ee\u6807\uff09" : (heightRatio > 0.2f ? "\u4e2d\u7b49\u504f\u9ad8\u89d2\u5ea6" : (heightRatio > -0.2f ? "AW2\u6807\u51c6\u89d2\u5ea6" : (heightRatio > -0.5f ? "\u4e2d\u7b49\u504f\u4f4e\u89d2\u5ea6" : "\u4f4e\u89d2\u5ea6\u5c04\u51fb\uff08\u653b\u51fb\u4f4e\u76ee\u6807\uff09")));
            System.out.printf("\u7b56\u7565: %s%n", strategy);
            System.out.printf("============================%n", new Object[0]);
        }
    }

    @Override
    public double getDesiredDistance() {
        return 2.5;
    }

    @Override
    public boolean canFireAtTarget(class_1309 target) {
        class_243 targetPosition = new class_243(target.method_23317(), target.method_23318(), target.method_23321());
        return this.canFireAtPosition(targetPosition);
    }

    @Override
    public boolean canFireAtPosition(class_243 targetPosition) {
        if (targetPosition == null) {
            return false;
        }
        float allowedRotationDifference = 20.0f;
        double dx = targetPosition.field_1352 - this.method_23317();
        double dz = targetPosition.field_1350 - this.method_23321();
        float actualTargetRot = (float)(class_3532.method_15349((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
        float actualRotDifference = class_3532.method_15393((float)(actualTargetRot - this.currentRot));
        float rotationDifference = class_3532.method_15393((float)(this.targetRot - this.currentRot));
        return Math.abs(rotationDifference) <= allowedRotationDifference && Math.abs(actualRotDifference) <= allowedRotationDifference;
    }

    @Override
    public boolean isValidTarget(class_1309 potentialTarget) {
        double minimumAttackDistance = 20.0;
        double distanceToTarget = this.method_5649(potentialTarget.method_23317(), potentialTarget.method_23318(), potentialTarget.method_23321());
        if (distanceToTarget < minimumAttackDistance * minimumAttackDistance) {
            return false;
        }
        return super.isValidTarget(potentialTarget);
    }

    public void setTargetPosition(class_2338 pos) {
        this.field_6011.method_12778(TARGET_POS, (Object)pos);
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("AttackCooldown", this.attackCooldown);
        compound.method_10556("InFiringSequence", this.inFiringSequence);
        compound.method_10569("CurrentRocketIndex", this.currentRocketIndex);
        compound.method_10569("FireDelay", this.fireDelay);
        if (this.lastTargetPos != null) {
            compound.method_10549("LastTargetPosX", this.lastTargetPos.field_1352);
            compound.method_10549("LastTargetPosY", this.lastTargetPos.field_1351);
            compound.method_10549("LastTargetPosZ", this.lastTargetPos.field_1350);
        }
        if (this.currentTarget != null) {
            compound.method_25927("CurrentTargetUUID", this.currentTarget.method_5667());
        }
        compound.method_10556("HasPositionTarget", this.hasPositionTarget());
        if (this.hasPositionTarget() && this.positionTarget != null) {
            compound.method_10549("PositionTargetX", this.positionTarget.field_1352);
            compound.method_10549("PositionTargetY", this.positionTarget.field_1351);
            compound.method_10549("PositionTargetZ", this.positionTarget.field_1350);
        }
    }

    @Override
    public void method_5749(class_2487 compound) {
        double z;
        double y;
        double x;
        super.method_5749(compound);
        this.attackCooldown = compound.method_10550("AttackCooldown");
        this.inFiringSequence = compound.method_10577("InFiringSequence");
        this.currentRocketIndex = compound.method_10550("CurrentRocketIndex");
        this.fireDelay = compound.method_10550("FireDelay");
        if (compound.method_10545("LastTargetPosX")) {
            x = compound.method_10574("LastTargetPosX");
            y = compound.method_10574("LastTargetPosY");
            z = compound.method_10574("LastTargetPosZ");
            this.lastTargetPos = new class_243(x, y, z);
        }
        if (compound.method_10545("CurrentTargetUUID")) {
            UUID targetUUID = compound.method_25926("CurrentTargetUUID");
            if (!this.method_37908().field_9236) {
                this.method_37908().method_8503().execute(() -> {
                    class_1297 entity = ((class_3218)this.method_37908()).method_14190(targetUUID);
                    if (entity instanceof class_1309) {
                        this.currentTarget = (class_1309)entity;
                    }
                });
            }
        }
        if (compound.method_10545("HasPositionTarget") && compound.method_10577("HasPositionTarget")) {
            x = compound.method_10574("PositionTargetX");
            y = compound.method_10574("PositionTargetY");
            z = compound.method_10574("PositionTargetZ");
            this.setPositionTarget(new class_243(x, y, z));
        } else {
            this.setPositionTarget(null);
        }
        if (this.inFiringSequence && (this.currentRocketIndex >= 36 || this.fireDelay < 0)) {
            this.finishFiringSequence();
        }
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new FollowEntityGoal(this, 1.0, 5.0, 30.0, 40.0, 80.0));
        this.field_6201.method_6277(2, (class_1352)new BaseCombatEntityAttackGoal(this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new PatrolGoal(this, 1.0, 40));
        this.field_6201.method_6277(3, (class_1352)new FollowEntityGoal(this, 1.0, 5.0, 5.0, Double.MAX_VALUE, 0.0));
        this.field_6201.method_6277(4, (class_1352)new ReturnToHomeGoal(this, 1.0));
        this.addTargetSelector();
    }

    @Override
    public void addTargetSelector() {
        Predicate<class_1309> unifiedPredicate = this::isValidTarget;
        this.field_6185.method_6277(1, (class_1352)new SkyExposedTargetGoal(this, class_1309.class, 10, true, false, unifiedPredicate));
    }

    @Override
    public class_1792 getScrollType() {
        return HywItemRegistry.NEST_OF_BEES;
    }

    @Override
    public double getArrivalThreshold() {
        return 3.0;
    }

    public static double getRandomInRange(double min, double max) {
        return min + Math.random() * (max - min);
    }

    public <T extends class_2394> int sendParticlesToAllNearby(class_3218 serverLevel, T particleOptions, double x, double y, double z, int count, double xOffset, double yOffset, double zOffset, double speed) {
        class_2675 packet = new class_2675(particleOptions, true, x, y, z, (float)xOffset, (float)yOffset, (float)zOffset, (float)speed, count);
        int sentCount = 0;
        for (class_3222 serverPlayer : serverLevel.method_18456()) {
            if (!this.sendParticlesToPlayer(serverLevel, serverPlayer, x, y, z, (class_2596<?>)packet)) continue;
            ++sentCount;
        }
        return sentCount;
    }

    private boolean sendParticlesToPlayer(class_3218 serverLevel, class_3222 serverPlayer, double x, double y, double z, class_2596<?> packet) {
        if (serverPlayer.method_37908() != serverLevel) {
            return false;
        }
        double distanceSquared = serverPlayer.method_19538().method_1025(new class_243(x, y, z));
        if (distanceSquared < 262144.0) {
            serverPlayer.field_13987.method_14364(packet);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasPositionTarget() {
        return (Boolean)this.field_6011.method_12789(HAS_POSITION_TARGET);
    }

    @Override
    public class_243 getPositionTarget() {
        return this.positionTarget;
    }

    @Override
    public void setPositionTarget(class_243 targetPosition) {
        this.positionTarget = targetPosition;
        this.field_6011.method_12778(HAS_POSITION_TARGET, (Object)(targetPosition != null ? 1 : 0));
        if (targetPosition != null) {
            this.setTargetPosition(class_2338.method_49638((class_2374)targetPosition));
        } else {
            this.setTargetPosition(class_2338.field_10980);
        }
    }

    private static class RocketTubePosition {
        public final float lateralOffset;
        public final float longitudinalOffset;
        public final float verticalOffset;

        public RocketTubePosition(float lateralOffset, float longitudinalOffset, float verticalOffset) {
            this.lateralOffset = lateralOffset;
            this.longitudinalOffset = longitudinalOffset;
            this.verticalOffset = verticalOffset;
        }
    }
}

