/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.siege;

import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1603;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2675;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.projectile.BulletEntity;
import ydmsama.hundred_years_war.main.entity.entities.tags.SiegeUnit;
import ydmsama.hundred_years_war.main.entity.goals.BaseCombatEntityAttackGoal;
import ydmsama.hundred_years_war.main.entity.goals.FollowEntityGoal;
import ydmsama.hundred_years_war.main.entity.goals.PatrolGoal;
import ydmsama.hundred_years_war.main.entity.goals.ReturnToHomeGoal;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywEntityRegistry;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class RibauldequinEntity
extends BaseCombatEntity
implements class_1603,
SiegeUnit {
    private static final float ATTACK_REACH = 64.0f;
    private static final float MOVEMENT_SPEED = 0.22f;
    private static final float BASE_RANGED_ATTACK_DAMAGE = 15.0f;
    private float leftWheelRotation;
    private float rightWheelRotation;
    private static final class_2940<class_2338> TARGET_POS = class_2945.method_12791(RibauldequinEntity.class, (class_2941)class_2943.field_13324);
    private int currentBarrelIndex = 0;
    private int shotDelay = 0;
    private class_1309 currentTarget = null;
    private class_243 lastTargetPos = null;
    private static final int BARREL_COUNT = 5;
    private static final int SHOT_DELAY_TICKS = 3;
    private static final float[] BARREL_ANGLE_OFFSETS = new float[]{-12.5f, -7.5f, 0.0f, 7.5f, 12.5f};
    private boolean inFiringSequence = false;
    private int attackCooldown = 0;

    public RibauldequinEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.method_49477(1.0f);
        this.field_6011.method_12784(TARGET_POS, (Object)class_2338.field_10980);
    }

    public static class_5132.class_5133 createRibauldequinAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23717, 64.0).method_26868(class_5134.field_23719, (double)0.22f).method_26868(class_5134.field_23721, 12.0).method_26868(class_5134.field_23724, 15.0).method_26868(class_5134.field_23716, 60.0).method_26868(class_5134.field_23718, 1.0).method_26868(HywAttributes.ATTACK_REACH, 64.0).method_26868(HywAttributes.RANGED_ATTACK_DAMAGE, 15.0);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            if (this.attackCooldown > 0) {
                --this.attackCooldown;
            }
            if (this.getHywTarget() != null) {
                this.setTargetPosition(this.getHywTarget().method_24515());
            } else {
                this.setTargetPosition(class_2338.field_10980);
            }
            if (this.inFiringSequence && this.shotDelay > 0) {
                --this.shotDelay;
                if (this.shotDelay == 0 && this.currentBarrelIndex < 5) {
                    this.fireSingleBarrel(this.currentBarrelIndex);
                    ++this.currentBarrelIndex;
                    if (this.currentBarrelIndex < 5) {
                        this.shotDelay = 3;
                    } else {
                        this.inFiringSequence = false;
                        this.resetFiringSequence();
                        this.attackCooldown = this.getAttackCoolDownDuration();
                    }
                }
            }
        }
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 15;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 5;
    }

    @Override
    public int getAttackCoolDownDuration() {
        Random random = new Random();
        return 120 + random.nextInt(30);
    }

    @Override
    public float getRotationLimit() {
        return 2.5f;
    }

    @Override
    protected void increaseStatsOnLevelUp() {
    }

    @Override
    public double getDesiredDistance() {
        return 2.5;
    }

    public void method_7105(class_1309 target, float pullProgress) {
        if (this.attackCooldown > 0 || this.inFiringSequence) {
            return;
        }
        if (!this.canFireAtTarget(target)) {
            return;
        }
        this.currentTarget = target;
        this.lastTargetPos = target.method_19538();
        this.currentBarrelIndex = 0;
        this.inFiringSequence = true;
        this.fireSingleBarrel(this.currentBarrelIndex);
        ++this.currentBarrelIndex;
        this.shotDelay = 3;
    }

    private void fireSingleBarrel(int barrelIndex) {
        class_243 targetPosition;
        BarrelPosition barrelPosition = this.calculateBarrelPosition(barrelIndex);
        BulletEntity bullet = new BulletEntity(HywEntityRegistry.BULLET, (class_1309)this, this.method_37908());
        bullet.method_7438(this.method_26825(HywAttributes.RANGED_ATTACK_DAMAGE));
        bullet.method_7451((byte)1);
        bullet.method_5814(barrelPosition.position.field_1352, barrelPosition.position.field_1351, barrelPosition.position.field_1350);
        if (this.currentTarget != null && this.currentTarget.method_5805()) {
            this.lastTargetPos = targetPosition = this.currentTarget.method_19538();
        } else if (this.lastTargetPos != null) {
            targetPosition = this.lastTargetPos;
        } else {
            float yaw = this.getTrueYBodyRot() + 90.0f;
            float yawRad = (float)Math.toRadians(yaw);
            targetPosition = new class_243(this.method_23317() + Math.cos(yawRad) * 30.0, this.method_23318() + 1.0, this.method_23321() + Math.sin(yawRad) * 30.0);
        }
        double dx = targetPosition.field_1352 - bullet.method_23317();
        double dz = targetPosition.field_1350 - bullet.method_23321();
        double dy = targetPosition.field_1351 + 0.5 - bullet.method_23318();
        double distance = Math.sqrt(dx * dx + dz * dz + dy * dy);
        if (distance == 0.0) {
            return;
        }
        float speed = 5.0f;
        double gravity = 0.05;
        double angle = Double.NaN;
        float miss = 1.0f;
        double[] angles = this.calculateLaunchAngles(speed, gravity, distance, dy);
        angle = angles[1];
        if (Double.isNaN(angle)) {
            return;
        }
        double randomSpeedOffset = RibauldequinEntity.getRandomInRange(-0.25, 0.75);
        double timeToTarget = distance / (((double)speed - randomSpeedOffset) * Math.cos(angle));
        double targetVelocityX = 0.0;
        double targetVelocityZ = 0.0;
        if (this.currentTarget != null && this.currentTarget.method_5805()) {
            targetVelocityX = this.currentTarget.method_18798().method_10216();
            targetVelocityZ = this.currentTarget.method_18798().method_10215();
        }
        double predictedX = targetPosition.field_1352 + targetVelocityX * timeToTarget;
        double predictedZ = targetPosition.field_1350 + targetVelocityZ * timeToTarget;
        double predictedDistance = Math.sqrt((predictedX - bullet.method_23317()) * (predictedX - bullet.method_23317()) + (predictedZ - bullet.method_23321()) * (predictedZ - bullet.method_23321()));
        angles = this.calculateLaunchAngles(speed, gravity, predictedDistance, dy);
        if (Double.isNaN(angles[0]) && Double.isNaN(angles[1])) {
            return;
        }
        angle = angles[1];
        dx = predictedX - bullet.method_23317();
        double horizontalDistance = Math.sqrt(dx * dx + (dz = predictedZ - bullet.method_23321()) * dz);
        if (horizontalDistance == 0.0) {
            return;
        }
        double horizontalSpeed = (double)speed * Math.cos(angle);
        double verticalSpeed = (double)speed * Math.sin(angle);
        float angleOffset = BARREL_ANGLE_OFFSETS[barrelIndex];
        float angleOffsetRad = (float)Math.toRadians(angleOffset);
        float velocityX = (float)(dx / horizontalDistance * horizontalSpeed);
        float velocityZ = (float)(dz / horizontalDistance * horizontalSpeed);
        float originalDir = (float)class_3532.method_15349((double)velocityZ, (double)velocityX);
        float newDir = originalDir + angleOffsetRad;
        float newVelocityX = (float)(Math.cos(newDir) * horizontalSpeed);
        float newVelocityZ = (float)(Math.sin(newDir) * horizontalSpeed);
        bullet.method_7485(newVelocityX, (float)verticalSpeed, newVelocityZ, speed, miss);
        float randomPitch = 1.4f + (float)RibauldequinEntity.getRandomInRange(0.0, 0.4);
        this.method_5783(class_3417.field_15152, 5.0f, randomPitch);
        this.method_37908().method_8649((class_1297)bullet);
        this.spawnParticles(this.method_37908(), bullet.method_23317(), bullet.method_23318(), bullet.method_23321());
    }

    private BarrelPosition calculateBarrelPosition(int barrelIndex) {
        float yBodyRot = this.getTrueYBodyRot() + 90.0f;
        float yBodyRotRad = (float)Math.toRadians(yBodyRot);
        double forwardX = Math.cos(yBodyRotRad);
        double forwardZ = Math.sin(yBodyRotRad);
        double rightX = Math.cos((double)yBodyRotRad + 1.5707963267948966);
        double rightZ = Math.sin((double)yBodyRotRad + 1.5707963267948966);
        double lateralOffset = 0.0;
        double longitudinalOffset = 0.0;
        switch (barrelIndex) {
            case 0: {
                lateralOffset = -1.0;
                longitudinalOffset = -0.2;
                break;
            }
            case 1: {
                lateralOffset = -0.5;
                longitudinalOffset = -0.1;
                break;
            }
            case 2: {
                lateralOffset = 0.0;
                longitudinalOffset = 0.0;
                break;
            }
            case 3: {
                lateralOffset = 0.5;
                longitudinalOffset = -0.1;
                break;
            }
            case 4: {
                lateralOffset = 1.0;
                longitudinalOffset = -0.2;
            }
        }
        double offsetX = forwardX * (2.0 + longitudinalOffset) + rightX * lateralOffset;
        double offsetZ = forwardZ * (2.0 + longitudinalOffset) + rightZ * lateralOffset;
        class_243 position = new class_243(this.method_23317() + offsetX, this.method_23318() + 1.1, this.method_23321() + offsetZ);
        return new BarrelPosition(position, BARREL_ANGLE_OFFSETS[barrelIndex]);
    }

    private void resetFiringSequence() {
        this.currentBarrelIndex = 0;
        this.shotDelay = 0;
        this.currentTarget = null;
        this.method_6021();
    }

    @Override
    public boolean canFireAtTarget(class_1309 target) {
        if (target == null) {
            return true;
        }
        if (this.isObstructed(target)) {
            return false;
        }
        float allowedRotationDifference = 15.0f;
        double dx = target.method_23317() - this.method_23317();
        double dz = target.method_23321() - this.method_23321();
        float actualTargetRot = (float)(class_3532.method_15349((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
        float actualRotDifference = class_3532.method_15393((float)(actualTargetRot - this.currentRot));
        float rotationDifference = class_3532.method_15393((float)(this.targetRot - this.currentRot));
        return Math.abs(rotationDifference) <= allowedRotationDifference && Math.abs(actualRotDifference) <= allowedRotationDifference;
    }

    private boolean isPathClear(class_1665 arrow, double angle, float speed, double dx, double dy, double dz, double distance, class_1309 target) {
        class_243 startPos = this.method_33571();
        class_243 direction = new class_243(dx / distance, Math.tan(angle), dz / distance).method_1029();
        class_243 endPos = startPos.method_1019(direction.method_1021(5.0));
        class_3965 hitResult = this.method_37908().method_17742(new class_3959(startPos, endPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)arrow));
        return hitResult.method_17783() == class_239.class_240.field_1333;
    }

    private double[] calculateLaunchAngles(double speed, double gravity, double distance, double heightDifference) {
        double discriminant = speed * speed * speed * speed - gravity * (gravity * distance * distance + 2.0 * heightDifference * speed * speed);
        if (discriminant < 0.0) {
            return new double[]{Double.NaN, Double.NaN};
        }
        double angle1 = Math.atan2(speed * speed + Math.sqrt(discriminant), gravity * distance);
        double angle2 = Math.atan2(speed * speed - Math.sqrt(discriminant), gravity * distance);
        return new double[]{angle1, angle2};
    }

    public static double getRandomInRange(double min, double max) {
        return min + Math.random() * (max - min);
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new FollowEntityGoal(this, 1.0, 5.0, 20.0, 25.0, 50.0));
        this.field_6201.method_6277(2, (class_1352)new BaseCombatEntityAttackGoal(this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new PatrolGoal(this, 1.0, 40));
        this.field_6201.method_6277(3, (class_1352)new FollowEntityGoal(this, 1.0, 5.0, 5.0, Double.MAX_VALUE, 0.0));
        this.field_6201.method_6277(4, (class_1352)new ReturnToHomeGoal(this, 1.0));
        super.addTargetSelector();
    }

    @Override
    public boolean isValidTarget(class_1309 potentialTarget) {
        if (this.isObstructed(potentialTarget)) {
            return false;
        }
        double minimumAttackDistance = 5.0;
        double allowedVerticalDistance = 30.0;
        double distanceToTarget = this.method_5649(potentialTarget.method_23317(), potentialTarget.method_23318(), potentialTarget.method_23321());
        if (distanceToTarget < minimumAttackDistance * minimumAttackDistance) {
            return false;
        }
        double verticalDistance = Math.abs(potentialTarget.method_23318() - this.method_23318());
        if (verticalDistance > allowedVerticalDistance) {
            return false;
        }
        return super.isValidTarget(potentialTarget);
    }

    public void setTargetPosition(class_2338 pos) {
        this.field_6011.method_12778(TARGET_POS, (Object)pos);
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("AttackCooldown", this.attackCooldown);
        compound.method_10556("InFiringSequence", this.inFiringSequence);
        if (this.lastTargetPos != null) {
            compound.method_10549("LastTargetPosX", this.lastTargetPos.field_1352);
            compound.method_10549("LastTargetPosY", this.lastTargetPos.field_1351);
            compound.method_10549("LastTargetPosZ", this.lastTargetPos.field_1350);
        }
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.attackCooldown = compound.method_10550("AttackCooldown");
        this.inFiringSequence = compound.method_10577("InFiringSequence");
        if (compound.method_10545("LastTargetPosX")) {
            double x = compound.method_10574("LastTargetPosX");
            double y = compound.method_10574("LastTargetPosY");
            double z = compound.method_10574("LastTargetPosZ");
            this.lastTargetPos = new class_243(x, y, z);
        }
    }

    private void spawnParticles(class_1937 world, double x, double y, double z) {
        if (world instanceof class_3218) {
            class_3218 serverLevel = (class_3218)world;
            this.sendParticlesToAllNearby(serverLevel, class_2398.field_11251, x, y, z, 20, 0.1, 0.1, 0.1, 0.02);
            this.sendParticlesToAllNearby(serverLevel, class_2398.field_11240, x, y, z, 5, 0.1, 0.1, 0.1, 0.2);
        }
    }

    public <T extends class_2394> int sendParticlesToAllNearby(class_3218 serverLevel, T particleOptions, double x, double y, double z, int count, double xOffset, double yOffset, double zOffset, double speed) {
        class_2675 packet = new class_2675(particleOptions, true, x, y, z, (float)xOffset, (float)yOffset, (float)zOffset, (float)speed, count);
        int sentCount = 0;
        for (class_3222 serverPlayer : serverLevel.method_18456()) {
            if (!this.sendParticlesToPlayer(serverLevel, serverPlayer, x, y, z, (class_2596<?>)packet)) continue;
            ++sentCount;
        }
        return sentCount;
    }

    private boolean sendParticlesToPlayer(class_3218 serverLevel, class_3222 serverPlayer, double x, double y, double z, class_2596<?> packet) {
        if (serverPlayer.method_37908() != serverLevel) {
            return false;
        }
        double distanceSquared = serverPlayer.method_19538().method_1025(new class_243(x, y, z));
        if (distanceSquared < 262144.0) {
            serverPlayer.field_13987.method_14364(packet);
            return true;
        }
        return false;
    }

    public float getLeftWheelRotation() {
        return this.leftWheelRotation;
    }

    public void setLeftWheelRotation(float leftWheelRotation) {
        this.leftWheelRotation = leftWheelRotation;
    }

    public float getRightWheelRotation() {
        return this.rightWheelRotation;
    }

    public void setRightWheelRotation(float rightWheelRotation) {
        this.rightWheelRotation = rightWheelRotation;
    }

    @Override
    public class_1792 getScrollType() {
        return HywItemRegistry.RIBAULDEQUIN;
    }

    @Override
    public double getArrivalThreshold() {
        return 2.0;
    }

    private static class BarrelPosition {
        public final class_243 position;
        public final float angleOffset;

        public BarrelPosition(class_243 position, float angleOffset) {
            this.position = position;
            this.angleOffset = angleOffset;
        }
    }
}

