/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.siege;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_7094;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.puppets.IPuppet;
import ydmsama.hundred_years_war.main.entity.entities.siege.UnloadPassengerable;
import ydmsama.hundred_years_war.main.entity.entities.tags.SiegeUnit;
import ydmsama.hundred_years_war.main.entity.goals.BaseCombatEntityAttackGoal;
import ydmsama.hundred_years_war.main.entity.goals.FollowEntityGoal;
import ydmsama.hundred_years_war.main.entity.goals.PatrolGoal;
import ydmsama.hundred_years_war.main.entity.goals.ReturnToHomeGoal;
import ydmsama.hundred_years_war.main.entity.utils.MultiSeatVehicle;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class SiegeTowerEntity
extends BaseCombatEntity
implements SiegeUnit,
MultiSeatVehicle,
UnloadPassengerable {
    private static final float MOVEMENT_SPEED = 0.18f;
    private static final class_2940<Boolean> IS_DEPLOYING = class_2945.method_12791(SiegeTowerEntity.class, (class_2941)class_2943.field_13323);
    public final class_7094 deployAnimationState = new class_7094();
    public final class_7094 undeployAnimationState = new class_7094();
    private final List<MultiSeatVehicle.Seat> seats = new ArrayList<MultiSeatVehicle.Seat>();
    private final Map<class_1297, MultiSeatVehicle.Seat> entitySeatMap = new HashMap<class_1297, MultiSeatVehicle.Seat>();
    private static final int MAX_PASSENGERS = 15;
    private class_243 unloadTarget;
    private static final double MAX_UNLOAD_DISTANCE = 6.0;
    private static final double UNLOAD_HEIGHT_RANGE = 15.0;
    private int unloadInitDelay = 0;
    private int unloadInterval = 0;
    private static final int UNLOAD_INIT_DELAY = 30;
    private static final int UNLOAD_INTERVAL = 20;
    private int lastAnimationTick = 0;
    private static final int ANIMATION_COOLDOWN = 30;
    private boolean isLastStateDeploying = false;

    public SiegeTowerEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5841().method_12784(IS_DEPLOYING, (Object)false);
        this.method_49477(1.0f);
        this.initializeSeats();
        this.isLastStateDeploying = false;
    }

    private void initializeSeats() {
        this.seats.clear();
        this.seats.add(new MultiSeatVehicle.Seat(MultiSeatVehicle.SeatType.PLAYER, new class_243(0.0, 11.8, 0.0), false, MultiSeatVehicle.SeatPose.STANDING));
        this.seats.add(new MultiSeatVehicle.Seat(MultiSeatVehicle.SeatType.RANGED, new class_243(0.8, 11.8, 0.8), false, MultiSeatVehicle.SeatPose.STANDING));
        this.seats.add(new MultiSeatVehicle.Seat(MultiSeatVehicle.SeatType.RANGED, new class_243(-0.8, 11.8, 0.8), false, MultiSeatVehicle.SeatPose.STANDING));
        this.seats.add(new MultiSeatVehicle.Seat(MultiSeatVehicle.SeatType.RANGED, new class_243(0.8, 11.8, -0.8), false, MultiSeatVehicle.SeatPose.STANDING));
        this.seats.add(new MultiSeatVehicle.Seat(MultiSeatVehicle.SeatType.RANGED, new class_243(-0.8, 11.8, -0.8), false, MultiSeatVehicle.SeatPose.STANDING));
        this.seats.add(new MultiSeatVehicle.Seat(MultiSeatVehicle.SeatType.INTERNAL, new class_243(0.0, 0.5, 0.0), true, MultiSeatVehicle.SeatPose.SITTING));
    }

    @Override
    public List<MultiSeatVehicle.Seat> getAllSeats() {
        return new ArrayList<MultiSeatVehicle.Seat>(this.seats);
    }

    @Override
    public int getMaxPassengers() {
        return 15;
    }

    @Override
    public Optional<MultiSeatVehicle.Seat> assignSeat(class_1297 entity) {
        MultiSeatVehicle.SeatType[] preferredTypes;
        if (this.entitySeatMap.containsKey(entity)) {
            MultiSeatVehicle.Seat currentSeat = this.entitySeatMap.get(entity);
            if (currentSeat.getType() == MultiSeatVehicle.SeatType.INTERNAL && entity instanceof class_1309 && this.isRangedUnit((class_1309)entity)) {
                for (MultiSeatVehicle.Seat seat : this.seats) {
                    if (seat.getType() != MultiSeatVehicle.SeatType.RANGED || !seat.canAccept(entity)) continue;
                    if (!currentSeat.isAllowMultiple()) {
                        currentSeat.setOccupant(null);
                    }
                    if (!seat.isAllowMultiple()) {
                        seat.setOccupant(entity);
                    }
                    this.entitySeatMap.put(entity, seat);
                    return Optional.of(seat);
                }
            }
            return Optional.of(currentSeat);
        }
        for (MultiSeatVehicle.SeatType type : preferredTypes = this.getPreferredSeatTypes(entity)) {
            for (MultiSeatVehicle.Seat seat : this.seats) {
                if (seat.getType() != type || !seat.canAccept(entity)) continue;
                if (!seat.isAllowMultiple()) {
                    seat.setOccupant(entity);
                }
                this.entitySeatMap.put(entity, seat);
                return Optional.of(seat);
            }
        }
        return Optional.empty();
    }

    @Override
    public void releaseSeat(class_1297 entity) {
        MultiSeatVehicle.Seat seat = this.entitySeatMap.remove(entity);
        if (seat != null && !seat.isAllowMultiple()) {
            seat.setOccupant(null);
        }
    }

    @Override
    public Optional<MultiSeatVehicle.Seat> getSeatForEntity(class_1297 entity) {
        return Optional.ofNullable(this.entitySeatMap.get(entity));
    }

    @Override
    public int getPassengerCount() {
        return this.method_5685().size();
    }

    @Override
    public MultiSeatVehicle.SeatType[] getPreferredSeatTypes(class_1297 entity) {
        if (entity instanceof class_1657 || entity instanceof IPuppet) {
            return new MultiSeatVehicle.SeatType[]{MultiSeatVehicle.SeatType.PLAYER, MultiSeatVehicle.SeatType.INTERNAL};
        }
        if (entity instanceof class_1309 && this.isRangedUnit((class_1309)entity)) {
            return new MultiSeatVehicle.SeatType[]{MultiSeatVehicle.SeatType.RANGED, MultiSeatVehicle.SeatType.INTERNAL};
        }
        return new MultiSeatVehicle.SeatType[]{MultiSeatVehicle.SeatType.INTERNAL};
    }

    public static class_5132.class_5133 createSiegeTowerAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23717, 20.0).method_26868(class_5134.field_23719, (double)0.18f).method_26868(class_5134.field_23721, 15.0).method_26868(class_5134.field_23724, 20.0).method_26868(class_5134.field_23716, 150.0).method_26868(class_5134.field_23718, 1.0).method_26868(HywAttributes.ATTACK_REACH, 5.0);
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new FollowEntityGoal(this, 1.0, 5.0, 20.0, 25.0, 50.0));
        this.field_6201.method_6277(2, (class_1352)new BaseCombatEntityAttackGoal(this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new PatrolGoal(this, 1.0, 40));
        this.field_6201.method_6277(3, (class_1352)new FollowEntityGoal(this, 1.0, 5.0, 5.0, Double.MAX_VALUE, 0.0));
        this.field_6201.method_6277(4, (class_1352)new ReturnToHomeGoal(this, 1.0));
        super.addTargetSelector();
    }

    @Override
    public boolean isValidTarget(class_1309 potentialTarget) {
        return false;
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 25;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 12;
    }

    @Override
    public int getAttackCoolDownDuration() {
        return 120;
    }

    @Override
    public float getRotationLimit() {
        return 1.0f;
    }

    @Override
    protected void increaseStatsOnLevelUp() {
    }

    @Override
    public double getDesiredDistance() {
        return 4.0;
    }

    @Override
    public double getArrivalThreshold() {
        return 2.0;
    }

    @Override
    protected void updateAnimationState() {
        boolean stateChanged;
        boolean currentIsDeploying = this.getIsDeploying();
        boolean bl = stateChanged = currentIsDeploying != this.isLastStateDeploying;
        if (stateChanged) {
            int currentTick = this.field_6012;
            if (currentTick - this.lastAnimationTick < 30) {
                return;
            }
            this.lastAnimationTick = currentTick;
            this.isLastStateDeploying = currentIsDeploying;
        }
        if (currentIsDeploying) {
            if (!this.deployAnimationState.method_41327()) {
                this.undeployAnimationState.method_41325();
                this.deployAnimationState.method_41322(this.field_6012);
            }
        } else if (!this.undeployAnimationState.method_41327()) {
            this.deployAnimationState.method_41325();
            this.undeployAnimationState.method_41322(this.field_6012);
        }
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            this.handleUnloadLogic();
        }
    }

    private void handleUnloadLogic() {
        if (!this.hasUnloadTarget()) {
            this.resetUnloadState();
            return;
        }
        class_243 target = this.getUnloadTarget();
        if (!this.canUnloadAtPosition(target)) {
            this.resetUnloadState();
            return;
        }
        if (!this.getIsDeploying()) {
            this.setIsDeploying(true);
            this.unloadInitDelay = 30;
            this.unloadInterval = 0;
            return;
        }
        if (this.unloadInitDelay > 0) {
            --this.unloadInitDelay;
            return;
        }
        if (this.unloadInterval > 0) {
            --this.unloadInterval;
            return;
        }
        this.unloadInterval = !this.executeUnload(target) ? 20 : 20;
    }

    private void resetUnloadState() {
        if (this.getIsDeploying()) {
            this.setIsDeploying(false);
            this.unloadInitDelay = 0;
            this.unloadInterval = 0;
        }
    }

    private boolean executeUnload(class_243 target) {
        ArrayList passengers = new ArrayList(this.method_5685());
        if (passengers.isEmpty()) {
            return true;
        }
        passengers.sort((e1, e2) -> Integer.compare(this.getUnloadPriority((class_1297)e1), this.getUnloadPriority((class_1297)e2)));
        class_1297 passenger = (class_1297)passengers.get(0);
        class_243 unloadPos = this.findAvailableUnloadPosition(target);
        if (unloadPos == null) {
            return false;
        }
        passenger.method_5848();
        double offsetX = (this.method_6051().method_43058() - 0.5) * 0.8;
        double offsetZ = (this.method_6051().method_43058() - 0.5) * 0.8;
        double finalX = unloadPos.field_1352 + offsetX;
        double finalZ = unloadPos.field_1350 + offsetZ;
        passenger.method_5859(finalX, unloadPos.field_1351, finalZ);
        if (passenger instanceof BaseCombatEntity) {
            BaseCombatEntity combatEntity = (BaseCombatEntity)passenger;
            combatEntity.setHomePosition(class_2338.method_49637((double)finalX, (double)unloadPos.field_1351, (double)finalZ));
            combatEntity.setHomeReturnRadius(999.0);
            combatEntity.setShouldRender(false);
        }
        return true;
    }

    private int getUnloadPriority(class_1297 entity) {
        Optional<MultiSeatVehicle.Seat> seatOpt = this.getSeatForEntity(entity);
        if (seatOpt.isPresent()) {
            switch (seatOpt.get().getType()) {
                case INTERNAL: {
                    return 0;
                }
                case RANGED: {
                    return 1;
                }
                case PLAYER: {
                    return 2;
                }
            }
        }
        return 3;
    }

    private class_243 findAvailableUnloadPosition(class_243 targetPos) {
        for (int y = 0; y <= 3; ++y) {
            class_243 checkPos = new class_243(targetPos.field_1352, targetPos.field_1351 + (double)y + 1.0, targetPos.field_1350);
            if (!this.isValidUnloadPosition(checkPos)) continue;
            return checkPos;
        }
        return null;
    }

    private boolean isValidUnloadPosition(class_243 pos) {
        class_2338 blockPos = new class_2338((int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350);
        return this.method_37908().method_22347(blockPos) && this.method_37908().method_22347(blockPos.method_10084());
    }

    protected boolean method_5818(class_1297 entity) {
        return this.canEntityMount(entity);
    }

    protected void method_5627(class_1297 entity) {
        super.method_5627(entity);
        this.assignSeat(entity);
        if (!this.method_37908().field_9236) {
            this.optimizeSeatAssignments();
        }
        if (!this.method_37908().field_9236 && entity instanceof BaseCombatEntity) {
            BaseCombatEntity combatEntity = (BaseCombatEntity)entity;
            combatEntity.setFollowTarget(null);
            ServerPacketHandler.sendClearFollowTargetToAll(entity.method_5667());
            ServerPacketHandler.sendClearSelectionToAll(entity.method_5667());
        }
    }

    protected void method_5793(class_1297 entity) {
        this.unloadPassengerToGround(entity);
        super.method_5793(entity);
        this.releaseSeat(entity);
    }

    protected void method_5865(class_1297 passenger, class_1297.class_4738 moveFunction) {
        Optional<MultiSeatVehicle.Seat> seatOpt = this.getSeatForEntity(passenger);
        if (seatOpt.isPresent()) {
            BaseCombatEntity combatEntity;
            MultiSeatVehicle.Seat seat = seatOpt.get();
            class_243 seatPos = seat.getPosition();
            float yBodyRot = this.getTrueYBodyRot() + 90.0f;
            float yBodyRotRad = (float)Math.toRadians(yBodyRot);
            double forwardX = Math.cos(yBodyRotRad);
            double forwardZ = Math.sin(yBodyRotRad);
            double rightX = Math.cos((double)yBodyRotRad + 1.5707963267948966);
            double rightZ = Math.sin((double)yBodyRotRad + 1.5707963267948966);
            double offsetX = forwardX * seatPos.field_1350 + rightX * seatPos.field_1352;
            double offsetZ = forwardZ * seatPos.field_1350 + rightZ * seatPos.field_1352;
            moveFunction.accept(passenger, this.method_23317() + offsetX, this.method_23318() + seatPos.field_1351, this.method_23321() + offsetZ);
            if (passenger instanceof BaseCombatEntity && !(combatEntity = (BaseCombatEntity)passenger).getHasTarget()) {
                passenger.method_5847(this.getTrueYBodyRot());
            }
        } else {
            super.method_5865(passenger, moveFunction);
        }
    }

    @Override
    @NotNull
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (!this.method_37908().field_9236 && this.canEntityMount((class_1297)player)) {
            player.method_5804((class_1297)this);
        }
        return super.method_5992(player, hand);
    }

    public MultiSeatVehicle.SeatPose getEntitySeatPose(class_1297 entity) {
        return this.getSeatForEntity(entity).map(MultiSeatVehicle.Seat::getPose).orElse(MultiSeatVehicle.SeatPose.SITTING);
    }

    private void optimizeSeatAssignments() {
        ArrayList passengers = new ArrayList(this.method_5685());
        ArrayList<class_1297> rangedUnits = new ArrayList<class_1297>();
        ArrayList<class_1297> otherUnits = new ArrayList<class_1297>();
        for (class_1297 passenger : passengers) {
            if (passenger instanceof class_1309 && this.isRangedUnit((class_1309)passenger)) {
                rangedUnits.add(passenger);
                continue;
            }
            otherUnits.add(passenger);
        }
        this.entitySeatMap.clear();
        for (MultiSeatVehicle.Seat seat : this.seats) {
            if (seat.isAllowMultiple()) continue;
            seat.setOccupant(null);
        }
        block2: for (class_1297 rangedUnit : rangedUnits) {
            boolean assigned = false;
            for (MultiSeatVehicle.Seat seat : this.seats) {
                if (seat.getType() != MultiSeatVehicle.SeatType.RANGED || !seat.canAccept(rangedUnit)) continue;
                if (!seat.isAllowMultiple()) {
                    seat.setOccupant(rangedUnit);
                }
                this.entitySeatMap.put(rangedUnit, seat);
                assigned = true;
                break;
            }
            if (assigned) continue;
            for (MultiSeatVehicle.Seat seat : this.seats) {
                if (seat.getType() != MultiSeatVehicle.SeatType.INTERNAL || !seat.canAccept(rangedUnit)) continue;
                this.entitySeatMap.put(rangedUnit, seat);
                continue block2;
            }
        }
        for (class_1297 otherUnit : otherUnits) {
            this.assignSeat(otherUnit);
        }
    }

    public class_1309 method_5642() {
        return null;
    }

    @Override
    public boolean canUnloadAtPosition(class_243 targetPosition) {
        if (targetPosition == null) {
            return false;
        }
        double horizontalDistance = Math.sqrt(Math.pow(targetPosition.field_1352 - this.method_23317(), 2.0) + Math.pow(targetPosition.field_1350 - this.method_23321(), 2.0));
        if (horizontalDistance > this.getMaxUnloadDistance()) {
            return false;
        }
        double heightDiff = targetPosition.field_1351 - this.method_23318();
        return heightDiff >= -0.5 * this.getUnloadHeightRange() && heightDiff <= this.getUnloadHeightRange();
    }

    @Override
    public boolean hasUnloadTarget() {
        return this.unloadTarget != null;
    }

    @Override
    public class_243 getUnloadTarget() {
        return this.unloadTarget;
    }

    @Override
    public void setUnloadTarget(class_243 targetPosition) {
        this.unloadTarget = targetPosition;
        if (targetPosition != null) {
            this.resetUnloadState();
        }
    }

    @Override
    public double getMaxUnloadDistance() {
        return 6.0;
    }

    @Override
    public double getUnloadHeightRange() {
        return 15.0;
    }

    @Override
    public void unloadPassengerToGround(class_1297 passenger) {
        if (this.method_37908().field_9236 || passenger == null) {
            return;
        }
        Random random = new Random();
        double maxDistance = this.getMaxUnloadDistance();
        double angle = random.nextDouble() * 2.0 * Math.PI;
        double distance = random.nextDouble() * maxDistance;
        double offsetX = Math.cos(angle) * distance;
        double offsetZ = Math.sin(angle) * distance;
        double targetX = this.method_23317() + offsetX;
        double targetZ = this.method_23321() + offsetZ;
        class_2338 groundPos = new class_2338((int)targetX, (int)this.method_23318(), (int)targetZ);
        double groundY = this.findGroundLevel(groundPos);
        passenger.method_5848();
        passenger.method_5859(targetX, groundY, targetZ);
        if (passenger instanceof BaseCombatEntity) {
            BaseCombatEntity combatEntity = (BaseCombatEntity)passenger;
            combatEntity.setHomePosition(class_2338.method_49637((double)targetX, (double)groundY, (double)targetZ));
            combatEntity.setHomeReturnRadius(999.0);
            combatEntity.setShouldRender(false);
        }
    }

    private double findGroundLevel(class_2338 startPos) {
        for (int y = startPos.method_10264(); y >= startPos.method_10264() - 10; --y) {
            class_2338 checkPos = new class_2338(startPos.method_10263(), y, startPos.method_10260());
            if (this.method_37908().method_22347(checkPos)) continue;
            class_2338 abovePos = checkPos.method_10084();
            if (!this.method_37908().method_22347(abovePos) || !this.method_37908().method_22347(abovePos.method_10084())) continue;
            return abovePos.method_10264();
        }
        return startPos.method_10264();
    }

    public void setIsDeploying(boolean deploying) {
        this.method_5841().method_12778(IS_DEPLOYING, (Object)deploying);
    }

    public boolean getIsDeploying() {
        return (Boolean)this.method_5841().method_12789(IS_DEPLOYING);
    }

    @Override
    public class_1792 getScrollType() {
        return HywItemRegistry.SIEGE_TOWER;
    }

    @Override
    public void method_6078(class_1282 damageSource) {
        ArrayList passengers = new ArrayList(this.method_5685());
        for (class_1297 passenger : passengers) {
            this.unloadPassengerToGround(passenger);
        }
        super.method_6078(damageSource);
    }

    @Override
    public boolean canFireAtTarget(class_1309 target) {
        return false;
    }
}

