/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.goals;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import ydmsama.hundred_years_war.main.entity.entities.ArcherEntity;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.HywHorseEntity;
import ydmsama.hundred_years_war.main.entity.entities.tags.SiegeUnit;
import ydmsama.hundred_years_war.main.entity.goals.MoveGoal;
import ydmsama.hundred_years_war.main.entity.utils.HorseRider;
import ydmsama.hundred_years_war.main.entity.utils.Mountable;
import ydmsama.hundred_years_war.main.entity.utils.MultiSeatVehicle;
import ydmsama.hundred_years_war.main.entity.utils.PathingTask;
import ydmsama.hundred_years_war.main.entity.utils.PathingTaskManager;
import ydmsama.hundred_years_war.main.entity.utils.PathingTaskManagerRegistry;
import ydmsama.hundred_years_war.main.selection.SelectionSystem;
import ydmsama.hundred_years_war.main.utils.ServerRelationHelper;

public class FollowEntityGoal
extends class_1352
implements MoveGoal {
    private final BaseCombatEntity mob;
    private final double speed;
    private class_1309 targetEntity;
    private final double followRange;
    private final double triggerRange;
    private final double teleportRange;
    private final double maxTeleportRange;
    private boolean shouldRemove;
    private boolean tryRiding;
    private class_11 currentPath;
    private boolean pathGenerated = false;

    public FollowEntityGoal(BaseCombatEntity mob, double speed, double followRange, double triggerRange, double teleportRange, double maxTeleportRange) {
        this.mob = mob;
        this.speed = speed;
        this.followRange = followRange;
        this.triggerRange = triggerRange;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        this.shouldRemove = true;
        this.teleportRange = teleportRange;
        this.maxTeleportRange = maxTeleportRange;
    }

    public boolean method_6264() {
        double distanceToTarget;
        class_1496 horse;
        class_1309 class_13092;
        this.targetEntity = this.mob.getFollowTarget();
        if (this.targetEntity == null || !this.targetEntity.method_5805()) {
            return false;
        }
        if (!this.mob.getGoalQueue().isEmpty()) {
            return false;
        }
        if (this.mob instanceof HorseRider && (class_13092 = this.targetEntity) instanceof class_1496 && (horse = (class_1496)class_13092).method_6727() && horse.method_6725() || this.mob instanceof Mountable && this.targetEntity instanceof MultiSeatVehicle) {
            this.tryRiding = true;
        }
        return (distanceToTarget = this.mob.method_5858((class_1297)this.targetEntity)) > this.triggerRange * this.triggerRange || !this.shouldRemove || this.tryRiding;
    }

    public boolean method_6266() {
        double distanceToTarget;
        this.targetEntity = this.mob.getFollowTarget();
        if (this.targetEntity == null || !this.targetEntity.method_5805()) {
            return false;
        }
        if (this.mob instanceof ArcherEntity && this.targetEntity instanceof HywHorseEntity || this.mob instanceof HorseRider && this.targetEntity instanceof class_1496 || this.mob instanceof Mountable && this.targetEntity instanceof MultiSeatVehicle) {
            this.tryRiding = true;
        }
        return (distanceToTarget = this.mob.method_5858((class_1297)this.targetEntity)) > this.triggerRange * this.triggerRange || !this.shouldRemove || this.tryRiding;
    }

    public void method_6269() {
        this.mob.setHomePosition(null);
        this.targetEntity = this.mob.getFollowTarget();
        if (!this.mob.commandHold()) {
            this.mob.setCommandHold(false);
        }
        this.shouldRemove = false;
        this.updatePath();
    }

    public void method_6270() {
        this.mob.method_5942().method_6340();
    }

    private boolean isInRidingRange(class_1309 rider, class_1309 vehicle) {
        double deltaX = rider.method_23317() - vehicle.method_23317();
        double deltaZ = rider.method_23321() - vehicle.method_23321();
        double horizontalDistance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
        double heightDiff = rider.method_23318() - vehicle.method_23318();
        double vehicleHeight = vehicle.method_17682();
        double minHeightDiff = -0.5 * vehicleHeight;
        double maxHeightDiff = 1.0 * vehicleHeight;
        double maxHorizontalDistance = Math.max((double)vehicle.method_17681() * 3.0, 2.0);
        return horizontalDistance <= maxHorizontalDistance && heightDiff >= minHeightDiff && heightDiff <= maxHeightDiff;
    }

    public void method_6268() {
        class_1309 class_13092;
        this.targetEntity = this.mob.getFollowTarget();
        if (this.targetEntity == null) {
            return;
        }
        double distanceToTarget = this.mob.method_5858((class_1297)this.targetEntity);
        if (this.tryRiding) {
            if (this.mob instanceof HorseRider && this.targetEntity instanceof class_1496 && !this.mob.method_5765() && this.targetEntity.method_5685().isEmpty() && this.isInRidingRange((class_1309)this.mob, this.targetEntity)) {
                this.mob.method_5873((class_1297)this.targetEntity, true);
                SelectionSystem.clearEntityFromAllSelections(this.mob);
                this.tryRiding = false;
                return;
            }
            if (this.mob instanceof Mountable && (class_13092 = this.targetEntity) instanceof MultiSeatVehicle) {
                MultiSeatVehicle multiSeatVehicle = (MultiSeatVehicle)class_13092;
                if (!this.mob.method_5765() && multiSeatVehicle.canEntityMount((class_1297)this.mob) && this.isInRidingRange((class_1309)this.mob, this.targetEntity)) {
                    this.mob.method_5873((class_1297)this.targetEntity, true);
                    SelectionSystem.clearEntityFromAllSelections(this.mob);
                    this.tryRiding = false;
                    return;
                }
            }
        }
        if (distanceToTarget > this.followRange * this.followRange) {
            this.mob.method_5942().method_6335((class_1297)this.targetEntity, this.speed);
        } else {
            this.shouldRemove = true;
        }
        if (distanceToTarget > this.teleportRange * this.teleportRange && distanceToTarget < this.maxTeleportRange * this.maxTeleportRange && (class_13092 = this.targetEntity) instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            if (!(this.mob instanceof SiegeUnit) && ServerRelationHelper.hasControlOver(player, (class_1297)this.mob)) {
                class_243 teleportPos = this.findSafeTeleportPosition();
                if (teleportPos != null) {
                    class_1309 actualEntity = this.getActualEntity();
                    actualEntity.method_5859(teleportPos.field_1352, teleportPos.field_1351, teleportPos.field_1350);
                    this.currentPath = null;
                }
                this.shouldRemove = true;
            }
        }
    }

    private void updatePath() {
        if (this.pathGenerated) {
            if (this.currentPath == null || this.currentPath.method_46() || !this.mob.method_5942().method_23966()) {
                this.currentPath = this.mob.method_5942().method_35141(this.targetEntity.method_24515(), 0, 16);
            }
        } else {
            this.createPathingTask(this.mob, this.targetEntity);
        }
    }

    private void createPathingTask(BaseCombatEntity mob, class_1309 target) {
        Consumer<class_11> pathConsumer = path -> {
            this.currentPath = path;
            this.pathGenerated = true;
        };
        PathingTask task = new PathingTask(mob, target.method_24515(), pathConsumer);
        PathingTaskManagerRegistry registry = PathingTaskManagerRegistry.getInstance();
        PathingTaskManager manager = registry.getTaskManager(mob.method_6139());
        manager.addTask(task);
    }

    private class_1309 getActualEntity() {
        class_1297 class_12972 = this.mob.method_5854();
        if (class_12972 instanceof HywHorseEntity) {
            HywHorseEntity horse = (HywHorseEntity)class_12972;
            return horse;
        }
        return this.mob;
    }

    private class_243 findSafeTeleportPosition() {
        class_2338 targetPos = this.targetEntity.method_24515();
        class_1309 actualEntity = this.getActualEntity();
        class_2338 mobPos = actualEntity.method_24515();
        double distanceToTarget = Math.sqrt(actualEntity.method_5858((class_1297)this.targetEntity));
        int range = 10;
        int heightLimit = 5;
        ArrayList<TeleportCandidate> candidates = new ArrayList<TeleportCandidate>();
        if (this.searchAtHeightDiff(targetPos, mobPos, distanceToTarget, range, 0, candidates)) {
            return this.selectBestCandidate(candidates);
        }
        if (this.searchAtHeightDiff(targetPos, mobPos, distanceToTarget, range, 1, candidates)) {
            return this.selectBestCandidate(candidates);
        }
        if (this.searchAtHeightDiff(targetPos, mobPos, distanceToTarget, range, 2, candidates)) {
            return this.selectBestCandidate(candidates);
        }
        int reducedRange = Math.max(3, range / 2);
        for (int heightDiff = 3; heightDiff <= heightLimit; ++heightDiff) {
            if (!this.searchAtHeightDiff(targetPos, mobPos, distanceToTarget, reducedRange, heightDiff, candidates)) continue;
            return this.selectBestCandidate(candidates);
        }
        return null;
    }

    private boolean searchAtHeightDiff(class_2338 targetPos, class_2338 mobPos, double distanceToTarget, int range, int heightDiff, List<TeleportCandidate> candidates) {
        candidates.clear();
        int maxCandidates = 50;
        List<int[]> searchOrder = this.generateSpiralSearchOrder(range);
        for (int[] offset : searchOrder) {
            int[] yOffsets;
            int[] nArray;
            if (candidates.size() >= maxCandidates) break;
            int newX = targetPos.method_10263() + offset[0];
            int newZ = targetPos.method_10260() + offset[1];
            double distanceToNewPos = Math.sqrt(mobPos.method_10262((class_2382)new class_2338(newX, targetPos.method_10264(), newZ)));
            if (distanceToNewPos > distanceToTarget) continue;
            if (heightDiff == 0) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                int[] nArray3 = new int[2];
                nArray3[0] = heightDiff;
                nArray = nArray3;
                nArray3[1] = -heightDiff;
            }
            for (int yOffset : yOffsets = nArray) {
                class_243 candidatePos;
                class_2338 pos = new class_2338(newX, targetPos.method_10264() + yOffset, newZ);
                if (this.isSafeTeleportLocation(pos, candidatePos = new class_243((double)newX + 0.5, (double)pos.method_10264(), (double)newZ + 0.5), false)) {
                    candidates.add(new TeleportCandidate(candidatePos, heightDiff, false));
                    continue;
                }
                if (!this.isSafeTeleportLocation(pos, candidatePos, true)) continue;
                candidates.add(new TeleportCandidate(candidatePos, heightDiff, true));
            }
        }
        return !candidates.isEmpty();
    }

    private List<int[]> generateSpiralSearchOrder(int range) {
        ArrayList<int[]> order = new ArrayList<int[]>();
        order.add(new int[]{0, 0});
        for (int layer = 1; layer <= range; ++layer) {
            int x = -layer;
            while (x <= layer) {
                order.add(new int[]{x++, layer});
            }
            x = layer - 1;
            while (x >= -layer) {
                order.add(new int[]{x--, -layer});
            }
            int z = -layer + 1;
            while (z <= layer - 1) {
                order.add(new int[]{-layer, z++});
            }
            z = layer - 1;
            while (z >= -layer + 1) {
                order.add(new int[]{layer, z--});
            }
        }
        return order;
    }

    private class_243 selectBestCandidate(List<TeleportCandidate> candidates) {
        if (candidates.isEmpty()) {
            return null;
        }
        candidates.sort(Comparator.comparing(TeleportCandidate::isWater));
        boolean bestIsWater = candidates.get((int)0).isWater;
        ArrayList<TeleportCandidate> bestCandidates = new ArrayList<TeleportCandidate>();
        for (TeleportCandidate candidate : candidates) {
            if (candidate.isWater != bestIsWater) break;
            bestCandidates.add(candidate);
        }
        TeleportCandidate chosen = (TeleportCandidate)bestCandidates.get(this.mob.method_6051().method_43048(bestCandidates.size()));
        return chosen.position;
    }

    private boolean isSafeTeleportLocation(class_2338 blockPos, class_243 targetCenter, boolean allowWater) {
        boolean waterBase;
        class_1309 actualEntity = this.getActualEntity();
        class_1937 level = actualEntity.method_37908();
        class_2338 below = blockPos.method_10074();
        class_2680 blockStateBelow = level.method_8320(below);
        class_3610 fluidStateBelow = level.method_8316(below);
        boolean solidBase = blockStateBelow.method_51367();
        boolean bl = waterBase = fluidStateBelow.method_15767(class_3486.field_15517) || blockStateBelow.method_27852(class_2246.field_10382);
        if (!(solidBase || allowWater && waterBase)) {
            return false;
        }
        class_243 offset = targetCenter.method_1020(actualEntity.method_19538());
        class_238 targetBox = actualEntity.method_5829().method_997(offset);
        if (!level.method_8587((class_1297)actualEntity, targetBox)) {
            return false;
        }
        int minX = class_3532.method_15357((double)targetBox.field_1323);
        int maxX = class_3532.method_15357((double)(targetBox.field_1320 - 1.0E-4));
        int minY = class_3532.method_15357((double)targetBox.field_1322);
        int maxY = class_3532.method_15357((double)(targetBox.field_1325 - 1.0E-4));
        int minZ = class_3532.method_15357((double)targetBox.field_1321);
        int maxZ = class_3532.method_15357((double)(targetBox.field_1324 - 1.0E-4));
        for (class_2338 checkPos : class_2338.method_10094((int)minX, (int)minY, (int)minZ, (int)maxX, (int)maxY, (int)maxZ)) {
            class_2680 state = level.method_8320(checkPos);
            class_3610 fluidState = level.method_8316(checkPos);
            if (!state.method_26220((class_1922)level, checkPos).method_1110()) {
                return false;
            }
            if (fluidState.method_15769()) continue;
            if (fluidState.method_15767(class_3486.field_15517)) {
                if (allowWater) continue;
                return false;
            }
            return false;
        }
        return level.method_8333((class_1297)actualEntity, targetBox, entity -> entity.method_5805() && entity != actualEntity && !entity.method_7325()).isEmpty();
    }

    private static class TeleportCandidate {
        final class_243 position;
        final int heightDiff;
        final boolean isWater;

        TeleportCandidate(class_243 position, int heightDiff, boolean isWater) {
            this.position = position;
            this.heightDiff = heightDiff;
            this.isWater = isWater;
        }

        public int heightDiff() {
            return this.heightDiff;
        }

        public boolean isWater() {
            return this.isWater;
        }
    }
}

