/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.utils;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_243;

public interface MultiSeatVehicle {
    public List<Seat> getAllSeats();

    public int getMaxPassengers();

    public Optional<Seat> assignSeat(class_1297 var1);

    public void releaseSeat(class_1297 var1);

    public Optional<Seat> getSeatForEntity(class_1297 var1);

    default public boolean canEntityMount(class_1297 entity) {
        if (this.getPassengerCount() >= this.getMaxPassengers()) {
            return false;
        }
        return this.assignSeat(entity).isPresent();
    }

    public int getPassengerCount();

    default public SeatType[] getPreferredSeatTypes(class_1297 entity) {
        if (entity instanceof class_1657) {
            return new SeatType[]{SeatType.PLAYER, SeatType.INTERNAL};
        }
        if (entity instanceof class_1309 && this.isRangedUnit((class_1309)entity)) {
            return new SeatType[]{SeatType.RANGED, SeatType.INTERNAL};
        }
        return new SeatType[]{SeatType.INTERNAL};
    }

    default public boolean isRangedUnit(class_1309 entity) {
        return entity instanceof class_1603;
    }

    public static enum SeatType {
        PLAYER,
        RANGED,
        INTERNAL;

    }

    public static class Seat {
        private final SeatType type;
        private final class_243 position;
        private final boolean allowMultiple;
        private final SeatPose pose;
        private class_1297 occupant;

        public Seat(SeatType type, class_243 position, boolean allowMultiple, SeatPose pose) {
            this.type = type;
            this.position = position;
            this.allowMultiple = allowMultiple;
            this.pose = pose;
        }

        public Seat(SeatType type, class_243 position, boolean allowMultiple) {
            this(type, position, allowMultiple, SeatPose.SITTING);
        }

        public SeatType getType() {
            return this.type;
        }

        public class_243 getPosition() {
            return this.position;
        }

        public boolean isAllowMultiple() {
            return this.allowMultiple;
        }

        public SeatPose getPose() {
            return this.pose;
        }

        public class_1297 getOccupant() {
            return this.occupant;
        }

        public void setOccupant(class_1297 entity) {
            this.occupant = entity;
        }

        public boolean isOccupied() {
            return this.occupant != null;
        }

        public boolean canAccept(class_1297 entity) {
            if (this.allowMultiple) {
                return true;
            }
            return !this.isOccupied();
        }
    }

    public static enum SeatPose {
        STANDING,
        SITTING;

    }
}

