/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.generation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3532;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ydmsama.hundred_years_war.main.generation.PregenManager;
import ydmsama.hundred_years_war.main.generation.StructureLocationGenerator;
import ydmsama.hundred_years_war.main.generation.StructurePlacementHelper;
import ydmsama.hundred_years_war.main.generation.StructurePosition;
import ydmsama.hundred_years_war.main.generation.StructurePositionResolver;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.template.BuildTemplateService;
import ydmsama.hundred_years_war.main.template.BuildingTask;
import ydmsama.hundred_years_war.main.template.BuildingTaskManager;
import ydmsama.hundred_years_war.main.template.HywStructureTemplate;
import ydmsama.hundred_years_war.main.template.PlacedBuilding;
import ydmsama.hundred_years_war.main.template.PlacedBuildingRegistry;
import ydmsama.hundred_years_war.main.template.TemplateManager;
import ydmsama.hundred_years_war.main.template.TemplateMetadata;

public class InstGenManager
extends class_18 {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstGenManager.class);
    private static final String DATA_NAME = "hundred_years_war_inst_gen";
    public static final boolean ENABLE_CONSOLE_OUTPUT = false;
    private static final int SAVE_INTERVAL_TICKS = 200;
    private static final int CHUNK_TICKET_LEVEL = 2;
    private static final class_3230<Long> STRUCTURE_TICKET = class_3230.method_14291((String)"hundred_years_war_structure_inst", Long::compare);
    private static final int GRID_SIZE = StructureLocationGenerator.getGridSize();
    private final Map<Long, StructureRecord> records = new HashMap<Long, StructureRecord>();
    private final Set<Long> evaluatedGrids = new HashSet<Long>();
    private final Map<UUID, Long> activeTasks = new HashMap<UUID, Long>();
    private transient StructurePositionResolver positionResolver;
    private transient class_3218 cachedLevel;
    private transient boolean runtimeInitialized = false;
    private long lastTickProcessed = -1L;
    private long lastSaveGameTime = 0L;
    private boolean instGenEnabled = true;

    public InstGenManager() {
    }

    public InstGenManager(class_2487 tag) {
        class_2499 list = tag.method_10554("structures", 10);
        for (int i = 0; i < list.size(); ++i) {
            StructureRecord record = StructureRecord.fromTag(list.method_10602(i));
            this.records.put(record.gridKey, record);
            this.evaluatedGrids.add(record.gridKey);
        }
        this.lastTickProcessed = tag.method_10537("lastTickProcessed");
        this.lastSaveGameTime = tag.method_10537("lastSaveGameTime");
        this.instGenEnabled = !tag.method_10545("instGenEnabled") || tag.method_10577("instGenEnabled");
    }

    public class_2487 method_75(class_2487 tag) {
        class_2499 list = new class_2499();
        for (StructureRecord record : this.records.values()) {
            list.add((Object)record.save());
        }
        tag.method_10566("structures", (class_2520)list);
        tag.method_10544("lastTickProcessed", this.lastTickProcessed);
        tag.method_10544("lastSaveGameTime", this.lastSaveGameTime);
        tag.method_10556("instGenEnabled", this.instGenEnabled);
        return tag;
    }

    public synchronized void initialize(class_3218 level) {
        if (this.runtimeInitialized) {
            this.cachedLevel = level;
            return;
        }
        this.cachedLevel = level;
        this.positionResolver = new StructurePositionResolver(level);
        this.restoreRuntimeState(level);
        PlacedBuildingRegistry registry = PlacedBuildingRegistry.get(level);
        registry.ensureLegacySweep(level);
        this.pruneLegacyBlockedRecords(registry);
        this.runtimeInitialized = true;
    }

    public void tick(class_3218 level) {
        if (level == null) {
            return;
        }
        if (!this.runtimeInitialized) {
            this.initialize(level);
        }
        this.cachedLevel = level;
        long gameTime = level.method_8510();
        if (gameTime == this.lastTickProcessed) {
            return;
        }
        this.lastTickProcessed = gameTime;
        this.processImmediateStructures(level);
        this.monitorActiveTasks(level);
        if (gameTime - this.lastSaveGameTime >= 200L) {
            this.lastSaveGameTime = gameTime;
            this.method_80();
        }
    }

    public synchronized void shutdown() {
        this.runtimeInitialized = false;
        this.cachedLevel = null;
    }

    public String getStats() {
        long completed = this.records.values().stream().filter(r -> r.status == Status.COMPLETED).count();
        long failed = this.records.values().stream().filter(r -> r.status == Status.FAILED).count();
        long active = this.activeTasks.size();
        long queued = this.records.values().stream().filter(r -> r.status == Status.DISCOVERED).count();
        return String.format(Locale.ROOT, "\u7ed3\u6784\u603b\u6570: %d | \u5b8c\u6210: %d | \u5931\u8d25: %d | \u6d3b\u8dc3\u4efb\u52a1: %d | \u5f85\u5904\u7406: %d | \u5373\u65f6\u751f\u6210: %s | \u4ec5\u9884\u8f7d\u6a21\u5f0f: %s", this.records.size(), completed, failed, active, queued, this.instGenEnabled ? "\u5f00\u542f" : "\u5173\u95ed");
    }

    public synchronized StructureRecord ensureRecord(class_3218 level, StructurePosition position, boolean markNearPriority) {
        int gridZ;
        if (position == null) {
            return null;
        }
        int gridX = this.gridCoord(position.getPosition().method_10263());
        long key = InstGenManager.gridKey(gridX, gridZ = this.gridCoord(position.getPosition().method_10260()));
        StructureRecord record = this.records.get(key);
        if (record == null) {
            record = new StructureRecord(position);
            record.discoveryGameTime = level != null ? level.method_8510() : 0L;
            record.nearPriority = markNearPriority;
            this.records.put(key, record);
            this.evaluatedGrids.add(key);
            this.method_80();
        } else if (markNearPriority && !record.nearPriority) {
            record.nearPriority = true;
            this.method_80();
        }
        return record;
    }

    public synchronized StructureRecord getRecord(long gridKey) {
        return this.records.get(gridKey);
    }

    public synchronized StructureRecord getRecord(int gridX, int gridZ) {
        return this.records.get(InstGenManager.gridKey(gridX, gridZ));
    }

    public synchronized List<StructureRecord> getAllRecordsSnapshot() {
        return List.copyOf(this.records.values());
    }

    public synchronized void markDirtyExternal() {
        this.method_80();
    }

    public synchronized void registerTask(StructureRecord record, UUID taskId) {
        if (record == null) {
            return;
        }
        if (!this.records.containsKey(record.gridKey)) {
            this.records.put(record.gridKey, record);
        }
        record.taskId = taskId;
        if (taskId != null) {
            record.status = Status.TASK_CREATED;
            record.taskPlacementStartNanos = System.nanoTime();
            record.placementLogged = false;
            this.activeTasks.put(taskId, record.gridKey);
        }
        this.method_80();
    }

    public synchronized void clearTaskTracking(UUID taskId) {
        if (taskId != null) {
            this.activeTasks.remove(taskId);
        }
    }

    public synchronized void markFailure(StructureRecord record, String reason) {
        if (record == null) {
            return;
        }
        this.recordFailure(record, reason);
    }

    public synchronized boolean hasRunningTasks() {
        for (StructureRecord record : this.records.values()) {
            if (record.taskId == null || record.status == Status.COMPLETED || record.status == Status.FAILED) continue;
            return true;
        }
        return false;
    }

    public synchronized List<String> getRunningTaskSummaries() {
        ArrayList<String> summaries = new ArrayList<String>();
        for (StructureRecord record : this.records.values()) {
            if (record.taskId == null || record.status != Status.TASK_CREATED) continue;
            class_2338 pos = record.anchorPos != null ? record.anchorPos : new class_2338(record.worldX, record.worldY, record.worldZ);
            summaries.add(String.format(Locale.ROOT, "\u6a21\u677f:%s | \u7f51\u683c:(%d,%d) | \u4f4d\u7f6e:(%d,%d,%d) | \u4efb\u52a1ID:%s", record.templateId, record.gridX, record.gridZ, pos.method_10263(), pos.method_10264(), pos.method_10260(), record.taskId));
        }
        return summaries;
    }

    public boolean isEnabled() {
        return this.instGenEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.setEnabled(this.cachedLevel, enabled);
    }

    public void setEnabled(class_3218 level, boolean enabled) {
        if (this.instGenEnabled == enabled) {
            return;
        }
        this.instGenEnabled = enabled;
        if (!enabled) {
            this.releaseAllTickets(level);
        }
        this.method_80();
        InstGenManager.logInfo(this, "InstGen\u7cfb\u7edf\u5df2{}", enabled ? "\u542f\u7528" : "\u7981\u7528");
    }

    public List<StructurePosition> getStructuresInRange(class_2338 center, int radius) {
        if (this.records.isEmpty()) {
            return Collections.emptyList();
        }
        double radiusSqr = class_3532.method_34954((int)radius);
        ArrayList<StructurePosition> result = new ArrayList<StructurePosition>();
        for (StructureRecord record : this.records.values()) {
            double dz;
            class_2338 class_23382 = record.anchorPos != null ? record.anchorPos : new class_2338(record.worldX, record.worldY, record.worldZ);
            class_2338 pos = class_23382;
            double dx = (double)pos.method_10263() + 0.5 - (double)center.method_10263();
            double distanceSqr = dx * dx + (dz = (double)pos.method_10260() + 0.5 - (double)center.method_10260()) * dz;
            if (!(distanceSqr <= radiusSqr)) continue;
            result.add(new StructurePosition(pos, record.templateId, record.rotation, record.mirror, record.generationSeed));
        }
        result.sort(Comparator.comparingDouble(sp -> sp.getPosition().method_10262((class_2382)center)));
        return result;
    }

    private void processImmediateStructures(class_3218 level) {
        int gridZ;
        if (!this.instGenEnabled || level.method_18456().isEmpty()) {
            return;
        }
        PlacedBuildingRegistry registry = PlacedBuildingRegistry.get(level);
        registry.ensureLegacySweep(level);
        int renderDistanceBlocks = level.method_8503().method_3760().method_14568() * 16;
        if (renderDistanceBlocks <= 0) {
            return;
        }
        HashSet<Long> candidateGridKeys = new HashSet<Long>();
        HashSet<Long> visibleChunkKeys = new HashSet<Long>();
        int renderDistanceChunks = level.method_8503().method_3760().method_14568();
        for (class_3222 player : level.method_18456()) {
            int minGridX = this.gridCoord(player.method_31477() - renderDistanceBlocks);
            int maxGridX = this.gridCoord(player.method_31477() + renderDistanceBlocks);
            int minGridZ = this.gridCoord(player.method_31479() - renderDistanceBlocks);
            int maxGridZ = this.gridCoord(player.method_31479() + renderDistanceBlocks);
            for (int gridX = minGridX; gridX <= maxGridX; ++gridX) {
                for (gridZ = minGridZ; gridZ <= maxGridZ; ++gridZ) {
                    candidateGridKeys.add(InstGenManager.gridKey(gridX, gridZ));
                }
            }
            class_1923 playerChunk = player.method_31476();
            int minChunkX = playerChunk.field_9181 - renderDistanceChunks;
            int maxChunkX = playerChunk.field_9181 + renderDistanceChunks;
            int minChunkZ = playerChunk.field_9180 - renderDistanceChunks;
            int maxChunkZ = playerChunk.field_9180 + renderDistanceChunks;
            for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
                for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                    long chunkKey = class_1923.method_8331((int)chunkX, (int)chunkZ);
                    visibleChunkKeys.add(chunkKey);
                    int baseBlockX = chunkX << 4;
                    int baseBlockZ = chunkZ << 4;
                    int chunkGridX = this.gridCoord(baseBlockX);
                    int chunkGridZ = this.gridCoord(baseBlockZ);
                    for (int dx = -1; dx <= 1; ++dx) {
                        for (int dz = -1; dz <= 1; ++dz) {
                            candidateGridKeys.add(InstGenManager.gridKey(chunkGridX + dx, chunkGridZ + dz));
                        }
                    }
                }
            }
        }
        if (candidateGridKeys.isEmpty() && visibleChunkKeys.isEmpty()) {
            return;
        }
        HashSet<Long> recordsToProcess = new HashSet<Long>();
        Iterator<Object> iterator = candidateGridKeys.iterator();
        while (iterator.hasNext()) {
            long key = (Long)iterator.next();
            if (registry.isLegacyGridBlocked(key)) continue;
            StructureRecord record = this.records.get(key);
            if (record == null) {
                if (this.evaluatedGrids.contains(key) || this.positionResolver == null) continue;
                class_1923 gridPos = new class_1923(key);
                int gridX = gridPos.field_9181;
                gridZ = gridPos.field_9180;
                this.evaluatedGrids.add(key);
                StructurePosition position = this.positionResolver.getStructureAt(gridX, gridZ);
                if (position == null) continue;
                record = new StructureRecord(position);
                record.discoveryGameTime = level.method_8510();
                record.status = Status.DISCOVERED;
                record.nearPriority = true;
                this.records.put(record.gridKey, record);
                this.method_80();
            } else {
                if (record.status == Status.COMPLETED || record.status == Status.FAILED || registry.isLegacyGridBlocked(record.gridKey)) continue;
                if (!record.nearPriority) {
                    record.nearPriority = true;
                    this.method_80();
                }
            }
            recordsToProcess.add(record.gridKey);
        }
        if (!visibleChunkKeys.isEmpty()) {
            block8: for (StructureRecord record : this.records.values()) {
                List<class_1923> coverage;
                if (record.status == Status.COMPLETED || record.status == Status.FAILED || registry.isLegacyGridBlocked(record.gridKey) || recordsToProcess.contains(record.gridKey) || (coverage = this.getImmediateChunkCoverage(record)).isEmpty()) continue;
                for (class_1923 chunkPos : coverage) {
                    if (!visibleChunkKeys.contains(class_1923.method_8331((int)chunkPos.field_9181, (int)chunkPos.field_9180))) continue;
                    if (!record.nearPriority) {
                        record.nearPriority = true;
                        this.method_80();
                    }
                    recordsToProcess.add(record.gridKey);
                    continue block8;
                }
            }
        }
        iterator = recordsToProcess.iterator();
        while (iterator.hasNext()) {
            long key = (Long)iterator.next();
            StructureRecord record = this.records.get(key);
            if (record == null) continue;
            this.ensureImmediateCompletion(level, record);
        }
    }

    private void ensureImmediateCompletion(class_3218 level, StructureRecord record) {
        long creationDurationMs;
        if (record.status == Status.COMPLETED || record.status == Status.FAILED) {
            return;
        }
        this.setInstGenClaim(record, true);
        PregenManager pregenManager = PregenManager.get(level);
        if (pregenManager != null) {
            pregenManager.cancelTask(record.gridKey, "\u5373\u65f6\u751f\u6210\u63a5\u7ba1", true);
        }
        record.nearPriority = true;
        if (record.taskId != null) {
            this.fastCompleteExistingTask(level, record);
            return;
        }
        TemplateMetadata metadata = TemplateManager.getInstance().getMetadata(record.templateId);
        if (metadata == null) {
            this.recordFailure(record, "Template metadata not found (instgen)");
            return;
        }
        HywStructureTemplate template = TemplateManager.getInstance().loadTemplate(record.templateId);
        if (template == null) {
            this.recordFailure(record, "Template data not found (instgen)");
            return;
        }
        List<class_1923> requiredChunks = this.getImmediateChunkCoverage(record, metadata, template);
        if (!requiredChunks.isEmpty() && !this.areChunksLoaded(level, requiredChunks)) {
            if (record.chunkPositions == null) {
                this.applyChunkTickets(level, record, requiredChunks);
            }
            return;
        }
        class_2338 basePos = new class_2338(record.worldX, record.worldY, record.worldZ);
        class_2338 placement = StructurePlacementHelper.computePlacementPosition(level, basePos, metadata, record.generationSeed);
        if (placement == null) {
            this.recordFailure(record, "Placement position unavailable (instgen)");
            return;
        }
        record.anchorPos = placement;
        record.worldX = placement.method_10263();
        record.worldY = placement.method_10264();
        record.worldZ = placement.method_10260();
        record.chunkPreloadDurationMs = 0L;
        record.taskCreationStartNanos = System.nanoTime();
        BuildTemplateService.BuildResult result = BuildTemplateService.createBuildingTaskWithResult(level, record.templateId, placement, record.rotation, 0.0f, 0L, "SYSTEM", template.getConnectionLayerDepth() > 0, true);
        record.taskCreationDurationMs = creationDurationMs = (System.nanoTime() - record.taskCreationStartNanos) / 1000000L;
        record.taskCreationStartNanos = -1L;
        if (!result.isSuccess()) {
            String failure = result.details != null ? result.details : result.failureReason.name();
            this.recordFailure(record, "Failed to create task: " + failure);
            return;
        }
        record.taskId = result.taskId;
        record.registeredBuildingId = result.buildingId;
        record.status = Status.TASK_CREATED;
        record.taskPlacementStartNanos = System.nanoTime();
        record.placementLogged = false;
        this.activeTasks.put(result.taskId, record.gridKey);
        this.method_80();
        InstGenManager.logInfo(this, "InstGen | \u5f00\u59cb\u5efa\u7b51\u4efb\u52a1 | \u4f4d\u7f6e:({},{},{}) | ID:{} \u7c7b\u578b:{}", placement.method_10263(), placement.method_10264(), placement.method_10260(), result.taskId, record.templateId);
        BuildingTaskManager taskManager = BuildingTaskManager.get(level);
        BuildingTask task = taskManager.getTask(result.taskId);
        if (task != null) {
            task.enableFastTrack();
        }
    }

    private void fastCompleteExistingTask(class_3218 level, StructureRecord record) {
        if (record.taskId == null) {
            return;
        }
        BuildingTaskManager taskManager = BuildingTaskManager.get(level);
        BuildingTaskManager.BuildingTaskStatus status = taskManager.getTaskStatus(record.taskId);
        if (status == null) {
            record.taskId = null;
            record.status = Status.COMPLETED;
            this.releaseChunkTickets(record);
            this.method_80();
            return;
        }
        if (status.completed || status.failed) {
            return;
        }
        BuildingTask task = taskManager.getTask(record.taskId);
        if (task != null) {
            task.enableFastTrack();
        }
    }

    private void monitorActiveTasks(class_3218 level) {
        if (this.activeTasks.isEmpty()) {
            return;
        }
        BuildingTaskManager taskManager = BuildingTaskManager.get(level);
        Iterator<Map.Entry<UUID, Long>> iterator = this.activeTasks.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, Long> entry = iterator.next();
            UUID taskId = entry.getKey();
            Long key = entry.getValue();
            StructureRecord record = this.records.get(key);
            if (record == null) {
                iterator.remove();
                continue;
            }
            BuildingTaskManager.BuildingTaskStatus status = taskManager.getTaskStatus(taskId);
            if (status == null) {
                record.status = Status.COMPLETED;
                record.taskId = null;
                record.taskPlacementStartNanos = -1L;
                this.releaseChunkTickets(record);
                iterator.remove();
                this.method_80();
                continue;
            }
            if (status.failed) {
                record.placementLogged = true;
                record.taskPlacementStartNanos = -1L;
                this.recordFailure(record, status.failureReason != null ? status.failureReason : "Unknown failure");
                record.taskId = null;
                iterator.remove();
                continue;
            }
            if (!status.completed) continue;
            if (!record.placementLogged) {
                class_2338 pos = record.anchorPos != null ? record.anchorPos : new class_2338(record.worldX, record.worldY, record.worldZ);
                InstGenManager.logInfo(this, "InstGen | \u7ed3\u675f\u5efa\u7b51\u4efb\u52a1 | \u4f4d\u7f6e:({},{},{}) | ID:{} \u7c7b\u578b:{}", pos.method_10263(), pos.method_10264(), pos.method_10260(), taskId, record.templateId);
                record.placementLogged = true;
            }
            record.taskPlacementStartNanos = -1L;
            record.status = Status.COMPLETED;
            record.taskId = null;
            this.releaseChunkTickets(record);
            record.registeredBuildingId = null;
            iterator.remove();
            this.method_80();
        }
    }

    private boolean areChunksLoaded(class_3218 level, List<class_1923> chunkPositions) {
        for (class_1923 chunkPos : chunkPositions) {
            if (level.method_8393(chunkPos.field_9181, chunkPos.field_9180)) continue;
            return false;
        }
        return true;
    }

    private void applyChunkTickets(class_3218 level, StructureRecord record, List<class_1923> chunkPositions) {
        if (record.chunkPositions != null) {
            return;
        }
        for (class_1923 chunkPos : chunkPositions) {
            level.method_14178().method_17297(STRUCTURE_TICKET, chunkPos, 2, (Object)record.gridKey);
        }
        record.chunkPositions = List.copyOf(chunkPositions);
    }

    private void releaseChunkTickets(StructureRecord record) {
        if (this.cachedLevel == null || record.chunkPositions == null) {
            record.chunkPositions = null;
            return;
        }
        class_3215 chunkSource = this.cachedLevel.method_14178();
        for (class_1923 chunkPos : record.chunkPositions) {
            chunkSource.method_17300(STRUCTURE_TICKET, chunkPos, 2, (Object)record.gridKey);
        }
        record.chunkPositions = null;
    }

    private List<class_1923> getImmediateChunkCoverage(StructureRecord record) {
        TemplateMetadata metadata = TemplateManager.getInstance().getMetadata(record.templateId);
        HywStructureTemplate template = metadata != null ? TemplateManager.getInstance().loadTemplate(record.templateId) : null;
        return this.getImmediateChunkCoverage(record, metadata, template);
    }

    private List<class_1923> getImmediateChunkCoverage(StructureRecord record, TemplateMetadata metadata, HywStructureTemplate template) {
        if (record.immediateChunkCache != null) {
            return record.immediateChunkCache;
        }
        if (metadata == null) {
            record.immediateChunkCache = Collections.emptyList();
            return record.immediateChunkCache;
        }
        List<class_1923> chunks = StructurePlacementHelper.computeChunkCoverage(record.worldX, record.worldZ, record.rotation, metadata, template);
        record.immediateChunkCache = chunks.isEmpty() ? Collections.emptyList() : List.copyOf(chunks);
        return record.immediateChunkCache;
    }

    private void recordFailure(StructureRecord record, String reason) {
        record.status = Status.FAILED;
        this.setInstGenClaim(record, false);
        record.failureReason = reason;
        this.cleanupRegisteredBuilding(record.registeredBuildingId);
        record.registeredBuildingId = null;
        this.releaseChunkTickets(record);
        this.method_80();
        InstGenManager.logWarn(this, "InstGen | Structure at {} failed: {}", record.anchorSummary(), reason);
    }

    public synchronized boolean isGridClaimed(long gridKey) {
        StructureRecord record = this.records.get(gridKey);
        return record != null && record.instGenClaimed && record.status != Status.FAILED;
    }

    private void setInstGenClaim(StructureRecord record, boolean claimed) {
        if (record == null || record.instGenClaimed == claimed) {
            return;
        }
        record.instGenClaimed = claimed;
        this.method_80();
    }

    private static boolean shouldLog(InstGenManager manager) {
        return false;
    }

    private static void logInfo(InstGenManager manager, String message, Object ... args) {
        if (InstGenManager.shouldLog(manager)) {
            LOGGER.info(message, args);
        }
    }

    private static void logWarn(InstGenManager manager, String message, Object ... args) {
        if (InstGenManager.shouldLog(manager)) {
            LOGGER.warn(message, args);
        }
    }

    private static void debug(String message, Object ... args) {
        if (!PregenManager.isDebugLoggingEnabled()) {
            return;
        }
        LOGGER.info("[InstGenDebug] " + message, args);
    }

    private void cleanupRegisteredBuilding(UUID buildingId) {
        class_3218 level = this.cachedLevel;
        if (level == null || buildingId == null) {
            return;
        }
        PlacedBuildingRegistry registry = PlacedBuildingRegistry.get(level);
        PlacedBuilding building = registry.getBuilding(buildingId);
        if (building != null && registry.removeBuilding(buildingId)) {
            ServerPacketHandler.broadcastBuildingUpdate(level, building, true);
        }
    }

    private static long gridKey(int gridX, int gridZ) {
        return class_1923.method_8331((int)gridX, (int)gridZ);
    }

    private int gridCoord(int blockCoord) {
        return Math.floorDiv(blockCoord, GRID_SIZE);
    }

    private void pruneLegacyBlockedRecords(PlacedBuildingRegistry registry) {
        if (registry == null || this.records.isEmpty()) {
            return;
        }
        boolean updated = false;
        for (StructureRecord record : this.records.values()) {
            if (!registry.isLegacyGridBlocked(record.gridKey) || record.status == Status.FAILED) continue;
            record.status = Status.FAILED;
            record.failureReason = "Skipped because chunk existed before mod installation";
            updated = true;
        }
        if (updated) {
            this.method_80();
        }
    }

    private void restoreRuntimeState(class_3218 level) {
        BuildingTaskManager taskManager = BuildingTaskManager.get(level);
        this.activeTasks.clear();
        for (StructureRecord record : this.records.values()) {
            record.chunkPositions = null;
            record.chunkPreloadDurationMs = -1L;
            record.taskCreationStartNanos = -1L;
            record.taskCreationDurationMs = -1L;
            record.taskPlacementStartNanos = -1L;
            record.placementLogged = false;
            record.immediateChunkCache = null;
            record.anchorPos = new class_2338(record.worldX, record.worldY, record.worldZ);
            if (record.status != Status.TASK_CREATED) continue;
            if (record.taskId != null) {
                BuildingTaskManager.BuildingTaskStatus status = taskManager.getTaskStatus(record.taskId);
                if (status == null || status.completed) {
                    record.status = Status.COMPLETED;
                    record.taskId = null;
                    this.method_80();
                    continue;
                }
                if (status.failed) {
                    this.recordFailure(record, status.failureReason != null ? status.failureReason : "Task failed");
                    record.taskId = null;
                    continue;
                }
                this.activeTasks.put(record.taskId, record.gridKey);
                record.taskPlacementStartNanos = System.nanoTime();
                continue;
            }
            record.status = Status.COMPLETED;
            this.method_80();
        }
    }

    private void releaseAllTickets(class_3218 level) {
        class_3218 effectiveLevel;
        class_3218 class_32182 = effectiveLevel = level != null ? level : this.cachedLevel;
        if (effectiveLevel == null) {
            return;
        }
        for (StructureRecord record : this.records.values()) {
            if (record.chunkPositions == null) continue;
            this.cachedLevel = effectiveLevel;
            this.releaseChunkTickets(record);
        }
    }

    public static InstGenManager get(class_3218 level) {
        class_26 storage = level.method_17983();
        return (InstGenManager)storage.method_17924(InstGenManager::new, InstGenManager::new, DATA_NAME);
    }

    public static InstGenManager get(MinecraftServer server) {
        return InstGenManager.get(server.method_30002());
    }

    static class StructureRecord {
        final int gridX;
        final int gridZ;
        final long gridKey;
        final String templateId;
        final int rotation;
        final boolean mirror;
        final long generationSeed;
        int worldX;
        int worldY;
        int worldZ;
        boolean nearPriority = false;
        long discoveryGameTime = 0L;
        UUID taskId = null;
        Status status = Status.DISCOVERED;
        String failureReason = null;
        boolean instGenClaimed = false;
        UUID registeredBuildingId = null;
        transient List<class_1923> chunkPositions;
        transient class_2338 anchorPos;
        transient long chunkPreloadDurationMs = -1L;
        transient long taskCreationStartNanos = -1L;
        transient long taskCreationDurationMs = -1L;
        transient long taskPlacementStartNanos = -1L;
        transient boolean placementLogged = false;
        transient List<class_1923> immediateChunkCache = null;

        StructureRecord(StructurePosition position) {
            this.gridX = StructureRecord.gridCoordFromPosition(position.getPosition().method_10263());
            this.gridZ = StructureRecord.gridCoordFromPosition(position.getPosition().method_10260());
            this.gridKey = InstGenManager.gridKey(this.gridX, this.gridZ);
            this.templateId = position.getTemplateId();
            this.rotation = position.getRotation();
            this.mirror = position.isMirror();
            this.generationSeed = position.getGenerationSeed();
            this.worldX = position.getPosition().method_10263();
            this.worldY = position.getPosition().method_10264();
            this.worldZ = position.getPosition().method_10260();
            this.anchorPos = new class_2338(this.worldX, this.worldY, this.worldZ);
        }

        StructureRecord(int gridX, int gridZ, String templateId, int rotation, boolean mirror, long generationSeed, int worldX, int worldY, int worldZ, boolean nearPriority, Status status, UUID taskId, String failureReason, long discoveryGameTime, boolean instGenClaimed, UUID registeredBuildingId) {
            this.gridX = gridX;
            this.gridZ = gridZ;
            this.gridKey = InstGenManager.gridKey(gridX, gridZ);
            this.templateId = templateId;
            this.rotation = rotation;
            this.mirror = mirror;
            this.generationSeed = generationSeed;
            this.worldX = worldX;
            this.worldY = worldY;
            this.worldZ = worldZ;
            this.nearPriority = nearPriority;
            this.status = status;
            this.taskId = taskId;
            this.failureReason = failureReason;
            this.discoveryGameTime = discoveryGameTime;
            this.instGenClaimed = instGenClaimed;
            this.anchorPos = new class_2338(this.worldX, this.worldY, this.worldZ);
            this.registeredBuildingId = registeredBuildingId;
        }

        class_2487 save() {
            class_2487 tag = new class_2487();
            tag.method_10569("gridX", this.gridX);
            tag.method_10569("gridZ", this.gridZ);
            tag.method_10582("templateId", this.templateId);
            tag.method_10569("rotation", this.rotation);
            tag.method_10556("mirror", this.mirror);
            tag.method_10544("generationSeed", this.generationSeed);
            tag.method_10569("worldX", this.worldX);
            tag.method_10569("worldY", this.worldY);
            tag.method_10569("worldZ", this.worldZ);
            tag.method_10556("nearPriority", this.nearPriority);
            tag.method_10582("status", this.status.name());
            tag.method_10556("instGenClaimed", this.instGenClaimed);
            if (this.taskId != null) {
                tag.method_25927("taskId", this.taskId);
            }
            if (this.failureReason != null) {
                tag.method_10582("failureReason", this.failureReason);
            }
            tag.method_10544("discoveryTime", this.discoveryGameTime);
            if (this.registeredBuildingId != null) {
                tag.method_25927("buildingId", this.registeredBuildingId);
            }
            return tag;
        }

        static StructureRecord fromTag(class_2487 tag) {
            int gridX = tag.method_10550("gridX");
            int gridZ = tag.method_10550("gridZ");
            String templateId = tag.method_10558("templateId");
            int rotation = tag.method_10550("rotation");
            boolean mirror = tag.method_10577("mirror");
            long generationSeed = tag.method_10537("generationSeed");
            int worldX = tag.method_10550("worldX");
            int worldY = tag.method_10550("worldY");
            int worldZ = tag.method_10550("worldZ");
            boolean nearPriority = tag.method_10577("nearPriority");
            Status status = Status.valueOf(tag.method_10558("status"));
            UUID taskId = tag.method_10545("taskId") ? tag.method_25926("taskId") : null;
            String failureReason = tag.method_10545("failureReason") ? tag.method_10558("failureReason") : null;
            long discoveryTime = tag.method_10537("discoveryTime");
            boolean instGenClaimed = tag.method_10545("instGenClaimed") && tag.method_10577("instGenClaimed");
            UUID buildingId = tag.method_10545("buildingId") ? tag.method_25926("buildingId") : null;
            return new StructureRecord(gridX, gridZ, templateId, rotation, mirror, generationSeed, worldX, worldY, worldZ, nearPriority, status, taskId, failureReason, discoveryTime, instGenClaimed, buildingId);
        }

        String anchorSummary() {
            return "(" + this.worldX + "," + this.worldY + "," + this.worldZ + ")";
        }

        static int gridCoordFromPosition(int blockCoord) {
            return Math.floorDiv(blockCoord, GRID_SIZE);
        }
    }

    static enum Status {
        DISCOVERED,
        TASK_CREATED,
        COMPLETED,
        FAILED;

    }
}

