/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.generation;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import ydmsama.hundred_years_war.main.template.HywStructureTemplate;
import ydmsama.hundred_years_war.main.template.TemplateMetadata;

public final class StructurePlacementHelper {
    private static final class_2338[] SURFACE_SEARCH_OFFSETS = new class_2338[]{new class_2338(1, 0, 0), new class_2338(-1, 0, 0), new class_2338(0, 0, 1), new class_2338(0, 0, -1), new class_2338(1, 0, 1)};

    private StructurePlacementHelper() {
    }

    public static class_2338 computePlacementPosition(class_3218 level, class_2338 basePos, TemplateMetadata metadata, long generationSeed) {
        if (metadata == null) {
            return basePos;
        }
        int x = basePos.method_10263();
        int z = basePos.method_10260();
        int minY = metadata.getMinGenerationHeight();
        int maxY = metadata.getMaxGenerationHeight();
        int worldMinY = level.method_31607();
        int worldMaxY = level.method_31600() - 1;
        boolean wantsSurface = metadata.isGenerateOnSurface();
        boolean wantsWaterSurface = metadata.isGenerateOnWaterSurface();
        boolean wantsUnderwater = metadata.isGenerateUnderwater();
        if (wantsSurface || wantsWaterSurface || wantsUnderwater) {
            class_2338 solidSurfacePos;
            class_2338 worldSurfacePos = StructurePlacementHelper.getHeightmapPosition(level, class_2902.class_2903.field_13202, x, z, worldMinY, worldMaxY);
            class_2680 worldSurfaceState = level.method_8320(worldSurfacePos);
            boolean worldSurfaceIsWater = worldSurfaceState.method_26227().method_15767(class_3486.field_15517);
            if (worldSurfaceIsWater) {
                class_2338 oceanFloorPos;
                if (wantsWaterSurface && StructurePlacementHelper.isWithinAllowedRange(worldSurfacePos.method_10264(), minY, maxY, worldMinY, worldMaxY)) {
                    return worldSurfacePos;
                }
                if (wantsUnderwater && StructurePlacementHelper.isWithinAllowedRange((oceanFloorPos = StructurePlacementHelper.getHeightmapPosition(level, class_2902.class_2903.field_13200, x, z, worldMinY, worldMaxY)).method_10264(), minY, maxY, worldMinY, worldMaxY)) {
                    return oceanFloorPos;
                }
            } else if (wantsSurface && (solidSurfacePos = StructurePlacementHelper.findSurfacePositionAvoidingWood(level, x, z, minY, maxY, worldMinY, worldMaxY)) != null) {
                return solidSurfacePos;
            }
            return null;
        }
        Random random = new Random(generationSeed);
        int restrictedMinY = Math.max(minY, worldMinY);
        int restrictedMaxY = Math.min(maxY, worldMaxY);
        if (restrictedMaxY <= restrictedMinY) {
            return new class_2338(x, restrictedMinY, z);
        }
        int y = random.nextInt(restrictedMaxY - restrictedMinY + 1) + restrictedMinY;
        return new class_2338(x, y, z);
    }

    private static class_2338 getHeightmapPosition(class_3218 level, class_2902.class_2903 type, int x, int z, int worldMinY, int worldMaxY) {
        int height = level.method_8624(type, x, z) - 1;
        int clamped = class_3532.method_15340((int)height, (int)worldMinY, (int)worldMaxY);
        return new class_2338(x, clamped, z);
    }

    private static boolean isWithinAllowedRange(int y, int minY, int maxY, int worldMinY, int worldMaxY) {
        int lowerBound = Math.max(minY, worldMinY);
        int upperBound = Math.min(maxY, worldMaxY);
        return y >= lowerBound && y <= upperBound;
    }

    private static class_2338 findSurfacePositionAvoidingWood(class_3218 level, int baseX, int baseZ, int minY, int maxY, int worldMinY, int worldMaxY) {
        class_2338 initial = StructurePlacementHelper.getHeightmapPosition(level, class_2902.class_2903.field_13203, baseX, baseZ, worldMinY, worldMaxY);
        if (!StructurePlacementHelper.isWithinAllowedRange(initial.method_10264(), minY, maxY, worldMinY, worldMaxY)) {
            return null;
        }
        if (!StructurePlacementHelper.isWoodSurface(level.method_8320(initial))) {
            return initial;
        }
        int attempts = 0;
        for (class_2338 offset : SURFACE_SEARCH_OFFSETS) {
            class_2338 solidPos;
            int offsetZ;
            if (attempts >= 5) break;
            ++attempts;
            int offsetX = baseX + offset.method_10263();
            class_2338 worldSurfacePos = StructurePlacementHelper.getHeightmapPosition(level, class_2902.class_2903.field_13202, offsetX, offsetZ = baseZ + offset.method_10260(), worldMinY, worldMaxY);
            if (level.method_8320(worldSurfacePos).method_26227().method_15767(class_3486.field_15517) || !StructurePlacementHelper.isWithinAllowedRange((solidPos = StructurePlacementHelper.getHeightmapPosition(level, class_2902.class_2903.field_13203, offsetX, offsetZ, worldMinY, worldMaxY)).method_10264(), minY, maxY, worldMinY, worldMaxY) || StructurePlacementHelper.isWoodSurface(level.method_8320(solidPos))) continue;
            return solidPos;
        }
        return null;
    }

    private static boolean isWoodSurface(class_2680 state) {
        return state.method_26164(class_3481.field_15475);
    }

    public static List<class_1923> computeChunkCoverage(int anchorX, int anchorZ, int rotation, TemplateMetadata metadata, HywStructureTemplate template) {
        if (template != null) {
            return StructurePlacementHelper.computeChunkCoverage(anchorX, anchorZ, rotation, template);
        }
        return StructurePlacementHelper.computeFallbackCoverage(anchorX, anchorZ, metadata);
    }

    public static List<class_1923> computeChunkCoverage(int anchorX, int anchorZ, int rotation, HywStructureTemplate template) {
        int totalRotation = StructurePlacementHelper.computeTotalRotation(template, rotation);
        class_2338 size = template.getSize();
        class_2338 entrance = template.getEntrance() != null ? template.getEntrance() : class_2338.field_10980;
        class_2338 placement = new class_2338(anchorX, 0, anchorZ);
        class_2338 transformedEntrance = StructurePlacementHelper.rotatePosition(entrance, size, totalRotation);
        class_2338 offset = placement.method_10059((class_2382)transformedEntrance);
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (int xEdge = 0; xEdge <= 1; ++xEdge) {
            for (int zEdge = 0; zEdge <= 1; ++zEdge) {
                class_2338 corner = new class_2338(xEdge == 0 ? 0 : size.method_10263() - 1, 0, zEdge == 0 ? 0 : size.method_10260() - 1);
                class_2338 transformedCorner = StructurePlacementHelper.rotatePosition(corner, size, totalRotation);
                class_2338 worldCorner = offset.method_10081((class_2382)transformedCorner);
                minX = Math.min(minX, worldCorner.method_10263());
                maxX = Math.max(maxX, worldCorner.method_10263());
                minZ = Math.min(minZ, worldCorner.method_10260());
                maxZ = Math.max(maxZ, worldCorner.method_10260());
            }
        }
        int minChunkX = Math.floorDiv(minX, 16);
        int maxChunkX = Math.floorDiv(maxX, 16);
        int minChunkZ = Math.floorDiv(minZ, 16);
        int maxChunkZ = Math.floorDiv(maxZ, 16);
        ArrayList<class_1923> result = new ArrayList<class_1923>();
        for (int x = minChunkX; x <= maxChunkX; ++x) {
            for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                result.add(new class_1923(x, z));
            }
        }
        return result;
    }

    public static List<class_1923> computeFallbackCoverage(int anchorX, int anchorZ, TemplateMetadata metadata) {
        if (metadata == null) {
            return List.of();
        }
        int radius = Math.max(metadata.getSize().method_10263(), metadata.getSize().method_10260());
        int minX = anchorX - radius;
        int maxX = anchorX + radius;
        int minZ = anchorZ - radius;
        int maxZ = anchorZ + radius;
        int minChunkX = Math.floorDiv(minX, 16);
        int maxChunkX = Math.floorDiv(maxX, 16);
        int minChunkZ = Math.floorDiv(minZ, 16);
        int maxChunkZ = Math.floorDiv(maxZ, 16);
        ArrayList<class_1923> result = new ArrayList<class_1923>();
        for (int x = minChunkX; x <= maxChunkX; ++x) {
            for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                result.add(new class_1923(x, z));
            }
        }
        return result;
    }

    public static int computeTotalRotation(HywStructureTemplate template, int baseRotation) {
        float savedYaw = template.getPlayerYaw();
        float relativeYaw = StructurePlacementHelper.normalizeAngle(savedYaw);
        int relativeRotation = Math.round(relativeYaw / 90.0f) * 90;
        relativeRotation = StructurePlacementHelper.normalizeRotation(relativeRotation);
        return StructurePlacementHelper.normalizeRotation(baseRotation + relativeRotation);
    }

    public static class_2338 rotatePosition(class_2338 pos, class_2338 size, int rotation) {
        int normalized = StructurePlacementHelper.normalizeRotation(rotation);
        int resultX = pos.method_10263();
        int resultZ = pos.method_10260();
        int currentSizeX = size.method_10263();
        int currentSizeZ = size.method_10260();
        for (int i = 0; i < normalized / 90; ++i) {
            int newX = resultZ;
            int newZ = currentSizeX - 1 - resultX;
            resultX = newX;
            resultZ = newZ;
            int temp = currentSizeX;
            currentSizeX = currentSizeZ;
            currentSizeZ = temp;
        }
        return new class_2338(resultX, pos.method_10264(), resultZ);
    }

    public static float normalizeAngle(float angle) {
        while (angle > 180.0f) {
            angle -= 360.0f;
        }
        while (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public static int normalizeRotation(int rotation) {
        if ((rotation %= 360) < 0) {
            rotation += 360;
        }
        return rotation;
    }
}

