/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.handler;

import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import ydmsama.hundred_years_war.main.chunk.HywChunkManager;
import ydmsama.hundred_years_war.main.entity.utils.PathingTaskManagerRegistry;
import ydmsama.hundred_years_war.main.handler.WorshipEffectHandler;
import ydmsama.hundred_years_war.main.utils.RelationSystem;

public class ModTickHandler {
    private static int damageRecordCleanupCounter = 0;
    private static final int DAMAGE_RECORD_CLEANUP_INTERVAL = 200;
    private static int worshipCheckCounter = 0;
    private static final int WORSHIP_CHECK_INTERVAL = 180;

    public static void registerTickHandler() {
        ServerTickEvents.START_SERVER_TICK.register(server -> HywChunkManager.onServerTickStart());
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            PathingTaskManagerRegistry registry = PathingTaskManagerRegistry.getInstance();
            registry.executeAllTasks();
            if (++damageRecordCleanupCounter >= 200) {
                RelationSystem.cleanupExpiredDamageRecords();
                damageRecordCleanupCounter = 0;
            }
            if (++worshipCheckCounter >= 180) {
                worshipCheckCounter = 0;
                ModTickHandler.checkWorshipEffectsForAllPlayers(server);
            }
            HywChunkManager.onServerTickEnd();
        });
        ServerTickEvents.END_WORLD_TICK.register(HywChunkManager::tickWorld);
    }

    private static void checkWorshipEffectsForAllPlayers(MinecraftServer server) {
        for (class_3222 player : server.method_3760().method_14571()) {
            WorshipEffectHandler.checkPlayerWorshipEffect(player);
        }
    }
}

