/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.item;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import ydmsama.hundred_years_war.main.blocks.warehouse.WarehouseControlBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.TransportWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.data.TransportData;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;

public class TransportOrderItem
extends class_1792 {
    public TransportOrderItem(class_1792.class_1793 properties) {
        super(properties.method_7889(1));
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!level.field_9236 && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            class_2338 boundPos = TransportOrderItem.getBoundWorkstation(stack);
            if (boundPos == null) {
                player.method_7353((class_2561)class_2561.method_43471((String)"item.hundred_years_war.transport_order.not_bound"), true);
                return class_1271.method_22431((Object)stack);
            }
            class_2586 blockEntity = level.method_8321(boundPos);
            if (!(blockEntity instanceof TransportWorkstationBlockEntity)) {
                stack.method_7983("BoundPos");
                stack.method_7983("TransportData");
                player.method_7353((class_2561)class_2561.method_43471((String)"item.hundred_years_war.transport_order.workstation_not_found"), true);
                return class_1271.method_22431((Object)stack);
            }
            ServerPacketHandler.sendOpenTransportOrderSync(serverPlayer, hand, stack);
        }
        return class_1271.method_22427((Object)stack);
    }

    public static void handleKeyAction(class_3222 player, class_1799 stack) {
        class_1937 level = player.method_37908();
        class_239 hitResult = player.method_5745(5.0, 0.0f, false);
        if (hitResult.method_17783() != class_239.class_240.field_1332) {
            return;
        }
        class_3965 blockHit = (class_3965)hitResult;
        class_2338 targetPos = blockHit.method_17777();
        class_2350 side = blockHit.method_17780();
        class_2586 blockEntity = level.method_8321(targetPos);
        if (blockEntity instanceof TransportWorkstationBlockEntity) {
            TransportWorkstationBlockEntity workstation = (TransportWorkstationBlockEntity)blockEntity;
            class_2338 boundPos = TransportOrderItem.getBoundWorkstation(stack);
            if (boundPos == null) {
                TransportOrderItem.bindToWorkstation(stack, targetPos);
                TransportData workstationData = workstation.getTransportData();
                TransportOrderItem.setTransportData(stack, workstationData);
                player.method_31548().method_5431();
                player.method_7353((class_2561)class_2561.method_43469((String)"item.hundred_years_war.transport_order.bound", (Object[])new Object[]{targetPos.method_10263(), targetPos.method_10264(), targetPos.method_10260()}), true);
            } else {
                if (boundPos.equals((Object)targetPos)) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"item.hundred_years_war.transport_order.cannot_target_self"), true);
                    return;
                }
                class_2586 boundEntity = level.method_8321(boundPos);
                if (!(boundEntity instanceof TransportWorkstationBlockEntity)) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"item.hundred_years_war.transport_order.invalid_bound"), true);
                    return;
                }
                TransportWorkstationBlockEntity boundWorkstation = (TransportWorkstationBlockEntity)boundEntity;
                TransportData data = TransportOrderItem.getTransportData(stack);
                if (data.addRoute(boundPos, targetPos, null, TransportData.TransportMode.DEPOSIT)) {
                    TransportOrderItem.setTransportData(stack, data);
                    boundWorkstation.setTransportData(data);
                    player.method_31548().method_5431();
                    player.method_7353((class_2561)class_2561.method_43469((String)"item.hundred_years_war.transport_order.target_added", (Object[])new Object[]{targetPos.method_10263(), targetPos.method_10264(), targetPos.method_10260()}), true);
                } else {
                    player.method_7353((class_2561)class_2561.method_43471((String)"item.hundred_years_war.transport_order.distance_too_far"), true);
                }
            }
        } else if (blockEntity instanceof class_1263 || blockEntity instanceof WarehouseControlBlockEntity) {
            class_2338 boundPos = TransportOrderItem.getBoundWorkstation(stack);
            if (boundPos == null) {
                player.method_7353((class_2561)class_2561.method_43471((String)"item.hundred_years_war.transport_order.not_bound"), true);
                return;
            }
            class_2586 boundEntity = level.method_8321(boundPos);
            if (!(boundEntity instanceof TransportWorkstationBlockEntity)) {
                player.method_7353((class_2561)class_2561.method_43471((String)"item.hundred_years_war.transport_order.invalid_bound"), true);
                return;
            }
            TransportWorkstationBlockEntity boundWorkstation = (TransportWorkstationBlockEntity)boundEntity;
            TransportData data = TransportOrderItem.getTransportData(stack);
            if (data.addRoute(boundPos, targetPos, null, TransportData.TransportMode.DEPOSIT)) {
                TransportOrderItem.setTransportData(stack, data);
                boundWorkstation.setTransportData(data);
                player.method_31548().method_5431();
                player.method_7353((class_2561)class_2561.method_43469((String)"item.hundred_years_war.transport_order.target_added", (Object[])new Object[]{targetPos.method_10263(), targetPos.method_10264(), targetPos.method_10260()}), true);
            } else {
                player.method_7353((class_2561)class_2561.method_43471((String)"item.hundred_years_war.transport_order.distance_too_far"), true);
            }
        } else {
            player.method_7353((class_2561)class_2561.method_43471((String)"item.hundred_years_war.transport_order.invalid_target"), true);
        }
    }

    public static void bindToWorkstation(class_1799 stack, class_2338 pos) {
        class_2487 tag = stack.method_7948();
        tag.method_10544("BoundPos", pos.method_10063());
    }

    public static class_2338 getBoundWorkstation(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10545("BoundPos")) {
            return class_2338.method_10092((long)tag.method_10537("BoundPos"));
        }
        return null;
    }

    public static TransportData getTransportData(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10545("TransportData")) {
            TransportData data = new TransportData();
            data.deserializeNBT(tag.method_10562("TransportData"));
            return data;
        }
        return new TransportData();
    }

    public static void setTransportData(class_1799 stack, TransportData data) {
        class_2487 tag = stack.method_7948();
        tag.method_10566("TransportData", (class_2520)data.serializeNBT());
    }

    public static List<class_2338> getPositionsForRender(class_1799 stack) {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        TransportData data = TransportOrderItem.getTransportData(stack);
        for (TransportData.TransportRoute route : data.getRoutes()) {
            positions.add(route.getTargetPos());
        }
        return positions;
    }

    public void method_7851(class_1799 stack, class_1937 level, List<class_2561> tooltip, class_1836 flag) {
        super.method_7851(stack, level, tooltip, flag);
        if (level != null && level.field_9236) {
            TransportOrderItem.addWrappedTooltip(tooltip, (class_2561)class_2561.method_43471((String)"item.hundred_years_war.transport_order.usage"));
            class_2338 boundPos = TransportOrderItem.getBoundWorkstation(stack);
            if (boundPos != null) {
                TransportOrderItem.addWrappedTooltip(tooltip, (class_2561)class_2561.method_43469((String)"item.hundred_years_war.transport_order.bound", (Object[])new Object[]{boundPos.method_10263(), boundPos.method_10264(), boundPos.method_10260()}));
            } else {
                TransportOrderItem.addWrappedTooltip(tooltip, (class_2561)class_2561.method_43471((String)"item.hundred_years_war.transport_order.not_bound"));
            }
            TransportData data = TransportOrderItem.getTransportData(stack);
            if (!data.isEmpty()) {
                TransportOrderItem.addWrappedTooltip(tooltip, (class_2561)class_2561.method_43469((String)"item.hundred_years_war.transport_order.routes", (Object[])new Object[]{data.getRoutes().size()}));
            }
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.hundred_years_war.transport_order.usage"));
            class_2338 boundPos = TransportOrderItem.getBoundWorkstation(stack);
            if (boundPos != null) {
                tooltip.add((class_2561)class_2561.method_43469((String)"item.hundred_years_war.transport_order.bound", (Object[])new Object[]{boundPos.method_10263(), boundPos.method_10264(), boundPos.method_10260()}));
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.hundred_years_war.transport_order.not_bound"));
            }
            TransportData data = TransportOrderItem.getTransportData(stack);
            if (!data.isEmpty()) {
                tooltip.add((class_2561)class_2561.method_43469((String)"item.hundred_years_war.transport_order.routes", (Object[])new Object[]{data.getRoutes().size()}));
            }
        }
    }

    private static void addWrappedTooltip(List<class_2561> tooltip, class_2561 component) {
        try {
            Class<?> helperClass = Class.forName("ydmsama.hundred_years_war.client.utils.TooltipHelper");
            Method method = helperClass.getMethod("addToTooltip", List.class, class_2561.class);
            method.invoke(null, tooltip, component);
        }
        catch (Exception e) {
            tooltip.add(component);
        }
    }
}

