/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import ydmsama.hundred_years_war.main.blocks.ModBlocks;
import ydmsama.hundred_years_war.main.item.BuildingToolItem;
import ydmsama.hundred_years_war.main.template.BuildTemplateService;
import ydmsama.hundred_years_war.main.template.HywStructureTemplate;
import ydmsama.hundred_years_war.main.template.TemplateManager;
import ydmsama.hundred_years_war.main.template.TemplateMetadata;

public class BuildingToolActionPacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "building_tool_action");

    public static void register() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ID, (server, player, handler, buf, responseSender) -> {
            Action action = (Action)buf.method_10818(Action.class);
            class_2338 pos = buf.readBoolean() ? buf.method_10811() : null;
            String data = buf.readBoolean() ? buf.method_19772() : null;
            server.execute(() -> BuildingToolActionPacket.handleAction(player, action, pos, data));
        });
    }

    private static void handleAction(class_3222 player, Action action, class_2338 pos, String data) {
        class_1799 mainHand = player.method_6047();
        if (!(mainHand.method_7909() instanceof BuildingToolItem)) {
            return;
        }
        switch (action) {
            case SWITCH_MODE: {
                BuildingToolItem.switchMode(mainHand);
                break;
            }
            case SET_FIRST_POS: {
                if (pos == null) break;
                BuildingToolItem.setFirstPos(mainHand, pos);
                BuildingToolItem.setSaveState(mainHand, BuildingToolItem.SaveState.FIRST_POS);
                break;
            }
            case SET_SECOND_POS: {
                if (pos == null) break;
                BuildingToolItem.setSecondPos(mainHand, pos);
                BuildingToolItem.setSaveState(mainHand, BuildingToolItem.SaveState.SECOND_POS);
                break;
            }
            case SET_ENTRANCE_POS: {
                if (pos == null) break;
                BuildingToolItem.setEntrancePos(mainHand, pos);
                BuildingToolItem.setSaveState(mainHand, BuildingToolItem.SaveState.READY_TO_SAVE);
                break;
            }
            case SET_FILL_FIRST_POS: {
                if (pos == null) break;
                BuildingToolItem.setFillFirstPos(mainHand, pos);
                BuildingToolItem.setFillSecondPos(mainHand, null);
                BuildingToolItem.setFillState(mainHand, BuildingToolItem.FillState.FIRST_POS);
                break;
            }
            case SET_FILL_SECOND_POS: {
                if (pos == null) break;
                BuildingToolItem.setFillSecondPos(mainHand, pos);
                BuildingToolItem.setFillState(mainHand, BuildingToolItem.FillState.SECOND_POS);
                break;
            }
            case SAVE_BUILDING: {
                class_1937 class_19372;
                if (data == null || !((class_19372 = player.method_37908()) instanceof class_3218)) break;
                class_3218 serverLevel = (class_3218)class_19372;
                class_2338 firstPos = BuildingToolItem.getFirstPos(mainHand);
                class_2338 secondPos = BuildingToolItem.getSecondPos(mainHand);
                class_2338 entrancePos = BuildingToolItem.getEntrancePos(mainHand);
                if (firstPos == null || secondPos == null) break;
                String[] mainParts = data.split("\\|", 2);
                String name = mainParts[0];
                String category = "";
                String description = "";
                boolean includeEntities = false;
                boolean includeBlockData = true;
                boolean enableGeneration = false;
                int generationWeight = 1;
                int connectionLayerDepth = 10;
                int minGenerationHeight = -64;
                int maxGenerationHeight = 320;
                boolean generateOnSurface = true;
                LinkedHashMap<String, JsonElement> customAttributes = new LinkedHashMap<String, JsonElement>(TemplateMetadata.createDefaultAttributes());
                if (mainParts.length > 1 && !mainParts[1].isEmpty()) {
                    try {
                        JsonObject settingsJson = JsonParser.parseString((String)mainParts[1]).getAsJsonObject();
                        if (settingsJson.has("category") && settingsJson.get("category").isJsonPrimitive()) {
                            category = settingsJson.get("category").getAsString();
                        }
                        if (settingsJson.has("description") && settingsJson.get("description").isJsonPrimitive()) {
                            description = settingsJson.get("description").getAsString();
                        }
                        if (settingsJson.has("includeEntities")) {
                            includeEntities = settingsJson.get("includeEntities").getAsBoolean();
                        }
                        if (settingsJson.has("includeBlockData")) {
                            includeBlockData = settingsJson.get("includeBlockData").getAsBoolean();
                        }
                        if (settingsJson.has("enableGeneration")) {
                            enableGeneration = settingsJson.get("enableGeneration").getAsBoolean();
                        }
                        if (settingsJson.has("generationWeight")) {
                            generationWeight = BuildingToolActionPacket.safeGetInt(settingsJson, "generationWeight", 1);
                        }
                        if (settingsJson.has("connectionLayerDepth")) {
                            connectionLayerDepth = BuildingToolActionPacket.safeGetInt(settingsJson, "connectionLayerDepth", 10);
                        }
                        if (settingsJson.has("minGenerationHeight")) {
                            minGenerationHeight = BuildingToolActionPacket.safeGetInt(settingsJson, "minGenerationHeight", -64);
                        }
                        if (settingsJson.has("maxGenerationHeight")) {
                            maxGenerationHeight = BuildingToolActionPacket.safeGetInt(settingsJson, "maxGenerationHeight", 320);
                        }
                        if (settingsJson.has("generateOnSurface")) {
                            generateOnSurface = settingsJson.get("generateOnSurface").getAsBoolean();
                        }
                        if (settingsJson.has("customAttributes") && settingsJson.get("customAttributes").isJsonObject()) {
                            JsonObject attributesJson = settingsJson.getAsJsonObject("customAttributes");
                            for (Map.Entry entry : attributesJson.entrySet()) {
                                customAttributes.put((String)entry.getKey(), ((JsonElement)entry.getValue()).deepCopy());
                            }
                        }
                    }
                    catch (JsonSyntaxException | IllegalStateException settingsJson) {
                        // empty catch block
                    }
                }
                String author = player.method_5477().getString();
                float playerYaw = player.method_36454();
                player.method_7353((class_2561)class_2561.method_43469((String)"message.hundred_years_war.building_save_started", (Object[])new Object[]{name}), true);
                int[] lastPercentage = new int[]{-1};
                CompletableFuture<HywStructureTemplate> templateFuture = BuildTemplateService.buildTemplateWithProgress(serverLevel, firstPos, secondPos, entrancePos, name, category, description, author, playerYaw, includeEntities, includeBlockData, enableGeneration, generationWeight, connectionLayerDepth, minGenerationHeight, maxGenerationHeight, generateOnSurface, customAttributes, (current, total) -> {
                    int percentage = (int)((double)current * 100.0 / (double)total);
                    if (percentage != lastPercentage[0]) {
                        lastPercentage[0] = percentage;
                        player.method_5682().execute(() -> player.method_7353((class_2561)class_2561.method_43469((String)"message.hundred_years_war.building_save_progress", (Object[])new Object[]{name, percentage}), true));
                    }
                });
                ((CompletableFuture)templateFuture.thenAccept(template -> player.method_5682().execute(() -> {
                    String templateId = name.toLowerCase().replaceAll("[^a-z0-9_]", "_") + "_" + System.currentTimeMillis();
                    boolean saved = TemplateManager.getInstance().saveTemplate((HywStructureTemplate)template, templateId);
                    if (saved) {
                        player.method_7353((class_2561)class_2561.method_43469((String)"message.hundred_years_war.building_saved", (Object[])new Object[]{name}), true);
                        BuildingToolItem.setSaveState(mainHand, BuildingToolItem.SaveState.NONE);
                        BuildingToolItem.setFirstPos(mainHand, null);
                        BuildingToolItem.setSecondPos(mainHand, null);
                        BuildingToolItem.setEntrancePos(mainHand, null);
                    } else {
                        player.method_7353((class_2561)class_2561.method_43469((String)"message.hundred_years_war.building_save_failed", (Object[])new Object[]{name}), true);
                    }
                }))).exceptionally(e -> {
                    player.method_5682().execute(() -> player.method_7353((class_2561)class_2561.method_43469((String)"message.hundred_years_war.building_save_error", (Object[])new Object[]{e.getMessage()}), true));
                    return null;
                });
                break;
            }
            case PLACE_BUILDING: {
                String playerName;
                class_1937 firstPos;
                if (pos == null || data == null || !((firstPos = player.method_37908()) instanceof class_3218)) break;
                class_3218 serverLevel = (class_3218)firstPos;
                String[] parts = data.split("\\|");
                String templateId = parts[0];
                int rotation = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
                long buildTimeSeconds = parts.length > 2 ? Long.parseLong(parts[2]) : 0L;
                boolean generateConnectionLayer = parts.length > 3 && Boolean.parseBoolean(parts[3]);
                boolean terrainCheck = parts.length > 4 && Boolean.parseBoolean(parts[4]);
                float currentPlayerYaw = player.method_36454();
                BuildTemplateService.BuildResult result = BuildTemplateService.createBuildingTaskWithResult(serverLevel, templateId, pos, rotation, currentPlayerYaw, buildTimeSeconds, playerName = player.method_5477().getString(), generateConnectionLayer, terrainCheck);
                if (result.isSuccess()) {
                    String templateName;
                    HywStructureTemplate template2 = TemplateManager.getInstance().loadTemplate(templateId);
                    String string = templateName = template2 != null ? template2.getName() : templateId;
                    if (buildTimeSeconds == 0L) {
                        player.method_43496((class_2561)class_2561.method_43469((String)"message.hundred_years_war.building_started_instant", (Object[])new Object[]{templateName}));
                        break;
                    }
                    player.method_43496((class_2561)class_2561.method_43469((String)"message.hundred_years_war.building_started", (Object[])new Object[]{templateName, buildTimeSeconds}));
                    break;
                }
                class_5250 errorMessage = switch (result.failureReason) {
                    default -> throw new IncompatibleClassChangeError();
                    case BuildTemplateService.BuildResult.FailureReason.TEMPLATE_NOT_FOUND -> class_2561.method_43469((String)"message.hundred_years_war.template_not_found", (Object[])new Object[]{templateId});
                    case BuildTemplateService.BuildResult.FailureReason.BUILDING_COLLISION -> class_2561.method_43469((String)"message.hundred_years_war.building_collision", (Object[])new Object[]{result.details});
                    case BuildTemplateService.BuildResult.FailureReason.INVALID_POSITION -> class_2561.method_43471((String)"message.hundred_years_war.invalid_position");
                    case BuildTemplateService.BuildResult.FailureReason.TERRAIN_TOO_UNEVEN -> class_2561.method_43471((String)"message.hundred_years_war.terrain_too_uneven");
                };
                player.method_43496((class_2561)errorMessage);
                break;
            }
            case APPLY_PLACEHOLDER_OPERATION: {
                class_1937 parts = player.method_37908();
                if (!(parts instanceof class_3218)) break;
                class_3218 serverLevel = (class_3218)parts;
                if (data == null) break;
                class_2338 firstPos = BuildingToolItem.getFillFirstPos(mainHand);
                class_2338 secondPos = BuildingToolItem.getFillSecondPos(mainHand);
                if (firstPos == null || secondPos == null) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.hundred_years_war.building_tool.fill_missing_selection"), true);
                    break;
                }
                boolean fillOperation = "fill".equalsIgnoreCase(data);
                boolean clearOperation = "clear".equalsIgnoreCase(data);
                if (!fillOperation && !clearOperation) break;
                int minX = Math.min(firstPos.method_10263(), secondPos.method_10263());
                int minY = Math.min(firstPos.method_10264(), secondPos.method_10264());
                int minZ = Math.min(firstPos.method_10260(), secondPos.method_10260());
                int maxX = Math.max(firstPos.method_10263(), secondPos.method_10263());
                int maxY = Math.max(firstPos.method_10264(), secondPos.method_10264());
                int maxZ = Math.max(firstPos.method_10260(), secondPos.method_10260());
                int affected = 0;
                for (class_2338 target : class_2338.method_10094((int)minX, (int)minY, (int)minZ, (int)maxX, (int)maxY, (int)maxZ)) {
                    class_2680 currentState = serverLevel.method_8320(target);
                    if (fillOperation) {
                        if (!currentState.method_26215() || !serverLevel.method_8652(target, ModBlocks.PLACEHOLDER_BLOCK.method_9564(), 3)) continue;
                        ++affected;
                        continue;
                    }
                    if (!currentState.method_27852(ModBlocks.PLACEHOLDER_BLOCK) || !serverLevel.method_8652(target, class_2246.field_10124.method_9564(), 3)) continue;
                    ++affected;
                }
                BuildingToolItem.resetFillState(mainHand);
                String messageKey = fillOperation ? "message.hundred_years_war.building_tool.fill_applied" : "message.hundred_years_war.building_tool.fill_cleared";
                player.method_7353((class_2561)class_2561.method_43469((String)messageKey, (Object[])new Object[]{affected}), true);
                break;
            }
            case UNDO_FILL_FIRST_POS: {
                BuildingToolItem.setFillFirstPos(mainHand, null);
                BuildingToolItem.setFillSecondPos(mainHand, null);
                BuildingToolItem.setFillState(mainHand, BuildingToolItem.FillState.NONE);
                break;
            }
            case UNDO_FILL_SECOND_POS: {
                BuildingToolItem.setFillSecondPos(mainHand, null);
                BuildingToolItem.setFillState(mainHand, BuildingToolItem.FillState.FIRST_POS);
                break;
            }
            case RESET_FILL_SELECTION: {
                BuildingToolItem.resetFillState(mainHand);
                break;
            }
            case UNDO_FIRST_POS: {
                BuildingToolItem.setFirstPos(mainHand, null);
                BuildingToolItem.setSaveState(mainHand, BuildingToolItem.SaveState.NONE);
                break;
            }
            case UNDO_SECOND_POS: {
                BuildingToolItem.setSecondPos(mainHand, null);
                BuildingToolItem.setSaveState(mainHand, BuildingToolItem.SaveState.FIRST_POS);
                break;
            }
            case UNDO_ENTRANCE_POS: {
                BuildingToolItem.setEntrancePos(mainHand, null);
                BuildingToolItem.setSaveState(mainHand, BuildingToolItem.SaveState.SECOND_POS);
            }
        }
    }

    private static int safeGetInt(JsonObject json, String key, int defaultValue) {
        try {
            return json.get(key).getAsInt();
        }
        catch (Exception ignored) {
            return defaultValue;
        }
    }

    public static enum Action {
        SWITCH_MODE,
        SET_FIRST_POS,
        SET_SECOND_POS,
        SET_ENTRANCE_POS,
        SET_FILL_FIRST_POS,
        SET_FILL_SECOND_POS,
        SAVE_BUILDING,
        PLACE_BUILDING,
        UNDO_FIRST_POS,
        UNDO_SECOND_POS,
        UNDO_ENTRANCE_POS,
        APPLY_PLACEHOLDER_OPERATION,
        UNDO_FILL_FIRST_POS,
        UNDO_FILL_SECOND_POS,
        RESET_FILL_SELECTION;

    }
}

