/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import ydmsama.hundred_years_war.main.template.PlacedBuilding;

public class PlacedBuildingSyncPacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "placed_buildings_sync");

    public static class_2540 createChunkPacket(class_1923 chunkPos, List<PlacedBuilding> buildings) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeLong(chunkPos.method_8324());
        buf.writeInt(buildings.size());
        for (PlacedBuilding building : buildings) {
            new BuildingData(building).write(buf);
        }
        return buf;
    }

    public static class_2540 createAreaPacket(List<PlacedBuilding> buildings) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeLong(0L);
        buf.writeInt(buildings.size());
        for (PlacedBuilding building : buildings) {
            new BuildingData(building).write(buf);
        }
        return buf;
    }

    public static class_2540 createUpdatePacket(PlacedBuilding building, boolean isRemoval) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeLong(-1L);
        buf.writeBoolean(isRemoval);
        if (isRemoval) {
            buf.method_10797(building.getBuildingId());
        } else {
            buf.writeInt(1);
            new BuildingData(building).write(buf);
        }
        return buf;
    }

    public static class BuildingData {
        public final UUID buildingId;
        public final String templateName;
        public final class_2338 minPos;
        public final class_2338 maxPos;
        public final class_2338 entrancePos;
        public final String placedBy;

        public BuildingData(PlacedBuilding building) {
            this.buildingId = building.getBuildingId();
            this.templateName = building.getTemplateName();
            this.minPos = building.getMinPos();
            this.maxPos = building.getMaxPos();
            this.entrancePos = building.getEntrancePos();
            this.placedBy = building.getPlacedBy();
        }

        public BuildingData(class_2540 buf) {
            this.buildingId = buf.method_10790();
            this.templateName = buf.method_10800(Short.MAX_VALUE);
            this.minPos = buf.method_10811();
            this.maxPos = buf.method_10811();
            this.entrancePos = buf.method_10811();
            this.placedBy = buf.method_10800(Short.MAX_VALUE);
        }

        public void write(class_2540 buf) {
            buf.method_10797(this.buildingId);
            buf.method_10814(this.templateName != null ? this.templateName : "");
            buf.method_10807(this.minPos);
            buf.method_10807(this.maxPos);
            buf.method_10807(this.entrancePos);
            buf.method_10814(this.placedBy != null ? this.placedBy : "");
        }
    }
}

