/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import ydmsama.hundred_years_war.main.recruitment.data.RecruitmentConfig;

public class RecruitmentDataResponsePacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "recruitment_data_response");
    private final String categoryId;
    private final List<RecruitmentConfig.UnitTypeConfig> unitTypes;

    public RecruitmentDataResponsePacket(String categoryId, List<RecruitmentConfig.UnitTypeConfig> unitTypes) {
        this.categoryId = categoryId;
        this.unitTypes = unitTypes;
    }

    public void encode(class_2540 buf) {
        buf.method_10814(this.categoryId);
        buf.writeInt(this.unitTypes.size());
        for (RecruitmentConfig.UnitTypeConfig unitType : this.unitTypes) {
            buf.method_10814(unitType.getId());
            buf.method_10814(unitType.getTranslationKey());
            buf.writeInt(unitType.getLevels().size());
            for (RecruitmentConfig.ArmyLevelConfig level : unitType.getLevels()) {
                buf.writeInt(level.getLevel());
                buf.method_10814(level.getTranslationKey());
                buf.writeInt(level.getExpCost());
                buf.writeInt(level.getUnits().size());
                for (RecruitmentConfig.UnitEntry unit : level.getUnits()) {
                    buf.method_10814(unit.getEntityType());
                    buf.writeInt(unit.getCountRange().getMin());
                    buf.writeInt(unit.getCountRange().getMax());
                    buf.writeInt(unit.getEquipmentLevel());
                }
                List<String> conditions = level.getConditions();
                if (conditions != null) {
                    buf.writeInt(conditions.size());
                    for (String condition : conditions) {
                        buf.method_10814(condition);
                    }
                    continue;
                }
                buf.writeInt(0);
            }
        }
    }

    public static RecruitmentDataResponsePacket decode(class_2540 buf) {
        String categoryId = buf.method_19772();
        int unitTypesSize = buf.readInt();
        ArrayList<RecruitmentConfig.UnitTypeConfig> unitTypes = new ArrayList<RecruitmentConfig.UnitTypeConfig>();
        for (int i = 0; i < unitTypesSize; ++i) {
            RecruitmentConfig.UnitTypeConfig unitType = new RecruitmentConfig.UnitTypeConfig();
            unitType.setId(buf.method_19772());
            unitType.setTranslationKey(buf.method_19772());
            int levelsSize = buf.readInt();
            ArrayList<RecruitmentConfig.ArmyLevelConfig> levels = new ArrayList<RecruitmentConfig.ArmyLevelConfig>();
            for (int j = 0; j < levelsSize; ++j) {
                RecruitmentConfig.ArmyLevelConfig level = new RecruitmentConfig.ArmyLevelConfig();
                level.setLevel(buf.readInt());
                level.setTranslationKey(buf.method_19772());
                level.setExpCost(buf.readInt());
                int unitsSize = buf.readInt();
                ArrayList<RecruitmentConfig.UnitEntry> units = new ArrayList<RecruitmentConfig.UnitEntry>();
                for (int k = 0; k < unitsSize; ++k) {
                    RecruitmentConfig.UnitEntry unit = new RecruitmentConfig.UnitEntry();
                    unit.setEntityType(buf.method_19772());
                    RecruitmentConfig.CountRange countRange = new RecruitmentConfig.CountRange();
                    countRange.setMin(buf.readInt());
                    countRange.setMax(buf.readInt());
                    unit.setCountRange(countRange);
                    unit.setEquipmentLevel(buf.readInt());
                    units.add(unit);
                }
                level.setUnits(units);
                int conditionsSize = buf.readInt();
                if (conditionsSize > 0) {
                    ArrayList<String> conditions = new ArrayList<String>();
                    for (int k = 0; k < conditionsSize; ++k) {
                        conditions.add(buf.method_19772());
                    }
                    level.setConditions(conditions);
                }
                levels.add(level);
            }
            unitType.setLevels(levels);
            unitTypes.add(unitType);
        }
        return new RecruitmentDataResponsePacket(categoryId, unitTypes);
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public List<RecruitmentConfig.UnitTypeConfig> getUnitTypes() {
        return this.unitTypes;
    }
}

