/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.main.utils.RelationSystem;

public class RelationSyncPacket {
    public static final class_2960 RELATION_SYNC_PACKET_ID = new class_2960("hundred_years_war", "relation_sync_packet");
    private final Set<UUID> enemyUUIDs;
    private final Set<UUID> sharedControlUUIDs;

    public RelationSyncPacket(Set<UUID> enemyUUIDs, Set<UUID> sharedControlUUIDs) {
        this.enemyUUIDs = enemyUUIDs;
        this.sharedControlUUIDs = sharedControlUUIDs;
    }

    public Set<UUID> getEnemyUUIDs() {
        return this.enemyUUIDs;
    }

    public Set<UUID> getSharedControlUUIDs() {
        return this.sharedControlUUIDs;
    }

    public static void encode(RelationSyncPacket packet, class_2540 buf) {
        buf.writeInt(packet.enemyUUIDs.size());
        for (UUID uuid : packet.enemyUUIDs) {
            buf.method_10797(uuid);
        }
        buf.writeInt(packet.sharedControlUUIDs.size());
        for (UUID uuid : packet.sharedControlUUIDs) {
            buf.method_10797(uuid);
        }
    }

    public static RelationSyncPacket decode(class_2540 buf) {
        int enemySize = buf.readInt();
        HashSet<UUID> enemyUUIDs = new HashSet<UUID>();
        for (int i = 0; i < enemySize; ++i) {
            enemyUUIDs.add(buf.method_10790());
        }
        int sharedControlSize = buf.readInt();
        HashSet<UUID> sharedControlUUIDs = new HashSet<UUID>();
        for (int i = 0; i < sharedControlSize; ++i) {
            sharedControlUUIDs.add(buf.method_10790());
        }
        return new RelationSyncPacket(enemyUUIDs, sharedControlUUIDs);
    }

    public static void sendToClient(class_3222 player) {
        UUID playerUUID = player.method_5667();
        HashSet<UUID> enemyUUIDs = new HashSet<UUID>();
        enemyUUIDs.addAll(RelationSystem.getRelationsByType(playerUUID, RelationSystem.RelationType.HOSTILE).keySet());
        HashSet<UUID> sharedControlUUIDs = new HashSet<UUID>();
        for (UUID otherUUID : RelationSystem.getAllRelationData().keySet()) {
            if (otherUUID.equals(playerUUID) || RelationSystem.getRelation(otherUUID, playerUUID) != RelationSystem.RelationType.CONTROL) continue;
            sharedControlUUIDs.add(otherUUID);
        }
        RelationSyncPacket packet = new RelationSyncPacket(enemyUUIDs, sharedControlUUIDs);
        class_2540 buf = PacketByteBufs.create();
        RelationSyncPacket.encode(packet, buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)RELATION_SYNC_PACKET_ID, (class_2540)buf);
    }
}

