/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.siege.SiegeMode;
import ydmsama.hundred_years_war.main.selection.SelectionSystem;

public class SiegeModeTogglePacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "siege_mode_toggle");
    private final boolean siegeModeActive;

    public SiegeModeTogglePacket(boolean siegeModeActive) {
        this.siegeModeActive = siegeModeActive;
    }

    public boolean isSiegeModeActive() {
        return this.siegeModeActive;
    }

    public void encode(class_2540 buf) {
        buf.writeBoolean(this.siegeModeActive);
    }

    public static SiegeModeTogglePacket decode(class_2540 buf) {
        boolean siegeModeActive = buf.readBoolean();
        return new SiegeModeTogglePacket(siegeModeActive);
    }

    public static void handle(class_3222 player, SiegeModeTogglePacket packet) {
        SelectionSystem.Selection selection = SelectionSystem.getSelection(player);
        if (selection != null) {
            List<UUID> entityUUIDs = selection.getEntityUUIDs();
            for (UUID uuid : entityUUIDs) {
                class_1297 entity = SelectionSystem.getEntityByUUIDWithinRadius(player, uuid, 200);
                if (entity instanceof SiegeMode) {
                    ((SiegeMode)entity).setSiegeModeEnabled(packet.siegeModeActive);
                }
                if (!(entity instanceof BaseCombatEntity)) continue;
                BaseCombatEntity combatEntity = (BaseCombatEntity)entity;
                combatEntity.clearPatrolPoints();
            }
        }
    }
}

