/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.main.spawn.SpawnPointBlockEntity;

public class SpawnPointConfigPacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "spawn_point_config");
    private final class_2338 pos;
    private final Mode mode;
    private final ConfigData configData;

    public SpawnPointConfigPacket(class_2338 pos, ConfigData configData) {
        this.pos = pos;
        this.mode = Mode.UPDATE;
        this.configData = configData;
    }

    public SpawnPointConfigPacket(class_2338 pos, Mode mode) {
        this.pos = pos;
        this.mode = mode;
        this.configData = null;
    }

    private SpawnPointConfigPacket(class_2338 pos, Mode mode, ConfigData data) {
        this.pos = pos;
        this.mode = mode;
        this.configData = data;
    }

    public static void encode(class_2540 buf, SpawnPointConfigPacket packet) {
        buf.method_10807(packet.pos);
        buf.method_10817((Enum)packet.mode);
        if (packet.mode == Mode.UPDATE && packet.configData != null) {
            ConfigData data = packet.configData;
            buf.writeDouble(data.activationDistance());
            buf.writeDouble(data.horizontalRange());
            buf.writeDouble(data.verticalRange());
            buf.writeInt(data.perSpawnCount());
            buf.writeInt(data.remainingCount());
            buf.writeInt(data.minInterval());
            buf.writeInt(data.maxInterval());
            buf.writeInt(data.currentInterval());
            buf.writeInt(data.maxActive());
            buf.writeBoolean(data.infinite());
            buf.writeBoolean(data.showActivationRange());
            buf.writeBoolean(data.paused());
            buf.writeBoolean(data.periodicReset());
            buf.writeLong(data.resetInterval());
            buf.writeLong(data.currentResetCooldown());
            buf.method_10804(data.entries().size());
            for (SpawnEntryData entry : data.entries()) {
                buf.method_10812(entry.id());
                buf.method_10804(entry.weight());
                buf.method_10804(entry.level());
                buf.method_10804(entry.equipmentLevel());
            }
        }
    }

    public static SpawnPointConfigPacket decode(class_2540 buf) {
        class_2338 pos = buf.method_10811();
        Mode mode = (Mode)buf.method_10818(Mode.class);
        if (mode == Mode.UPDATE) {
            double activation = buf.readDouble();
            double horizontal = buf.readDouble();
            double vertical = buf.readDouble();
            int perSpawn = buf.readInt();
            int remaining = buf.readInt();
            int minInterval = buf.readInt();
            int maxInterval = buf.readInt();
            int currentInterval = buf.readInt();
            int maxActive = buf.readInt();
            boolean infinite = buf.readBoolean();
            boolean showActivationRange = buf.readBoolean();
            boolean paused = buf.readBoolean();
            boolean periodicReset = buf.readBoolean();
            long resetInterval = buf.readLong();
            long currentResetCooldown = buf.readLong();
            int size = buf.method_10816();
            ArrayList<SpawnEntryData> entries = new ArrayList<SpawnEntryData>();
            for (int i = 0; i < size; ++i) {
                class_2960 id = buf.method_10810();
                int weight = buf.method_10816();
                int level = buf.method_10816();
                int equipmentLevel = buf.method_10816();
                entries.add(new SpawnEntryData(id, weight, level, equipmentLevel));
            }
            ConfigData data = new ConfigData(activation, horizontal, vertical, perSpawn, remaining, minInterval, maxInterval, currentInterval, maxActive, infinite, showActivationRange, paused, periodicReset, resetInterval, currentResetCooldown, entries);
            return new SpawnPointConfigPacket(pos, mode, data);
        }
        return new SpawnPointConfigPacket(pos, mode, null);
    }

    public static void handle(class_3222 player, SpawnPointConfigPacket packet) {
        class_3218 level = player.method_51469();
        class_2586 blockEntity = level.method_8321(packet.pos);
        if (!(blockEntity instanceof SpawnPointBlockEntity)) {
            return;
        }
        SpawnPointBlockEntity spawnPoint = (SpawnPointBlockEntity)blockEntity;
        switch (packet.mode) {
            case UPDATE: {
                SpawnPointConfigPacket.applyUpdate(spawnPoint, packet.configData);
                break;
            }
            case SAVE_DEFAULTS: {
                spawnPoint.saveCurrentAsInitial();
                break;
            }
            case RESTORE_DEFAULTS: {
                spawnPoint.restoreSavedState();
            }
        }
    }

    private static void applyUpdate(SpawnPointBlockEntity spawnPoint, ConfigData data) {
        if (data == null) {
            return;
        }
        ArrayList<SpawnPointBlockEntity.SpawnEntry> entries = new ArrayList<SpawnPointBlockEntity.SpawnEntry>();
        for (SpawnEntryData entry : data.entries()) {
            if (entry.weight() <= 0) continue;
            entries.add(new SpawnPointBlockEntity.SpawnEntry(entry.id(), entry.weight(), entry.level(), entry.equipmentLevel()));
        }
        spawnPoint.applyConfiguration(data.activationDistance(), data.horizontalRange(), data.verticalRange(), data.perSpawnCount(), data.remainingCount(), data.minInterval(), data.maxInterval(), data.currentInterval(), data.maxActive(), data.infinite(), data.showActivationRange(), data.paused(), data.periodicReset(), data.resetInterval(), data.currentResetCooldown(), entries);
    }

    public class_2338 pos() {
        return this.pos;
    }

    public Mode mode() {
        return this.mode;
    }

    public ConfigData configData() {
        return this.configData;
    }

    public static enum Mode {
        UPDATE,
        SAVE_DEFAULTS,
        RESTORE_DEFAULTS;

    }

    public record ConfigData(double activationDistance, double horizontalRange, double verticalRange, int perSpawnCount, int remainingCount, int minInterval, int maxInterval, int currentInterval, int maxActive, boolean infinite, boolean showActivationRange, boolean paused, boolean periodicReset, long resetInterval, long currentResetCooldown, List<SpawnEntryData> entries) {
    }

    public record SpawnEntryData(class_2960 id, int weight, int level, int equipmentLevel) {
    }
}

