/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.main.supply.SupplyManager;
import ydmsama.hundred_years_war.main.supply.SupplyPointBlockEntity;

public class SupplyTransferPacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "supply_transfer");
    private final class_2338 blockPos;
    private final double amount;
    private final boolean isDeposit;

    public SupplyTransferPacket(class_2338 blockPos, double amount, boolean isDeposit) {
        this.blockPos = blockPos;
        this.amount = amount;
        this.isDeposit = isDeposit;
    }

    public SupplyTransferPacket(class_2540 buf) {
        this.blockPos = buf.method_10811();
        this.amount = buf.readDouble();
        this.isDeposit = buf.readBoolean();
    }

    public void encode(class_2540 buf) {
        buf.method_10807(this.blockPos);
        buf.writeDouble(this.amount);
        buf.writeBoolean(this.isDeposit);
    }

    public static SupplyTransferPacket decode(class_2540 buf) {
        return new SupplyTransferPacket(buf);
    }

    public static void handle(class_3222 player, SupplyTransferPacket packet) {
        class_2586 blockEntity = player.method_37908().method_8321(packet.blockPos);
        if (!(blockEntity instanceof SupplyPointBlockEntity)) {
            return;
        }
        SupplyPointBlockEntity supplyPoint = (SupplyPointBlockEntity)blockEntity;
        if (!supplyPoint.method_5443((class_1657)player)) {
            return;
        }
        if (!supplyPoint.canPlayerAccess((class_1657)player)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.hundred_years_war.supply_point.cannot_access"), true);
            return;
        }
        SupplyManager.SupplySource playerSource = SupplyManager.getSupplySource(player.method_5667());
        if (playerSource == null) {
            SupplyManager.registerSupplySource(player.method_5667(), SupplyManager.SupplySourceType.PLAYER, 1000.0);
            playerSource = SupplyManager.getSupplySource(player.method_5667());
        }
        if (playerSource != null && playerSource.getOwnerId() == null) {
            SupplyManager.setSupplySourceOwner(player.method_5667(), player.method_5667());
        }
        if (packet.isDeposit) {
            double toDeposit;
            if (playerSource != null && (toDeposit = Math.min(packet.amount, playerSource.getSupplyValue())) > 0.0) {
                playerSource.consumeSupply(toDeposit);
                supplyPoint.depositSupply(toDeposit);
            }
        } else {
            double withdrawn = supplyPoint.withdrawSupply(packet.amount);
            if (playerSource != null && withdrawn > 0.0) {
                playerSource.addSupply(withdrawn);
            }
        }
    }

    public class_2338 getBlockPos() {
        return this.blockPos;
    }

    public double getAmount() {
        return this.amount;
    }

    public boolean isDeposit() {
        return this.isDeposit;
    }
}

