/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.main.network.packets.TeamApplicationsResponsePacket;
import ydmsama.hundred_years_war.main.utils.PlayerRelationData;
import ydmsama.hundred_years_war.main.utils.RelationData;
import ydmsama.hundred_years_war.main.utils.RelationSystem;
import ydmsama.hundred_years_war.main.utils.TeamRelationData;

public class TeamApplicationsRequestPacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "team_applications_request");

    public TeamApplicationsRequestPacket() {
    }

    public TeamApplicationsRequestPacket(class_2540 buf) {
    }

    public void encode(class_2540 buf) {
    }

    public static TeamApplicationsRequestPacket decode(class_2540 buf) {
        return new TeamApplicationsRequestPacket(buf);
    }

    public static void handle(class_3222 player) {
        UUID playerUUID = player.method_5667();
        List<UUID> playerTeams = RelationSystem.getPlayerTeams(playerUUID);
        if (!playerTeams.isEmpty()) {
            UUID teamUUID = playerTeams.get(0);
            TeamRelationData teamData = RelationSystem.getTeamRelationData(teamUUID);
            if (teamData != null) {
                TeamRelationData.MemberType memberType = teamData.getMemberType(playerUUID);
                if (memberType == TeamRelationData.MemberType.OWNER || memberType == TeamRelationData.MemberType.ADMIN) {
                    ArrayList<TeamApplicationsResponsePacket.Application> applications = new ArrayList<TeamApplicationsResponsePacket.Application>();
                    for (UUID applicantUUID : teamData.getPendingApplications()) {
                        RelationData relationData = RelationSystem.getRelationData(applicantUUID);
                        String applicantName = relationData instanceof PlayerRelationData ? ((PlayerRelationData)relationData).getPlayerName() : Optional.ofNullable(player.method_5682().method_3760().method_14602(applicantUUID)).map(p -> p.method_5477().getString()).orElse("Unknown");
                        long applyTime = System.currentTimeMillis();
                        applications.add(new TeamApplicationsResponsePacket.Application(applicantName, applicantUUID, applyTime));
                    }
                    TeamApplicationsResponsePacket responsePacket = new TeamApplicationsResponsePacket(applications);
                    class_2540 responseBuf = PacketByteBufs.create();
                    responsePacket.encode(responseBuf);
                    ServerPlayNetworking.send((class_3222)player, (class_2960)TeamApplicationsResponsePacket.ID, (class_2540)responseBuf);
                    System.out.println("\u53d1\u9001\u56e2\u961f\u7533\u8bf7\u5217\u8868\u7ed9\u73a9\u5bb6 " + player.method_5477().getString() + "\uff0c\u7533\u8bf7\u6570\u91cf: " + applications.size());
                } else {
                    TeamApplicationsRequestPacket.sendEmptyTeamApplicationsResponse(player);
                }
            } else {
                TeamApplicationsRequestPacket.sendEmptyTeamApplicationsResponse(player);
            }
        } else {
            TeamApplicationsRequestPacket.sendEmptyTeamApplicationsResponse(player);
        }
    }

    private static void sendEmptyTeamApplicationsResponse(class_3222 player) {
        TeamApplicationsResponsePacket responsePacket = new TeamApplicationsResponsePacket(new ArrayList<TeamApplicationsResponsePacket.Application>());
        class_2540 responseBuf = PacketByteBufs.create();
        responsePacket.encode(responseBuf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)TeamApplicationsResponsePacket.ID, (class_2540)responseBuf);
    }
}

