/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.main.network.packets.TeamMembersResponsePacket;
import ydmsama.hundred_years_war.main.utils.PlayerRelationData;
import ydmsama.hundred_years_war.main.utils.RelationData;
import ydmsama.hundred_years_war.main.utils.RelationSystem;
import ydmsama.hundred_years_war.main.utils.TeamRelationData;

public class TeamMembersRequestPacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "team_members_request");
    private final UUID teamUUID;

    public TeamMembersRequestPacket(UUID teamUUID) {
        this.teamUUID = teamUUID;
    }

    public TeamMembersRequestPacket(class_2540 buf) {
        this.teamUUID = buf.method_10790();
    }

    public void encode(class_2540 buf) {
        buf.method_10797(this.teamUUID);
    }

    public static TeamMembersRequestPacket decode(class_2540 buf) {
        return new TeamMembersRequestPacket(buf);
    }

    public UUID getTeamUUID() {
        return this.teamUUID;
    }

    public static void handle(class_3222 player, UUID teamUUID) {
        TeamRelationData teamData = RelationSystem.getTeamRelationData(teamUUID);
        if (teamData != null) {
            ArrayList<TeamMembersResponsePacket.Member> members = new ArrayList<TeamMembersResponsePacket.Member>();
            String teamName = teamData.getTeamName();
            Map<UUID, TeamRelationData.MemberType> allMembers = teamData.getAllMembers();
            for (Map.Entry<UUID, TeamRelationData.MemberType> entry : allMembers.entrySet()) {
                UUID memberUUID = entry.getKey();
                TeamRelationData.MemberType memberType = entry.getValue();
                RelationData relationData = RelationSystem.getRelationData(memberUUID);
                String memberName = relationData instanceof PlayerRelationData ? ((PlayerRelationData)relationData).getPlayerName() : Optional.ofNullable(player.method_5682().method_3760().method_14602(memberUUID)).map(p -> p.method_5477().getString()).orElse("Unknown");
                TeamMembersResponsePacket.Member.Role role = switch (memberType) {
                    case TeamRelationData.MemberType.OWNER -> TeamMembersResponsePacket.Member.Role.OWNER;
                    case TeamRelationData.MemberType.ADMIN -> TeamMembersResponsePacket.Member.Role.ADMIN;
                    default -> TeamMembersResponsePacket.Member.Role.MEMBER;
                };
                long joinTime = System.currentTimeMillis();
                members.add(new TeamMembersResponsePacket.Member(memberName, memberUUID, role, joinTime));
            }
            TeamMembersResponsePacket responsePacket = new TeamMembersResponsePacket(teamUUID, teamName, members);
            class_2540 responseBuf = PacketByteBufs.create();
            responsePacket.encode(responseBuf);
            ServerPlayNetworking.send((class_3222)player, (class_2960)TeamMembersResponsePacket.ID, (class_2540)responseBuf);
        } else {
            ArrayList<TeamMembersResponsePacket.Member> emptyList = new ArrayList<TeamMembersResponsePacket.Member>();
            TeamMembersResponsePacket responsePacket = new TeamMembersResponsePacket(teamUUID, "Unknown Team", emptyList);
            class_2540 responseBuf = PacketByteBufs.create();
            responsePacket.encode(responseBuf);
            ServerPlayNetworking.send((class_3222)player, (class_2960)TeamMembersResponsePacket.ID, (class_2540)responseBuf);
        }
    }
}

