/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import ydmsama.hundred_years_war.main.utils.RelationSystem;
import ydmsama.hundred_years_war.main.utils.TeamRelationData;

public class TeamRelationResponsePacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "team_relation_response_packet");
    private final Map<UUID, RelationInfo> relationInfoMap = new HashMap<UUID, RelationInfo>();
    private final Map<UUID, TeamInfo> teamInfoMap = new HashMap<UUID, TeamInfo>();
    private final UUID teamUUID;

    public TeamRelationResponsePacket(UUID teamUUID) {
        this.teamUUID = teamUUID;
    }

    public static TeamRelationResponsePacket decode(class_2540 buf) {
        UUID teamUUID = buf.method_10790();
        TeamRelationResponsePacket packet = new TeamRelationResponsePacket(teamUUID);
        int playerCount = buf.readInt();
        for (int i = 0; i < playerCount; ++i) {
            UUID uuid = buf.method_10790();
            String playerName = buf.method_19772();
            RelationSystem.RelationType teamRelation = RelationSystem.RelationType.valueOf(buf.method_19772());
            RelationSystem.RelationType theirRelation = RelationSystem.RelationType.valueOf(buf.method_19772());
            packet.relationInfoMap.put(uuid, new RelationInfo(playerName, teamRelation, theirRelation));
        }
        int teamCount = buf.readInt();
        for (int i = 0; i < teamCount; ++i) {
            UUID otherTeamUuid = buf.method_10790();
            String teamName = buf.method_19772();
            RelationSystem.RelationType teamRelation = RelationSystem.RelationType.valueOf(buf.method_19772());
            RelationSystem.RelationType theirRelation = RelationSystem.RelationType.valueOf(buf.method_19772());
            int memberCount = buf.readInt();
            HashMap<UUID, TeamRelationData.MemberType> members = new HashMap<UUID, TeamRelationData.MemberType>();
            for (int j = 0; j < memberCount; ++j) {
                UUID memberUuid = buf.method_10790();
                TeamRelationData.MemberType memberType = TeamRelationData.MemberType.valueOf(buf.method_19772());
                members.put(memberUuid, memberType);
            }
            packet.teamInfoMap.put(otherTeamUuid, new TeamInfo(teamName, teamRelation, members, theirRelation));
        }
        return packet;
    }

    public void encode(class_2540 buf) {
        buf.method_10797(this.teamUUID);
        buf.writeInt(this.relationInfoMap.size());
        for (Map.Entry<UUID, RelationInfo> entry : this.relationInfoMap.entrySet()) {
            buf.method_10797(entry.getKey());
            buf.method_10814(entry.getValue().getPlayerName());
            buf.method_10814(entry.getValue().getTeamRelation().name());
            buf.method_10814(entry.getValue().getTheirRelation().name());
        }
        buf.writeInt(this.teamInfoMap.size());
        for (Map.Entry<UUID, Object> entry : this.teamInfoMap.entrySet()) {
            buf.method_10797(entry.getKey());
            buf.method_10814(((TeamInfo)entry.getValue()).getTeamName());
            buf.method_10814(((TeamInfo)entry.getValue()).getTeamRelation().name());
            buf.method_10814(((TeamInfo)entry.getValue()).getTheirRelation().name());
            Map<UUID, TeamRelationData.MemberType> members = ((TeamInfo)entry.getValue()).getMembers();
            buf.writeInt(members.size());
            for (Map.Entry<UUID, TeamRelationData.MemberType> memberEntry : members.entrySet()) {
                buf.method_10797(memberEntry.getKey());
                buf.method_10814(memberEntry.getValue().name());
            }
        }
    }

    public void addRelationInfo(UUID uuid, String playerName, RelationSystem.RelationType teamRelation, RelationSystem.RelationType theirRelation) {
        this.relationInfoMap.put(uuid, new RelationInfo(playerName, teamRelation, theirRelation));
    }

    public void addTeamInfo(UUID teamUuid, String teamName, RelationSystem.RelationType teamRelation, Map<UUID, TeamRelationData.MemberType> members) {
        this.addTeamInfo(teamUuid, teamName, teamRelation, members, RelationSystem.RelationType.NEUTRAL);
    }

    public void addTeamInfo(UUID teamUuid, String teamName, RelationSystem.RelationType teamRelation, Map<UUID, TeamRelationData.MemberType> members, RelationSystem.RelationType theirRelation) {
        this.teamInfoMap.put(teamUuid, new TeamInfo(teamName, teamRelation, members, theirRelation));
    }

    public Map<UUID, RelationInfo> getRelationInfoMap() {
        return this.relationInfoMap;
    }

    public Map<UUID, TeamInfo> getTeamInfoMap() {
        return this.teamInfoMap;
    }

    public UUID getTeamUUID() {
        return this.teamUUID;
    }

    public static class RelationInfo {
        private final String playerName;
        private final RelationSystem.RelationType teamRelation;
        private final RelationSystem.RelationType theirRelation;

        public RelationInfo(String playerName, RelationSystem.RelationType teamRelation, RelationSystem.RelationType theirRelation) {
            this.playerName = playerName;
            this.teamRelation = teamRelation;
            this.theirRelation = theirRelation;
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public RelationSystem.RelationType getTeamRelation() {
            return this.teamRelation;
        }

        public RelationSystem.RelationType getTheirRelation() {
            return this.theirRelation;
        }
    }

    public static class TeamInfo {
        private final String teamName;
        private final RelationSystem.RelationType teamRelation;
        private final Map<UUID, TeamRelationData.MemberType> members;
        private RelationSystem.RelationType theirRelation;

        public TeamInfo(String teamName, RelationSystem.RelationType teamRelation, Map<UUID, TeamRelationData.MemberType> members) {
            this(teamName, teamRelation, members, RelationSystem.RelationType.NEUTRAL);
        }

        public TeamInfo(String teamName, RelationSystem.RelationType teamRelation, Map<UUID, TeamRelationData.MemberType> members, RelationSystem.RelationType theirRelation) {
            this.teamName = teamName;
            this.teamRelation = teamRelation;
            this.members = members;
            this.theirRelation = theirRelation;
        }

        public String getTeamName() {
            return this.teamName;
        }

        public RelationSystem.RelationType getTeamRelation() {
            return this.teamRelation;
        }

        public Map<UUID, TeamRelationData.MemberType> getMembers() {
            return this.members;
        }

        public RelationSystem.RelationType getTheirRelation() {
            return this.theirRelation;
        }

        public void setTheirRelation(RelationSystem.RelationType theirRelation) {
            this.theirRelation = theirRelation;
        }
    }
}

