/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import ydmsama.hundred_years_war.main.template.TemplateMetadata;

public final class TemplateListResponsePacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "template_list_response");
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

    private TemplateListResponsePacket() {
    }

    public static void encode(class_2540 buf, Collection<TemplateMetadata> metadataCollection) {
        buf.method_10804(metadataCollection.size());
        for (TemplateMetadata metadata : metadataCollection) {
            buf.method_10814(metadata.getTemplateId() == null ? "" : metadata.getTemplateId());
            buf.method_10814(TemplateListResponsePacket.nullToEmpty(metadata.getName()));
            buf.method_10814(TemplateListResponsePacket.nullToEmpty(metadata.getCategory()));
            buf.method_10814(TemplateListResponsePacket.nullToEmpty(metadata.getDescription()));
            TemplateListResponsePacket.writeNullableBlockPos(buf, metadata.getSize());
            TemplateListResponsePacket.writeNullableBlockPos(buf, metadata.getEntrance());
            buf.method_10814(TemplateListResponsePacket.nullToEmpty(metadata.getAuthor()));
            buf.writeLong(metadata.getCreatedTime());
            buf.method_10804(metadata.getTotalBlocks());
            buf.writeFloat(metadata.getPlayerYaw());
            buf.writeBoolean(metadata.getFileName() != null);
            if (metadata.getFileName() != null) {
                buf.method_10814(metadata.getFileName());
            }
            buf.writeLong(metadata.getFileSize());
            Map<String, Integer> blockCount = metadata.getBlockCount();
            buf.method_10804(blockCount != null ? blockCount.size() : 0);
            if (blockCount != null) {
                for (Map.Entry<String, Integer> entry : blockCount.entrySet()) {
                    buf.method_10814(entry.getKey());
                    buf.method_10804(entry.getValue().intValue());
                }
            }
            buf.writeBoolean(metadata.isGenerationEnabled());
            buf.method_10804(metadata.getGenerationWeight());
            buf.method_10804(metadata.getConnectionLayerDepth());
            buf.method_10804(metadata.getMinGenerationHeight());
            buf.method_10804(metadata.getMaxGenerationHeight());
            buf.writeBoolean(metadata.isGenerateOnSurface());
            Map<String, JsonElement> attributes = metadata.getCustomAttributes();
            buf.method_10804(attributes.size());
            for (Map.Entry<String, JsonElement> entry : attributes.entrySet()) {
                buf.method_10814(entry.getKey());
                buf.method_10814(GSON.toJson(entry.getValue()));
            }
        }
    }

    public static List<TemplateMetadata> decode(class_2540 buf) {
        int count = buf.method_10816();
        ArrayList<TemplateMetadata> list = new ArrayList<TemplateMetadata>(count);
        for (int i = 0; i < count; ++i) {
            String templateId = buf.method_19772();
            String name = TemplateListResponsePacket.emptyToNull(buf.method_19772());
            String category = TemplateListResponsePacket.emptyToNull(buf.method_19772());
            String description = TemplateListResponsePacket.emptyToNull(buf.method_19772());
            class_2338 size = TemplateListResponsePacket.readNullableBlockPos(buf);
            class_2338 entrance = TemplateListResponsePacket.readNullableBlockPos(buf);
            String author = TemplateListResponsePacket.emptyToNull(buf.method_19772());
            long createdTime = buf.readLong();
            int totalBlocks = buf.method_10816();
            float playerYaw = buf.readFloat();
            String fileName = null;
            if (buf.readBoolean()) {
                fileName = buf.method_19772();
            }
            long fileSize = buf.readLong();
            int blockCountSize = buf.method_10816();
            LinkedHashMap<String, Integer> blockCount = new LinkedHashMap<String, Integer>(blockCountSize);
            for (int j = 0; j < blockCountSize; ++j) {
                String key = buf.method_19772();
                int value = buf.method_10816();
                blockCount.put(key, value);
            }
            TemplateMetadata metadata = new TemplateMetadata(name, category, description, size, entrance, author, createdTime, totalBlocks, blockCount, fileName, fileSize, playerYaw);
            metadata.setTemplateId(templateId.isEmpty() ? null : templateId);
            boolean enableGeneration = buf.readBoolean();
            metadata.setGenerationEnabled(enableGeneration);
            metadata.setGenerationWeight(buf.method_10816());
            metadata.setConnectionLayerDepth(buf.method_10816());
            metadata.setMinGenerationHeight(buf.method_10816());
            metadata.setMaxGenerationHeight(buf.method_10816());
            metadata.setGenerateOnSurface(buf.readBoolean());
            int attributeCount = buf.method_10816();
            LinkedHashMap<String, JsonElement> customAttributes = new LinkedHashMap<String, JsonElement>(attributeCount);
            for (int j = 0; j < attributeCount; ++j) {
                String key = buf.method_19772();
                String json = buf.method_19772();
                customAttributes.put(key, JsonParser.parseString((String)json));
            }
            metadata.setCustomAttributes(customAttributes);
            list.add(metadata);
        }
        return list;
    }

    private static String nullToEmpty(String value) {
        return value == null ? "" : value;
    }

    private static String emptyToNull(String value) {
        return value.isEmpty() ? null : value;
    }

    private static void writeNullableBlockPos(class_2540 buf, class_2338 pos) {
        if (pos == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.method_10807(pos);
        }
    }

    private static class_2338 readNullableBlockPos(class_2540 buf) {
        if (!buf.readBoolean()) {
            return null;
        }
        return buf.method_10811();
    }
}

