/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets.warehouse;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import ydmsama.hundred_years_war.main.network.packets.warehouse.WarehouseItemData;

public class WarehouseDataSyncPacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "warehouse_data_sync");
    private final class_2338 blockPos;
    private final List<WarehouseItemData> items;
    private final int totalCapacity;
    private final int usedCapacity;
    private final String sortType;
    private final boolean sortAscending;

    public WarehouseDataSyncPacket(class_2338 blockPos, List<WarehouseItemData> items, int totalCapacity, int usedCapacity, String sortType, boolean sortAscending) {
        this.blockPos = blockPos;
        this.items = items;
        this.totalCapacity = totalCapacity;
        this.usedCapacity = usedCapacity;
        this.sortType = sortType;
        this.sortAscending = sortAscending;
    }

    public WarehouseDataSyncPacket(class_2338 blockPos, List<WarehouseItemData> items, int totalCapacity, int usedCapacity) {
        this(blockPos, items, totalCapacity, usedCapacity, "NAME", true);
    }

    public static WarehouseDataSyncPacket fromItemStacks(class_2338 blockPos, List<class_1799> itemStacks, int totalCapacity, int usedCapacity) {
        ArrayList<WarehouseItemData> itemDataList = new ArrayList<WarehouseItemData>();
        for (class_1799 stack : itemStacks) {
            itemDataList.add(new WarehouseItemData(stack, stack.method_7947()));
        }
        return new WarehouseDataSyncPacket(blockPos, itemDataList, totalCapacity, usedCapacity);
    }

    public static void encode(WarehouseDataSyncPacket packet, class_2540 buf) {
        buf.method_10807(packet.blockPos);
        buf.writeInt(packet.totalCapacity);
        buf.writeInt(packet.usedCapacity);
        buf.method_10814(packet.sortType);
        buf.writeBoolean(packet.sortAscending);
        buf.writeInt(packet.items.size());
        for (WarehouseItemData item : packet.items) {
            item.encode(buf);
        }
    }

    public static WarehouseDataSyncPacket decode(class_2540 buf) {
        class_2338 pos = buf.method_10811();
        int totalCapacity = buf.readInt();
        int usedCapacity = buf.readInt();
        String sortType = buf.method_19772();
        boolean sortAscending = buf.readBoolean();
        int itemCount = buf.readInt();
        ArrayList<WarehouseItemData> items = new ArrayList<WarehouseItemData>();
        for (int i = 0; i < itemCount; ++i) {
            items.add(WarehouseItemData.decode(buf));
        }
        return new WarehouseDataSyncPacket(pos, items, totalCapacity, usedCapacity, sortType, sortAscending);
    }

    public class_2338 getBlockPos() {
        return this.blockPos;
    }

    public List<WarehouseItemData> getItemData() {
        return this.items;
    }

    public List<class_1799> getDisplayItems() {
        ArrayList<class_1799> displayItems = new ArrayList<class_1799>();
        for (WarehouseItemData data : this.items) {
            class_1799 display = data.getItemType();
            display.method_7939(data.getActualCount());
            displayItems.add(display);
        }
        return displayItems;
    }

    public int getTotalCapacity() {
        return this.totalCapacity;
    }

    public int getUsedCapacity() {
        return this.usedCapacity;
    }

    public String getSortType() {
        return this.sortType;
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }
}

