/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.spawn;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import ydmsama.hundred_years_war.main.blocks.ModBlockEntities;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;

public class SpawnPointBlockEntity
extends class_2586 {
    public static final String TAG_ACTIVATION_DISTANCE = "ActivationDistance";
    public static final String TAG_HORIZONTAL_RANGE = "HorizontalRange";
    public static final String TAG_VERTICAL_RANGE = "VerticalRange";
    public static final String TAG_PER_SPAWN = "PerSpawn";
    public static final String TAG_REMAINING = "Remaining";
    public static final String TAG_MIN_INTERVAL = "MinInterval";
    public static final String TAG_MAX_INTERVAL = "MaxInterval";
    public static final String TAG_CURRENT_INTERVAL = "CurrentInterval";
    public static final String TAG_MAX_ACTIVE = "MaxActive";
    public static final String TAG_INFINITE = "Infinite";
    public static final String TAG_RESET_INTERVAL = "ResetInterval";
    public static final String TAG_LAST_ACTIVATION = "LastActivation";
    public static final String TAG_LAST_TICK = "LastTick";
    public static final String TAG_LAST_RESET = "LastReset";
    public static final String TAG_CURRENT_RESET_COOLDOWN = "CurrentResetCooldown";
    public static final String TAG_SPAWN_ENTRIES = "SpawnEntries";
    public static final String TAG_ACTIVE_ENTITIES = "ActiveEntities";
    public static final String TAG_SAVED_STATE = "SavedState";
    public static final String TAG_ACTIVE_COUNT = "ActiveCount";
    public static final String TAG_SHOW_ACTIVATION_RANGE = "ShowActivationRange";
    public static final String TAG_PAUSED = "Paused";
    public static final String TAG_PERIODIC_RESET = "PeriodicReset";
    private double activationDistance = 16.0;
    private double horizontalRange = 4.0;
    private double verticalRange = 2.0;
    private int perSpawnCount = 1;
    private int remainingCount = 20;
    private int minInterval = 5;
    private int maxInterval = 20;
    private int currentInterval = 0;
    private int maxActiveEntities = 5;
    private boolean infiniteSummon = false;
    private long resetInterval = 0L;
    private long currentResetCooldown = 0L;
    private boolean showActivationRange = false;
    private boolean paused = true;
    private boolean periodicReset = false;
    private int trackedActiveEntities = 0;
    private int lastSyncedActiveEntities = -1;
    private long lastActiveSyncTick = -1L;
    private long lastActivationTick = -1L;
    private long lastTickTime = -1L;
    private long lastResetTick = -1L;
    private final List<SpawnEntry> spawnEntries = new ArrayList<SpawnEntry>();
    private final Set<UUID> spawnedEntities = new HashSet<UUID>();
    private SavedState savedState = null;
    private int cachedActiveCount = -1;
    private long lastCountTick = -1L;
    private static final int COUNT_CACHE_INTERVAL = 20;
    private static final int ACTIVE_COUNT_SYNC_INTERVAL = 5;

    public SpawnPointBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.SPAWN_POINT, pos, state);
        this.spawnEntries.add(new SpawnEntry(new class_2960("minecraft", "zombie"), 1, 1, 1));
    }

    public void serverTick() {
        class_1937 level = this.method_10997();
        if (!(level instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)level;
        long gameTime = serverLevel.method_8510();
        long delta = 1L;
        if (this.lastTickTime >= 0L) {
            delta = Math.max(1L, gameTime - this.lastTickTime);
        }
        this.lastTickTime = gameTime;
        boolean needsSync = false;
        if (gameTime - this.lastActiveSyncTick >= 5L) {
            this.countActiveEntitiesInRange((class_1937)serverLevel);
        }
        if (this.periodicReset && this.savedState == null) {
            this.periodicReset = false;
            needsSync = true;
        }
        if (this.paused) {
            if (needsSync) {
                this.method_5431();
                this.sync();
            }
            return;
        }
        int oldInterval = this.currentInterval;
        long oldResetCooldown = this.currentResetCooldown;
        if (this.currentInterval > 0) {
            this.currentInterval = (int)Math.max(0L, (long)this.currentInterval - delta);
            if (this.currentInterval != oldInterval) {
                needsSync = true;
            }
        }
        if (this.periodicReset && this.savedState != null && this.currentResetCooldown > 0L) {
            this.currentResetCooldown = Math.max(0L, this.currentResetCooldown - delta);
            if (this.currentResetCooldown != oldResetCooldown) {
                needsSync = true;
            }
            if (this.currentResetCooldown == 0L && oldResetCooldown > 0L) {
                this.restoreSavedState();
                this.currentResetCooldown = this.resetInterval;
                needsSync = true;
            }
        }
        if (gameTime % 100L == 0L) {
            this.cleanupDeadEntities(serverLevel);
        }
        if (needsSync) {
            this.method_5431();
            this.sync();
        }
        if (this.currentInterval > 0) {
            return;
        }
        if (!this.canAttemptSpawn(serverLevel)) {
            return;
        }
        if (!this.hasNearbyPlayer(serverLevel)) {
            return;
        }
        int spawned = this.performSpawn(serverLevel, serverLevel.field_9229);
        if (spawned > 0) {
            this.lastActivationTick = gameTime;
            this.lastResetTick = gameTime;
            this.currentInterval = this.computeNextInterval(serverLevel.field_9229);
            this.method_5431();
            this.sync();
        }
    }

    private int performSpawn(class_3218 level, class_5819 random) {
        SpawnEntry entry;
        int currentActive;
        int currentActive2;
        int allowed;
        if (this.spawnEntries.isEmpty()) {
            return 0;
        }
        int n = allowed = this.infiniteSummon ? Integer.MAX_VALUE : this.remainingCount;
        if (allowed <= 0) {
            return 0;
        }
        int toSpawn = Math.min(this.perSpawnCount, allowed);
        if (this.maxActiveEntities > 0 && (toSpawn = Math.min(toSpawn, Math.max(0, this.maxActiveEntities - (currentActive2 = this.countActiveEntitiesInRange((class_1937)level))))) <= 0) {
            return 0;
        }
        int spawned = 0;
        for (int i = 0; i < toSpawn && (this.maxActiveEntities <= 0 || (currentActive = this.countActiveEntitiesInRange((class_1937)level)) < this.maxActiveEntities) && (entry = this.chooseEntry(random)) != null; ++i) {
            double z;
            class_1299 entityType = class_7923.field_41177.method_17966(entry.entityId()).orElse(null);
            if (entityType == null) continue;
            double x = (double)this.method_11016().method_10263() + 0.5 + class_3532.method_15366((class_5819)random, (double)(-this.horizontalRange), (double)this.horizontalRange);
            Double groundY = this.findGroundPosition(level, x, z = (double)this.method_11016().method_10260() + 0.5 + class_3532.method_15366((class_5819)random, (double)(-this.horizontalRange), (double)this.horizontalRange));
            double y = groundY != null ? groundY : (double)this.method_11016().method_10264() + class_3532.method_15366((class_5819)random, (double)(-this.verticalRange), (double)this.verticalRange);
            class_1297 entity = entityType.method_5883((class_1937)level);
            if (entity == null) continue;
            if (entity instanceof BaseCombatEntity) {
                BaseCombatEntity baseCombatEntity = (BaseCombatEntity)entity;
                baseCombatEntity.setLevel(entry.level());
                baseCombatEntity.setEquipment(entry.equipmentLevel());
                baseCombatEntity.setRequiresSupply(false);
            }
            entity.method_5808(x, y, z, random.method_43057() * 360.0f, 0.0f);
            if (!level.method_17892(entity)) {
                entity.method_31472();
                continue;
            }
            if (!level.method_30736(entity)) continue;
            this.spawnedEntities.add(entity.method_5667());
            ++spawned;
        }
        if (spawned > 0) {
            if (!this.infiniteSummon) {
                this.remainingCount = Math.max(0, this.remainingCount - spawned);
            }
            this.cachedActiveCount = -1;
            this.countActiveEntitiesInRange((class_1937)level);
        }
        return spawned;
    }

    private Double findGroundPosition(class_3218 level, double x, double z) {
        class_2338 centerPos = this.method_11016();
        int minY = (int)Math.floor((double)centerPos.method_10264() - this.verticalRange);
        int maxY = (int)Math.ceil((double)centerPos.method_10264() + this.verticalRange);
        class_2338.class_2339 checkPos = new class_2338.class_2339();
        int blockX = class_3532.method_15357((double)x);
        int blockZ = class_3532.method_15357((double)z);
        for (int y = maxY; y >= minY; --y) {
            checkPos.method_10103(blockX, y, blockZ);
            class_2680 groundState = level.method_8320((class_2338)checkPos);
            if (!this.isValidGround(level, (class_2338)checkPos, groundState)) continue;
            checkPos.method_10103(blockX, y + 1, blockZ);
            class_2680 aboveState1 = level.method_8320((class_2338)checkPos);
            checkPos.method_10103(blockX, y + 2, blockZ);
            class_2680 aboveState2 = level.method_8320((class_2338)checkPos);
            if (aboveState1.method_26216((class_1922)level, (class_2338)checkPos.method_33098(y + 1)) || aboveState2.method_26216((class_1922)level, (class_2338)checkPos.method_33098(y + 2))) continue;
            return (double)y + 1.0;
        }
        return null;
    }

    private boolean isValidGround(class_3218 level, class_2338 pos, class_2680 state) {
        if (!state.method_26216((class_1922)level, pos)) {
            return false;
        }
        return state.method_26206((class_1922)level, pos, class_2350.field_11036);
    }

    private SpawnEntry chooseEntry(class_5819 random) {
        if (this.spawnEntries.isEmpty()) {
            return null;
        }
        int totalWeight = this.spawnEntries.stream().mapToInt(SpawnEntry::weight).sum();
        if (totalWeight <= 0) {
            return this.spawnEntries.get(0);
        }
        int value = random.method_43048(totalWeight);
        int cumulative = 0;
        for (SpawnEntry entry : this.spawnEntries) {
            if (value >= (cumulative += entry.weight())) continue;
            return entry;
        }
        return this.spawnEntries.get(this.spawnEntries.size() - 1);
    }

    private int computeNextInterval(class_5819 random) {
        int max;
        if (this.minInterval <= 0 && this.maxInterval <= 0) {
            return 0;
        }
        int min = Math.max(0, this.minInterval);
        if (min == (max = Math.max(min, this.maxInterval))) {
            return min;
        }
        return random.method_43048(max - min + 1) + min;
    }

    private boolean canAttemptSpawn(class_3218 serverLevel) {
        int currentActive;
        if (this.spawnEntries.isEmpty()) {
            return false;
        }
        if (!this.infiniteSummon && this.remainingCount <= 0) {
            return false;
        }
        return this.maxActiveEntities <= 0 || (currentActive = this.countActiveEntitiesInRange((class_1937)serverLevel)) < this.maxActiveEntities;
    }

    private void cleanupDeadEntities(class_3218 serverLevel) {
        if (this.spawnedEntities.isEmpty()) {
            return;
        }
        int sizeBefore = this.spawnedEntities.size();
        this.spawnedEntities.removeIf(uuid -> {
            class_1297 entity = serverLevel.method_14190(uuid);
            return entity == null || !entity.method_5805();
        });
        if (this.spawnedEntities.size() != sizeBefore) {
            this.cachedActiveCount = -1;
            this.countActiveEntitiesInRange((class_1937)serverLevel);
        }
    }

    private int countActiveEntitiesInRange(class_1937 level) {
        if (level == null) {
            return this.trackedActiveEntities;
        }
        if (this.activationDistance <= 0.0 || this.spawnedEntities.isEmpty()) {
            this.updateTrackedActiveEntities(level, 0);
            return 0;
        }
        double scanRadius = this.activationDistance;
        class_238 scanBox = new class_238((double)this.method_11016().method_10263() - scanRadius, (double)this.method_11016().method_10264() - scanRadius, (double)this.method_11016().method_10260() - scanRadius, (double)this.method_11016().method_10263() + scanRadius + 1.0, (double)this.method_11016().method_10264() + scanRadius + 1.0, (double)this.method_11016().method_10260() + scanRadius + 1.0);
        List nearbyEntities = level.method_8333((class_1297)null, scanBox, entity -> {
            if (entity == null || !entity.method_5805()) {
                return false;
            }
            return this.spawnedEntities.contains(entity.method_5667());
        });
        this.updateTrackedActiveEntities(level, nearbyEntities.size());
        return nearbyEntities.size();
    }

    public int getActiveEntityCount(class_1937 level) {
        if (level == null) {
            return this.trackedActiveEntities;
        }
        if (level.field_9236) {
            return this.trackedActiveEntities;
        }
        long gameTime = level.method_8510();
        if (this.cachedActiveCount >= 0 && this.lastCountTick >= 0L && gameTime - this.lastCountTick < 20L) {
            return this.cachedActiveCount;
        }
        this.cachedActiveCount = this.countActiveEntitiesInRange(level);
        this.lastCountTick = gameTime;
        return this.cachedActiveCount;
    }

    private void updateTrackedActiveEntities(class_1937 level, int newCount) {
        if (this.trackedActiveEntities == newCount) {
            if (level != null && !level.field_9236) {
                long gameTime = level.method_8510();
                if (this.lastSyncedActiveEntities < 0) {
                    this.lastSyncedActiveEntities = newCount;
                }
                if (this.lastActiveSyncTick < 0L) {
                    this.lastActiveSyncTick = gameTime;
                }
            }
            return;
        }
        this.trackedActiveEntities = newCount;
        if (level == null || level.field_9236) {
            return;
        }
        long gameTime = level.method_8510();
        if (newCount != this.lastSyncedActiveEntities || this.lastSyncedActiveEntities < 0 || gameTime - this.lastActiveSyncTick >= 5L) {
            this.lastSyncedActiveEntities = newCount;
            this.lastActiveSyncTick = gameTime;
            this.method_5431();
            this.sync();
        }
    }

    public void restoreSavedState() {
        class_1937 currentLevel;
        if (this.savedState == null) {
            return;
        }
        this.activationDistance = this.savedState.activationDistance();
        this.horizontalRange = this.savedState.horizontalRange();
        this.verticalRange = this.savedState.verticalRange();
        this.perSpawnCount = this.savedState.perSpawnCount();
        this.remainingCount = this.savedState.remainingCount();
        this.minInterval = this.savedState.minInterval();
        this.maxInterval = this.savedState.maxInterval();
        this.currentInterval = this.savedState.currentInterval();
        this.maxActiveEntities = this.savedState.maxActiveEntities();
        this.infiniteSummon = this.savedState.infiniteSummon();
        this.resetInterval = this.savedState.resetInterval();
        this.spawnEntries.clear();
        this.spawnEntries.addAll(this.savedState.spawnEntries());
        long l = this.lastResetTick = this.method_10997() != null ? this.method_10997().method_8510() : -1L;
        if (this.periodicReset && this.resetInterval > 0L) {
            this.currentResetCooldown = this.resetInterval;
        }
        if ((currentLevel = this.method_10997()) != null && !currentLevel.field_9236) {
            this.cachedActiveCount = -1;
            this.countActiveEntitiesInRange(currentLevel);
        }
        this.method_5431();
        this.sync();
    }

    public void saveCurrentAsInitial() {
        class_1937 currentLevel;
        this.savedState = new SavedState(this.activationDistance, this.horizontalRange, this.verticalRange, this.perSpawnCount, this.remainingCount, this.minInterval, this.maxInterval, this.currentInterval, this.maxActiveEntities, this.infiniteSummon, this.resetInterval, new ArrayList<SpawnEntry>(this.spawnEntries));
        long l = this.lastResetTick = this.method_10997() != null ? this.method_10997().method_8510() : this.lastResetTick;
        if (this.periodicReset && this.resetInterval > 0L) {
            this.currentResetCooldown = this.resetInterval;
        }
        if ((currentLevel = this.method_10997()) != null && !currentLevel.field_9236) {
            this.cachedActiveCount = -1;
            this.countActiveEntitiesInRange(currentLevel);
        }
        this.method_5431();
        this.sync();
    }

    public List<SpawnEntry> getSpawnEntries() {
        return this.spawnEntries;
    }

    public class_2561 getPrimaryEntryName() {
        if (this.spawnEntries.isEmpty()) {
            return null;
        }
        class_2960 id = this.spawnEntries.get(0).entityId();
        return class_7923.field_41177.method_17966(id).map(class_1299::method_5897).orElse((class_2561)class_2561.method_43470((String)id.toString()));
    }

    public void setSpawnEntries(List<SpawnEntry> entries) {
        this.spawnEntries.clear();
        entries.stream().filter(entry -> entry.weight() > 0).forEach(this.spawnEntries::add);
        this.method_5431();
        this.sync();
    }

    public void setActivationDistance(double activationDistance) {
        this.activationDistance = Math.max(0.0, activationDistance);
        this.method_5431();
        this.sync();
    }

    public double getActivationDistance() {
        return this.activationDistance;
    }

    public double getHorizontalRange() {
        return this.horizontalRange;
    }

    public void setHorizontalRange(double horizontalRange) {
        this.horizontalRange = Math.max(0.0, horizontalRange);
        this.method_5431();
        this.sync();
    }

    public double getVerticalRange() {
        return this.verticalRange;
    }

    public void setVerticalRange(double verticalRange) {
        this.verticalRange = Math.max(0.0, verticalRange);
        this.method_5431();
        this.sync();
    }

    public int getPerSpawnCount() {
        return this.perSpawnCount;
    }

    public void setPerSpawnCount(int perSpawnCount) {
        this.perSpawnCount = Math.max(1, perSpawnCount);
        this.method_5431();
        this.sync();
    }

    public int getRemainingCount() {
        return this.remainingCount;
    }

    public void setRemainingCount(int remainingCount) {
        this.remainingCount = Math.max(0, remainingCount);
        this.method_5431();
        this.sync();
    }

    public int getMinInterval() {
        return this.minInterval;
    }

    public void setMinInterval(int minInterval) {
        this.minInterval = Math.max(0, minInterval);
        this.method_5431();
        this.sync();
    }

    public int getMaxInterval() {
        return this.maxInterval;
    }

    public void setMaxInterval(int maxInterval) {
        this.maxInterval = Math.max(0, maxInterval);
        this.method_5431();
        this.sync();
    }

    public int getCurrentInterval() {
        return this.currentInterval;
    }

    public void setCurrentInterval(int currentInterval) {
        this.currentInterval = Math.max(0, currentInterval);
        this.method_5431();
        this.sync();
    }

    public int getMaxActiveEntities() {
        return this.maxActiveEntities;
    }

    public void setMaxActiveEntities(int maxActiveEntities) {
        this.maxActiveEntities = Math.max(0, maxActiveEntities);
        this.method_5431();
        this.sync();
    }

    public boolean isInfiniteSummon() {
        return this.infiniteSummon;
    }

    public void setInfiniteSummon(boolean infiniteSummon) {
        this.infiniteSummon = infiniteSummon;
        this.method_5431();
        this.sync();
    }

    public long getResetInterval() {
        return this.resetInterval;
    }

    public void setResetInterval(long resetInterval) {
        this.resetInterval = Math.max(0L, resetInterval);
        this.method_5431();
        this.sync();
    }

    public long getCurrentResetCooldown() {
        return this.currentResetCooldown;
    }

    public void setCurrentResetCooldown(long currentResetCooldown) {
        this.currentResetCooldown = Math.max(0L, currentResetCooldown);
        this.method_5431();
        this.sync();
    }

    public boolean isShowActivationRange() {
        return this.showActivationRange;
    }

    public void setShowActivationRange(boolean showActivationRange) {
        this.showActivationRange = showActivationRange;
        this.method_5431();
        this.sync();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
        this.method_5431();
        this.sync();
    }

    public boolean isPeriodicResetEnabled() {
        return this.periodicReset;
    }

    public void setPeriodicReset(boolean periodicReset) {
        boolean newValue;
        this.periodicReset = newValue = periodicReset && this.savedState != null;
        if (newValue && this.currentResetCooldown <= 0L && this.resetInterval > 0L) {
            this.currentResetCooldown = this.resetInterval;
        }
        this.method_5431();
        this.sync();
    }

    public void applyConfiguration(double activationDistance, double horizontalRange, double verticalRange, int perSpawnCount, int remainingCount, int minInterval, int maxInterval, int currentInterval, int maxActiveEntities, boolean infiniteSummon, boolean showActivationRange, boolean paused, boolean periodicReset, long resetInterval, long currentResetCooldown, List<SpawnEntry> entries) {
        boolean periodicResetEnabled;
        this.activationDistance = Math.max(0.0, activationDistance);
        this.horizontalRange = Math.max(0.0, horizontalRange);
        this.verticalRange = Math.max(0.0, verticalRange);
        this.perSpawnCount = Math.max(1, perSpawnCount);
        this.remainingCount = Math.max(0, remainingCount);
        this.minInterval = Math.max(0, minInterval);
        this.maxInterval = Math.max(this.minInterval, maxInterval);
        this.currentInterval = Math.max(0, currentInterval);
        this.maxActiveEntities = Math.max(0, maxActiveEntities);
        this.infiniteSummon = infiniteSummon;
        this.showActivationRange = showActivationRange;
        this.paused = paused;
        this.periodicReset = periodicResetEnabled = periodicReset && this.savedState != null;
        this.resetInterval = Math.max(0L, resetInterval);
        this.currentResetCooldown = Math.max(0L, currentResetCooldown);
        if (periodicResetEnabled && this.currentResetCooldown <= 0L && this.resetInterval > 0L) {
            this.currentResetCooldown = this.resetInterval;
        }
        this.spawnEntries.clear();
        entries.stream().filter(entry -> entry.weight() > 0).forEach(this.spawnEntries::add);
        if (this.infiniteSummon) {
            this.remainingCount = 0;
        }
        this.method_5431();
        this.sync();
    }

    public SavedState getSavedState() {
        return this.savedState;
    }

    public long getLastActivationTick() {
        return this.lastActivationTick;
    }

    public long getLastResetTick() {
        return this.lastResetTick;
    }

    public long getLastTickTime() {
        return this.lastTickTime;
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.activationDistance = tag.method_10574(TAG_ACTIVATION_DISTANCE);
        this.horizontalRange = tag.method_10574(TAG_HORIZONTAL_RANGE);
        this.verticalRange = tag.method_10574(TAG_VERTICAL_RANGE);
        this.perSpawnCount = tag.method_10550(TAG_PER_SPAWN);
        this.remainingCount = tag.method_10550(TAG_REMAINING);
        this.minInterval = tag.method_10550(TAG_MIN_INTERVAL);
        this.maxInterval = tag.method_10550(TAG_MAX_INTERVAL);
        this.currentInterval = tag.method_10550(TAG_CURRENT_INTERVAL);
        this.maxActiveEntities = tag.method_10550(TAG_MAX_ACTIVE);
        this.infiniteSummon = tag.method_10577(TAG_INFINITE);
        this.showActivationRange = tag.method_10577(TAG_SHOW_ACTIVATION_RANGE);
        this.paused = tag.method_10577(TAG_PAUSED);
        this.periodicReset = tag.method_10577(TAG_PERIODIC_RESET);
        this.resetInterval = tag.method_10537(TAG_RESET_INTERVAL);
        this.currentResetCooldown = tag.method_10537(TAG_CURRENT_RESET_COOLDOWN);
        this.lastActivationTick = tag.method_10537(TAG_LAST_ACTIVATION);
        this.lastTickTime = tag.method_10537(TAG_LAST_TICK);
        this.lastResetTick = tag.method_10537(TAG_LAST_RESET);
        this.trackedActiveEntities = tag.method_10573(TAG_ACTIVE_COUNT, 3) ? tag.method_10550(TAG_ACTIVE_COUNT) : 0;
        this.lastSyncedActiveEntities = this.trackedActiveEntities;
        this.lastActiveSyncTick = this.field_11863 != null ? this.field_11863.method_8510() : -1L;
        this.spawnEntries.clear();
        class_2499 listTag = tag.method_10554(TAG_SPAWN_ENTRIES, 10);
        for (class_2520 entryTag : listTag) {
            class_2487 entryCompound;
            SpawnEntry entry;
            if (!(entryTag instanceof class_2487) || (entry = SpawnEntry.fromTag(entryCompound = (class_2487)entryTag)) == null) continue;
            this.spawnEntries.add(entry);
        }
        this.spawnedEntities.clear();
        class_2499 activeList = tag.method_10554(TAG_ACTIVE_ENTITIES, 10);
        for (class_2520 activeTag : activeList) {
            if (!(activeTag instanceof class_2487)) continue;
            class_2487 compoundTag = (class_2487)activeTag;
            this.spawnedEntities.add(class_2512.method_25930((class_2520)compoundTag));
        }
        this.savedState = tag.method_10573(TAG_SAVED_STATE, 10) ? SavedState.fromTag(tag.method_10562(TAG_SAVED_STATE)) : null;
        if (this.periodicReset && this.savedState == null) {
            this.periodicReset = false;
        }
        if (this.field_11863 == null || this.field_11863.field_9236) {
            // empty if block
        }
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10549(TAG_ACTIVATION_DISTANCE, this.activationDistance);
        tag.method_10549(TAG_HORIZONTAL_RANGE, this.horizontalRange);
        tag.method_10549(TAG_VERTICAL_RANGE, this.verticalRange);
        tag.method_10569(TAG_PER_SPAWN, this.perSpawnCount);
        tag.method_10569(TAG_REMAINING, this.remainingCount);
        tag.method_10569(TAG_MIN_INTERVAL, this.minInterval);
        tag.method_10569(TAG_MAX_INTERVAL, this.maxInterval);
        tag.method_10569(TAG_CURRENT_INTERVAL, this.currentInterval);
        tag.method_10569(TAG_MAX_ACTIVE, this.maxActiveEntities);
        tag.method_10556(TAG_INFINITE, this.infiniteSummon);
        tag.method_10556(TAG_SHOW_ACTIVATION_RANGE, this.showActivationRange);
        tag.method_10556(TAG_PAUSED, this.paused);
        tag.method_10556(TAG_PERIODIC_RESET, this.periodicReset);
        tag.method_10544(TAG_RESET_INTERVAL, this.resetInterval);
        tag.method_10544(TAG_CURRENT_RESET_COOLDOWN, this.currentResetCooldown);
        tag.method_10544(TAG_LAST_ACTIVATION, this.lastActivationTick);
        tag.method_10544(TAG_LAST_TICK, this.lastTickTime);
        tag.method_10544(TAG_LAST_RESET, this.lastResetTick);
        tag.method_10569(TAG_ACTIVE_COUNT, this.trackedActiveEntities);
        class_2499 listTag = new class_2499();
        for (SpawnEntry entry : this.spawnEntries) {
            listTag.add((Object)entry.toTag());
        }
        tag.method_10566(TAG_SPAWN_ENTRIES, (class_2520)listTag);
        class_2499 activeList = new class_2499();
        for (UUID uuid : this.spawnedEntities) {
            activeList.add((Object)class_2512.method_25929((UUID)uuid));
        }
        tag.method_10566(TAG_ACTIVE_ENTITIES, (class_2520)activeList);
        if (this.savedState != null) {
            tag.method_10566(TAG_SAVED_STATE, (class_2520)this.savedState.toTag());
        }
    }

    public class_2487 method_16887() {
        class_2487 tag = this.method_38244();
        if (this.field_11863 == null || !this.field_11863.field_9236) {
            // empty if block
        }
        return tag;
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public void sync() {
        class_1937 level = this.method_10997();
        if (level == null) {
            return;
        }
        level.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
    }

    public void method_38240(class_1799 stack) {
        class_2487 tag = this.createItemExportTag();
        class_1747.method_38073((class_1799)stack, (class_2591)this.method_11017(), (class_2487)tag);
    }

    private class_2487 createItemExportTag() {
        class_2487 tag = this.method_38244();
        tag.method_10566(TAG_ACTIVE_ENTITIES, (class_2520)new class_2499());
        tag.method_10569(TAG_ACTIVE_COUNT, 0);
        tag.method_10544(TAG_LAST_ACTIVATION, -1L);
        tag.method_10544(TAG_LAST_TICK, -1L);
        tag.method_10544(TAG_LAST_RESET, -1L);
        int clampedInterval = Math.max(0, tag.method_10550(TAG_CURRENT_INTERVAL));
        tag.method_10569(TAG_CURRENT_INTERVAL, clampedInterval);
        long clampedReset = Math.max(0L, tag.method_10537(TAG_CURRENT_RESET_COOLDOWN));
        tag.method_10544(TAG_CURRENT_RESET_COOLDOWN, clampedReset);
        return tag;
    }

    private boolean hasNearbyPlayer(class_3218 level) {
        if (this.activationDistance <= 0.0) {
            return true;
        }
        return level.method_18459((double)this.method_11016().method_10263() + 0.5, (double)this.method_11016().method_10264() + 0.5, (double)this.method_11016().method_10260() + 0.5, this.activationDistance, false) != null;
    }

    public record SavedState(double activationDistance, double horizontalRange, double verticalRange, int perSpawnCount, int remainingCount, int minInterval, int maxInterval, int currentInterval, int maxActiveEntities, boolean infiniteSummon, long resetInterval, List<SpawnEntry> spawnEntries) {
        public class_2487 toTag() {
            class_2487 tag = new class_2487();
            tag.method_10549(SpawnPointBlockEntity.TAG_ACTIVATION_DISTANCE, this.activationDistance);
            tag.method_10549(SpawnPointBlockEntity.TAG_HORIZONTAL_RANGE, this.horizontalRange);
            tag.method_10549(SpawnPointBlockEntity.TAG_VERTICAL_RANGE, this.verticalRange);
            tag.method_10569(SpawnPointBlockEntity.TAG_PER_SPAWN, this.perSpawnCount);
            tag.method_10569(SpawnPointBlockEntity.TAG_REMAINING, this.remainingCount);
            tag.method_10569(SpawnPointBlockEntity.TAG_MIN_INTERVAL, this.minInterval);
            tag.method_10569(SpawnPointBlockEntity.TAG_MAX_INTERVAL, this.maxInterval);
            tag.method_10569(SpawnPointBlockEntity.TAG_CURRENT_INTERVAL, this.currentInterval);
            tag.method_10569(SpawnPointBlockEntity.TAG_MAX_ACTIVE, this.maxActiveEntities);
            tag.method_10556(SpawnPointBlockEntity.TAG_INFINITE, this.infiniteSummon);
            tag.method_10544(SpawnPointBlockEntity.TAG_RESET_INTERVAL, this.resetInterval);
            class_2499 listTag = new class_2499();
            for (SpawnEntry entry : this.spawnEntries) {
                listTag.add((Object)entry.toTag());
            }
            tag.method_10566(SpawnPointBlockEntity.TAG_SPAWN_ENTRIES, (class_2520)listTag);
            return tag;
        }

        public static SavedState fromTag(class_2487 tag) {
            double activationDistance = tag.method_10574(SpawnPointBlockEntity.TAG_ACTIVATION_DISTANCE);
            double horizontalRange = tag.method_10574(SpawnPointBlockEntity.TAG_HORIZONTAL_RANGE);
            double verticalRange = tag.method_10574(SpawnPointBlockEntity.TAG_VERTICAL_RANGE);
            int perSpawn = tag.method_10550(SpawnPointBlockEntity.TAG_PER_SPAWN);
            int remaining = tag.method_10550(SpawnPointBlockEntity.TAG_REMAINING);
            int minInterval = tag.method_10550(SpawnPointBlockEntity.TAG_MIN_INTERVAL);
            int maxInterval = tag.method_10550(SpawnPointBlockEntity.TAG_MAX_INTERVAL);
            int currentInterval = tag.method_10550(SpawnPointBlockEntity.TAG_CURRENT_INTERVAL);
            int maxActive = tag.method_10550(SpawnPointBlockEntity.TAG_MAX_ACTIVE);
            boolean infinite = tag.method_10577(SpawnPointBlockEntity.TAG_INFINITE);
            long reset = tag.method_10537(SpawnPointBlockEntity.TAG_RESET_INTERVAL);
            ArrayList entries = Lists.newArrayList();
            class_2499 listTag = tag.method_10554(SpawnPointBlockEntity.TAG_SPAWN_ENTRIES, 10);
            for (class_2520 entryTag : listTag) {
                class_2487 entryCompound;
                SpawnEntry entry;
                if (!(entryTag instanceof class_2487) || (entry = SpawnEntry.fromTag(entryCompound = (class_2487)entryTag)) == null) continue;
                entries.add(entry);
            }
            return new SavedState(activationDistance, horizontalRange, verticalRange, perSpawn, remaining, minInterval, maxInterval, currentInterval, maxActive, infinite, reset, entries);
        }
    }

    public record SpawnEntry(class_2960 entityId, int weight, int level, int equipmentLevel) {
        public SpawnEntry {
            weight = Math.max(1, weight);
            level = Math.max(1, level);
            equipmentLevel = Math.max(1, equipmentLevel);
        }

        public static SpawnEntry fromTag(class_2487 tag) {
            if (!tag.method_10545("id")) {
                return null;
            }
            class_2960 id = new class_2960(tag.method_10558("id"));
            int weight = tag.method_10550("weight");
            if (weight <= 0) {
                return null;
            }
            int level = tag.method_10545("level") ? Math.max(1, tag.method_10550("level")) : 1;
            int equipmentLevel = tag.method_10545("equipment_level") ? Math.max(1, tag.method_10550("equipment_level")) : level;
            return new SpawnEntry(id, weight, level, equipmentLevel);
        }

        public class_2487 toTag() {
            class_2487 tag = new class_2487();
            tag.method_10582("id", this.entityId.toString());
            tag.method_10569("weight", Math.max(1, this.weight));
            tag.method_10569("level", Math.max(1, this.level));
            tag.method_10569("equipment_level", Math.max(1, this.equipmentLevel));
            return tag;
        }
    }
}

