/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.supply;

public final class SupplyDataEncoding {
    private static final int DATA_SCALE = 10;
    private static final int MAX_ENCODED_VALUE = Short.MAX_VALUE;

    private SupplyDataEncoding() {
    }

    public static int encode(double value) {
        if (Double.isNaN(value) || value <= 0.0) {
            return 0;
        }
        int scaled = (int)Math.round(value * 10.0);
        return Math.min(Short.MAX_VALUE, scaled);
    }

    public static double decode(int encoded) {
        int clamped = Math.max(0, Math.min(encoded, Short.MAX_VALUE));
        return (double)clamped / 10.0;
    }

    public static boolean isClamped(int encoded) {
        return encoded >= Short.MAX_VALUE;
    }

    public static double getClampValue() {
        return 3276.7;
    }
}

