/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.supply;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import ydmsama.hundred_years_war.main.config.ServerModConfig;
import ydmsama.hundred_years_war.main.entity.utils.BaseCombatSupport;
import ydmsama.hundred_years_war.main.supply.SupplyPointBlockEntity;
import ydmsama.hundred_years_war.main.utils.RelationSystem;

public class SupplyManager {
    private static final Map<UUID, SupplyRelation> entityRelations = new ConcurrentHashMap<UUID, SupplyRelation>();
    private static final Map<UUID, SupplySource> supplySources = new ConcurrentHashMap<UUID, SupplySource>();
    private static final Map<UUID, Long> lastDamageTime = new ConcurrentHashMap<UUID, Long>();
    private static final Map<UUID, Long> noSupplyStartTime = new ConcurrentHashMap<UUID, Long>();
    private static final double SUPPLY_RANGE = 100.0;
    private static final long SUPPLY_CHECK_INTERVAL = 1200000L;
    private static final long DAMAGE_INTERVAL = 10000L;
    private static final long DAMAGE_START_DELAY = 60000L;
    private static final int NO_SUPPLY_EFFECT_DURATION = 24000;
    private static final int NO_SUPPLY_WEAKNESS_LEVEL = 3;
    private static final int NO_SUPPLY_SLOWNESS_LEVEL = 1;
    private static final float MIN_SUPPLY_DAMAGE_HEALTH = 2.0f;
    private static final double TICKS_PER_MINECRAFT_DAY = 24000.0;

    public static void tick(class_3218 level) {
        if (!ServerModConfig.INSTANCE.isEnableSupplySystem()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        HashSet<UUID> relationsToRemove = new HashSet<UUID>();
        HashMap<UUID, BaseCombatSupport> relationsToReestablish = new HashMap<UUID, BaseCombatSupport>();
        for (Map.Entry<UUID, SupplyRelation> entry : entityRelations.entrySet()) {
            UUID entityId2 = entry.getKey();
            SupplyRelation relation = entry.getValue();
            class_1297 entity = level.method_14190(entityId2);
            if (entity instanceof BaseCombatSupport) {
                Long lastDamage;
                BaseCombatSupport combatEntity = (BaseCombatSupport)entity;
                if (!combatEntity.requiresSupply() || !entity.method_5805()) {
                    relationsToRemove.add(entityId2);
                    continue;
                }
                relation.updateEntityPos(entity.method_24515());
                if (relation.getDistance() > 100.0) {
                    relationsToRemove.add(entityId2);
                    relationsToReestablish.put(entityId2, combatEntity);
                    continue;
                }
                SupplySource source = supplySources.get(relation.getSourceId());
                if (source == null) {
                    relationsToRemove.add(entityId2);
                    relationsToReestablish.put(entityId2, combatEntity);
                    continue;
                }
                if (!SupplyManager.isSourceFriendlyWithEntity(source, combatEntity)) {
                    relationsToRemove.add(entityId2);
                    relationsToReestablish.put(entityId2, combatEntity);
                    continue;
                }
                double dailyConsumption = Math.max(0.0, combatEntity.getDailySupplyConsumption());
                relation.setDailyConsumption(dailyConsumption);
                double consumptionPerTick = dailyConsumption / 24000.0;
                if (source.getSupplyValue() <= 0.0 || consumptionPerTick > 0.0 && source.getSupplyValue() < consumptionPerTick) {
                    relationsToRemove.add(entityId2);
                    relationsToReestablish.put(entityId2, combatEntity);
                    continue;
                }
                if (source.consumeSupply(consumptionPerTick)) {
                    relation.updateSupplyTime();
                    combatEntity.asLivingEntity().method_6016(class_1294.field_5903);
                    combatEntity.asLivingEntity().method_6016(class_1294.field_5909);
                    combatEntity.asLivingEntity().method_6016(class_1294.field_5911);
                    noSupplyStartTime.remove(entityId2);
                    continue;
                }
                SupplyManager.applyNoSupplyEffects(combatEntity, entityId2, currentTime, level);
                if (!relation.isExpired() || (lastDamage = lastDamageTime.get(entityId2)) != null && currentTime - lastDamage <= 10000L) continue;
                combatEntity.asLivingEntity().method_5643(combatEntity.asLivingEntity().method_48923().method_48825(), 1.0f);
                lastDamageTime.put(entityId2, currentTime);
                continue;
            }
            if (entity != null && entity.method_5805()) continue;
            relationsToRemove.add(entityId2);
        }
        if (!relationsToRemove.isEmpty()) {
            for (UUID entityId3 : relationsToRemove) {
                SupplyManager.removeSupplyRelation(entityId3);
            }
        }
        if (!relationsToReestablish.isEmpty()) {
            for (BaseCombatSupport combatEntity : relationsToReestablish.values()) {
                SupplyManager.tryEstablishSupply(combatEntity, (class_1937)level);
            }
        }
        Iterator<Map.Entry<UUID, SupplySource>> sourceIterator = supplySources.entrySet().iterator();
        while (sourceIterator.hasNext()) {
            class_2586 blockEntity;
            Map.Entry<UUID, SupplySource> sourceEntry = sourceIterator.next();
            SupplySource source = sourceEntry.getValue();
            source.getSuppliedEntities().removeIf(entityId -> !entityRelations.containsKey(entityId));
            if (source.getSupplyValue() <= 0.0 && !source.getSuppliedEntities().isEmpty()) {
                for (UUID entityId4 : new ArrayList<UUID>(source.getSuppliedEntities())) {
                    SupplyManager.removeSupplyRelation(entityId4);
                    class_1297 entity = level.method_14190(entityId4);
                    if (!(entity instanceof BaseCombatSupport)) continue;
                    BaseCombatSupport combatEntity = (BaseCombatSupport)entity;
                    SupplyManager.tryEstablishSupply(combatEntity, (class_1937)level);
                }
            }
            if (source.getType() != SupplySourceType.SUPPLY_POINT || (blockEntity = SupplyManager.findSupplyPointBlockEntity((class_1937)level, source.getId())) != null) continue;
            for (UUID entityId5 : new ArrayList<UUID>(source.getSuppliedEntities())) {
                SupplyManager.removeSupplyRelation(entityId5);
            }
            sourceIterator.remove();
        }
    }

    public static void tryEstablishSupply(BaseCombatSupport entity, class_1937 level) {
        if (!entity.requiresSupply()) {
            return;
        }
        if (!ServerModConfig.INSTANCE.isEnableSupplySystem()) {
            return;
        }
        class_1309 livingEntity = entity.asLivingEntity();
        UUID entityId = livingEntity.method_5667();
        if (entityRelations.containsKey(entityId)) {
            return;
        }
        class_2338 entityPos = livingEntity.method_24515();
        SupplySource nearestSource = null;
        double nearestDistance = 101.0;
        class_2338 nearestSourcePos = null;
        for (Map.Entry<UUID, SupplySource> entry : supplySources.entrySet()) {
            double distance;
            class_1657 player;
            SupplySource source = entry.getValue();
            class_2338 sourcePos = null;
            if (source.getType() == SupplySourceType.SUPPLY_POINT) {
                class_2586 blockEntity;
                sourcePos = source.getBlockPos();
                if (sourcePos != null && !((blockEntity = level.method_8321(sourcePos)) instanceof SupplyPointBlockEntity)) {
                    sourcePos = null;
                }
            } else if (source.getType() == SupplySourceType.PLAYER && (player = level.method_18470(source.getId())) != null) {
                sourcePos = player.method_24515();
            }
            if (sourcePos == null || !((distance = Math.sqrt(entityPos.method_10262((class_2382)sourcePos))) < nearestDistance) || !(distance <= 100.0) || !(source.getSupplyValue() > 0.0) || !SupplyManager.isSourceFriendlyWithEntity(source, entity)) continue;
            nearestSource = source;
            nearestDistance = distance;
            nearestSourcePos = sourcePos;
        }
        if (nearestSource != null) {
            SupplyRelation relation = new SupplyRelation(entityId, nearestSource.getId(), nearestSource.getType(), entityPos, nearestSourcePos);
            relation.setDailyConsumption(Math.max(0.0, entity.getDailySupplyConsumption()));
            entityRelations.put(entityId, relation);
            nearestSource.getSuppliedEntities().add(entityId);
        } else if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            SupplyManager.applyNoSupplyEffects(entity, entityId, System.currentTimeMillis(), serverLevel);
        }
    }

    public static void removeSupplyRelation(UUID entityId) {
        SupplySource source;
        SupplyRelation relation = entityRelations.remove(entityId);
        if (relation != null && (source = supplySources.get(relation.getSourceId())) != null) {
            source.getSuppliedEntities().remove(entityId);
        }
        lastDamageTime.remove(entityId);
        noSupplyStartTime.remove(entityId);
    }

    public static void registerSupplySource(UUID sourceId, SupplySourceType type, double maxSupply) {
        SupplySource source = supplySources.get(sourceId);
        if (source == null) {
            source = new SupplySource(sourceId, type, maxSupply);
            supplySources.put(sourceId, source);
        } else {
            source.setMaxSupplyValue(maxSupply);
        }
        if (type == SupplySourceType.PLAYER && source.getOwnerId() == null) {
            source.setOwnerId(sourceId);
        }
    }

    public static void registerSupplySource(UUID sourceId, SupplySourceType type, double maxSupply, class_2338 blockPos) {
        SupplySource source = supplySources.get(sourceId);
        if (source == null) {
            source = new SupplySource(sourceId, type, maxSupply, blockPos);
            supplySources.put(sourceId, source);
        } else {
            source.setMaxSupplyValue(maxSupply);
            source.setBlockPos(blockPos);
        }
        if (type == SupplySourceType.PLAYER && source.getOwnerId() == null) {
            source.setOwnerId(sourceId);
        }
    }

    public static void unregisterSupplySource(UUID sourceId) {
        SupplySource source = supplySources.remove(sourceId);
        if (source != null) {
            for (UUID entityId : source.getSuppliedEntities()) {
                entityRelations.remove(entityId);
                lastDamageTime.remove(entityId);
                noSupplyStartTime.remove(entityId);
            }
        }
    }

    public static SupplySource getSupplySource(UUID sourceId) {
        return supplySources.get(sourceId);
    }

    public static double convertFoodToSupply(int foodValue) {
        return (double)foodValue * 0.5;
    }

    public static double getDailyConsumption(UUID sourceId) {
        SupplySource source = supplySources.get(sourceId);
        if (source == null) {
            return 0.0;
        }
        double totalConsumption = 0.0;
        for (UUID entityId : source.getSuppliedEntities()) {
            SupplyRelation relation = entityRelations.get(entityId);
            if (relation == null || !relation.getSourceId().equals(sourceId)) continue;
            totalConsumption += Math.max(0.0, relation.getDailyConsumption());
        }
        return totalConsumption;
    }

    private static class_2586 findSupplyPointBlockEntity(class_1937 level, UUID blockEntityId) {
        SupplySource source = supplySources.get(blockEntityId);
        if (source != null && source.getBlockPos() != null) {
            return level.method_8321(source.getBlockPos());
        }
        return null;
    }

    public static void saveData(Path savePath) throws IOException {
        class_2487 rootTag = new class_2487();
        class_2499 relationsList = new class_2499();
        for (SupplyRelation supplyRelation : entityRelations.values()) {
            relationsList.add((Object)supplyRelation.saveToNbt());
        }
        rootTag.method_10566("Relations", (class_2520)relationsList);
        class_2499 sourcesList = new class_2499();
        for (SupplySource supplySource : supplySources.values()) {
            sourcesList.add((Object)supplySource.saveToNbt());
        }
        rootTag.method_10566("Sources", (class_2520)sourcesList);
        class_2499 class_24992 = new class_2499();
        for (Map.Entry<UUID, Long> entry : lastDamageTime.entrySet()) {
            class_2487 damageTag = new class_2487();
            damageTag.method_25927("EntityId", entry.getKey());
            damageTag.method_10544("LastDamage", entry.getValue().longValue());
            class_24992.add((Object)damageTag);
        }
        rootTag.method_10566("DamageTimes", (class_2520)class_24992);
        class_2499 class_24993 = new class_2499();
        for (Map.Entry<UUID, Long> entry : noSupplyStartTime.entrySet()) {
            class_2487 noSupplyTag = new class_2487();
            noSupplyTag.method_25927("EntityId", entry.getKey());
            noSupplyTag.method_10544("StartTime", entry.getValue().longValue());
            class_24993.add((Object)noSupplyTag);
        }
        rootTag.method_10566("NoSupplyTimes", (class_2520)class_24993);
        class_2507.method_30614((class_2487)rootTag, (File)savePath.toFile());
    }

    public static void loadData(Path savePath) {
        entityRelations.clear();
        supplySources.clear();
        lastDamageTime.clear();
        noSupplyStartTime.clear();
        if (Files.exists(savePath, new LinkOption[0])) {
            try {
                class_2487 rootTag = class_2507.method_30613((File)savePath.toFile());
                class_2499 relationsList = rootTag.method_10554("Relations", 10);
                for (int i = 0; i < relationsList.size(); ++i) {
                    SupplyRelation relation = SupplyRelation.loadFromNbt(relationsList.method_10602(i));
                    entityRelations.put(relation.getEntityId(), relation);
                }
                class_2499 sourcesList = rootTag.method_10554("Sources", 10);
                for (int i = 0; i < sourcesList.size(); ++i) {
                    SupplySource source = SupplySource.loadFromNbt(sourcesList.method_10602(i));
                    if (source.getType() == SupplySourceType.PLAYER && source.getOwnerId() == null) {
                        source.setOwnerId(source.getId());
                    }
                    supplySources.put(source.getId(), source);
                }
                class_2499 damageList = rootTag.method_10554("DamageTimes", 10);
                for (int i = 0; i < damageList.size(); ++i) {
                    class_2487 damageTag = damageList.method_10602(i);
                    lastDamageTime.put(damageTag.method_25926("EntityId"), damageTag.method_10537("LastDamage"));
                }
                if (rootTag.method_10545("NoSupplyTimes")) {
                    class_2499 noSupplyList = rootTag.method_10554("NoSupplyTimes", 10);
                    for (int i = 0; i < noSupplyList.size(); ++i) {
                        class_2487 noSupplyTag = noSupplyList.method_10602(i);
                        noSupplyStartTime.put(noSupplyTag.method_25926("EntityId"), noSupplyTag.method_10537("StartTime"));
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Map<UUID, SupplyRelation> getEntityRelations() {
        return new HashMap<UUID, SupplyRelation>(entityRelations);
    }

    public static Map<UUID, SupplySource> getSupplySources() {
        return new HashMap<UUID, SupplySource>(supplySources);
    }

    public static void setSupplySourceOwner(UUID sourceId, UUID ownerId) {
        SupplySource source = supplySources.get(sourceId);
        if (source != null) {
            source.setOwnerId(ownerId);
        }
    }

    public static boolean hasActiveSupply(BaseCombatSupport entity) {
        if (entity == null) {
            return false;
        }
        if (!ServerModConfig.INSTANCE.isEnableSupplySystem()) {
            return true;
        }
        if (!entity.requiresSupply()) {
            return true;
        }
        SupplyRelation relation = entityRelations.get(entity.getUUID());
        return relation != null && !relation.isExpired();
    }

    private static boolean isSourceFriendlyWithEntity(SupplySource source, BaseCombatSupport entity) {
        UUID sourceOwner;
        if (source == null || entity == null) {
            return false;
        }
        UUID entityOwner = entity.method_6139();
        if (entityOwner == null) {
            return false;
        }
        if (source.getType() == SupplySourceType.PLAYER && source.getOwnerId() == null) {
            source.setOwnerId(source.getId());
        }
        if ((sourceOwner = source.getOwnerId()) == null) {
            return true;
        }
        if (sourceOwner.equals(entityOwner)) {
            return true;
        }
        RelationSystem.RelationType forward = RelationSystem.getRelation(sourceOwner, entityOwner);
        RelationSystem.RelationType backward = RelationSystem.getRelation(entityOwner, sourceOwner);
        if (forward == RelationSystem.RelationType.HOSTILE || backward == RelationSystem.RelationType.HOSTILE) {
            return false;
        }
        return forward == RelationSystem.RelationType.FRIENDLY || forward == RelationSystem.RelationType.CONTROL || backward == RelationSystem.RelationType.FRIENDLY || backward == RelationSystem.RelationType.CONTROL;
    }

    private static void applyNoSupplyEffects(BaseCombatSupport entity, UUID entityId, long currentTime, class_3218 level) {
        noSupplyStartTime.putIfAbsent(entityId, currentTime);
        long noSupplyDuration = currentTime - noSupplyStartTime.get(entityId);
        class_1309 livingEntity = entity.asLivingEntity();
        livingEntity.method_6092(new class_1293(class_1294.field_5903, 60, 0, false, false));
        livingEntity.method_6092(new class_1293(class_1294.field_5909, 24000, Math.max(0, 0), false, false));
        livingEntity.method_6092(new class_1293(class_1294.field_5911, 24000, Math.max(0, 2), false, false));
        if (livingEntity.field_6012 % 40 == 0) {
            level.method_14199((class_2394)class_2398.field_11231, livingEntity.method_23317(), livingEntity.method_23318() + (double)livingEntity.method_17682() + 0.3, livingEntity.method_23321(), 1, 0.3, 0.3, 0.3, 0.0);
        }
        if (noSupplyDuration > 60000L) {
            Long lastDamage = lastDamageTime.get(entityId);
            if (livingEntity.method_6032() > 2.0f && (lastDamage == null || currentTime - lastDamage > 10000L)) {
                livingEntity.method_5643(livingEntity.method_48923().method_48825(), 1.0f);
                lastDamageTime.put(entityId, currentTime);
            }
        }
    }

    public static class SupplyRelation {
        private final UUID entityId;
        private final UUID sourceId;
        private final SupplySourceType sourceType;
        private class_2338 lastKnownEntityPos;
        private class_2338 sourcePos;
        private long lastSupplyTime;
        private long establishedTime;
        private double dailyConsumption;

        public SupplyRelation(UUID entityId, UUID sourceId, SupplySourceType sourceType, class_2338 entityPos, class_2338 sourcePos) {
            this.entityId = entityId;
            this.sourceId = sourceId;
            this.sourceType = sourceType;
            this.lastKnownEntityPos = entityPos;
            this.sourcePos = sourcePos;
            this.lastSupplyTime = System.currentTimeMillis();
            this.establishedTime = System.currentTimeMillis();
            this.dailyConsumption = 0.0;
        }

        public void updateEntityPos(class_2338 pos) {
            this.lastKnownEntityPos = pos;
        }

        public void updateSupplyTime() {
            this.lastSupplyTime = System.currentTimeMillis();
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.lastSupplyTime > 1200000L;
        }

        public double getDistance() {
            if (this.lastKnownEntityPos == null || this.sourcePos == null) {
                return Double.MAX_VALUE;
            }
            return Math.sqrt(this.lastKnownEntityPos.method_10262((class_2382)this.sourcePos));
        }

        public class_2487 saveToNbt() {
            class_2487 tag = new class_2487();
            tag.method_25927("EntityId", this.entityId);
            tag.method_25927("SourceId", this.sourceId);
            tag.method_10582("SourceType", this.sourceType.name());
            tag.method_10549("DailyConsumption", this.dailyConsumption);
            if (this.lastKnownEntityPos != null) {
                tag.method_10544("EntityPos", this.lastKnownEntityPos.method_10063());
            }
            if (this.sourcePos != null) {
                tag.method_10544("SourcePos", this.sourcePos.method_10063());
            }
            tag.method_10544("LastSupplyTime", this.lastSupplyTime);
            tag.method_10544("EstablishedTime", this.establishedTime);
            return tag;
        }

        public static SupplyRelation loadFromNbt(class_2487 tag) {
            UUID entityId = tag.method_25926("EntityId");
            UUID sourceId = tag.method_25926("SourceId");
            SupplySourceType sourceType = SupplySourceType.valueOf(tag.method_10558("SourceType"));
            class_2338 entityPos = tag.method_10545("EntityPos") ? class_2338.method_10092((long)tag.method_10537("EntityPos")) : null;
            class_2338 sourcePos = tag.method_10545("SourcePos") ? class_2338.method_10092((long)tag.method_10537("SourcePos")) : null;
            SupplyRelation relation = new SupplyRelation(entityId, sourceId, sourceType, entityPos, sourcePos);
            relation.lastSupplyTime = tag.method_10537("LastSupplyTime");
            relation.establishedTime = tag.method_10537("EstablishedTime");
            relation.dailyConsumption = Math.max(0.0, tag.method_10574("DailyConsumption"));
            return relation;
        }

        public UUID getEntityId() {
            return this.entityId;
        }

        public UUID getSourceId() {
            return this.sourceId;
        }

        public SupplySourceType getSourceType() {
            return this.sourceType;
        }

        public class_2338 getLastKnownEntityPos() {
            return this.lastKnownEntityPos;
        }

        public class_2338 getSourcePos() {
            return this.sourcePos;
        }

        public long getLastSupplyTime() {
            return this.lastSupplyTime;
        }

        public double getDailyConsumption() {
            return this.dailyConsumption;
        }

        public void setDailyConsumption(double dailyConsumption) {
            this.dailyConsumption = Math.max(0.0, dailyConsumption);
        }
    }

    public static class SupplySource {
        private final UUID id;
        private final SupplySourceType type;
        private double supplyValue;
        private double maxSupplyValue;
        private final Set<UUID> suppliedEntities;
        private class_2338 blockPos;
        private UUID ownerId;

        public SupplySource(UUID id, SupplySourceType type, double maxSupplyValue) {
            this.id = id;
            this.type = type;
            this.supplyValue = 0.0;
            this.maxSupplyValue = maxSupplyValue;
            this.suppliedEntities = new HashSet<UUID>();
        }

        public SupplySource(UUID id, SupplySourceType type, double maxSupplyValue, class_2338 blockPos) {
            this(id, type, maxSupplyValue);
            this.blockPos = blockPos;
        }

        public boolean canSupply(double amount) {
            return this.supplyValue >= amount;
        }

        public boolean consumeSupply(double amount) {
            if (this.canSupply(amount)) {
                this.supplyValue -= amount;
                return true;
            }
            return false;
        }

        public void addSupply(double amount) {
            this.supplyValue = Math.min(this.supplyValue + amount, this.maxSupplyValue);
        }

        public class_2487 saveToNbt() {
            class_2487 tag = new class_2487();
            tag.method_25927("Id", this.id);
            tag.method_10582("Type", this.type.name());
            tag.method_10549("SupplyValue", this.supplyValue);
            tag.method_10549("MaxSupplyValue", this.maxSupplyValue);
            if (this.blockPos != null) {
                tag.method_10544("BlockPos", this.blockPos.method_10063());
            }
            if (this.ownerId != null) {
                tag.method_25927("OwnerId", this.ownerId);
            }
            class_2499 entitiesList = new class_2499();
            for (UUID entityId : this.suppliedEntities) {
                class_2487 entityTag = new class_2487();
                entityTag.method_25927("EntityId", entityId);
                entitiesList.add((Object)entityTag);
            }
            tag.method_10566("SuppliedEntities", (class_2520)entitiesList);
            return tag;
        }

        public static SupplySource loadFromNbt(class_2487 tag) {
            UUID id = tag.method_25926("Id");
            SupplySourceType type = SupplySourceType.valueOf(tag.method_10558("Type"));
            double maxSupplyValue = tag.method_10574("MaxSupplyValue");
            class_2338 blockPos = tag.method_10545("BlockPos") ? class_2338.method_10092((long)tag.method_10537("BlockPos")) : null;
            SupplySource source = blockPos != null ? new SupplySource(id, type, maxSupplyValue, blockPos) : new SupplySource(id, type, maxSupplyValue);
            source.supplyValue = tag.method_10574("SupplyValue");
            if (tag.method_10545("OwnerId")) {
                source.ownerId = tag.method_25926("OwnerId");
            }
            class_2499 entitiesList = tag.method_10554("SuppliedEntities", 10);
            for (int i = 0; i < entitiesList.size(); ++i) {
                class_2487 entityTag = entitiesList.method_10602(i);
                source.suppliedEntities.add(entityTag.method_25926("EntityId"));
            }
            return source;
        }

        public UUID getId() {
            return this.id;
        }

        public SupplySourceType getType() {
            return this.type;
        }

        public double getSupplyValue() {
            return this.supplyValue;
        }

        public double getMaxSupplyValue() {
            return this.maxSupplyValue;
        }

        public Set<UUID> getSuppliedEntities() {
            return this.suppliedEntities;
        }

        public void setSupplyValue(double value) {
            this.supplyValue = Math.min(value, this.maxSupplyValue);
        }

        public class_2338 getBlockPos() {
            return this.blockPos;
        }

        public void setBlockPos(class_2338 pos) {
            this.blockPos = pos;
        }

        public UUID getOwnerId() {
            return this.ownerId;
        }

        public void setOwnerId(UUID ownerId) {
            this.ownerId = ownerId;
        }

        public void setMaxSupplyValue(double maxSupplyValue) {
            this.maxSupplyValue = maxSupplyValue;
        }
    }

    public static enum SupplySourceType {
        SUPPLY_POINT,
        PLAYER;

    }
}

