/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.template;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ydmsama.hundred_years_war.main.blocks.ModBlocks;
import ydmsama.hundred_years_war.main.template.HywStructureTemplate;
import ydmsama.hundred_years_war.main.template.TemplateManager;

public class BuildingTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildingTask.class);
    private static final int CLEAR_FLAGS = 35;
    private static final int FAST_TRACK_BLOCKS_PER_TICK = 10000;
    private static final int CONNECTION_COLUMNS_PER_TICK = 500;
    private static final int CONNECTION_FAST_TRACK_MULTIPLIER = 10;
    private static final int WATER_SURFACE_CHECKS_PER_TICK = 500;
    private static final int BURIAL_CHECKS_PER_TICK = 2048;
    private static final String ATTRIBUTE_GENERATE_ON_WATER_SURFACE = "generate_on_water_surface";
    private static final String ATTRIBUTE_MIN_BURIAL_RATE = "min_burial_rate";
    private static final String ATTRIBUTE_MAX_BURIAL_RATE = "max_burial_rate";
    private final UUID taskId;
    private final String templateId;
    private final class_2338 position;
    private final int rotation;
    private final float currentPlayerYaw;
    private final long totalBuildTime;
    private final String playerName;
    private final boolean generateConnectionLayer;
    private final boolean terrainCheck;
    private HywStructureTemplate template;
    private List<BlockPlacement> pendingPlacements;
    private int currentIndex = 0;
    private long startTime = -1L;
    private long elapsedTime = 0L;
    private boolean completed = false;
    private boolean failed = false;
    private String failureReason = null;
    private volatile boolean preparing = false;
    private volatile boolean prepareCompleted = false;
    private int placedBlocks = 0;
    private int failedBlocks = 0;
    private boolean fastTrack = false;
    private List<ConnectionColumn> connectionColumns = Collections.emptyList();
    private List<BlockPlacement> connectionPlacements = new ArrayList<BlockPlacement>();
    private int connectionColumnIndex = 0;
    private int connectionLayerActualPositions = 0;
    private int connectionLayerMaxDepthReached = 0;
    private boolean connectionLayerReady = true;
    private boolean connectionLayerFailed = false;
    private boolean startLogged = false;
    private boolean finishLogged = false;
    private boolean failureLogged = false;
    private boolean failureMessageSent = false;
    private int connectionLayerMaxDepth = 10;
    private long connectionLayerStartTime = -1L;
    private final boolean templateRequestsWaterSurfaceValidation;
    private List<class_2338> waterSurfaceCheckPositions = Collections.emptyList();
    private int waterSurfaceCheckIndex = 0;
    private boolean waterSurfaceValidationReady = true;
    private boolean waterSurfaceValidationFailed = false;
    private boolean waterSurfaceValidationInitialized = false;
    private final double minBurialRate;
    private final double maxBurialRate;
    private boolean burialValidationRequired = false;
    private boolean burialValidationReady = true;
    private boolean burialValidationFailed = false;
    private List<class_2338> burialCheckPositions = Collections.emptyList();
    private int burialCheckIndex = 0;
    private int burialOccupiedPositions = 0;
    private class_2338 minPos = null;
    private class_2338 maxPos = null;
    private UUID registeredBuildingId = null;
    private List<class_1923> requiredChunksForBuilding = Collections.emptyList();

    private static void logWarn(String message, Object ... args) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.warn(message, args);
        }
    }

    public BuildingTask(String templateId, class_2338 position, int rotation, float currentPlayerYaw, long totalBuildTime, String playerName) {
        this(templateId, position, rotation, currentPlayerYaw, totalBuildTime, playerName, false, false);
    }

    public BuildingTask(String templateId, class_2338 position, int rotation, float currentPlayerYaw, long totalBuildTime, String playerName, boolean generateConnectionLayer) {
        this(templateId, position, rotation, currentPlayerYaw, totalBuildTime, playerName, generateConnectionLayer, false);
    }

    public BuildingTask(String templateId, class_2338 position, int rotation, float currentPlayerYaw, long totalBuildTime, String playerName, boolean generateConnectionLayer, boolean terrainCheck) {
        this(templateId, position, rotation, currentPlayerYaw, totalBuildTime, playerName, generateConnectionLayer, terrainCheck, null);
    }

    public BuildingTask(String templateId, class_2338 position, int rotation, float currentPlayerYaw, long totalBuildTime, String playerName, boolean generateConnectionLayer, boolean terrainCheck, class_3218 level) {
        this(templateId, null, position, rotation, currentPlayerYaw, totalBuildTime, playerName, generateConnectionLayer, terrainCheck, level);
    }

    public BuildingTask(String templateId, HywStructureTemplate preloadedTemplate, class_2338 position, int rotation, float currentPlayerYaw, long totalBuildTime, String playerName, boolean generateConnectionLayer, boolean terrainCheck, class_3218 level) {
        this(templateId, preloadedTemplate, position, rotation, currentPlayerYaw, totalBuildTime, playerName, generateConnectionLayer, terrainCheck, level, true);
    }

    public BuildingTask(String templateId, HywStructureTemplate preloadedTemplate, class_2338 position, int rotation, float currentPlayerYaw, long totalBuildTime, String playerName, boolean generateConnectionLayer, boolean terrainCheck, class_3218 level, boolean immediatePreparation) {
        this.taskId = UUID.randomUUID();
        this.templateId = templateId;
        this.position = position;
        this.rotation = rotation;
        this.currentPlayerYaw = currentPlayerYaw;
        this.totalBuildTime = totalBuildTime;
        this.playerName = playerName;
        this.generateConnectionLayer = generateConnectionLayer;
        this.terrainCheck = terrainCheck;
        this.template = preloadedTemplate != null ? preloadedTemplate : TemplateManager.getInstance().loadTemplate(templateId);
        double[] burialBounds = BuildingTask.resolveBurialConstraints(this.template);
        this.minBurialRate = burialBounds[0];
        this.maxBurialRate = burialBounds[1];
        this.resetBurialValidationState();
        this.templateRequestsWaterSurfaceValidation = BuildingTask.isTemplateAttributeEnabled(this.template, ATTRIBUTE_GENERATE_ON_WATER_SURFACE);
        this.waterSurfaceValidationReady = !this.templateRequestsWaterSurfaceValidation;
        boolean bl = this.waterSurfaceValidationInitialized = !this.templateRequestsWaterSurfaceValidation;
        if (this.template == null) {
            this.failed = true;
            this.failureReason = "Template not found: " + templateId;
            this.logTaskFailed();
        } else if (immediatePreparation) {
            this.preparePlacements(level);
        } else {
            this.preparing = true;
        }
    }

    public BuildingTask(class_2487 tag) {
        this.taskId = tag.method_25926("taskId");
        this.templateId = tag.method_10558("templateId");
        this.position = class_2338.method_10092((long)tag.method_10537("position"));
        this.rotation = tag.method_10550("rotation");
        this.currentPlayerYaw = tag.method_10583("currentPlayerYaw");
        this.totalBuildTime = tag.method_10537("totalBuildTime");
        this.playerName = tag.method_10558("playerName");
        this.generateConnectionLayer = tag.method_10577("generateConnectionLayer");
        this.terrainCheck = tag.method_10577("terrainCheck");
        this.currentIndex = tag.method_10550("currentIndex");
        this.startTime = tag.method_10537("startTime");
        this.elapsedTime = tag.method_10537("elapsedTime");
        this.completed = tag.method_10577("completed");
        this.failed = tag.method_10577("failed");
        this.failureReason = tag.method_10545("failureReason") ? tag.method_10558("failureReason") : null;
        this.placedBlocks = tag.method_10550("placedBlocks");
        this.failedBlocks = tag.method_10550("failedBlocks");
        if (tag.method_10545("minPos")) {
            this.minPos = class_2338.method_10092((long)tag.method_10537("minPos"));
        }
        if (tag.method_10545("maxPos")) {
            this.maxPos = class_2338.method_10092((long)tag.method_10537("maxPos"));
        }
        if (tag.method_10545("registeredBuildingId")) {
            this.registeredBuildingId = tag.method_25926("registeredBuildingId");
        }
        this.fastTrack = tag.method_10577("fastTrack");
        this.preparing = tag.method_10577("preparing");
        this.prepareCompleted = tag.method_10577("prepareCompleted");
        if (this.startTime != -1L) {
            this.startLogged = true;
        }
        if (this.completed) {
            this.finishLogged = true;
        }
        if (this.failed) {
            this.failureLogged = true;
        }
        this.template = TemplateManager.getInstance().loadTemplate(this.templateId);
        double[] burialBounds = BuildingTask.resolveBurialConstraints(this.template);
        this.minBurialRate = burialBounds[0];
        this.maxBurialRate = burialBounds[1];
        this.resetBurialValidationState();
        this.templateRequestsWaterSurfaceValidation = BuildingTask.isTemplateAttributeEnabled(this.template, ATTRIBUTE_GENERATE_ON_WATER_SURFACE);
        this.waterSurfaceValidationReady = !this.templateRequestsWaterSurfaceValidation;
        boolean bl = this.waterSurfaceValidationInitialized = !this.templateRequestsWaterSurfaceValidation;
        if (this.template == null && !this.failed) {
            this.failed = true;
            this.failureReason = "Template not found on reload: " + this.templateId;
            this.logTaskFailed();
        }
        if (!this.failed && !this.completed && this.template != null) {
            this.preparePlacements();
        }
    }

    private void preparePlacements() {
        this.preparePlacements(null);
    }

    public void completeAsyncPreparation() {
        if (!this.preparing) {
            return;
        }
        try {
            this.preparePlacementsAsync();
            this.prepareCompleted = true;
            this.preparing = false;
            this.connectionLayerReady = !this.generateConnectionLayer && !this.terrainCheck;
        }
        catch (Exception e) {
            BuildingTask.logWarn("\u5f02\u6b65\u51c6\u5907\u5931\u8d25: {}", e.getMessage());
            this.failed = true;
            this.failureReason = "Async preparation failed: " + e.getMessage();
            this.preparing = false;
            this.logTaskFailed();
        }
    }

    private void preparePlacementsAsync() {
        if (this.template == null) {
            return;
        }
        this.pendingPlacements = new ArrayList<BlockPlacement>();
        this.minPos = null;
        this.maxPos = null;
        float savedYaw = this.template.getPlayerYaw();
        float relativeYaw = BuildingTask.normalizeAngle(savedYaw - this.currentPlayerYaw);
        int relativeRotation = Math.round(relativeYaw / 90.0f) * 90;
        relativeRotation = BuildingTask.normalizeRotation(relativeRotation);
        int totalRotation = BuildingTask.normalizeRotation(this.rotation + relativeRotation);
        class_2338 entrance = this.template.getEntrance();
        if (entrance == null) {
            entrance = class_2338.field_10980;
        }
        class_2338 transformedEntrance = BuildingTask.transformPosition(entrance, this.template.getSize(), totalRotation);
        class_2338 offset = this.position.method_10059((class_2382)transformedEntrance);
        HashMap<class_2680, class_2680> rotationCache = new HashMap<class_2680, class_2680>();
        for (Map.Entry<HywStructureTemplate.ChunkPos, HywStructureTemplate.TemplateChunk> entry : this.template.getChunks().entrySet()) {
            HywStructureTemplate.ChunkPos chunkPos = entry.getKey();
            HywStructureTemplate.TemplateChunk chunk = entry.getValue();
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        class_2680 transformedState;
                        class_2680 state = chunk.getBlock(x, y, z);
                        if (state == null || state.method_26215()) continue;
                        class_2338 relativePos = new class_2338(chunkPos.x * 16 + x, chunkPos.y * 16 + y, chunkPos.z * 16 + z);
                        class_2338 transformedPos = BuildingTask.transformPosition(relativePos, this.template.getSize(), totalRotation);
                        class_2338 worldPos = offset.method_10081((class_2382)transformedPos);
                        boolean isPlaceholder = state.method_27852(ModBlocks.PLACEHOLDER_BLOCK);
                        class_2487 tileData = null;
                        if (isPlaceholder) {
                            transformedState = class_2246.field_10124.method_9564();
                        } else {
                            transformedState = rotationCache.computeIfAbsent(state, s -> BuildingTask.transformBlockState(s, totalRotation));
                            tileData = chunk.getTileData(x, y, z);
                        }
                        this.pendingPlacements.add(new BlockPlacement(worldPos, transformedState, tileData));
                        if (this.minPos == null) {
                            this.minPos = worldPos;
                            this.maxPos = worldPos;
                            continue;
                        }
                        this.minPos = new class_2338(Math.min(this.minPos.method_10263(), worldPos.method_10263()), Math.min(this.minPos.method_10264(), worldPos.method_10264()), Math.min(this.minPos.method_10260(), worldPos.method_10260()));
                        this.maxPos = new class_2338(Math.max(this.maxPos.method_10263(), worldPos.method_10263()), Math.max(this.maxPos.method_10264(), worldPos.method_10264()), Math.max(this.maxPos.method_10260(), worldPos.method_10260()));
                    }
                }
            }
        }
        this.sortPendingPlacements();
        this.prepareBurialValidationState();
        this.prepareWaterSurfaceValidationState();
        this.calculateRequiredChunks();
    }

    private void preparePlacements(class_3218 level) {
        if (this.template == null) {
            return;
        }
        this.pendingPlacements = new ArrayList<BlockPlacement>();
        this.minPos = null;
        this.maxPos = null;
        float savedYaw = this.template.getPlayerYaw();
        float relativeYaw = BuildingTask.normalizeAngle(savedYaw - this.currentPlayerYaw);
        int relativeRotation = Math.round(relativeYaw / 90.0f) * 90;
        relativeRotation = BuildingTask.normalizeRotation(relativeRotation);
        int totalRotation = BuildingTask.normalizeRotation(this.rotation + relativeRotation);
        class_2338 entrance = this.template.getEntrance();
        if (entrance == null) {
            entrance = class_2338.field_10980;
        }
        class_2338 transformedEntrance = BuildingTask.transformPosition(entrance, this.template.getSize(), totalRotation);
        class_2338 offset = this.position.method_10059((class_2382)transformedEntrance);
        HashMap<class_2680, class_2680> rotationCache = new HashMap<class_2680, class_2680>();
        for (Map.Entry<HywStructureTemplate.ChunkPos, HywStructureTemplate.TemplateChunk> entry : this.template.getChunks().entrySet()) {
            HywStructureTemplate.ChunkPos chunkPos = entry.getKey();
            HywStructureTemplate.TemplateChunk chunk = entry.getValue();
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        class_2680 transformedState;
                        class_2680 state = chunk.getBlock(x, y, z);
                        if (state == null || state.method_26215()) continue;
                        class_2338 relativePos = new class_2338(chunkPos.x * 16 + x, chunkPos.y * 16 + y, chunkPos.z * 16 + z);
                        class_2338 transformedPos = BuildingTask.transformPosition(relativePos, this.template.getSize(), totalRotation);
                        class_2338 worldPos = offset.method_10081((class_2382)transformedPos);
                        boolean isPlaceholder = state.method_27852(ModBlocks.PLACEHOLDER_BLOCK);
                        class_2487 tileData = null;
                        if (isPlaceholder) {
                            transformedState = class_2246.field_10124.method_9564();
                        } else {
                            transformedState = rotationCache.computeIfAbsent(state, s -> BuildingTask.transformBlockState(s, totalRotation));
                            tileData = chunk.getTileData(x, y, z);
                        }
                        this.pendingPlacements.add(new BlockPlacement(worldPos, transformedState, tileData));
                        if (this.minPos == null) {
                            this.minPos = worldPos;
                            this.maxPos = worldPos;
                            continue;
                        }
                        this.minPos = new class_2338(Math.min(this.minPos.method_10263(), worldPos.method_10263()), Math.min(this.minPos.method_10264(), worldPos.method_10264()), Math.min(this.minPos.method_10260(), worldPos.method_10260()));
                        this.maxPos = new class_2338(Math.max(this.maxPos.method_10263(), worldPos.method_10263()), Math.max(this.maxPos.method_10264(), worldPos.method_10264()), Math.max(this.maxPos.method_10260(), worldPos.method_10260()));
                    }
                }
            }
        }
        this.sortPendingPlacements();
        this.prepareBurialValidationState();
        this.prepareWaterSurfaceValidationState();
        this.initializeConnectionLayerState();
        this.calculateRequiredChunks();
    }

    private void calculateRequiredChunks() {
        if (this.minPos == null || this.maxPos == null) {
            this.requiredChunksForBuilding = Collections.emptyList();
            return;
        }
        int minChunkX = Math.floorDiv(this.minPos.method_10263(), 16);
        int maxChunkX = Math.floorDiv(this.maxPos.method_10263(), 16);
        int minChunkZ = Math.floorDiv(this.minPos.method_10260(), 16);
        int maxChunkZ = Math.floorDiv(this.maxPos.method_10260(), 16);
        int capacity = (maxChunkX - minChunkX + 1) * (maxChunkZ - minChunkZ + 1);
        ArrayList<class_1923> chunks = new ArrayList<class_1923>(capacity);
        for (int x = minChunkX; x <= maxChunkX; ++x) {
            for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                chunks.add(new class_1923(x, z));
            }
        }
        this.requiredChunksForBuilding = chunks;
    }

    private void sortPendingPlacements() {
        if (this.pendingPlacements == null || this.pendingPlacements.isEmpty()) {
            return;
        }
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (BlockPlacement blockPlacement : this.pendingPlacements) {
            int y = blockPlacement.worldPos.method_10264();
            if (y < minY) {
                minY = y;
            }
            if (y <= maxY) continue;
            maxY = y;
        }
        List[] buckets = new List[maxY - minY + 1];
        for (BlockPlacement p : this.pendingPlacements) {
            int idx = p.worldPos.method_10264() - minY;
            ArrayList<BlockPlacement> bucket = buckets[idx];
            if (bucket == null) {
                buckets[idx] = bucket = new ArrayList<BlockPlacement>();
            }
            bucket.add(p);
        }
        ArrayList<BlockPlacement> arrayList = new ArrayList<BlockPlacement>(this.pendingPlacements.size());
        for (List bucket : buckets) {
            if (bucket == null) continue;
            arrayList.addAll(bucket);
        }
        this.pendingPlacements = arrayList;
    }

    private void resetBurialValidationState() {
        this.burialValidationRequired = this.minBurialRate > 1.0E-6 || this.maxBurialRate < 0.999999;
        this.burialValidationReady = !this.burialValidationRequired;
        this.burialValidationFailed = false;
        this.burialCheckPositions = Collections.emptyList();
        this.burialCheckIndex = 0;
        this.burialOccupiedPositions = 0;
    }

    private void prepareWaterSurfaceValidationState() {
        if (!this.templateRequestsWaterSurfaceValidation) {
            this.waterSurfaceCheckPositions = Collections.emptyList();
            this.waterSurfaceCheckIndex = 0;
            this.waterSurfaceValidationReady = true;
            this.waterSurfaceValidationInitialized = true;
            this.waterSurfaceValidationFailed = false;
            return;
        }
        if (this.position == null || this.pendingPlacements == null || this.pendingPlacements.isEmpty()) {
            this.waterSurfaceCheckPositions = Collections.emptyList();
            this.waterSurfaceCheckIndex = 0;
            this.waterSurfaceValidationReady = true;
            this.waterSurfaceValidationInitialized = true;
            this.waterSurfaceValidationFailed = false;
            return;
        }
        int anchorY = this.position.method_10264();
        ArrayList<class_2338> anchors = new ArrayList<class_2338>();
        for (BlockPlacement placement : this.pendingPlacements) {
            if (placement.worldPos.method_10264() != anchorY) continue;
            anchors.add(placement.worldPos);
        }
        this.waterSurfaceCheckPositions = anchors;
        this.waterSurfaceCheckIndex = 0;
        this.waterSurfaceValidationFailed = false;
        if (anchors.isEmpty()) {
            this.waterSurfaceValidationReady = true;
            this.waterSurfaceValidationInitialized = true;
        } else {
            this.waterSurfaceValidationReady = false;
            this.waterSurfaceValidationInitialized = false;
        }
    }

    private void prepareBurialValidationState() {
        if (!this.burialValidationRequired) {
            this.burialValidationReady = true;
            this.burialCheckPositions = Collections.emptyList();
            this.burialCheckIndex = 0;
            this.burialOccupiedPositions = 0;
            return;
        }
        if (this.pendingPlacements == null || this.pendingPlacements.isEmpty()) {
            this.burialValidationReady = true;
            this.burialCheckPositions = Collections.emptyList();
            this.burialCheckIndex = 0;
            this.burialOccupiedPositions = 0;
            return;
        }
        ArrayList<class_2338> positions = new ArrayList<class_2338>(this.pendingPlacements.size());
        for (BlockPlacement placement : this.pendingPlacements) {
            if (placement.isConnectionLayer) continue;
            positions.add(placement.worldPos);
        }
        this.burialCheckPositions = positions;
        this.burialCheckIndex = 0;
        this.burialOccupiedPositions = 0;
        this.burialValidationFailed = false;
        this.burialValidationReady = positions.isEmpty();
    }

    private void initializeConnectionLayerState() {
        this.connectionPlacements = new ArrayList<BlockPlacement>();
        this.connectionColumns = Collections.emptyList();
        this.connectionColumnIndex = 0;
        this.connectionLayerActualPositions = 0;
        this.connectionLayerMaxDepthReached = 0;
        this.connectionLayerFailed = false;
        this.connectionLayerStartTime = -1L;
        this.connectionLayerReady = true;
        if (!this.generateConnectionLayer && !this.terrainCheck) {
            this.connectionLayerReady = true;
            return;
        }
        Long2ObjectOpenHashMap lowestPositionsByXZ = new Long2ObjectOpenHashMap();
        Long2ObjectOpenHashMap lowestBlocksByXZ = new Long2ObjectOpenHashMap();
        int entranceY = this.position.method_10264();
        for (BlockPlacement placement : this.pendingPlacements) {
            long key;
            class_2338 existing;
            if (placement.worldPos.method_10264() > entranceY || (existing = (class_2338)lowestPositionsByXZ.get(key = (long)placement.worldPos.method_10263() << 32 ^ (long)placement.worldPos.method_10260() & 0xFFFFFFFFL)) != null && placement.worldPos.method_10264() >= existing.method_10264()) continue;
            lowestPositionsByXZ.put(key, (Object)placement.worldPos);
            lowestBlocksByXZ.put(key, (Object)placement.state);
        }
        if (lowestPositionsByXZ.isEmpty()) {
            this.connectionLayerReady = true;
            return;
        }
        this.connectionLayerMaxDepth = this.template != null && this.template.getConnectionLayerDepth() > 0 ? this.template.getConnectionLayerDepth() : 10;
        ArrayList<ConnectionColumn> columns = new ArrayList<ConnectionColumn>(lowestPositionsByXZ.size());
        for (Long2ObjectMap.Entry entry : lowestPositionsByXZ.long2ObjectEntrySet()) {
            class_2680 state = (class_2680)lowestBlocksByXZ.get(entry.getLongKey());
            columns.add(new ConnectionColumn((class_2338)entry.getValue(), state, this.connectionLayerMaxDepth));
        }
        columns.sort(Comparator.comparingInt(column -> column.basePos.method_10264()));
        this.connectionColumns = columns;
        this.connectionLayerReady = this.connectionColumns.isEmpty();
        if (!this.connectionLayerReady) {
            this.connectionLayerStartTime = System.nanoTime();
        }
    }

    private boolean processConnectionLayer(class_3218 level) {
        int used;
        int budget;
        if (this.connectionLayerReady || this.connectionLayerFailed) {
            return this.connectionLayerReady;
        }
        if (this.connectionColumns.isEmpty()) {
            this.connectionLayerReady = true;
            return true;
        }
        if (this.fastTrack) {
            long fastTrackBudget = 100000L;
            budget = (int)Math.min(Integer.MAX_VALUE, fastTrackBudget);
        } else {
            budget = 500;
        }
        for (int spent = 0; spent < budget && this.connectionColumnIndex < this.connectionColumns.size(); spent += used) {
            ConnectionColumn column = this.connectionColumns.get(this.connectionColumnIndex);
            used = this.processConnectionColumn(level, column, budget - spent);
            if (!column.done) continue;
            ++this.connectionColumnIndex;
        }
        if (this.connectionColumnIndex >= this.connectionColumns.size()) {
            this.finalizeConnectionLayer();
        }
        return this.connectionLayerReady;
    }

    private int processConnectionColumn(class_3218 level, ConnectionColumn column, int budget) {
        int used = 0;
        if (column.done) {
            return 0;
        }
        if (!column.initialChecked) {
            column.initialChecked = true;
            class_2338 firstBelow = column.basePos.method_10074();
            if (firstBelow.method_10264() < level.method_31607()) {
                column.done = true;
                return 0;
            }
            class_2680 firstBelowState = level.method_8320(firstBelow);
            if (!this.canReplaceForConnectionLayer(firstBelowState)) {
                column.done = true;
                return 0;
            }
            column.needsConnection = true;
            column.counted = true;
            ++this.connectionLayerActualPositions;
        }
        while (column.needsConnection && column.processedDepth < column.maxDepth && used < budget) {
            int nextDepth = column.processedDepth + 1;
            class_2338 targetPos = column.basePos.method_10087(nextDepth);
            if (targetPos.method_10264() < level.method_31607()) {
                column.done = true;
                break;
            }
            class_2680 currentState = level.method_8320(targetPos);
            if (!this.canReplaceForConnectionLayer(currentState)) {
                column.done = true;
                break;
            }
            if (this.generateConnectionLayer) {
                this.connectionPlacements.add(new BlockPlacement(targetPos, column.blockState, null, true));
            }
            column.processedDepth = nextDepth;
            ++used;
        }
        if (column.processedDepth >= column.maxDepth) {
            class_2338 belowMax = column.basePos.method_10087(column.maxDepth + 1);
            if (belowMax.method_10264() >= level.method_31607()) {
                class_2680 belowState = level.method_8320(belowMax);
                if (this.canReplaceForConnectionLayer(belowState)) {
                    column.reachedMaxDepth = true;
                }
            } else {
                column.reachedMaxDepth = true;
            }
            column.done = true;
        }
        if (column.done && column.needsConnection && column.reachedMaxDepth) {
            ++this.connectionLayerMaxDepthReached;
        }
        if (column.done && !column.needsConnection) {
            column.reachedMaxDepth = false;
        }
        return used;
    }

    private void finalizeConnectionLayer() {
        float ratio;
        if (this.connectionLayerReady || this.connectionLayerFailed) {
            return;
        }
        if (this.terrainCheck && this.connectionLayerActualPositions > 0 && (ratio = (float)this.connectionLayerMaxDepthReached / (float)this.connectionLayerActualPositions) > 0.1f) {
            this.failed = true;
            this.failureReason = "Terrain too uneven - more than 10% of positions reach maximum depth";
            this.logTaskFailed();
            this.connectionLayerFailed = true;
            return;
        }
        if (this.generateConnectionLayer && !this.connectionPlacements.isEmpty()) {
            this.pendingPlacements.addAll(this.connectionPlacements);
            this.sortPendingPlacements();
        }
        this.connectionLayerReady = true;
        this.connectionLayerStartTime = -1L;
    }

    private void initializeWaterSurfaceValidation(class_3218 level) {
        if (this.waterSurfaceValidationInitialized) {
            return;
        }
        this.waterSurfaceValidationInitialized = true;
        if (this.waterSurfaceCheckPositions.isEmpty()) {
            this.waterSurfaceValidationReady = true;
            return;
        }
        if (this.position == null) {
            this.waterSurfaceValidationReady = true;
            return;
        }
        class_3610 fluidState = level.method_8316(this.position);
        this.waterSurfaceValidationReady = !fluidState.method_15767(class_3486.field_15517);
    }

    private boolean processWaterSurfaceValidation(class_3218 level) {
        int budget;
        if (this.waterSurfaceValidationReady || this.waterSurfaceValidationFailed) {
            return true;
        }
        if (this.fastTrack) {
            long fastTrackBudget = 100000L;
            budget = (int)Math.min(Integer.MAX_VALUE, fastTrackBudget);
        } else {
            budget = 500;
        }
        for (int processed = 0; processed < budget && this.waterSurfaceCheckIndex < this.waterSurfaceCheckPositions.size(); ++processed) {
            class_2338 checkPos;
            if (level.method_8316(checkPos = this.waterSurfaceCheckPositions.get(this.waterSurfaceCheckIndex++)).method_15767(class_3486.field_15517)) continue;
            this.waterSurfaceValidationFailed = true;
            this.waterSurfaceValidationReady = true;
            this.failed = true;
            this.failureReason = String.format(Locale.ROOT, "Water surface validation failed at (%d,%d,%d)", checkPos.method_10263(), checkPos.method_10264(), checkPos.method_10260());
            this.logTaskFailed();
            break;
        }
        if (!this.waterSurfaceValidationFailed && this.waterSurfaceCheckIndex >= this.waterSurfaceCheckPositions.size()) {
            this.waterSurfaceValidationReady = true;
        }
        return this.waterSurfaceValidationReady || this.waterSurfaceValidationFailed;
    }

    private boolean processBurialValidation(class_3218 level) {
        int budget;
        if (this.burialValidationReady || this.burialValidationFailed || !this.burialValidationRequired) {
            return true;
        }
        if (this.fastTrack) {
            long fastTrackBudget = 100000L;
            budget = (int)Math.min(Integer.MAX_VALUE, fastTrackBudget);
        } else {
            budget = 2048;
        }
        for (int processed = 0; processed < budget && this.burialCheckIndex < this.burialCheckPositions.size(); ++processed) {
            class_2338 checkPos;
            if (level.method_8320(checkPos = this.burialCheckPositions.get(this.burialCheckIndex++)).method_26215()) continue;
            ++this.burialOccupiedPositions;
        }
        if (this.burialCheckIndex >= this.burialCheckPositions.size()) {
            double total = this.burialCheckPositions.isEmpty() ? 0.0 : (double)this.burialCheckPositions.size();
            double ratio = total <= 0.0 ? 0.0 : (double)this.burialOccupiedPositions / total;
            double clampedRatio = class_3532.method_15350((double)ratio, (double)0.0, (double)1.0);
            if (clampedRatio + 1.0E-6 < this.minBurialRate || clampedRatio - 1.0E-6 > this.maxBurialRate) {
                this.burialValidationFailed = true;
                this.burialValidationReady = true;
                this.failed = true;
                this.failureReason = String.format(Locale.ROOT, "Burial ratio %.2f outside allowed range [%.2f, %.2f]", clampedRatio, this.minBurialRate, this.maxBurialRate);
                this.logTaskFailed();
                this.notifyFailureMessage(level, (class_2561)class_2561.method_43469((String)"message.hundred_years_war.building_burial_invalid", (Object[])new Object[]{(int)Math.round(clampedRatio * 100.0), (int)Math.round(this.minBurialRate * 100.0), (int)Math.round(this.maxBurialRate * 100.0)}));
            } else {
                this.burialValidationReady = true;
            }
        }
        return this.burialValidationReady || this.burialValidationFailed;
    }

    public boolean tick(class_3218 level, long currentTick) {
        int blocksToPlace;
        if (this.failed) {
            this.logTaskFailed();
            return true;
        }
        if (this.completed) {
            this.logTaskCompleted();
            return true;
        }
        if (this.preparing) {
            return false;
        }
        if (this.prepareCompleted && !this.connectionLayerReady && (this.generateConnectionLayer || this.terrainCheck)) {
            this.initializeConnectionLayerState();
            this.prepareCompleted = false;
        }
        if (this.pendingPlacements == null || this.pendingPlacements.isEmpty()) {
            this.completed = true;
            if (this.startTime == -1L) {
                this.startTime = currentTick;
            }
            this.elapsedTime = currentTick - this.startTime;
            this.logTaskStarted();
            this.logTaskCompleted();
            return true;
        }
        if (this.templateRequestsWaterSurfaceValidation) {
            this.initializeWaterSurfaceValidation(level);
            if (!this.waterSurfaceValidationReady) {
                if (!this.processWaterSurfaceValidation(level)) {
                    return false;
                }
                if (this.waterSurfaceValidationFailed) {
                    return true;
                }
            }
        }
        if ((this.generateConnectionLayer || this.terrainCheck) && !this.connectionLayerReady) {
            if (!this.processConnectionLayer(level)) {
                return false;
            }
            if (this.connectionLayerFailed) {
                return true;
            }
        }
        if (this.burialValidationRequired && !this.burialValidationReady) {
            if (!this.processBurialValidation(level)) {
                return false;
            }
            if (this.burialValidationFailed) {
                return true;
            }
        }
        if (this.startTime == -1L) {
            this.startTime = currentTick;
            this.logTaskStarted();
        }
        this.elapsedTime = currentTick - this.startTime;
        if (this.totalBuildTime == 0L) {
            blocksToPlace = this.pendingPlacements.size();
        } else {
            double progress = Math.min(1.0, (double)this.elapsedTime / (double)this.totalBuildTime);
            int targetIndex = (int)Math.floor((double)this.pendingPlacements.size() * progress);
            blocksToPlace = Math.max(0, targetIndex - this.currentIndex);
            if (this.elapsedTime >= this.totalBuildTime && this.currentIndex < this.pendingPlacements.size()) {
                blocksToPlace = this.pendingPlacements.size() - this.currentIndex;
            }
        }
        if (this.fastTrack && this.currentIndex < this.pendingPlacements.size()) {
            int remaining = this.pendingPlacements.size() - this.currentIndex;
            blocksToPlace = Math.min(remaining, Math.max(blocksToPlace, 10000));
        }
        int placed = 0;
        while (placed < blocksToPlace && this.currentIndex < this.pendingPlacements.size()) {
            block29: {
                BlockPlacement placement = this.pendingPlacements.get(this.currentIndex);
                boolean attemptedPlacement = true;
                try {
                    class_2680 currentState;
                    if (placement.isConnectionLayer && !this.canReplaceForConnectionLayer(currentState = level.method_8320(placement.worldPos))) {
                        attemptedPlacement = false;
                    }
                    if (attemptedPlacement) {
                        if (this.placeBlock(level, placement)) {
                            ++this.placedBlocks;
                        } else {
                            ++this.failedBlocks;
                        }
                        ++placed;
                    }
                }
                catch (Exception e) {
                    BuildingTask.logWarn("Failed to place block at {}: {}", placement.worldPos, e.getMessage());
                    if (!attemptedPlacement) break block29;
                    ++this.failedBlocks;
                    ++placed;
                }
            }
            ++this.currentIndex;
        }
        if (this.currentIndex >= this.pendingPlacements.size()) {
            this.completed = true;
            this.logTaskCompleted();
        }
        return this.completed;
    }

    public void enableFastTrack() {
        if (this.completed || this.failed) {
            return;
        }
        this.fastTrack = true;
    }

    private void logTaskStarted() {
    }

    private void logTaskCompleted() {
    }

    private void logTaskFailed() {
    }

    private boolean canReplaceForConnectionLayer(class_2680 state) {
        if (state.method_26215()) {
            return true;
        }
        class_3610 fluidState = state.method_26227();
        if (!fluidState.method_15769()) {
            return true;
        }
        if (state.method_45474()) {
            return true;
        }
        return !state.method_51366();
    }

    private boolean placeBlock(class_3218 level, BlockPlacement placement) {
        class_2338 pos = placement.worldPos;
        class_2680 desiredState = placement.state;
        class_2680 currentState = level.method_8320(pos);
        if (currentState.equals(desiredState)) {
            this.applyTileData(level, pos, placement);
            return true;
        }
        if (!this.clearTargetPosition(level, pos, currentState)) {
            return false;
        }
        if (!level.method_8652(pos, desiredState, 3)) {
            return false;
        }
        this.applyTileData(level, pos, placement);
        return true;
    }

    private void applyTileData(class_3218 level, class_2338 pos, BlockPlacement placement) {
        class_2586 blockEntity;
        if (placement.tileData != null && this.template != null && this.template.includesBlockData() && (blockEntity = level.method_8321(pos)) != null) {
            blockEntity.method_11014(placement.tileData);
        }
    }

    private boolean clearTargetPosition(class_3218 level, class_2338 pos, class_2680 currentState) {
        if (currentState.method_26215()) {
            return true;
        }
        if (currentState.method_26214((class_1922)level, pos) == -1.0f) {
            return false;
        }
        this.clearDoubleBlockPartner(level, pos, currentState);
        if (level.method_8652(pos, class_2246.field_10124.method_9564(), 35)) {
            return true;
        }
        return level.method_22352(pos, false);
    }

    private void clearDoubleBlockPartner(class_3218 level, class_2338 pos, class_2680 state) {
        if (!state.method_28498((class_2769)class_2741.field_12533)) {
            return;
        }
        class_2756 half = (class_2756)state.method_11654((class_2769)class_2741.field_12533);
        class_2338 otherPos = half == class_2756.field_12609 ? pos.method_10074() : pos.method_10084();
        class_2680 otherState = level.method_8320(otherPos);
        if (otherState.method_28498((class_2769)class_2741.field_12533) && otherState.method_11654((class_2769)class_2741.field_12533) != half && otherState.method_27852(state.method_26204())) {
            level.method_8652(otherPos, class_2246.field_10124.method_9564(), 35);
        }
    }

    public class_2487 save() {
        class_2487 tag = new class_2487();
        tag.method_25927("taskId", this.taskId);
        tag.method_10582("templateId", this.templateId);
        tag.method_10544("position", this.position.method_10063());
        tag.method_10569("rotation", this.rotation);
        tag.method_10548("currentPlayerYaw", this.currentPlayerYaw);
        tag.method_10544("totalBuildTime", this.totalBuildTime);
        tag.method_10582("playerName", this.playerName);
        tag.method_10556("generateConnectionLayer", this.generateConnectionLayer);
        tag.method_10556("terrainCheck", this.terrainCheck);
        tag.method_10569("currentIndex", this.currentIndex);
        tag.method_10544("startTime", this.startTime);
        tag.method_10544("elapsedTime", this.elapsedTime);
        tag.method_10556("completed", this.completed);
        tag.method_10556("failed", this.failed);
        if (this.failureReason != null) {
            tag.method_10582("failureReason", this.failureReason);
        }
        tag.method_10569("placedBlocks", this.placedBlocks);
        tag.method_10569("failedBlocks", this.failedBlocks);
        if (this.minPos != null) {
            tag.method_10544("minPos", this.minPos.method_10063());
        }
        if (this.maxPos != null) {
            tag.method_10544("maxPos", this.maxPos.method_10063());
        }
        if (this.registeredBuildingId != null) {
            tag.method_25927("registeredBuildingId", this.registeredBuildingId);
        }
        tag.method_10556("fastTrack", this.fastTrack);
        tag.method_10556("preparing", this.preparing);
        tag.method_10556("prepareCompleted", this.prepareCompleted);
        return tag;
    }

    private static boolean isTemplateAttributeEnabled(HywStructureTemplate template, String key) {
        if (template == null || key == null) {
            return false;
        }
        Map<String, JsonElement> attributes = template.getCustomAttributes();
        if (attributes == null) {
            return false;
        }
        JsonElement element = attributes.get(key);
        return element != null && element.isJsonPrimitive() && element.getAsJsonPrimitive().isBoolean() && element.getAsBoolean();
    }

    private static double[] resolveBurialConstraints(HywStructureTemplate template) {
        double min = BuildingTask.getTemplateAttributeDouble(template, ATTRIBUTE_MIN_BURIAL_RATE, 0.0);
        double max = BuildingTask.getTemplateAttributeDouble(template, ATTRIBUTE_MAX_BURIAL_RATE, 1.0);
        if ((min = class_3532.method_15350((double)min, (double)0.0, (double)1.0)) > (max = class_3532.method_15350((double)max, (double)0.0, (double)1.0))) {
            double temp = min;
            min = max;
            max = temp;
        }
        return new double[]{min, max};
    }

    private static double getTemplateAttributeDouble(HywStructureTemplate template, String key, double defaultValue) {
        if (template == null || key == null) {
            return defaultValue;
        }
        Map<String, JsonElement> attributes = template.getCustomAttributes();
        if (attributes == null) {
            return defaultValue;
        }
        JsonElement element = attributes.get(key);
        if (element == null || element.isJsonNull()) {
            return defaultValue;
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                return primitive.getAsDouble();
            }
            if (primitive.isString()) {
                try {
                    return Double.parseDouble(primitive.getAsString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return defaultValue;
    }

    private static class_2338 transformPosition(class_2338 pos, class_2338 size, int rotation) {
        class_2338 result = pos;
        class_2338 currentSize = size;
        for (int i = 0; i < rotation / 90; ++i) {
            int newX = result.method_10260();
            int newZ = currentSize.method_10263() - 1 - result.method_10263();
            result = new class_2338(newX, result.method_10264(), newZ);
            int temp = currentSize.method_10263();
            currentSize = new class_2338(currentSize.method_10260(), currentSize.method_10264(), temp);
        }
        return result;
    }

    private static class_2680 transformBlockState(class_2680 state, int rotation) {
        class_2470 rot = switch (rotation) {
            case 90 -> class_2470.field_11465;
            case 180 -> class_2470.field_11464;
            case 270 -> class_2470.field_11463;
            default -> class_2470.field_11467;
        };
        return state.method_26186(rot);
    }

    private static float normalizeAngle(float angle) {
        while (angle > 180.0f) {
            angle -= 360.0f;
        }
        while (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    private static int normalizeRotation(int rotation) {
        if ((rotation %= 360) < 0) {
            rotation += 360;
        }
        return rotation;
    }

    private void notifyFailureMessage(class_3218 level, class_2561 message) {
        if (this.failureMessageSent || level == null || this.isSystemTask() || this.playerName == null || this.playerName.isEmpty()) {
            return;
        }
        class_3222 player = level.method_8503().method_3760().method_14566(this.playerName);
        if (player != null) {
            player.method_43496(message);
        }
        this.failureMessageSent = true;
    }

    public UUID getTaskId() {
        return this.taskId;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public boolean isPreparing() {
        return this.preparing;
    }

    public UUID getRegisteredBuildingId() {
        return this.registeredBuildingId;
    }

    public void setRegisteredBuildingId(UUID registeredBuildingId) {
        this.registeredBuildingId = registeredBuildingId;
    }

    public List<class_1923> getRequiredChunks() {
        return this.requiredChunksForBuilding;
    }

    public float getProgress() {
        if (this.pendingPlacements == null || this.pendingPlacements.isEmpty()) {
            return 1.0f;
        }
        return (float)this.currentIndex / (float)this.pendingPlacements.size();
    }

    public long getTotalBuildTimeTicks() {
        return this.totalBuildTime;
    }

    private boolean isSystemTask() {
        return "SYSTEM".equals(this.playerName);
    }

    public String getTemplateName() {
        return this.template != null ? this.template.getName() : this.templateId;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public int getPlacedBlocks() {
        return this.placedBlocks;
    }

    public int getFailedBlocks() {
        return this.failedBlocks;
    }

    public class_2338 getCenterPosition() {
        if (this.minPos != null && this.maxPos != null) {
            return new class_2338((this.minPos.method_10263() + this.maxPos.method_10263()) / 2, (this.minPos.method_10264() + this.maxPos.method_10264()) / 2, (this.minPos.method_10260() + this.maxPos.method_10260()) / 2);
        }
        return this.position;
    }

    public boolean isSystemGenerated() {
        return "SYSTEM".equals(this.playerName);
    }

    public class_2338 getMinPos() {
        return this.minPos;
    }

    public class_2338 getMaxPos() {
        return this.maxPos;
    }

    private static class BlockPlacement {
        final class_2338 worldPos;
        final class_2680 state;
        final class_2487 tileData;
        final boolean isConnectionLayer;

        BlockPlacement(class_2338 worldPos, class_2680 state, class_2487 tileData) {
            this(worldPos, state, tileData, false);
        }

        BlockPlacement(class_2338 worldPos, class_2680 state, class_2487 tileData, boolean isConnectionLayer) {
            this.worldPos = worldPos;
            this.state = state;
            this.tileData = tileData;
            this.isConnectionLayer = isConnectionLayer;
        }
    }

    private static class ConnectionColumn {
        final class_2338 basePos;
        final class_2680 blockState;
        final int maxDepth;
        boolean initialChecked = false;
        boolean needsConnection = false;
        boolean counted = false;
        boolean done = false;
        int processedDepth = 0;
        boolean reachedMaxDepth = false;

        ConnectionColumn(class_2338 basePos, class_2680 blockState, int maxDepth) {
            this.basePos = basePos;
            this.blockState = blockState;
            this.maxDepth = maxDepth;
        }
    }
}

