/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.template;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import net.minecraft.class_18;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.template.BuildingTask;
import ydmsama.hundred_years_war.main.template.HywStructureTemplate;
import ydmsama.hundred_years_war.main.template.PlacedBuilding;
import ydmsama.hundred_years_war.main.template.PlacedBuildingRegistry;

public class BuildingTaskManager
extends class_18 {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildingTaskManager.class);
    private static final String DATA_NAME = "hundred_years_war_building_tasks";
    private final Map<UUID, BuildingTask> activeTasks = new HashMap<UUID, BuildingTask>();
    private final List<BuildingTask> completedTasks = new ArrayList<BuildingTask>();
    private final Map<String, List<UUID>> playerTasks = new HashMap<String, List<UUID>>();
    private long lastTickTime = 0L;

    private static void logInfo(String message, Object ... args) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info(message, args);
        }
    }

    private static void logWarn(String message, Object ... args) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.warn(message, args);
        }
    }

    public BuildingTaskManager() {
    }

    public BuildingTaskManager(class_2487 tag) {
        class_2499 activeList = tag.method_10554("activeTasks", 10);
        for (int i = 0; i < activeList.size(); ++i) {
            BuildingTask task = new BuildingTask(activeList.method_10602(i));
            this.activeTasks.put(task.getTaskId(), task);
            this.playerTasks.computeIfAbsent(task.getPlayerName(), k -> new ArrayList()).add(task.getTaskId());
        }
        if (tag.method_10545("completedTasks")) {
            class_2499 completedList = tag.method_10554("completedTasks", 10);
            for (int i = 0; i < completedList.size(); ++i) {
                this.completedTasks.add(new BuildingTask(completedList.method_10602(i)));
            }
        }
        this.lastTickTime = tag.method_10537("lastTickTime");
    }

    public class_2487 method_75(class_2487 tag) {
        class_2499 activeList = new class_2499();
        for (BuildingTask task : this.activeTasks.values()) {
            activeList.add((Object)task.save());
        }
        tag.method_10566("activeTasks", (class_2520)activeList);
        class_2499 completedList = new class_2499();
        int completedCount = Math.min(this.completedTasks.size(), 100);
        for (int i = this.completedTasks.size() - completedCount; i < this.completedTasks.size(); ++i) {
            completedList.add((Object)this.completedTasks.get(i).save());
        }
        tag.method_10566("completedTasks", (class_2520)completedList);
        tag.method_10544("lastTickTime", this.lastTickTime);
        return tag;
    }

    public UUID addTask(String templateId, class_2338 position, int rotation, float currentPlayerYaw, long buildTimeSeconds, String playerName, boolean generateConnectionLayer, boolean terrainCheck) {
        return this.addTask(templateId, position, rotation, currentPlayerYaw, buildTimeSeconds, playerName, generateConnectionLayer, terrainCheck, null);
    }

    public UUID addTask(String templateId, class_2338 position, int rotation, float currentPlayerYaw, long buildTimeSeconds, String playerName, boolean generateConnectionLayer, boolean terrainCheck, class_3218 level) {
        long buildTimeTicks = buildTimeSeconds * 20L;
        BuildingTask task = new BuildingTask(templateId, position, rotation, currentPlayerYaw, buildTimeTicks, playerName, generateConnectionLayer, terrainCheck, level);
        if (task.isFailed()) {
            return null;
        }
        this.activeTasks.put(task.getTaskId(), task);
        this.playerTasks.computeIfAbsent(playerName, k -> new ArrayList()).add(task.getTaskId());
        this.method_80();
        return task.getTaskId();
    }

    public UUID addTaskWithTemplate(String templateId, HywStructureTemplate template, class_2338 position, int rotation, float currentPlayerYaw, long buildTimeSeconds, String playerName, boolean generateConnectionLayer, boolean terrainCheck, class_3218 level) {
        long buildTimeTicks = buildTimeSeconds * 20L;
        BuildingTask task = new BuildingTask(templateId, template, position, rotation, currentPlayerYaw, buildTimeTicks, playerName, generateConnectionLayer, terrainCheck, level);
        if (task.isFailed()) {
            return null;
        }
        this.activeTasks.put(task.getTaskId(), task);
        this.playerTasks.computeIfAbsent(playerName, k -> new ArrayList()).add(task.getTaskId());
        this.method_80();
        return task.getTaskId();
    }

    public UUID addTaskWithTemplateAsync(String templateId, HywStructureTemplate template, class_2338 position, int rotation, float currentPlayerYaw, long buildTimeSeconds, String playerName, boolean generateConnectionLayer, boolean terrainCheck, class_3218 level) {
        long buildTimeTicks = buildTimeSeconds * 20L;
        BuildingTask task = new BuildingTask(templateId, template, position, rotation, currentPlayerYaw, buildTimeTicks, playerName, generateConnectionLayer, terrainCheck, level, false);
        if (task.isFailed()) {
            return null;
        }
        UUID taskId = task.getTaskId();
        this.activeTasks.put(taskId, task);
        this.playerTasks.computeIfAbsent(playerName, k -> new ArrayList()).add(taskId);
        this.method_80();
        CompletableFuture.runAsync(() -> {
            try {
                task.completeAsyncPreparation();
            }
            catch (Exception e) {
                BuildingTaskManager.logWarn("\u5f02\u6b65\u51c6\u5907\u4efb\u52a1\u5931\u8d25: {}", e.getMessage());
            }
        }, Executors.newCachedThreadPool());
        return taskId;
    }

    public UUID addTask(String templateId, class_2338 position, int rotation, float currentPlayerYaw, long buildTimeSeconds, String playerName, boolean generateConnectionLayer) {
        return this.addTask(templateId, position, rotation, currentPlayerYaw, buildTimeSeconds, playerName, generateConnectionLayer, false);
    }

    public UUID addTask(String templateId, class_2338 position, int rotation, float currentPlayerYaw, long buildTimeSeconds, String playerName) {
        return this.addTask(templateId, position, rotation, currentPlayerYaw, buildTimeSeconds, playerName, false, false);
    }

    public BuildingTask getTask(UUID taskId) {
        return this.activeTasks.get(taskId);
    }

    public void removeTask(class_3218 level, UUID taskId) {
        BuildingTask task = this.activeTasks.remove(taskId);
        if (task != null) {
            this.cleanupRegisteredBuilding(level, task);
            for (List<UUID> playerTaskList : this.playerTasks.values()) {
                playerTaskList.remove(taskId);
            }
            this.method_80();
        }
    }

    public void tick(class_3218 level, long currentTick) {
        if (this.activeTasks.isEmpty()) {
            return;
        }
        if (currentTick <= this.lastTickTime) {
            return;
        }
        this.lastTickTime = currentTick;
        ArrayList<UUID> completedTaskIds = new ArrayList<UUID>();
        for (BuildingTask task : this.activeTasks.values()) {
            if (!task.tick(level, currentTick)) continue;
            if (task.isFailed()) {
                this.cleanupRegisteredBuilding(level, task);
            }
            completedTaskIds.add(task.getTaskId());
        }
        if (!completedTaskIds.isEmpty()) {
            for (UUID taskId : completedTaskIds) {
                BuildingTask task = this.activeTasks.remove(taskId);
                if (task == null) continue;
                this.completedTasks.add(task);
                List<UUID> playerTaskList = this.playerTasks.get(task.getPlayerName());
                if (playerTaskList == null) continue;
                playerTaskList.remove(taskId);
            }
            this.method_80();
        }
    }

    public BuildingTaskStatus getTaskStatus(UUID taskId) {
        BuildingTask task = this.activeTasks.get(taskId);
        if (task == null) {
            for (BuildingTask completed : this.completedTasks) {
                if (!completed.getTaskId().equals(taskId)) continue;
                return new BuildingTaskStatus(taskId, completed.getTemplateName(), 1.0f, true, completed.isFailed(), completed.getFailureReason(), completed.getPlacedBlocks(), completed.getFailedBlocks());
            }
            return null;
        }
        return new BuildingTaskStatus(taskId, task.getTemplateName(), task.getProgress(), task.isCompleted(), task.isFailed(), task.getFailureReason(), task.getPlacedBlocks(), task.getFailedBlocks());
    }

    public List<BuildingTaskStatus> getPlayerTasks(String playerName) {
        ArrayList<BuildingTaskStatus> result = new ArrayList<BuildingTaskStatus>();
        List<UUID> taskIds = this.playerTasks.get(playerName);
        if (taskIds != null) {
            for (UUID taskId : taskIds) {
                BuildingTaskStatus status = this.getTaskStatus(taskId);
                if (status == null) continue;
                result.add(status);
            }
        }
        return result;
    }

    public boolean cancelTask(class_3218 level, UUID taskId) {
        BuildingTask task = this.activeTasks.remove(taskId);
        if (task != null) {
            this.cleanupRegisteredBuilding(level, task);
            List<UUID> playerTaskList = this.playerTasks.get(task.getPlayerName());
            if (playerTaskList != null) {
                playerTaskList.remove(taskId);
            }
            this.method_80();
            return true;
        }
        return false;
    }

    private void cleanupRegisteredBuilding(class_3218 level, BuildingTask task) {
        if (level == null || task == null) {
            return;
        }
        UUID buildingId = task.getRegisteredBuildingId();
        if (buildingId == null) {
            return;
        }
        PlacedBuildingRegistry registry = PlacedBuildingRegistry.get(level);
        PlacedBuilding building = registry.getBuilding(buildingId);
        if (building != null && registry.removeBuilding(buildingId)) {
            ServerPacketHandler.broadcastBuildingUpdate(level, building, true);
        }
        task.setRegisteredBuildingId(null);
    }

    public UUID registerExistingTask(BuildingTask task) {
        if (task.isFailed()) {
            return null;
        }
        this.activeTasks.put(task.getTaskId(), task);
        this.playerTasks.computeIfAbsent(task.getPlayerName(), k -> new ArrayList()).add(task.getTaskId());
        this.method_80();
        return task.getTaskId();
    }

    public int getActiveTaskCount() {
        return this.activeTasks.size();
    }

    public List<BuildingTaskStatus> getActiveTaskSnapshots() {
        ArrayList<BuildingTaskStatus> snapshots = new ArrayList<BuildingTaskStatus>(this.activeTasks.size());
        for (BuildingTask task : this.activeTasks.values()) {
            snapshots.add(new BuildingTaskStatus(task.getTaskId(), task.getTemplateName(), task.getProgress(), task.isCompleted(), task.isFailed(), task.getFailureReason(), task.getPlacedBlocks(), task.getFailedBlocks()));
        }
        snapshots.sort(Comparator.comparing(status -> status.templateName));
        return snapshots;
    }

    public void cleanupHistory(int keepCount) {
        if (this.completedTasks.size() > keepCount) {
            this.completedTasks.subList(0, this.completedTasks.size() - keepCount).clear();
            this.method_80();
        }
    }

    public static BuildingTaskManager get(class_3218 world) {
        class_26 storage = world.method_17983();
        return (BuildingTaskManager)storage.method_17924(BuildingTaskManager::new, BuildingTaskManager::new, DATA_NAME);
    }

    public static BuildingTaskManager get(MinecraftServer server) {
        return BuildingTaskManager.get(server.method_30002());
    }

    public static class BuildingTaskStatus {
        public final UUID taskId;
        public final String templateName;
        public final float progress;
        public final boolean completed;
        public final boolean failed;
        public final String failureReason;
        public final int placedBlocks;
        public final int failedBlocks;

        BuildingTaskStatus(UUID taskId, String templateName, float progress, boolean completed, boolean failed, String failureReason, int placedBlocks, int failedBlocks) {
            this.taskId = taskId;
            this.templateName = templateName;
            this.progress = progress;
            this.completed = completed;
            this.failed = failed;
            this.failureReason = failureReason;
            this.placedBlocks = placedBlocks;
            this.failedBlocks = failedBlocks;
        }
    }
}

