/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.template.attribute;

import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import ydmsama.hundred_years_war.main.template.attribute.TemplateTagDefinition;

public final class TemplateTags {
    private static final Map<String, TemplateTagDefinition> DEFINITIONS;

    private TemplateTags() {
    }

    public static Collection<TemplateTagDefinition> all() {
        return DEFINITIONS.values();
    }

    public static TemplateTagDefinition get(String id) {
        if (id == null) {
            return null;
        }
        return DEFINITIONS.get(id.toLowerCase(Locale.ROOT));
    }

    public static Optional<TemplateTagDefinition> find(String id) {
        return Optional.ofNullable(TemplateTags.get(id));
    }

    public static boolean isKnownTag(String id) {
        return TemplateTags.get(id) != null;
    }

    public static Map<String, JsonElement> createAttributeValues(String id) {
        TemplateTagDefinition definition = TemplateTags.get(id);
        if (definition == null) {
            return Map.of();
        }
        return definition.createAttributeValues();
    }

    public static Set<String> getAttributeKeys(String id) {
        TemplateTagDefinition definition = TemplateTags.get(id);
        return definition == null ? Set.of() : definition.getAttributeKeys();
    }

    static {
        LinkedHashMap<String, TemplateTagDefinition> definitions = new LinkedHashMap<String, TemplateTagDefinition>();
        definitions.put("economic_building", new TemplateTagDefinition("economic_building", "template_tag.economic_building", List.of("economic_building_development_income", "economic_building_development_capacity")));
        definitions.put("technology_building", new TemplateTagDefinition("technology_building", "template_tag.technology_building", List.of("technology_building_research_income", "technology_building_research_capacity")));
        definitions.put("military_building", new TemplateTagDefinition("military_building", "template_tag.military_building", List.of("military_building_military_income", "military_building_military_capacity")));
        definitions.put("settlement", new TemplateTagDefinition("settlement", "template_tag.settlement", List.of("race", "settlement_type", "settlement_weight", "point_requirement", "development_requirement")));
        DEFINITIONS = Collections.unmodifiableMap(definitions);
    }
}

