/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.utils;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1496;
import net.minecraft.class_1743;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1934;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.puppets.BowPuppetEntity;
import ydmsama.hundred_years_war.main.entity.entities.puppets.CrossbowPuppetEntity;
import ydmsama.hundred_years_war.main.entity.entities.puppets.IPuppet;
import ydmsama.hundred_years_war.main.entity.entities.puppets.MeleePuppetEntity;
import ydmsama.hundred_years_war.main.registry.HywEntityRegistry;
import ydmsama.hundred_years_war.main.utils.PuppetStateHandler;

public class PuppetManager {
    public static IPuppet createPuppetForPlayer(class_3222 player) {
        class_1297 class_12972;
        class_1496 horse;
        IPuppet puppet;
        PuppetType puppetType;
        if (player.field_13974.method_14257() != class_1934.field_9215) {
            return null;
        }
        IPuppet existingPuppet = PuppetManager.findPlayerPuppet(player);
        if (existingPuppet != null) {
            ((class_1297)existingPuppet).method_31472();
        }
        if ((puppetType = PuppetManager.determinePuppetType(player)) == null) {
            puppetType = PuppetType.MELEE;
        }
        class_1297 playerVehicle = null;
        if (player.method_5765()) {
            playerVehicle = player.method_5854();
            player.method_5848();
        }
        if ((puppet = PuppetManager.createPuppetByType(puppetType, player)) == null) {
            return null;
        }
        class_1297 puppetEntity = (class_1297)puppet;
        puppetEntity.method_5814(player.method_23317(), player.method_23318() + 0.01, player.method_23321());
        float headYaw = player.method_5791();
        puppetEntity.method_36456(headYaw);
        puppetEntity.method_36457(player.method_36455());
        if (puppetEntity instanceof BaseCombatEntity) {
            BaseCombatEntity combatPuppet = (BaseCombatEntity)puppetEntity;
            combatPuppet.method_5847(headYaw);
            combatPuppet.method_5636(headYaw);
        }
        puppet.method_6732(player.method_5667());
        PuppetManager.copyPlayerEquipmentToPuppet(player, puppet, puppetType);
        player.method_37908().method_8649(puppetEntity);
        if (playerVehicle != null) {
            puppetEntity.method_5873(playerVehicle, true);
            if (playerVehicle instanceof class_1496) {
                horse = (class_1496)playerVehicle;
                puppetEntity.method_36456(horse.method_36454());
                puppetEntity.method_5636(horse.method_36454());
                puppetEntity.method_5847(horse.method_36454());
            }
        }
        player.method_5873(puppetEntity, true);
        if (puppetEntity.method_5765() && (class_12972 = puppetEntity.method_5854()) instanceof class_1496) {
            horse = (class_1496)class_12972;
            player.method_36456(horse.method_36454());
            player.method_5847(horse.method_36454());
        } else {
            player.method_36456(puppetEntity.method_36454());
            player.method_5847(puppetEntity.method_36454());
        }
        PuppetStateHandler.restorePuppetState(player, puppet);
        return puppet;
    }

    public static void removePuppetForPlayer(class_3222 player) {
        class_1297 vehicle;
        class_1297 puppetEntity;
        double playerX = player.method_23317();
        double playerY = player.method_23318();
        double playerZ = player.method_23321();
        float playerYRot = player.method_36454();
        float playerXRot = player.method_36455();
        IPuppet puppet = PuppetManager.findPlayerPuppet(player);
        class_1297 puppetVehicle = null;
        if (puppet != null) {
            PuppetStateHandler.savePuppetState(player, puppet);
        }
        if (puppet != null && (puppetEntity = (class_1297)puppet).method_5765()) {
            puppetVehicle = puppetEntity.method_5854();
        }
        if (player.method_5765() && (vehicle = player.method_5854()) instanceof IPuppet) {
            player.method_5848();
            player.method_5859(playerX, playerY, playerZ);
            player.method_36456(playerYRot);
            player.method_36457(playerXRot);
        }
        if (puppet != null) {
            puppetEntity = (class_1297)puppet;
            if (puppetEntity.method_5765()) {
                puppetEntity.method_5848();
            }
            puppetEntity.method_31472();
            if (puppetVehicle != null && !puppetVehicle.method_31481()) {
                player.method_5873(puppetVehicle, true);
                if (puppetVehicle instanceof class_1496) {
                    class_1496 horse = (class_1496)puppetVehicle;
                    player.method_36456(horse.method_36454());
                    player.method_5847(horse.method_36454());
                }
            }
        }
    }

    private static PuppetType determinePuppetType(class_3222 player) {
        class_1799 mainhandItem = player.method_6047();
        PuppetType mainHandType = PuppetManager.getTypeForItem(mainhandItem);
        if (mainHandType != null) {
            return mainHandType;
        }
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            PuppetType itemType = PuppetManager.getTypeForItem(stack);
            if (itemType == null) continue;
            return itemType;
        }
        return null;
    }

    private static PuppetType getTypeForItem(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return null;
        }
        class_1792 item = itemStack.method_7909();
        if (item instanceof class_1829 || item instanceof class_1743) {
            return PuppetType.MELEE;
        }
        if (item instanceof class_1753) {
            return PuppetType.BOW;
        }
        if (item instanceof class_1764) {
            return PuppetType.CROSSBOW;
        }
        return null;
    }

    private static IPuppet createPuppetByType(PuppetType type, class_3222 player) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case PuppetType.MELEE -> (MeleePuppetEntity)HywEntityRegistry.MELEE_PUPPET.method_5883(player.method_37908());
            case PuppetType.BOW -> (BowPuppetEntity)HywEntityRegistry.BOW_PUPPET.method_5883(player.method_37908());
            case PuppetType.CROSSBOW -> (CrossbowPuppetEntity)HywEntityRegistry.CROSSBOW_PUPPET.method_5883(player.method_37908());
        };
    }

    private static void copyPlayerEquipmentToPuppet(class_3222 player, IPuppet puppet, PuppetType puppetType) {
        class_1799 weaponToEquip;
        if (!(puppet instanceof BaseCombatEntity)) {
            return;
        }
        BaseCombatEntity combatEntity = (BaseCombatEntity)((Object)puppet);
        PuppetManager.copyArmorToPuppet(player, combatEntity);
        class_1799 offhandItem = player.method_6079();
        if (!offhandItem.method_7960()) {
            combatEntity.method_5673(class_1304.field_6171, offhandItem.method_7972());
        }
        switch (puppetType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case MELEE: {
                class_1799 class_17992 = PuppetManager.findMeleeWeaponForPlayer(player);
                break;
            }
            case BOW: {
                class_1799 class_17992 = PuppetManager.findBowForPlayer(player);
                break;
            }
            case CROSSBOW: {
                class_1799 class_17992 = weaponToEquip = PuppetManager.findCrossbowForPlayer(player);
            }
        }
        if (!weaponToEquip.method_7960()) {
            combatEntity.method_5673(class_1304.field_6173, weaponToEquip);
        } else if (puppetType == PuppetType.MELEE) {
            combatEntity.method_5673(class_1304.field_6173, class_1799.field_8037);
        }
    }

    private static void copyArmorToPuppet(class_3222 player, BaseCombatEntity combatEntity) {
        class_1799 boots;
        class_1799 leggings;
        class_1799 chestplate;
        class_1799 helmet = player.method_6118(class_1304.field_6169);
        if (!helmet.method_7960()) {
            combatEntity.method_5673(class_1304.field_6169, helmet.method_7972());
        }
        if (!(chestplate = player.method_6118(class_1304.field_6174)).method_7960()) {
            combatEntity.method_5673(class_1304.field_6174, chestplate.method_7972());
        }
        if (!(leggings = player.method_6118(class_1304.field_6172)).method_7960()) {
            combatEntity.method_5673(class_1304.field_6172, leggings.method_7972());
        }
        if (!(boots = player.method_6118(class_1304.field_6166)).method_7960()) {
            combatEntity.method_5673(class_1304.field_6166, boots.method_7972());
        }
    }

    private static class_1799 findMeleeWeaponForPlayer(class_3222 player) {
        class_1799 mainhandItem = player.method_6047();
        if (PuppetManager.isMeleeWeapon(mainhandItem)) {
            return mainhandItem.method_7972();
        }
        return PuppetManager.findItemInInventory(player, PuppetManager::isMeleeWeapon);
    }

    private static class_1799 findBowForPlayer(class_3222 player) {
        class_1799 mainhandItem = player.method_6047();
        if (mainhandItem.method_7909() instanceof class_1753) {
            return mainhandItem.method_7972();
        }
        return PuppetManager.findItemInInventory(player, stack -> stack.method_7909() instanceof class_1753);
    }

    private static class_1799 findCrossbowForPlayer(class_3222 player) {
        class_1799 mainhandItem = player.method_6047();
        if (mainhandItem.method_7909() instanceof class_1764) {
            return mainhandItem.method_7972();
        }
        return PuppetManager.findItemInInventory(player, stack -> stack.method_7909() instanceof class_1764);
    }

    private static boolean isMeleeWeapon(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return false;
        }
        class_1792 item = itemStack.method_7909();
        return item instanceof class_1829 || item instanceof class_1743;
    }

    private static class_1799 findItemInInventory(class_3222 player, Predicate<class_1799> predicate) {
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            if (!predicate.test(stack)) continue;
            return stack.method_7972();
        }
        return class_1799.field_8037;
    }

    public static IPuppet findPlayerPuppet(class_3222 player) {
        List nearbyEntities = player.method_37908().method_8333((class_1297)player, player.method_5829().method_1014(50.0), entity -> entity instanceof IPuppet);
        for (class_1297 entity2 : nearbyEntities) {
            if (!(entity2 instanceof IPuppet)) continue;
            IPuppet puppet = (IPuppet)entity2;
            if (!player.method_5667().equals(puppet.method_6139())) continue;
            return puppet;
        }
        return null;
    }

    public static enum PuppetType {
        MELEE,
        BOW,
        CROSSBOW;

    }
}

