/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.client.screens.components.TexturedButton;
import com.st0x0ef.stellaris.client.screens.helper.ScreenHelper;
import com.st0x0ef.stellaris.client.screens.tablet.TabletEntry;
import com.st0x0ef.stellaris.common.utils.ResourceLocationUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class TabletButton
extends Button {
    public static final ResourceLocation TEXTURE = ResourceLocationUtils.guiTexture("util/buttons/button");
    public static final ResourceLocation HOVER_TEXTURE = ResourceLocationUtils.guiTexture("util/buttons/button");
    private ResourceLocation buttonTexture;
    private ResourceLocation hoverButtonTexture;
    private int xTexStart;
    private int yTexStart;
    private int yDiffText;
    private int textureWidth;
    private int textureHeight;
    private TabletEntry.ItemInfo info;

    public TabletButton(int xIn, int yIn, int widthIn, int heightIn, Button.OnPress onPressIn, TabletEntry.ItemInfo info) {
        this(xIn, yIn, widthIn, heightIn, (Component)Component.empty(), onPressIn, DEFAULT_NARRATION, info);
    }

    public TabletButton(int xIn, int yIn, int widthIn, int heightIn, Component title, Button.OnPress onPressIn, TabletEntry.ItemInfo info) {
        this(xIn, yIn, widthIn, heightIn, title, onPressIn, DEFAULT_NARRATION, info);
    }

    public TabletButton(int xIn, int yIn, int widthIn, int heightIn, Component title, Button.OnPress onPressIn, Button.CreateNarration onTooltipIn, TabletEntry.ItemInfo info) {
        super(xIn, yIn, widthIn, heightIn, title, onPressIn, onTooltipIn);
        this.textureWidth = widthIn;
        this.textureHeight = heightIn;
        this.yDiffText = 0;
        this.xTexStart = 0;
        this.yTexStart = 0;
        this.buttonTexture = TEXTURE;
        this.hoverButtonTexture = HOVER_TEXTURE;
        this.info = info;
        this.setTooltip();
    }

    public void setTooltip() {
        switch (this.info.iconType()) {
            case "item": {
                this.info.components().stream().filter(c -> c.type().equals("item")).toList().getFirst();
                break;
            }
            case "entity": {
                this.info.components().stream().filter(c -> c.type().equals("entity")).findFirst().ifPresent(entity -> {
                    Entity entity1 = ScreenHelper.createEntity((Level)Minecraft.getInstance().level, entity.entity().get().entity());
                    Stellaris.LOG.info("Entity: {}", (Object)entity1.getDisplayName());
                    this.tooltip(Tooltip.create((Component)entity1.getDisplayName()));
                });
            }
        }
    }

    public <T extends TabletButton> T tooltip(@Nullable Tooltip tooltip) {
        this.setTooltip(tooltip);
        return this.cast();
    }

    private <T extends TabletButton> T cast() {
        return (T)((Object)this);
    }

    public <T extends TabletButton> T tex(ResourceLocation buttonTexture, ResourceLocation hovorTexture) {
        this.buttonTexture = buttonTexture;
        this.hoverButtonTexture = hovorTexture;
        return this.cast();
    }

    public <T extends TabletButton> T size(int texWidth, int texHeight) {
        this.textureWidth = texWidth;
        this.textureHeight = texHeight;
        return this.cast();
    }

    public <T extends TabletButton> T setUVs(int xTexStart, int yTexStart) {
        this.xTexStart = xTexStart;
        this.yTexStart = yTexStart;
        return this.cast();
    }

    public void setYShift(int y) {
        this.yDiffText = y;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.getInstance();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
        int i = this.yTexStart;
        if (this.isHoveredOrFocused()) {
            i += this.yDiffText;
        }
        ResourceLocation texture = this.getTypeTexture(this.isHovered, this.buttonTexture, this.hoverButtonTexture);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        ScreenHelper.renderTextureWithColor.blit(graphics.pose(), this.getX(), this.getY(), this.xTexStart, i, this.width, this.height, this.textureWidth, this.textureHeight, this.getTypeColor());
        switch (this.info.iconType()) {
            case "item": {
                this.info.components().stream().filter(c -> c.type().equals("item")).findFirst().ifPresent(item -> ScreenHelper.renderItemWithCustomSize(graphics, minecraft, item.item().get().stack(), this.getX(), this.getY(), this.width));
                break;
            }
            case "entity": {
                this.info.components().stream().filter(c -> c.type().equals("entity")).findFirst().ifPresent(entity -> {
                    Entity entity1 = ScreenHelper.createEntity((Level)Minecraft.getInstance().level, entity.entity().get().entity());
                    ScreenHelper.renderEntityInInventory(graphics, this.getX(), this.getY(), 7.0f, new Vector3f(1.5f, 2.5f, 0.0f), new Quaternionf(-1.0f, 0.0f, 0.0f, 0.0f), null, entity1);
                });
            }
        }
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
    }

    private ResourceLocation getTypeTexture(boolean hover, ResourceLocation buttonTexture, ResourceLocation hoverButtonTexture) {
        if (hover) {
            return hoverButtonTexture;
        }
        return buttonTexture;
    }

    protected Vec3 getTypeColor() {
        return TexturedButton.ColorTypes.DEFAULT.getColor();
    }
}

