/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens.windows;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.client.screens.PlanetSelectionScreen;
import com.st0x0ef.stellaris.client.screens.components.LaunchPadsList;
import com.st0x0ef.stellaris.client.screens.components.TexturedButton;
import com.st0x0ef.stellaris.client.screens.info.CelestialBody;
import com.st0x0ef.stellaris.client.screens.windows.MoveableWindow;
import com.st0x0ef.stellaris.client.screens.windows.SpaceStationWindow;
import com.st0x0ef.stellaris.common.data.planets.Planet;
import com.st0x0ef.stellaris.common.launchpads.LaunchPad;
import com.st0x0ef.stellaris.common.launchpads.LaunchPadUtils;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import com.st0x0ef.stellaris.common.utils.ResourceLocationUtils;
import com.st0x0ef.stellaris.common.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class LaunchWindow
extends MoveableWindow {
    public final ArrayList<TexturedButton> spaceStationButtons = new ArrayList();
    public final PlanetSelectionScreen parent;
    @Nullable
    public CelestialBody celestialBody;
    public TexturedButton spaceStationButton;
    private LaunchPadsList padsList;
    private String errorMessage = this.getErrorMessage();

    public LaunchWindow(int width, int height, Component message, PlanetSelectionScreen parent) {
        super(width, height, message, (Screen)parent);
        this.parent = parent;
        this.moveLimit = 15;
    }

    @Override
    public void init() {
        GLFW.glfwSetScrollCallback((long)Minecraft.getInstance().getWindow().getWindow(), (arg_0, arg_1, arg_2) -> ((MouseHandler)Minecraft.getInstance().mouseHandler).onScroll(arg_0, arg_1, arg_2));
        this.padsList = new LaunchPadsList(this.getWindowX() + 40, this.getWindowY() + 60, this.getWidth() - 80, this.getHeight() - 90, (Component)Component.translatable((String)"gui.stellaris.launchpads"), this, new ArrayList<LaunchPad>());
        this.addWidget(this.padsList);
        this.spaceStationButton = new TexturedButton(this.getWindowX() + this.getWidth() / 2 + 73, this.getWindowY() + 18, 28, 18, (Component)Component.literal((String)""), button -> {
            if (this.celestialBody != null) {
                this.parent.setWindowVisible(1);
                ((SpaceStationWindow)this.parent.moveableWindows.get(1)).setCelestialBody(this.celestialBody);
            }
        }).tex(ResourceLocationUtils.id("textures/gui/util/buttons/space_station_button.png"), ResourceLocationUtils.id("textures/gui/util/buttons/space_station_button_hover.png"));
        this.spaceStationButton.setTooltip(Tooltip.create((Component)Component.literal((String)"Space Stations")));
        this.addWidget(this.spaceStationButton);
    }

    @Override
    public void renderWindow(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.clear((int)256, (boolean)Minecraft.ON_OSX);
        this.padsList.launchPads = this.getLaunchPadsForDimension();
        guiGraphics.blit(ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/gui/util/window/window_large.png"), this.getWindowX(), this.getWindowY(), 0.0f, 0.0f, this.getWidth(), this.getHeight(), this.getWidth(), this.getHeight());
        if (this.celestialBody != null && PlanetUtil.getPlanet(this.celestialBody.dimension) != null) {
            this.spaceStationButton.visible = this.celestialBody.spaceStation;
            Planet planet = PlanetUtil.getPlanet(this.celestialBody.dimension);
            guiGraphics.drawCenteredString(Minecraft.getInstance().font, this.celestialBody.name + " Launch Points", this.getWindowX() + this.getWidth() / 2, this.getWindowY() + 23, -1);
            guiGraphics.drawCenteredString(Minecraft.getInstance().font, (Component)PlanetUtil.getInLinePlanetInfo(planet), this.getWindowX() + this.getWidth() / 2, this.padsList.getY() - 12, -1);
            if (!this.parent.canLaunch(planet)) {
                guiGraphics.drawCenteredString(Minecraft.getInstance().font, "You cannot launch to this planet!", this.getWindowX() + this.getWidth() / 2, this.getWindowY() + this.getHeight() - 26, -65536);
            }
            if (this.padsList.launchPads.isEmpty()) {
                guiGraphics.drawCenteredString(Minecraft.getInstance().font, this.errorMessage, this.getWindowX() + this.getWidth() / 2, this.padsList.getY() + 7, Utils.getColorHexCode("white"));
            }
        }
        guiGraphics.flush();
        this.parent.dragging = false;
    }

    @Override
    public void close() {
        GLFW.glfwSetScrollCallback((long)Minecraft.getInstance().getWindow().getWindow(), this.parent::onMouseScroll);
        this.parent.canZoom = true;
        super.close();
    }

    @Override
    public Consumer<MoveableWindow> resize(Minecraft minecraft, int width, int height) {
        CelestialBody body = this.celestialBody;
        return window -> {
            if (window instanceof LaunchWindow) {
                LaunchWindow launchWindow = (LaunchWindow)((Object)window);
                launchWindow.setCelestialBody(body);
                launchWindow.setCelestialBody(body);
                launchWindow.init();
            }
        };
    }

    public void setCelestialBody(@Nullable CelestialBody celestialBody) {
        this.celestialBody = celestialBody;
    }

    public ArrayList<LaunchPad> getLaunchPadsForDimension() {
        Planet planet;
        ArrayList<LaunchPad> launchPads = new ArrayList<LaunchPad>();
        if (this.celestialBody == null) {
            return launchPads;
        }
        if (this.celestialBody.canLaunchOn || this.parent.getPlayer().isCreative()) {
            launchPads.add(this.addDirectLaunch());
        }
        if ((planet = PlanetUtil.getPlanet(this.celestialBody.dimension)) == null) {
            return launchPads;
        }
        PlanetSelectionScreen.LAUNCH_PADS.launchPads().stream().filter(pad -> pad.dimension().location().equals((Object)planet.dimension()) || planet.orbit().isPresent() && pad.dimension().location().equals((Object)planet.orbit().get())).filter(pad -> LaunchPadUtils.canPlayerJoinLaunchPad(pad, this.parent.getPlayer())).forEach(launchPads::add);
        return launchPads;
    }

    public LaunchPad addDirectLaunch() {
        Player player = this.parent.getPlayer();
        return new LaunchPad(10000, this.parent.getPlayer().position(), (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)this.celestialBody.dimension), "Launch Directly", true, player.getName().getString(), List.of());
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.close();
            return false;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public void changeVisibility(boolean visible) {
        super.changeVisibility(visible);
        for (TexturedButton button : this.spaceStationButtons) {
            button.visible = visible;
        }
    }

    public String getErrorMessage() {
        double randomNumber = Math.random() * 100.0 + 1.0;
        if (randomNumber < 55.0) {
            return "No Launch Pads available";
        }
        if (randomNumber < 99.0) {
            return "Error 404: Launchpads not found";
        }
        return "These are not the Launchpads you are looking for";
    }

    @Override
    public int getMoveLimit() {
        return 15;
    }
}

