/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.entities.machines;

import com.fej1fun.potentials.components.FluidAmountMapDataComponent;
import com.fej1fun.potentials.fluid.UniversalFluidStorage;
import com.fej1fun.potentials.providers.FluidProvider;
import com.st0x0ef.stellaris.common.blocks.entities.machines.BaseEnergyContainerBlockEntity;
import com.st0x0ef.stellaris.common.menus.OxygenDistributorMenu;
import com.st0x0ef.stellaris.common.network.packets.SyncFluidPacketWithoutDirection;
import com.st0x0ef.stellaris.common.oxygen.DimensionOxygenManager;
import com.st0x0ef.stellaris.common.oxygen.GlobalOxygenManager;
import com.st0x0ef.stellaris.common.registry.BlockEntityRegistry;
import com.st0x0ef.stellaris.common.registry.FluidRegistry;
import com.st0x0ef.stellaris.common.utils.capabilities.fluid.FluidUtil;
import com.st0x0ef.stellaris.common.utils.capabilities.fluid.SingleFluidStorage;
import dev.architectury.fluid.FluidStack;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class OxygenDistributorBlockEntity
extends BaseEnergyContainerBlockEntity
implements FluidProvider.BLOCK {
    public final SingleFluidStorage oxygenTank = new SingleFluidStorage(20000L){

        @Override
        protected void onChange() {
            OxygenDistributorBlockEntity.this.setChanged();
            if (OxygenDistributorBlockEntity.this.level != null && OxygenDistributorBlockEntity.this.level.getServer() != null && !OxygenDistributorBlockEntity.this.level.getServer().getPlayerList().getPlayers().isEmpty()) {
                NetworkManager.sendToPlayers((Iterable)OxygenDistributorBlockEntity.this.level.getServer().getPlayerList().getPlayers(), (CustomPacketPayload)new SyncFluidPacketWithoutDirection(new FluidAmountMapDataComponent(List.of(this.getFluidInTank(0).getFluid()), List.of(Long.valueOf(this.getFluidValueInTank()))), 0, OxygenDistributorBlockEntity.this.getBlockPos()));
            }
        }

        @Override
        public boolean isFluidValid(int tank, FluidStack stack) {
            return stack.getFluid().isSame((Fluid)FluidRegistry.OXYGEN_STILL.get());
        }
    };

    public OxygenDistributorBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.OXYGEN_DISTRIBUTOR.get(), pos, state);
    }

    @Override
    public void tick() {
        FluidUtil.moveFluidFromItem(0, 0, (NonNullList<ItemStack>)this.items, this.oxygenTank, 5L);
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            DimensionOxygenManager oxygenManager = GlobalOxygenManager.getInstance().getOrCreateDimensionManager(serverLevel);
            if (oxygenManager.getOxygenRoom(this.getBlockPos()) == null) {
                oxygenManager.addOxygenRoom(this.getBlockPos());
            }
        }
    }

    public boolean useOxygenAndEnergy() {
        if (this.oxygenTank.getFluidValueInTank() > 0L && this.energyContainer.getEnergy() >= 3) {
            this.oxygenTank.drain(this.oxygenTank.getFluidInTank(0).copyWithAmount(1L), false);
            this.energyContainer.extract(3, false);
            return true;
        }
        return false;
    }

    public long addOxygen(long amount) {
        FluidStack stack = this.oxygenTank.isEmpty() ? FluidStack.create((Fluid)((Fluid)FluidRegistry.OXYGEN_STILL.get()), (long)amount) : this.oxygenTank.getFluidInTank(0).copyWithAmount(amount);
        return this.oxygenTank.fill(stack, false);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.stellaris.oxygen_distributor");
    }

    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new OxygenDistributorMenu(containerId, inventory, (Container)this, this);
    }

    @Override
    public int getContainerSize() {
        return 1;
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.oxygenTank.load(tag, provider, "oxygen");
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.oxygenTank.save(tag, provider, "oxygen");
    }

    @Nullable
    public UniversalFluidStorage getFluidTank(@Nullable Direction direction) {
        return this.oxygenTank;
    }
}

