/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.machines;

import com.fej1fun.potentials.fluid.ItemFluidStorage;
import com.fej1fun.potentials.fluid.UniversalFluidItemStorage;
import com.fej1fun.potentials.providers.FluidProvider;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.st0x0ef.stellaris.common.blocks.entities.machines.FluidTankBlockEntity;
import com.st0x0ef.stellaris.common.blocks.machines.BaseMachineBlock;
import com.st0x0ef.stellaris.common.registry.BlockEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidTankBlock
extends BaseMachineBlock {
    public final long capacity;
    public static final IntegerProperty STAGE = IntegerProperty.create((String)"stage", (int)0, (int)9);

    public FluidTankBlock(BlockBehaviour.Properties properties, long capacity) {
        super(properties);
        this.capacity = capacity;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    protected MapCodec<? extends FluidTankBlock> codec() {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)FluidTankBlock.propertiesCodec(), (App)Codec.LONG.fieldOf("capacity").forGetter(tank -> tank.capacity)).apply((Applicative)instance, FluidTankBlock::new));
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FluidTankBlockEntity(pos, state, this.capacity);
    }

    @Override
    public BlockEntityType<?> getBlockEntityType() {
        return BlockEntityRegistry.FLUID_TANK.get();
    }

    @Override
    public boolean hasTicker(Level level) {
        return !level.isClientSide();
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof FluidProvider.ITEM) {
            FluidProvider.ITEM provider = (FluidProvider.ITEM)item;
            UniversalFluidItemStorage fluidStorage = provider.getFluidTank(stack);
            BlockEntity be = level.getBlockEntity(pos);
            if (fluidStorage != null && be instanceof FluidTankBlockEntity) {
                FluidTankBlockEntity fluidTankBlock = (FluidTankBlockEntity)be;
                fluidTankBlock.getFluidTank(null).fill(fluidStorage.getFluidInTank(0), false);
            }
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{STAGE});
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        player.awardStat(Stats.BLOCK_MINED.get((Object)this));
        player.causeFoodExhaustion(0.005f);
        if (level instanceof ServerLevel) {
            if (blockEntity instanceof FluidProvider.BLOCK) {
                FluidProvider.BLOCK fluidStorage = (FluidProvider.BLOCK)blockEntity;
                ItemStack stack = new ItemStack((ItemLike)this);
                FluidProvider.ITEM provider = (FluidProvider.ITEM)stack.getItem();
                UniversalFluidItemStorage universalFluidItemStorage = provider.getFluidTank(stack);
                if (universalFluidItemStorage instanceof ItemFluidStorage) {
                    ItemFluidStorage storage = (ItemFluidStorage)universalFluidItemStorage;
                    storage.setFluidInTank(0, fluidStorage.getFluidTank(null).getFluidInTank(0));
                }
                FluidTankBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)stack);
            }
            state.spawnAfterBreak((ServerLevel)level, pos, tool, false);
        }
    }
}

