/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.data.screen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.client.events.custom.PlanetSelectionClientEvents;
import com.st0x0ef.stellaris.client.screens.GalaxyScreen;
import com.st0x0ef.stellaris.client.screens.PlanetSelectionScreen;
import com.st0x0ef.stellaris.client.screens.info.PSystemInfo;
import com.st0x0ef.stellaris.client.screens.record.PSystemRecord;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PSystemPack
extends SimpleJsonResourceReloadListener {
    public static final Map<String, PSystemRecord> PSYSTEM = new HashMap<String, PSystemRecord>();

    public PSystemPack() {
        super(Stellaris.GSON, "renderer/planet_screen/planetary_system");
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        PSYSTEM.clear();
        PlanetSelectionScreen.PSYSTEMS.clear();
        object.forEach((key, value) -> {
            JsonObject json = GsonHelper.convertToJsonObject((JsonElement)value, (String)"planetary_systems");
            PSystemRecord.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).result().ifPresentOrElse(record -> {
                PSYSTEM.put(record.name(), (PSystemRecord)record);
                PSystemInfo screenPSYSTEM = new PSystemInfo(record.name(), record.translatable(), record.parent(), record.id(), record.stars(), record.centerX(), record.centerY());
                PlanetSelectionScreen.PSYSTEMS.add(screenPSYSTEM);
                Stellaris.LOG.info("Added a planetary system '{}' to PlanetScreen: {}", (Object)record.name(), (Object)record.id());
            }, () -> Stellaris.LOG.error("Failed to parse PSystemRecord JSON: {}", (Object)key.toString()));
        });
        Stellaris.LOG.info("Finished loading {} Planetary System.", (Object)PlanetSelectionScreen.PSYSTEMS.size());
        ((PlanetSelectionClientEvents.PostGalaxyPackRegistryEvent)PlanetSelectionClientEvents.POST_GALAXY_PACK_REGISTRY.invoker()).galaxyRegistered(GalaxyScreen.GALAXY);
    }
}

